/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.impl.util.table;

import com.intellij.psi.PsiElement;
import com.intellij.psi.css.CssFunction;
import com.intellij.psi.css.CssTerm;
import com.intellij.psi.css.impl.CssElementTypes;
import com.intellij.psi.css.impl.util.completion.FunctionUserLookup;
import com.intellij.psi.css.impl.util.table.CssPropertyUtil;
import com.intellij.psi.css.impl.util.table.CssPropertyValueImpl;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlToken;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CssFunctionPropertyValue
extends CssPropertyValueImpl {
    private final String myFunctionName;
    private final boolean myOptional;

    public CssFunctionPropertyValue(@NotNull String functionName, boolean optional) {
        if (functionName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionName", "com/intellij/psi/css/impl/util/table/CssFunctionPropertyValue", "<init>"));
        }
        super(optional ? functionName : new FunctionUserLookup(functionName));
        this.myFunctionName = functionName;
        this.myOptional = optional;
    }

    @Override
    public boolean isValueBelongs(@Nullable PsiElement element) {
        if (element == null) {
            return false;
        }
        CssTerm term = (CssTerm)PsiTreeUtil.getParentOfType((PsiElement)element, CssTerm.class, (boolean)false);
        if (term == null) {
            return false;
        }
        PsiElement child = term.getFirstChild();
        if (child == null || child.getNextSibling() != null) {
            return false;
        }
        if (child instanceof CssFunction) {
            String functionName = ((CssFunction)child).getName();
            return this.myFunctionName.equals(CssPropertyUtil.getElementNameWithoutVendorPrefix(functionName));
        }
        if (this.myOptional && child instanceof XmlToken && ((XmlToken)child).getTokenType() == CssElementTypes.CSS_IDENT) {
            String functionName = child.getText();
            return functionName != null && this.myFunctionName.equals(CssPropertyUtil.getElementNameWithoutVendorPrefix(functionName));
        }
        return false;
    }
}

