/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.css.resolve;

import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.css.CssRuleset;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.CssSupportLoader;
import com.intellij.psi.css.StylesheetFile;
import com.intellij.psi.css.resolve.CssElementProcessor;
import com.intellij.psi.impl.include.FileIncludeManager;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class CssTraveller {
    public void travel(@NotNull PsiElement startingPoint, @NotNull CssElementProcessor processor) {
        PsiFile topLevelFile;
        if (startingPoint == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "startingPoint", "com/intellij/psi/css/resolve/CssTraveller", "travel"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/resolve/CssTraveller", "travel"));
        }
        PsiUtilCore.ensureValid((PsiElement)startingPoint);
        Project project = startingPoint.getProject();
        PsiFile originalFile = startingPoint.getContainingFile();
        HashSet visitedFiles = ContainerUtil.newHashSet();
        boolean continueProcessing = CssTraveller.processFile(originalFile, processor, visitedFiles);
        if (continueProcessing && CssTraveller.processIncludedFiles(originalFile, visitedFiles, processor) && (topLevelFile = InjectedLanguageManager.getInstance((Project)project).getTopLevelFile((PsiElement)originalFile)) != originalFile && CssTraveller.processFile(topLevelFile, processor, visitedFiles)) {
            CssTraveller.processIncludedFiles(topLevelFile, visitedFiles, processor);
        }
        visitedFiles.clear();
    }

    private static boolean processFile(@NotNull PsiFile file, @NotNull CssElementProcessor processor, @NotNull Set<PsiFile> visitedFiles) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/resolve/CssTraveller", "processFile"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/resolve/CssTraveller", "processFile"));
        }
        if (visitedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedFiles", "com/intellij/psi/css/resolve/CssTraveller", "processFile"));
        }
        if (!visitedFiles.add(file)) {
            return true;
        }
        if (!processor.process(file)) {
            return false;
        }
        if (file instanceof StylesheetFile) {
            return CssTraveller.processStylesheet(((StylesheetFile)file).getStylesheet(), processor);
        }
        for (PsiFile psiFile : file.getViewProvider().getAllFiles()) {
            if (CssTraveller.processNonCssFile(psiFile, processor)) continue;
            return false;
        }
        return true;
    }

    private static boolean processIncludedFiles(@NotNull PsiFile file, @NotNull Set<PsiFile> visitedFiles, @NotNull CssElementProcessor processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/resolve/CssTraveller", "processIncludedFiles"));
        }
        if (visitedFiles == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "visitedFiles", "com/intellij/psi/css/resolve/CssTraveller", "processIncludedFiles"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/resolve/CssTraveller", "processIncludedFiles"));
        }
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile != null) {
            Project project = file.getProject();
            for (VirtualFile f : FileIncludeManager.getManager((Project)project).getIncludedFiles(virtualFile, false)) {
                PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(f);
                if (psiFile == null || CssTraveller.processFile(psiFile, processor, visitedFiles)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processNonCssFile(@NotNull PsiFile file, final @NotNull CssElementProcessor processor) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/psi/css/resolve/CssTraveller", "processNonCssFile"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/resolve/CssTraveller", "processNonCssFile"));
        }
        if (CssSupportLoader.isInFileThatSupportsEmbeddedCss((PsiElement)file)) {
            return PsiTreeUtil.processElements((PsiElement)file, (PsiElementProcessor)new PsiElementProcessor(){

                public boolean execute(@NotNull PsiElement element) {
                    if (element == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/psi/css/resolve/CssTraveller$1", "execute"));
                    }
                    if (element instanceof CssStylesheet) {
                        return CssTraveller.processStylesheet((CssStylesheet)element, processor);
                    }
                    return true;
                }
            });
        }
        return true;
    }

    private static boolean processStylesheet(@NotNull CssStylesheet stylesheet, @NotNull CssElementProcessor processor) {
        if (stylesheet == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stylesheet", "com/intellij/psi/css/resolve/CssTraveller", "processStylesheet"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/resolve/CssTraveller", "processStylesheet"));
        }
        if (!processor.process(stylesheet)) {
            return false;
        }
        for (CssRuleset ruleset : stylesheet.getRulesets(true)) {
            boolean continueProcess = CssTraveller.processRuleset(ruleset, processor);
            if (continueProcess) continue;
            return false;
        }
        return true;
    }

    private static boolean processRuleset(@NotNull CssRuleset ruleset, @NotNull CssElementProcessor processor) {
        if (ruleset == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ruleset", "com/intellij/psi/css/resolve/CssTraveller", "processRuleset"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "processor", "com/intellij/psi/css/resolve/CssTraveller", "processRuleset"));
        }
        if (processor.process(ruleset)) {
            for (CssRuleset nestedRuleset : ruleset.getNestedRulesets()) {
                if (CssTraveller.processRuleset(nestedRuleset, processor)) continue;
                return false;
            }
        }
        return true;
    }
}

