/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.diagram.settings;

import com.intellij.openapi.graph.base.Graph;
import com.intellij.openapi.graph.layout.Layouter;
import com.intellij.openapi.graph.settings.GraphSettings;
import com.intellij.openapi.graph.settings.GraphSettingsProvider;
import com.intellij.openapi.graph.view.Graph2D;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;

public enum DiagramLayout {
    BALLOON,
    CIRCULAR,
    HIERARCHIC_GROUP,
    ORGANIC,
    ORTHOGONAL,
    DIRECTED_ORTHOGONAL,
    TREE;


    public static DiagramLayout getDefault() {
        return HIERARCHIC_GROUP;
    }

    public Layouter getLayouter(Graph2D graph, Project project) {
        GraphSettings settings = GraphSettingsProvider.getInstance((Project)project).getSettings((Graph)graph);
        switch (this) {
            case BALLOON: {
                return settings.getBalloonLayouter();
            }
            case CIRCULAR: {
                return settings.getCircularLayouter();
            }
            case DIRECTED_ORTHOGONAL: {
                return settings.getDirectedOrthogonalLayouter();
            }
            case HIERARCHIC_GROUP: {
                return settings.getGroupLayouter();
            }
            case ORGANIC: {
                return settings.getOrganicLayouter();
            }
            case ORTHOGONAL: {
                return settings.getOrthogonalLayouter();
            }
            case TREE: {
                return settings.getHVTreeLayouter();
            }
        }
        return settings.getGroupLayouter();
    }

    public String getPresentableName() {
        return StringUtil.capitalizeWords((String)this.name().toLowerCase().replaceAll("_", " "), (boolean)true);
    }

    public static DiagramLayout fromString(Object obj) {
        if (obj == null) {
            return DiagramLayout.getDefault();
        }
        String name = obj.toString();
        try {
            return DiagramLayout.valueOf(name.toUpperCase().replaceAll(" ", "_"));
        }
        catch (IllegalArgumentException e) {
            return DiagramLayout.getDefault();
        }
    }
}

