/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.editor.valueclass;

import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.TreeExpander;
import com.intellij.javaee.module.view.common.attributes.JavaeeTreeTableView;
import com.intellij.javaee.module.view.nodes.JavaeeNodeDescriptor;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossAddAction;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossEditAction;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossPersistentColumn;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossPropertyDescriptor;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossRemoveAction;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossTableColumn;
import com.intellij.javaee.oss.jboss.editor.valueclass.JBossValueClassesNode;
import com.intellij.javaee.oss.jboss.model.JBossCmpRoot;
import com.intellij.javaee.oss.jboss.model.JBossProperty;
import com.intellij.javaee.oss.jboss.model.JBossValueClass;
import com.intellij.javaee.oss.util.BooleanRenderer;
import com.intellij.javaee.oss.util.TreeExpanderImpl;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.treeStructure.treetable.TreeColumnInfo;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.JBUI;
import java.awt.Dimension;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JBossValueClassesEditor
extends JavaeeTreeTableView {
    private final JBossCmpRoot cmp;

    public JBossValueClassesEditor(JBossCmpRoot cmp) {
        super(cmp.getManager().getProject(), (JavaeeNodeDescriptor)new JBossValueClassesNode(cmp));
        this.cmp = cmp;
        this.getComponent().setBorder((Border)IdeBorderFactory.createTitledBorder((String)JBossBundle.getText("JBossValueClassesEditor.title", new Object[0]), (boolean)true));
        this.getTreeTableView().setShowVerticalLines(true);
        this.getTreeTableView().setIntercellSpacing((Dimension)JBUI.size((int)1, (int)0));
        this.getTreeTableView().setDefaultRenderer(Boolean.class, (TableCellRenderer)new BooleanRenderer((JTable)this.getTreeTableView()));
        this.init();
    }

    protected boolean isShowTree() {
        return !this.cmp.getDependentValueClasses().getDependentValueClasses().isEmpty();
    }

    @NotNull
    protected String getEmptyPaneText() {
        String string = JBossBundle.getText("JBossValueClassesEditor.empty", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/jboss/editor/valueclass/JBossValueClassesEditor", "getEmptyPaneText"));
        }
        return string;
    }

    protected ColumnInfo<?, ?>[] createColumnInfos() {
        return new ColumnInfo[]{new TreeColumnInfo(""), new JBossPersistentColumn(), new JBossTableColumn()};
    }

    @Nullable
    protected ActionGroup createToolbarActions() {
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.add((AnAction)new JBossAddAction(this.cmp, (JComponent)this.getTreeTableView()));
        actions.add((AnAction)new JBossRemoveAction(this.cmp, this.getTreeTableView()));
        actions.add((AnAction)new JBossEditAction(this.getTreeTableView()));
        actions.addSeparator();
        actions.add(CommonActionsManager.getInstance().createExpandAllAction((TreeExpander)new TreeExpanderImpl((JTree)this.getTree()), (JComponent)this.getTree()));
        actions.add(CommonActionsManager.getInstance().createCollapseAllAction((TreeExpander)new TreeExpanderImpl((JTree)this.getTree()), (JComponent)this.getTree()));
        return actions;
    }

    @Nullable
    static JBossProperty findProperty(JavaeeNodeDescriptor<?> node) {
        Object element = node.getElement();
        if (element instanceof JBossPropertyDescriptor) {
            String name = ((JBossPropertyDescriptor)element).getName();
            JBossValueClass valueClass = (JBossValueClass)node.getParentDescriptor().getElement();
            for (JBossProperty property : valueClass.getProperties()) {
                if (!name.equals(property.getPropertyName().getValue())) continue;
                return property;
            }
        }
        return null;
    }
}

