/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.jboss.server;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.JavaParameters;
import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.deployment.DeploymentSource;
import com.intellij.javaee.oss.admin.JavaeeAdmin;
import com.intellij.javaee.oss.admin.JavaeeAdminClientImpl;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.agent.ProcessAgentProxyFactory;
import com.intellij.javaee.oss.agent.ReflectiveThreadAgentProxyFactory;
import com.intellij.javaee.oss.jboss.JBossBundle;
import com.intellij.javaee.oss.jboss.admin.JBoss71AdminServerImpl;
import com.intellij.javaee.oss.jboss.admin.JBoss7AdminServerImpl;
import com.intellij.javaee.oss.jboss.admin.JBossAdminServerImpl;
import com.intellij.javaee.oss.jboss.server.JBossExtensions;
import com.intellij.javaee.oss.jboss.server.JBossIntegration;
import com.intellij.javaee.oss.jboss.version.JBossContributionsProvider;
import com.intellij.javaee.oss.jboss.version.JBossVersion6Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersion7Handler;
import com.intellij.javaee.oss.jboss.version.JBossVersionContribution;
import com.intellij.javaee.oss.jboss.version.JBossVersionHandler;
import com.intellij.javaee.oss.server.JavaeeServerInstance;
import com.intellij.javaee.oss.server.JavaeeServerModel;
import com.intellij.javaee.oss.util.Version;
import com.intellij.javaee.ui.packaging.ExplodedWarArtifactType;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.ui.configuration.ModulesConfigurator;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.packaging.artifacts.Artifact;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.jetbrains.annotations.NonNls;

public abstract class JBossServerModel
extends JavaeeServerModel {
    private static final Logger LOG = Logger.getInstance((String)("#" + JBossServerModel.class.getName()));
    @NonNls
    private static final String JBOSS_LOG_FILE_ID = "JBoss";
    @NonNls
    private static final String FINAL_REVISION = "Final";
    public boolean DOMAIN = false;
    public String SERVER_GROUP = "";
    private JBossContributionsProvider<ServerModelContribution> myContributionsProvider;

    public JBossServerModel() {
        this.init();
    }

    private void init() {
        this.myContributionsProvider = new JBossContributionsProvider<ServerModelContribution>(ServerModelContribution.class);
        this.myContributionsProvider.add(JBossVersion6Handler.ID, new ServerModelContribution(){

            @Override
            public JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
                return new JBossAdminServerImpl((AgentProxyFactory)new ReflectiveThreadAgentProxyFactory(), JBossServerModel.this.getLibraries());
            }

            @Override
            public boolean isExtensionValidationRequired(Artifact artifact) {
                return new Version(JBossServerModel.this.getVersion()).getMajor() < 5 || artifact.getArtifactType() != ExplodedWarArtifactType.getInstance();
            }

            @Override
            public boolean isEmptyPasswordAllowed() {
                return false;
            }
        });
        this.myContributionsProvider.add(JBossVersion7Handler.ID, new ServerModelContribution(){

            @Override
            public JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
                Version version = new Version(JBossServerModel.this.getVersion());
                int atVersion710 = version.compare(7, 1, 0);
                boolean validationSince71final = atVersion710 == 0 && version.getRevision().startsWith(JBossServerModel.FINAL_REVISION) || atVersion710 > 0;
                ProcessAgentProxyFactory agentProxyFactory = new ProcessAgentProxyFactory(serverInstance){

                    protected Sdk getJdk() {
                        return JBossServerModel.this.getJre();
                    }

                    protected boolean forceDynamicClasspath() {
                        return true;
                    }

                    protected void customizeParameters(JavaParameters javaParameters) {
                        try {
                            File workDir = FileUtil.createTempDirectory((String)"jboss.working.dir", null);
                            javaParameters.setWorkingDirectory(workDir);
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                };
                if (validationSince71final) {
                    return new JBoss71AdminServerImpl(JBossServerModel.this, (AgentProxyFactory)agentProxyFactory, JBossServerModel.this.getLibraries());
                }
                return new JBoss7AdminServerImpl(JBossServerModel.this, (AgentProxyFactory)agentProxyFactory, JBossServerModel.this.getLibraries());
            }

            @Override
            public boolean isExtensionValidationRequired(Artifact artifact) {
                return artifact.getArtifactType() != ExplodedWarArtifactType.getInstance();
            }

            @Override
            public boolean isEmptyPasswordAllowed() {
                return true;
            }
        });
        this.myContributionsProvider.addDefault(new ServerModelContribution(){

            @Override
            public JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean isExtensionValidationRequired(Artifact artifact) {
                return false;
            }

            @Override
            public boolean isEmptyPasswordAllowed() {
                return true;
            }
        });
    }

    public Object clone() throws CloneNotSupportedException {
        JBossServerModel result = (JBossServerModel)((Object)super.clone());
        result.init();
        return result;
    }

    public String getServerSpecificContext(File source) {
        return JBossServerModel.cutWarExtension((File)source);
    }

    protected String getLogFileId() {
        return JBOSS_LOG_FILE_ID;
    }

    public void checkConfiguration() throws RuntimeConfigurationException {
        super.checkConfiguration();
        List artifacts = this.getCommonModel().getDeployedArtifacts();
        for (Artifact artifact : artifacts) {
            DeploymentSource deploymentSource;
            File source;
            DeploymentModel model = this.getCommonModel().getDeploymentModel(artifact);
            if (model == null || (source = (deploymentSource = model.getDeploymentSource()).getFile()) == null || !this.getContribution(this.myContributionsProvider).isExtensionValidationRequired(artifact) || JBossExtensions.getInstance().isValidExtension(artifact.getArtifactType(), FileUtilRt.getExtension((String)source.getName()))) continue;
            String message = JBossBundle.getText("JBossServerModel.error.extension", artifact.getName());
            RuntimeConfigurationError error = new RuntimeConfigurationError(message);
            error.setQuickFix(() -> ModulesConfigurator.showArtifactSettings((Project)this.getCommonModel().getProject(), (Artifact)artifact));
            throw error;
        }
    }

    @NonNls
    protected String getDefaultUsername() {
        return JBossServerModel.doGetDefaultUsername();
    }

    @NonNls
    protected String getDefaultPassword() {
        return JBossServerModel.doGetDefaultPassword();
    }

    @NonNls
    protected static String doGetDefaultUsername() {
        return "";
    }

    @NonNls
    protected static String doGetDefaultPassword() {
        return "";
    }

    protected boolean isEmptyPasswordAllowed() {
        return this.getContribution(this.myContributionsProvider).isEmptyPasswordAllowed();
    }

    protected JavaeeAdmin createServerAdmin(JavaeeServerInstance serverInstance) throws Exception {
        return new JavaeeAdminClientImpl(this.getContribution(this.myContributionsProvider).createServerAdmin(serverInstance));
    }

    protected List<File> getLibraries() throws ExecutionException {
        List libraries = super.getLibraries();
        libraries.add(this.getPathUnderHome("client/jbossall-client.jar"));
        libraries.add(this.getPathUnderHome("modules"));
        return libraries;
    }

    public JBossVersionHandler getVersionHandler() {
        return JBossIntegration.getVersionHandler(this.getHome());
    }

    public <T extends JBossVersionContribution> T getContribution(JBossContributionsProvider<T> provider) {
        JBossVersionHandler versionHandler = this.getVersionHandler();
        return provider.get(versionHandler == null ? null : versionHandler.getId());
    }

    public int getPingPort() {
        return this.getCommonModel().getPort();
    }

    protected void checkProcessJdk() throws RuntimeConfigurationError {
        this.checkHasJdk();
        if (this.isAtLeast8()) {
            this.checkJdkAtLeast7();
        } else {
            boolean jdk8supported;
            Version version = new Version(this.getVersion());
            int atVersion730 = version.compare(7, 3, 0);
            boolean bl = jdk8supported = atVersion730 == 0 && version.getRevision().startsWith(FINAL_REVISION) || atVersion730 > 0;
            if (!jdk8supported) {
                this.checkJdkAtMost7();
            }
        }
    }

    protected boolean isAtLeast8() {
        return new Version(this.getVersion()).getMajor() >= 8;
    }

    public void setDomain(boolean domain) {
        this.DOMAIN = domain;
    }

    public boolean isDomain() {
        return this.DOMAIN;
    }

    public void setServerGroup(String serverGroup) {
        this.SERVER_GROUP = serverGroup;
    }

    public String getServerGroup() {
        return this.SERVER_GROUP;
    }

    private static interface ServerModelContribution
    extends JBossVersionContribution {
        public JavaeeAdmin createServerAdmin(JavaeeServerInstance var1) throws Exception;

        public boolean isExtensionValidationRequired(Artifact var1);

        public boolean isEmptyPasswordAllowed();
    }
}

