/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.util.nodes;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.spring.data.util.nodes.QueryNode;
import com.intellij.spring.data.util.nodes.SimpleLeaf;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerNode
extends QueryNode {
    private final Set<QueryNode> children;

    public ContainerNode(@NotNull String expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/spring/data/util/nodes/ContainerNode", "<init>"));
        }
        super(expression);
        this.children = new LinkedHashSet<QueryNode>();
        String operation = this.getChildrenNodesDelimiter();
        List strings = StringUtil.split((String)expression, (String)operation, (boolean)true, (boolean)false);
        for (int i = 0; i < strings.size(); ++i) {
            String s = (String)strings.get(i);
            this.children.add((QueryNode)this.getChildrenFactory().fun((Object)s));
            if (i == strings.size() - 1) continue;
            this.children.add(new SimpleLeaf(operation));
        }
    }

    protected Function<String, QueryNode> getChildrenFactory() {
        return SimpleLeaf::new;
    }

    @Override
    @NotNull
    public Set<? extends QueryNode> getChildren() {
        Set<QueryNode> set = this.children;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/data/util/nodes/ContainerNode", "getChildren"));
        }
        return set;
    }

    protected String getChildrenNodesDelimiter() {
        return "";
    }

    @Override
    public String getExpression() {
        List strings = ContainerUtil.map(this.getChildren(), (Function)new Function<QueryNode, String>(){

            public String fun(QueryNode queryNode) {
                return queryNode.getExpression();
            }
        });
        return StringUtil.join((Collection)strings, (String)"");
    }
}

