/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.jsp;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlSuppressableInspectionTool;
import com.intellij.jsp.impl.CustomTagDescriptorBase;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.XmlElementVisitor;
import com.intellij.psi.impl.source.jsp.jspXml.JspScriptlet;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.util.CheckTagEmptyBodyInspection;
import org.jetbrains.annotations.NotNull;

public class JspTagBodyContentInspection
extends XmlSuppressableInspectionTool {
    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "holder", "com/intellij/codeInspection/jsp/JspTagBodyContentInspection", "buildVisitor"));
        }
        XmlElementVisitor xmlElementVisitor = new XmlElementVisitor(){

            public void visitXmlTag(XmlTag tag) {
                XmlElementDescriptor descriptor = tag.getDescriptor();
                if (descriptor instanceof CustomTagDescriptorBase) {
                    int type = descriptor.getContentType();
                    switch (type) {
                        case 0: {
                            if (tag.isEmpty() || ContainerUtil.find((Object[])tag.getValue().getChildren(), tag1 -> {
                                if (tag1 instanceof XmlText && !StringUtil.isEmptyOrSpaces((String)((XmlText)tag1).getValue())) {
                                    return true;
                                }
                                return tag1 instanceof XmlTag && !"http://java.sun.com/JSP/Page".equals(((XmlTag)tag1).getNamespace());
                            }) == null) break;
                            holder.registerProblem((PsiElement)tag, "No content allowed inside tags with 'empty' content type", new LocalQuickFix[]{new CheckTagEmptyBodyInspection.Fix()});
                            break;
                        }
                        case 101: {
                            JspScriptlet[] scriptlets = (JspScriptlet[])PsiTreeUtil.getChildrenOfType((PsiElement)tag, JspScriptlet.class);
                            if (scriptlets == null) break;
                            for (JspScriptlet scriptlet : scriptlets) {
                                holder.registerProblem((PsiElement)scriptlet, "Scripting is not allowed inside tags with 'scriptless' content type", new LocalQuickFix[]{new RemoveScriptletsFix()});
                            }
                            break;
                        }
                    }
                }
            }
        };
        if (xmlElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspTagBodyContentInspection", "buildVisitor"));
        }
        return xmlElementVisitor;
    }

    private static class RemoveScriptletsFix
    implements LocalQuickFix {
        private RemoveScriptletsFix() {
        }

        @NotNull
        public String getName() {
            if ("Remove scriptlet(s)" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspTagBodyContentInspection$RemoveScriptletsFix", "getName"));
            }
            return "Remove scriptlet(s)";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/jsp/JspTagBodyContentInspection$RemoveScriptletsFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/codeInspection/jsp/JspTagBodyContentInspection$RemoveScriptletsFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/codeInspection/jsp/JspTagBodyContentInspection$RemoveScriptletsFix", "applyFix"));
            }
            final PsiElement element = descriptor.getPsiElement();
            new WriteCommandAction.Simple(project, new PsiFile[]{element.getContainingFile()}){

                protected void run() throws Throwable {
                    JspScriptlet[] scriptlets = (JspScriptlet[])PsiTreeUtil.getChildrenOfType((PsiElement)element.getParent(), JspScriptlet.class);
                    assert (scriptlets != null);
                    for (JspScriptlet scriptlet : scriptlets) {
                        scriptlet.delete();
                    }
                }
            }.execute();
        }
    }
}

