/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.jsp.index;

import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.css.CssStylesheet;
import com.intellij.psi.css.resolve.CssInclusionContext;
import com.intellij.psi.css.util.AbstractTagUtil;
import com.intellij.psi.impl.source.jsp.JspFileIndex;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JspCssInclusionContext
extends CssInclusionContext {
    @Nullable
    public PsiFile[] getContextFiles(@NotNull PsiFile current) {
        if (current == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "current", "com/intellij/jsp/index/JspCssInclusionContext", "getContextFiles"));
        }
        JspFileIndex index = JspFileIndex.getInstance(current.getProject());
        return index.getIncludingFiles(current);
    }

    @Nullable
    public CssStylesheet getStylesheet(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/jsp/index/JspCssInclusionContext", "getStylesheet"));
        }
        if (file instanceof XmlFile) {
            XmlTag headTag;
            XmlDocument document = ((XmlFile)file).getDocument();
            XmlTag xmlTag = headTag = document != null ? AbstractTagUtil.findGenericHeadTag((XmlDocument)document) : null;
            if (headTag != null) {
                XmlTag[] styleTags;
                for (XmlTag styleTag : styleTags = headTag.findSubTags("style")) {
                    CssStylesheet stylesheet = (CssStylesheet)PsiTreeUtil.getChildOfType((PsiElement)styleTag, CssStylesheet.class);
                    if (stylesheet == null) continue;
                    return stylesheet;
                }
            } else {
                CssStylesheet stylesheet;
                XmlTag styleTag = AbstractTagUtil.findStyleTag((XmlDocument)document);
                if (styleTag != null && (stylesheet = (CssStylesheet)PsiTreeUtil.getChildOfType((PsiElement)styleTag, CssStylesheet.class)) != null) {
                    return stylesheet;
                }
            }
        }
        return null;
    }
}

