/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ws.actions;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.ValidationInfo;
import com.intellij.openapi.util.Computable;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.ws.WSBundle;
import com.intellij.ws.WebServicesPlugin;
import com.intellij.ws.WebServicesPluginSettings;
import com.intellij.ws.actions.DeployWebServiceDialog;
import com.intellij.ws.actions.WebServicePlatformUtils;
import com.intellij.ws.engines.axis.AxisUtil;
import com.intellij.ws.engines.axis.AxisWSEngine;
import com.intellij.ws.engines.axis2.Axis2WSEngine;
import com.intellij.ws.engines.jwsdp.JWSDPWSEngine;
import com.intellij.ws.engines.websphere.WebSphereWSEngine;
import com.intellij.ws.engines.wsengine.DialogWithWebServicePlatform;
import com.intellij.ws.engines.wsengine.WSEngine;
import com.intellij.ws.engines.wsengine.WSEngineManager;
import com.intellij.ws.utils.DeployUtils;
import com.intellij.ws.utils.ui.GenerateFromJavaCodeDialogBase;
import com.intellij.ws.utils.ui.MyDialogWrapper;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class GenerateWsdlFromJavaDialog
extends GenerateFromJavaCodeDialogBase
implements DialogWithWebServicePlatform {
    private JPanel myPanel;
    private JLabel className;
    private ComboBox typeMappingVersion;
    private JLabel typeMappingVersionText;
    private ComboBox soapAction;
    private JLabel soapActionText;
    private ComboBox bindingStyle;
    private ComboBox useItemsInBindings;
    private JLabel bindingStyleText;
    private JLabel useItemsInBindingsText;
    private ComboBox generationType;
    private JLabel generationTypeText;
    private JTable methodsTable;
    private JLabel webServicePlatformText;
    private ComboBox webServicePlatform;
    private WSEngine currentEngine;
    private JScrollPane methodTablePane;
    private JTextField webServiceNamespace;
    private JLabel webServiceNamespaceText;
    private JLabel webServiceURLText;
    private JTextField webServiceURL;
    private boolean requestedOnce;

    public GenerateWsdlFromJavaDialog(Project _project, PsiClass clazz, @Nullable GenerateWsdlFromJavaDialog previousDialog) {
        super(_project, clazz);
        Object[] objectArray = new Object[]{};
        this.$$$setupUI$$$();
        this.setTitle(WSBundle.message("generate.wsdl.from.java.dialog.title", objectArray));
        this.configureComboBox((JComboBox)this.typeMappingVersion, Arrays.asList("1.1", "1.2"));
        this.doInitFor(this.typeMappingVersionText, (JComponent)this.typeMappingVersion, 'v');
        if (previousDialog != null) {
            this.typeMappingVersion.setSelectedItem(previousDialog.typeMappingVersion.getSelectedItem());
        }
        this.configureComboBox((JComboBox)this.soapAction, Arrays.asList("DEFAULT", "OPERATION", "NONE"));
        this.doInitFor(this.soapActionText, (JComponent)this.soapAction, 'o');
        if (previousDialog != null) {
            this.soapAction.setSelectedItem(previousDialog.soapAction.getSelectedItem());
        }
        this.configureComboBox((JComboBox)this.bindingStyle, Arrays.asList("DOCUMENT", "RPC", "WRAPPED"));
        this.doInitFor(this.bindingStyleText, (JComponent)this.bindingStyle, 'b');
        if (previousDialog != null) {
            this.bindingStyle.setSelectedItem(previousDialog.bindingStyle.getSelectedItem());
        }
        this.configureComboBox((JComboBox)this.useItemsInBindings, Arrays.asList("LITERAL", "ENCODED"));
        this.doInitFor(this.useItemsInBindingsText, (JComponent)this.useItemsInBindings, 'u');
        if (previousDialog != null) {
            this.useItemsInBindings.setSelectedItem(previousDialog.useItemsInBindings.getSelectedItem());
        }
        this.configureComboBox((JComboBox)this.generationType, Arrays.asList("All", "Interface", "Implementation"));
        this.doInitFor(this.generationTypeText, (JComponent)this.generationType, 'g');
        this.generationType.setVisible(false);
        this.generationTypeText.setVisible(false);
        this.doInitFor(this.webServiceURLText, this.webServiceURL, 'e');
        if (previousDialog != null) {
            this.webServiceURL.setText(previousDialog.webServiceURL.getText());
        }
        this.doInitFor(this.webServiceNamespaceText, this.webServiceNamespace, 'n');
        if (previousDialog != null) {
            this.webServiceNamespace.setText(previousDialog.webServiceNamespace.getText());
        }
        WebServicePlatformUtils.initWSPlatforms(this);
        this.init();
        this.setupWSPlatformSpecificFields();
    }

    @Override
    public void setCurrentClass(PsiClass psiClass) {
        super.setCurrentClass(psiClass);
        if (this.webServiceNamespace == null) {
            if (!this.requestedOnce) {
                SwingUtilities.invokeLater(() -> this.initWebServiceNamespaceAndUrl(psiClass));
                this.requestedOnce = true;
            }
        } else {
            this.initWebServiceNamespaceAndUrl(psiClass);
        }
    }

    private void initWebServiceNamespaceAndUrl(PsiClass psiClass) {
        if (psiClass != null && this.webServiceNamespace.getText().length() == 0) {
            List<String> lastContexts = WebServicesPlugin.getInstance(this.myProject).getLastContexts();
            String mycontext = lastContexts.size() > 0 ? lastContexts.get(0) : "";
            String wsUrl = AxisUtil.getWebServiceUrlReference(mycontext, psiClass.getQualifiedName().replace('.', '/'));
            this.webServiceNamespace.setText("http://" + DeployWebServiceDialog.buildNSNameFromClass(psiClass, this.currentEngine));
            this.webServiceURL.setText(wsUrl);
        }
    }

    @Override
    protected JComponent getClassName() {
        return this.className;
    }

    protected JComponent createCenterPanel() {
        return this.myPanel;
    }

    protected void doOKAction() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        instance.setLastPlatform(this.getWebServicePlatformCombo().getSelectedItem().toString());
        super.doOKAction();
    }

    @Override
    protected ValidationInfo doValidate(MyDialogWrapper.ValidationData _data) {
        String uptoDateCheck;
        final PsiClass clazz = this.getCurrentClass();
        Object validationResult = clazz != null && clazz.isInterface() ? ((uptoDateCheck = DeployUtils.checkIfClassIsUpToDate(this.myProject, clazz)) != null ? new ValidationInfo(uptoDateCheck, null) : null) : super.doValidate(_data);
        if (validationResult == null) {
            String notAcceptableClazzMessage = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                public String compute() {
                    return GenerateWsdlFromJavaDialog.this.currentEngine.checkNotAcceptableClassForGenerateWsdl(clazz);
                }
            });
            if (notAcceptableClazzMessage != null) {
                return new ValidationInfo(notAcceptableClazzMessage, null);
            }
            MyValidationData validationData = (MyValidationData)_data;
            if (this.currentEngine instanceof AxisWSEngine && validationData.selectedMethods.length == 0) {
                return new ValidationInfo("No methods selected", null);
            }
            try {
                URL uRL = new URL(validationData.webServiceUrl);
            }
            catch (MalformedURLException ex) {
                return new ValidationInfo(WSBundle.message("invalid.web.service.url.validation.message", new Object[0]), (JComponent)this.webServiceURL);
            }
            if (validationData.webServiceNS.length() == 0) {
                return new ValidationInfo(WSBundle.message("invalid.web.service.namespace.validation.message", new Object[0]), (JComponent)this.webServiceNamespace);
            }
            ValidationInfo result = WebServicePlatformUtils.checkIfPlatformIsSetUpCorrectly(this, this.currentEngine);
            if (result != null) {
                return result;
            }
        }
        return validationResult;
    }

    @Override
    @NotNull
    protected String getHelpId() {
        if ("GenerateWsdlFromJava.html" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/ws/actions/GenerateWsdlFromJavaDialog", "getHelpId"));
        }
        return "GenerateWsdlFromJava.html";
    }

    public String getTypeMappingVersion() {
        return this.typeMappingVersion.getSelectedItem().toString();
    }

    public String getSoapAction() {
        return this.soapAction.getSelectedItem().toString();
    }

    public String getBindingStyle() {
        return this.bindingStyle.getSelectedItem().toString();
    }

    public String getUseItemsInBindings() {
        return this.useItemsInBindings.getSelectedItem().toString();
    }

    public String getGenerationType() {
        return this.generationType.getSelectedItem().toString();
    }

    @Override
    protected JTable getMethodsTable() {
        return this.methodsTable;
    }

    @Override
    public JComboBox getWebServicePlatformCombo() {
        return this.webServicePlatform;
    }

    @Override
    public JLabel getWebServicePlaformText() {
        return this.webServicePlatformText;
    }

    @Override
    public void setupWSPlatformSpecificFields() {
        String currentPlatform = (String)this.webServicePlatform.getSelectedItem();
        this.currentEngine = WebServicesPluginSettings.getInstance().getEngineManager().getWSEngineByName(currentPlatform);
        boolean isAxis2 = currentPlatform.equals(Axis2WSEngine.AXIS2_PLATFORM);
        boolean isAxis = currentPlatform.equals("Apache Axis");
        boolean jaxRPC = currentPlatform.equals("JAX_RPC");
        boolean jaxws = currentPlatform.equals(JWSDPWSEngine.JWSDP_PLATFORM);
        boolean websphere = currentPlatform.equals(WebSphereWSEngine.WEBSPHERE_PLATFORM);
        this.soapAction.setVisible(isAxis || websphere);
        this.soapActionText.setVisible(isAxis || websphere);
        this.useItemsInBindings.setVisible(isAxis || isAxis2 || websphere);
        this.useItemsInBindingsText.setVisible(isAxis || isAxis2 || websphere);
        this.bindingStyle.setVisible(isAxis || isAxis2 || jaxRPC || websphere);
        this.bindingStyleText.setVisible(isAxis || isAxis2 || jaxRPC || websphere);
        this.typeMappingVersion.setVisible(isAxis);
        this.typeMappingVersionText.setVisible(isAxis);
        this.methodTablePane.setVisible(isAxis || websphere);
        this.webServiceNamespace.setVisible(!jaxws);
        this.webServiceNamespaceText.setVisible(!jaxws);
        this.pack();
    }

    @Override
    public Module getSelectedModule() {
        PsiClass aClass = this.getCurrentClass();
        return aClass != null ? ModuleUtil.findModuleForPsiElement((PsiElement)aClass) : null;
    }

    @Override
    public JComboBox getModuleChooser() {
        return null;
    }

    @Override
    public String[] getAvailableEngineNames() {
        WebServicesPluginSettings instance = WebServicesPluginSettings.getInstance();
        WSEngineManager engineManager = instance.getEngineManager();
        return engineManager.getAvailableWSEngineNames();
    }

    public WSEngine getCurrentWsEngine() {
        return this.currentEngine;
    }

    public JTextField getWebServiceURL() {
        return this.webServiceURL;
    }

    public JTextField getWebServiceNamespace() {
        return this.webServiceNamespace;
    }

    @Override
    protected GenerateFromJavaCodeDialogBase.MyValidationData createValidationData() {
        return new MyValidationData();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        ComboBox comboBox;
        JLabel jLabel2;
        JTextField jTextField;
        JTextField jTextField2;
        JLabel jLabel3;
        JLabel jLabel4;
        ComboBox comboBox2;
        JLabel jLabel5;
        ComboBox comboBox3;
        ComboBox comboBox4;
        JLabel jLabel6;
        JLabel jLabel7;
        ComboBox comboBox5;
        JLabel jLabel8;
        ComboBox comboBox6;
        JLabel jLabel9;
        JPanel jPanel;
        this.myPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 2, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.typeMappingVersionText = jLabel9 = new JLabel();
        jLabel9.setText("Type mapping version:");
        jLabel9.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.typemapping.version.tooltip"));
        jPanel.add((Component)jLabel9, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.typeMappingVersion = comboBox6 = new ComboBox();
        comboBox6.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.typemapping.version.tooltip"));
        jPanel.add((Component)comboBox6, new GridConstraints(7, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.soapActionText = jLabel8 = new JLabel();
        jLabel8.setText("Soap action:");
        jLabel8.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.soap.action.tooltip"));
        jPanel.add((Component)jLabel8, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.soapAction = comboBox5 = new ComboBox();
        comboBox5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.soap.action.tooltip"));
        jPanel.add((Component)comboBox5, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.bindingStyleText = jLabel7 = new JLabel();
        jLabel7.setText("Binding style:");
        jLabel7.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.binding.style.tooltip"));
        jPanel.add((Component)jLabel7, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.useItemsInBindingsText = jLabel6 = new JLabel();
        jLabel6.setText("Use items in bindings:");
        jLabel6.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.use.items.binding.tooltip"));
        jPanel.add((Component)jLabel6, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.bindingStyle = comboBox4 = new ComboBox();
        comboBox4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.binding.style.tooltip"));
        jPanel.add((Component)comboBox4, new GridConstraints(5, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.useItemsInBindings = comboBox3 = new ComboBox();
        comboBox3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.use.items.binding.tooltip"));
        jPanel.add((Component)comboBox3, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.generationTypeText = jLabel5 = new JLabel();
        jLabel5.setText("Generation type:");
        jLabel5.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.java2wsdl.generatetype.tooltip"));
        jPanel.add((Component)jLabel5, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.generationType = comboBox2 = new ComboBox();
        comboBox2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.java2wsdl.generatetype.tooltip"));
        jPanel.add((Component)comboBox2, new GridConstraints(8, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JBScrollPane jBScrollPane = new JBScrollPane();
        this.methodTablePane = jBScrollPane;
        jBScrollPane.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.methodsforoperations.tooltip"));
        jPanel.add((Component)jBScrollPane, new GridConstraints(1, 0, 1, 2, 0, 3, 7, 7, null, new Dimension(-1, 170), new Dimension(-1, 170)));
        JBTable jBTable = new JBTable();
        this.methodsTable = jBTable;
        jBTable.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.methodsforoperations.tooltip"));
        jBTable.setPreferredScrollableViewportSize(new Dimension(400, 150));
        jBScrollPane.setViewportView((Component)jBTable);
        this.webServiceNamespaceText = jLabel4 = new JLabel();
        jLabel4.setText("Web Service Namespace:");
        jLabel4.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.namespace.tooltip"));
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.webServiceURLText = jLabel3 = new JLabel();
        jLabel3.setText("Web Service URL:");
        jLabel3.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.url.tooltip"));
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.webServiceNamespace = jTextField2 = new JTextField();
        jTextField2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.namespace.tooltip"));
        jPanel.add((Component)jTextField2, new GridConstraints(2, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.webServiceURL = jTextField = new JTextField();
        jTextField.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.url.tooltip"));
        jPanel.add((Component)jTextField, new GridConstraints(3, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.webServicePlatformText = jLabel2 = new JLabel();
        jLabel2.setText("Web Service Platform:");
        jLabel2.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.wstoolkit.tooltip"));
        jPanel.add((Component)jLabel2, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.webServicePlatform = comboBox = new ComboBox();
        comboBox.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.wstoolkit.tooltip"));
        jPanel.add((Component)comboBox, new GridConstraints(9, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(1, 2, new Insets(0, 0, 0, 0), 5, -1, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 0, 1, 2, 0, 3, 3, 3, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Class to generate wsdl for");
        jLabel10.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.classname.wsdl.tooltip"));
        jPanel2.add((Component)jLabel10, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.className = jLabel = new JLabel();
        jLabel.setText("Label");
        jLabel.setToolTipText(ResourceBundle.getBundle("com/intellij/ws/WSBundle").getString("webservice.classname.wsdl.tooltip"));
        jPanel2.add((Component)jLabel, new GridConstraints(0, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(10, 1, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }

    class MyValidationData
    extends GenerateFromJavaCodeDialogBase.MyValidationData {
        String webServiceNS;
        String webServiceUrl;

        MyValidationData() {
            super(GenerateWsdlFromJavaDialog.this);
        }

        @Override
        protected void doAcquire() {
            super.doAcquire();
            this.webServiceNS = GenerateWsdlFromJavaDialog.this.webServiceNamespace.getText();
            this.webServiceUrl = GenerateWsdlFromJavaDialog.this.webServiceURL.getText();
        }
    }
}

