/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.ui.SameHeightPanel;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.javascript.trace.TraceBundle;
import com.intellij.javascript.trace.execution.EventsToolbarPanel;
import com.intellij.javascript.trace.execution.StackToolbarPanel;
import com.intellij.javascript.trace.execution.TraceConsoleProperties;
import com.intellij.javascript.trace.execution.code.CodeRange;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.EventDataReceivedHandler;
import com.intellij.javascript.trace.execution.common.EventDataReceivingHandler;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.common.EventStreamChangeType;
import com.intellij.javascript.trace.execution.common.EventStreamCommand;
import com.intellij.javascript.trace.execution.common.FileLoadedHandler;
import com.intellij.javascript.trace.execution.common.OriginalTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.SessionRunning;
import com.intellij.javascript.trace.execution.common.StackEntryBase;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.javascript.trace.execution.context.ContextTree;
import com.intellij.javascript.trace.execution.context.StackFrameContext;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventStreamNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.search.TraceNavigator;
import com.intellij.javascript.trace.execution.search.TraceSearch;
import com.intellij.javascript.trace.execution.stack.StackNode;
import com.intellij.javascript.trace.execution.stack.StackTree;
import com.intellij.javascript.trace.execution.stack.StackTreeStructure;
import com.intellij.javascript.trace.settings.TraceProjectSettings;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.javascript.trace.settings.TraceSettingsManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Splitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.Timer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TracePanel
extends JPanel
implements TraceContext,
Disposable {
    private RunConfiguration myRunConfiguration;
    private ExecutionEnvironment myEnvironment;
    private TraceSession myTraceSession;
    private TraceConsoleProperties myProperties;
    private ConsoleView myConsole;
    private ContextTree myContextTree;
    private JScrollPane myEventsPane;
    private JScrollPane myStackPane;
    private JScrollPane myContextPane;
    private EventNode mySelectedEventNode;
    private StackFrameContext myContext;
    private EventTree myEventTree;
    private StackTree myStackTree;
    private MyEventGettingRequest myEventGettingRequest;
    private TraceProjectSettings.EventFilterState myActiveFilter = TraceProjectSettings.EventFilterState.NULL_FILTER;
    private static final Logger LOG = Logger.getInstance(TracePanel.class);
    private Timer myEventLoadingLabelTimer;
    private Timer myStackUpdateTimer;
    private SimpleNode myLastSelectedNode;
    private TraceSettingsManager myTraceSettingsManager;
    private TraceSearch myTraceSearch;
    private TraceNavigator myTraceNavigator;
    private Function<StackNode[], StackNode> myStackNodeSelector;
    private SessionRunning myIsSessionRunning = new SessionRunning(){

        @Override
        public boolean isRunning() {
            return TracePanel.this.myTraceSession.isRunning();
        }
    };

    public TracePanel(RunConfiguration runConfiguration, ExecutionEnvironment environment, TraceSession traceSession, TraceConsoleProperties properties, ConsoleView console) {
        super(new BorderLayout(0, 1));
        this.myRunConfiguration = runConfiguration;
        this.myEnvironment = environment;
        this.myTraceSession = traceSession;
        this.myProperties = properties;
        this.myConsole = console;
        this.myTraceSearch = new TraceSearch(this);
        this.myTraceNavigator = new TraceNavigator(this);
        Runnable cancelEventRetrieval = () -> {
            if (this.myEventGettingRequest != null) {
                this.myEventGettingRequest.cancel();
            }
            if (this.myStackTree == null) {
                this.cleanUpStackAndContext();
            }
        };
        traceSession.onError((Consumer<Exception>)((Consumer)error -> cancelEventRetrieval.run()));
        traceSession.onSessionStopped(cancelEventRetrieval);
        this.myEventLoadingLabelTimer = UIUtil.createNamedTimer((String)"TracePanelEvenLoading", (int)300, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (TracePanel.this.myEventGettingRequest != null) {
                    TracePanel.this.setEventLoadingMessageToStackPanel();
                }
            }
        });
        this.myEventLoadingLabelTimer.setRepeats(false);
    }

    private void cleanUpStackAndContext() {
        this.cleanUpStackTreeResources();
        this.cleanUpContextTreeResources();
        this.myContextPane.setViewportView(this.createContextTreeView());
    }

    public void dispose() {
        if (this.myEventGettingRequest != null) {
            this.myEventGettingRequest.cancel();
        }
        this.cleanUpStackTreeResources();
        this.cleanUpEventTreeResources();
        this.cleanUpContextTreeResources();
    }

    public void initUI() {
        this.myTraceSettingsManager = new TraceSettingsManager(this.myRunConfiguration.getProject(), this.myProperties);
        this.myTraceSettingsManager.addSettingsConsumer((Consumer<TraceSettings>)((Consumer)settings -> {
            this.myActiveFilter = settings.getFilter();
            this.myTraceSession.applySettings((TraceSettings)settings);
            if (settings.isRealtimeEvaluationEnabled()) {
                ValueLookupManager.getInstance((Project)this.myRunConfiguration.getProject()).startListening();
            }
        }));
        this.myEventsPane = ScrollPaneFactory.createScrollPane();
        this.myEventsPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 6);
        this.myEventTree = this.createEventsTreeView();
        this.myStackPane = ScrollPaneFactory.createScrollPane();
        this.myStackPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 7);
        this.myContextPane = ScrollPaneFactory.createScrollPane();
        this.myContextPane.putClientProperty(UIUtil.KEEP_BORDER_SIDES, 3);
        this.myTraceSettingsManager.applySettings();
        EventsToolbarPanel eventsToolbarPanel = new EventsToolbarPanel(this.myRunConfiguration.getProject(), this.myProperties, this, this.myEventTree, () -> this.clear(true, true), this);
        StackToolbarPanel stackToolbarPanel = new StackToolbarPanel(this);
        final Splitter rightSplitter = new Splitter();
        rightSplitter.setFirstComponent((JComponent)this.myStackPane);
        rightSplitter.setSecondComponent((JComponent)this.myContextPane);
        rightSplitter.setHonorComponentsMinimumSize(false);
        rightSplitter.setProportion(0.6f);
        final JPanel rightPanel = new JPanel(new BorderLayout());
        rightPanel.add((Component)rightSplitter, "Center");
        rightPanel.add((Component)SameHeightPanel.wrap((JComponent)stackToolbarPanel, (JComponent)eventsToolbarPanel), "North");
        JPanel leftPanel = new JPanel(new BorderLayout());
        leftPanel.add((Component)this.myEventsPane, "Center");
        leftPanel.add((Component)eventsToolbarPanel, "North");
        final Splitter splitter = new Splitter();
        splitter.setFirstComponent((JComponent)leftPanel);
        splitter.setSecondComponent((JComponent)rightPanel);
        splitter.setHonorComponentsMinimumSize(false);
        splitter.setProportion(0.25f);
        this.add((Component)splitter, "Center");
        this.myContextPane.setViewportView(this.createContextTreeView());
        this.myEventsPane.setViewportView((Component)((Object)this.myEventTree));
        Disposer.register((Disposable)this, (Disposable)new Disposable(){

            public void dispose() {
                rightPanel.remove((Component)rightSplitter);
                rightSplitter.dispose();
                TracePanel.this.remove((Component)splitter);
                splitter.dispose();
            }
        });
        this.myTraceSession.onNewEvent(this);
        this.myTraceSession.onNewContext(this);
        this.myTraceSession.onContextChanged(this);
    }

    private void clear(boolean clearEventTreeCache, boolean clearConsole) {
        if (this.myEventGettingRequest != null) {
            this.myEventGettingRequest.cancel();
        }
        if (clearConsole) {
            this.myConsole.clear();
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            this.cleanUpStackAndContext();
            this.myEventTree.clear(false, clearEventTreeCache);
        });
    }

    private EventTree createEventsTreeView() {
        final EventTree treeView = new EventTree(this, this.myIsSessionRunning, this.myTraceSession.isNodeJsSession());
        if (this.myStackUpdateTimer != null) {
            this.myStackUpdateTimer.stop();
        }
        this.myStackUpdateTimer = UIUtil.createNamedTimer((String)"TracePanelEventsTree", (int)50, (ActionListener)new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                TracePanel.this.performStackUpdate(treeView);
            }
        });
        treeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                TracePanel.this.myStackUpdateTimer.restart();
            }
        });
        treeView.addEventStreamInterruptedNodeSelectionHandler(() -> {
            this.cleanUpStackAndContext();
            this.setInterruptedEventStreamMessageToStackPanel();
        });
        treeView.addEventStreamLabelNodeSelectionHandler(() -> {
            this.cleanUpStackAndContext();
            this.setLabelEventStreamMessageToStackPanel();
        });
        treeView.addTraceCloseRequestedHandler((Consumer<EventStreamNode>)((Consumer)eventStreamNode -> {
            FileEditorManager fileEditorManager = FileEditorManager.getInstance((Project)this.myRunConfiguration.getProject());
            for (TraceVirtualFile file : this.myTraceSession.getLoadedTracedSourceFiles(eventStreamNode.getStreamId())) {
                fileEditorManager.closeFile((VirtualFile)file);
            }
        }));
        treeView.addBrowserCommandHandler((Consumer<EventStreamCommand>)((Consumer)command -> this.myTraceSession.executeInBrowser((EventStreamCommand)command)));
        return treeView;
    }

    @Override
    public boolean isLoadingStackTrace() {
        return this.myEventGettingRequest != null;
    }

    private void performStackUpdate(EventTree treeView) {
        SimpleNode selectedNode = treeView.getSelectedNode();
        if (selectedNode != null && selectedNode.equals((Object)this.myLastSelectedNode)) {
            return;
        }
        this.myLastSelectedNode = selectedNode;
        this.cleanUpStackAndContext();
        if (this.myEventGettingRequest != null) {
            this.myEventGettingRequest.cancel();
            this.myEventGettingRequest = null;
        }
        if (selectedNode != null && selectedNode instanceof EventNode) {
            this.myEventLoadingLabelTimer.restart();
            this.myEventGettingRequest = new MyEventGettingRequest(this.myRunConfiguration.getProject(), this.myTraceSession, this.myActiveFilter);
            EventNode eventNode = (EventNode)selectedNode;
            if (!this.myEventGettingRequest.start(eventNode, (Consumer<StackTreeStructure>)((Consumer)structure -> {
                this.mySelectedEventNode = eventNode;
                if (structure.getAllNodes().length > 0) {
                    this.myStackTree = this.createStackTreeView((StackTreeStructure)((Object)structure));
                    this.myStackPane.setViewportView((Component)((Object)this.myStackTree));
                } else {
                    this.setEmptyStackMessageToStackPanel();
                    if (this.myStackNodeSelector != null) {
                        this.myStackNodeSelector.fun((Object)new StackNode[0]);
                        this.myStackNodeSelector = null;
                    }
                }
                this.myEventGettingRequest = null;
                this.myEventLoadingLabelTimer.stop();
            }))) {
                this.myEventGettingRequest = null;
            }
        } else if (this.myStackNodeSelector == null) {
            this.myTraceSearch.reset();
        }
    }

    private void setEmptyStackMessageToStackPanel() {
        this.setStackPanelLabel(TraceBundle.message("console.trace.events.emptyStack", new Object[0]));
    }

    private void setEventLoadingMessageToStackPanel() {
        this.setStackPanelLabel(TraceBundle.message("console.trace.events.eventIsLoading", new Object[0]));
    }

    private void setStackPanelLabel(String text) {
        JPanel panel = new JPanel(new GridBagLayout());
        JLabel label = new JLabel(text);
        label.setBorder(new EmptyBorder(0, 25, 0, 25));
        panel.add((Component)label, new GridBagConstraints());
        this.myStackPane.setViewportView(panel);
    }

    private void setInterruptedEventStreamMessageToStackPanel() {
        this.setStackPanelLabel(TraceBundle.message("console.trace.events.eventContextInterrupted", new Object[0]));
    }

    private void setLabelEventStreamMessageToStackPanel() {
        this.setStackPanelLabel(TraceBundle.message("console.trace.events.eventContextLabel", new Object[0]));
    }

    private StackTree createStackTreeView(@NotNull StackTreeStructure stackTreeStructure) {
        if (stackTreeStructure == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackTreeStructure", "com/intellij/javascript/trace/execution/TracePanel", "createStackTreeView"));
        }
        this.cleanUpStackTreeResources();
        final StackTree treeView = new StackTree(stackTreeStructure, this);
        if (this.myStackNodeSelector != null) {
            treeView.setSelected((StackNode)((Object)this.myStackNodeSelector.fun((Object)treeView.getAllNodes())));
            this.myStackNodeSelector = null;
        }
        treeView.addStackNodeTraceRequestHandler((Consumer<StackNode>)((Consumer)node -> this.myTraceSession.getTracedSourceFile(node.getScope(), this, false)));
        treeView.addStackNodeMappedTraceRequestedHandler((Consumer<StackNode>)((Consumer)node -> this.myTraceSession.getTracedSourceFile(node.getScope(), this, true)));
        treeView.addStackNodeSelectedHandler((Consumer<StackNode>)((Consumer)node -> this.myTraceSession.getTracedSourceFile(node.getScope(), this, this.myProperties.alwaysOpenMappedTraceIfAvailable())));
        treeView.addStackNodeCallerTraceRequestHandler((Consumer<StackNode>)((Consumer)node -> {
            StackNode caller = node.getParentStackNode();
            final RuntimeFunctionScope nodeScope = node.getScope();
            if (caller == null) {
                return;
            }
            final StackFrameContext context = StackFrameContext.create(this.myContext, caller);
            final RuntimeFunctionScope callerScope = caller.getScope();
            this.myTraceSession.getTracedSourceFile(callerScope, new FileLoadedHandler(){

                @Override
                public void fileLoaded(OriginalTraceVirtualFile file, RuntimeFunctionScope functionScope, boolean useMappedSourceIfAvailable) {
                    TraceVirtualFile fileToDisplay = file.getFileToDisplay(context, useMappedSourceIfAvailable);
                    fileToDisplay.setContext(context);
                    TracePanel.openTraceFile(TracePanel.this.myRunConfiguration.getProject(), fileToDisplay, nodeScope.getCallerStatement(callerScope));
                }
            }, this.myProperties.alwaysOpenMappedTraceIfAvailable());
        }));
        treeView.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent event) {
                StackNode selectedNode = (StackNode)treeView.getSelectedNode();
                if (selectedNode != null && selectedNode.getScope() != null) {
                    TracePanel.this.myContext = StackFrameContext.create(TracePanel.this.mySelectedEventNode, selectedNode);
                    TracePanel.this.myContextTree.updateContext(TracePanel.this.myContext);
                    if (TracePanel.this.myProperties.getAutoScrollToTrace()) {
                        TracePanel.this.myStackTree.stackNodeSelected(selectedNode);
                    }
                }
            }
        });
        treeView.addSourceRequestedHandler((Consumer<StackNode>)((Consumer)stackNode -> this.myTraceSession.getTracedSourceFile(stackNode.getScope(), new FileLoadedHandler(){

            @Override
            public void fileLoaded(OriginalTraceVirtualFile file, RuntimeFunctionScope functionScope, boolean useMappedSourceIfAvailable) {
                if (!TracePanel.this.myContext.getStackFrame().equals(functionScope)) {
                    return;
                }
                TraceVirtualFile traceFile = file.getFileToDisplay(TracePanel.this.myContext, useMappedSourceIfAvailable);
                VirtualFile localFile = traceFile.getProjectFile();
                if (localFile == null) {
                    return;
                }
                TracePanel.openFile(TracePanel.this.myRunConfiguration.getProject(), localFile, (Consumer<Editor[]>)editors -> {
                    for (Editor editor : editors) {
                        TextRange activeRange = traceFile.getFunctionRange(editor, functionScope);
                        if (activeRange == TextRange.EMPTY_RANGE) continue;
                        editor.getScrollingModel().scrollTo(TracePanel.getScrollPosition(editor.getDocument(), activeRange), ScrollType.CENTER);
                    }
                });
            }
        }, this.myProperties.alwaysOpenMappedTraceIfAvailable())));
        return treeView;
    }

    private Component createContextTreeView() {
        this.myContextTree = new ContextTree(this.myEnvironment.getProject());
        return this.myContextTree;
    }

    private void cleanUpEventTreeResources() {
        this.myEventsPane.setViewportView(null);
        if (this.myEventTree != null) {
            Disposer.dispose((Disposable)this.myEventTree);
        }
    }

    private void cleanUpStackTreeResources() {
        this.myStackPane.setViewportView(null);
        if (this.myStackTree != null) {
            Disposer.dispose((Disposable)this.myStackTree);
        }
        if (this.myEventLoadingLabelTimer != null) {
            this.myEventLoadingLabelTimer.stop();
        }
        if (this.myStackUpdateTimer != null) {
            this.myStackUpdateTimer.stop();
        }
        this.myStackTree = null;
    }

    private void cleanUpContextTreeResources() {
        this.myContextPane.setViewportView(null);
        Disposer.dispose((Disposable)this.myContextTree);
    }

    @Override
    public void newEventStreamAdded(@NotNull ContextMetadata context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/TracePanel", "newEventStreamAdded"));
        }
        if (this.myEventTree != null) {
            this.myEventTree.addEventStream(context);
        }
    }

    @Override
    public void eventStreamChanged(@NotNull String streamId, @NotNull EventStreamChangeType change) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/TracePanel", "eventStreamChanged"));
        }
        if (change == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "change", "com/intellij/javascript/trace/execution/TracePanel", "eventStreamChanged"));
        }
        if (this.myEventTree != null) {
            if (change == EventStreamChangeType.INTERRUPTED) {
                this.myEventTree.interruptEventStream(streamId);
            }
            if (change == EventStreamChangeType.EXPIRED) {
                this.myEventTree.expireEventStream(streamId);
            }
            if (change == EventStreamChangeType.ACTIVATED) {
                this.myEventTree.activateEventStream(streamId);
            }
        }
    }

    @Override
    public void eventMetadataReceived(EventMetadataExtended metadata) {
        if (this.myEventTree != null) {
            this.myEventTree.eventMetadataReceived(metadata);
            this.myTraceNavigator.resetCache();
        }
    }

    @Override
    public void fileLoaded(OriginalTraceVirtualFile file, RuntimeFunctionScope functionScope, boolean useMappedSourceIfAvailable) {
        if (!this.myContext.getStackFrame().equals(functionScope)) {
            return;
        }
        TraceVirtualFile fileToDisplay = file.getFileToDisplay(this.myContext, useMappedSourceIfAvailable);
        fileToDisplay.setContext(this.myContext);
        TracePanel.openTraceFile(this.myRunConfiguration.getProject(), fileToDisplay, null);
    }

    private static void openTraceFile(@NotNull Project project, @NotNull TraceVirtualFile file, @Nullable RuntimeStatement elementToSelect) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TracePanel", "openTraceFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/execution/TracePanel", "openTraceFile"));
        }
        TracePanel.openFile(project, (VirtualFile)file, (Consumer<Editor[]>)((Consumer)editors -> {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/execution/TracePanel", "lambda$openTraceFile$15"));
            }
            for (Editor editor : editors) {
                TextRange selectRange;
                if (elementToSelect != null && (selectRange = file.getStatementRange(editor, file.getCurrentContext().getStackFrame(), elementToSelect.getCodeElement())) != TextRange.EMPTY_RANGE) {
                    editor.getSelectionModel().setSelection(selectRange.getStartOffset(), selectRange.getEndOffset());
                    editor.getScrollingModel().scrollTo(TracePanel.getScrollPosition(editor.getDocument(), selectRange), ScrollType.CENTER);
                    return;
                }
                editor.getSelectionModel().removeSelection();
                TextRange activeRange = file.getCurrentScopeApproxRange(editor);
                if (activeRange == TextRange.EMPTY_RANGE) continue;
                editor.getScrollingModel().scrollTo(TracePanel.getScrollPosition(editor.getDocument(), activeRange), ScrollType.CENTER);
            }
        }));
    }

    @NotNull
    private static CodeRange getCodeRange(@NotNull Document document, @NotNull TextRange range) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/javascript/trace/execution/TracePanel", "getCodeRange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/javascript/trace/execution/TracePanel", "getCodeRange"));
        }
        int startOffset = range.getStartOffset();
        int endOffset = range.getEndOffset();
        int startLine = document.getLineNumber(startOffset);
        int startColumn = startOffset - document.getLineStartOffset(startLine);
        int endLine = document.getLineNumber(endOffset);
        int endColumn = endOffset - document.getLineStartOffset(endLine);
        CodeRange codeRange = new CodeRange(startLine, endLine, startColumn, endColumn);
        if (codeRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TracePanel", "getCodeRange"));
        }
        return codeRange;
    }

    @NotNull
    private static LogicalPosition getScrollPosition(@NotNull Document document, @NotNull TextRange textRange) {
        if (document == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "document", "com/intellij/javascript/trace/execution/TracePanel", "getScrollPosition"));
        }
        if (textRange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "textRange", "com/intellij/javascript/trace/execution/TracePanel", "getScrollPosition"));
        }
        CodeRange range = TracePanel.getCodeRange(document, textRange);
        LogicalPosition logicalPosition = TracePanel.getScrollPosition(range);
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TracePanel", "getScrollPosition"));
        }
        return logicalPosition;
    }

    @NotNull
    private static LogicalPosition getScrollPosition(@NotNull CodeRange range) {
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "range", "com/intellij/javascript/trace/execution/TracePanel", "getScrollPosition"));
        }
        LogicalPosition logicalPosition = range.getRowStart() == range.getRowEnd() ? new LogicalPosition(range.getRowStart(), Math.min(range.getColStart() + 120, range.getColEnd())) : new LogicalPosition(range.getRowStart(), range.getColStart());
        if (logicalPosition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TracePanel", "getScrollPosition"));
        }
        return logicalPosition;
    }

    private static void openFile(@NotNull Project project, @NotNull VirtualFile file, @NotNull Consumer<Editor[]> openedEditorsConsumer) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TracePanel", "openFile"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/execution/TracePanel", "openFile"));
        }
        if (openedEditorsConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "openedEditorsConsumer", "com/intellij/javascript/trace/execution/TracePanel", "openFile"));
        }
        OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(project, file);
        openFileDescriptor.navigate(false);
        FileEditor[] editors = FileEditorManager.getInstance((Project)project).getAllEditors(file);
        ArrayList<Editor> openedEditors = new ArrayList<Editor>();
        if (editors.length > 0) {
            for (FileEditor editor : editors) {
                TextEditor textEditor = (TextEditor)editor;
                openFileDescriptor.navigateIn(textEditor.getEditor());
                openedEditors.add(textEditor.getEditor());
            }
        }
        try {
            openedEditorsConsumer.consume((Object)openedEditors.toArray(new Editor[openedEditors.size()]));
        }
        catch (Exception ex) {
            LOG.warn((Throwable)ex);
        }
    }

    @Override
    @NotNull
    public TraceSession getTraceSession() {
        TraceSession traceSession = this.myTraceSession;
        if (traceSession == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TracePanel", "getTraceSession"));
        }
        return traceSession;
    }

    @Override
    @NotNull
    public TraceSearch getTraceSearch() {
        TraceSearch traceSearch = this.myTraceSearch;
        if (traceSearch == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TracePanel", "getTraceSearch"));
        }
        return traceSearch;
    }

    @Override
    @NotNull
    public TraceNavigator getTraceNavigator() {
        TraceNavigator traceNavigator = this.myTraceNavigator;
        if (traceNavigator == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TracePanel", "getTraceNavigator"));
        }
        return traceNavigator;
    }

    @Override
    @NotNull
    public TraceSettingsManager getTraceSettingsManager() {
        TraceSettingsManager traceSettingsManager = this.myTraceSettingsManager;
        if (traceSettingsManager == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TracePanel", "getTraceSettingsManager"));
        }
        return traceSettingsManager;
    }

    @Override
    public void select(@NotNull EventNode eventNode, @NotNull Function<StackNode[], StackNode> stackNodeSelector) {
        if (eventNode == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventNode", "com/intellij/javascript/trace/execution/TracePanel", "select"));
        }
        if (stackNodeSelector == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stackNodeSelector", "com/intellij/javascript/trace/execution/TracePanel", "select"));
        }
        if (this.myEventTree != null) {
            if (this.myLastSelectedNode == eventNode && this.myStackTree != null) {
                this.myStackTree.setSelected((StackNode)((Object)stackNodeSelector.fun((Object)this.myStackTree.getAllNodes())));
            } else {
                this.myStackNodeSelector = stackNodeSelector;
                this.myEventTree.setSelected(eventNode);
            }
        }
    }

    @Override
    @Nullable
    public StackTree getCurrentStackTree() {
        return this.myStackTree;
    }

    @Override
    @Nullable
    public EventTree getCurrentEventTree() {
        return this.myEventTree;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProperties.getProject();
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/TracePanel", "getProject"));
        }
        return project;
    }

    @Override
    public void activateToolWindow() {
        ExecutionManager executionManager = ExecutionManager.getInstance((Project)this.myEnvironment.getProject());
        RunContentDescriptor contentDescriptor = this.myEnvironment.getContentToReuse();
        executionManager.getContentManager().toFrontRunContent(DefaultRunExecutor.getRunExecutorInstance(), contentDescriptor);
    }

    private static class MyEventGettingRequest
    implements EventDataReceivingHandler,
    EventDataReceivedHandler {
        private Project myProject;
        private TraceSession mySession;
        private TraceProjectSettings.EventFilterState myActiveFilter;
        private ProgressIndicator myEventPreparingIndicator;
        private final Semaphore myEventPreparingLock;
        private Runnable myCancelDelegate;
        private StackEntryBase[] myEntries;
        private volatile boolean myIsCancelled;

        public MyEventGettingRequest(@NotNull Project project, @NotNull TraceSession session, @NotNull TraceProjectSettings.EventFilterState activeFilter) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/javascript/trace/execution/TracePanel$MyEventGettingRequest", "<init>"));
            }
            if (session == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "session", "com/intellij/javascript/trace/execution/TracePanel$MyEventGettingRequest", "<init>"));
            }
            if (activeFilter == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "activeFilter", "com/intellij/javascript/trace/execution/TracePanel$MyEventGettingRequest", "<init>"));
            }
            this.myActiveFilter = TraceProjectSettings.EventFilterState.NULL_FILTER;
            this.myEventPreparingLock = new Semaphore();
            this.myCancelDelegate = () -> {};
            this.myEntries = new StackEntryBase[0];
            this.myProject = project;
            this.mySession = session;
            this.myActiveFilter = activeFilter;
        }

        public void cancel() {
            this.myCancelDelegate.run();
            this.myIsCancelled = true;
            this.myEventPreparingLock.up();
        }

        public boolean start(final EventNode eventNode, final Consumer<StackTreeStructure> requestFinished) {
            if (!this.mySession.isRunning()) {
                return false;
            }
            this.myEventPreparingLock.down();
            this.myCancelDelegate = this.mySession.getEvent(eventNode.getEvent(), this, this);
            ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, TraceBundle.message("console.trace.stack.loading", new Object[0]), false){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/javascript/trace/execution/TracePanel$MyEventGettingRequest$1", "run"));
                    }
                    if (myIsCancelled) {
                        return;
                    }
                    myEventPreparingIndicator = indicator;
                    myEventPreparingIndicator.setFraction(0.0);
                    myEventPreparingLock.waitFor();
                    if (!myIsCancelled) {
                        StackTreeStructure stackTreeStructure = new StackTreeStructure(myEntries, eventNode.getEvent(), myActiveFilter);
                        MyEventGettingRequest.access$1302(this, null);
                        myEventPreparingIndicator.setFraction(1.0);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (myIsCancelled) {
                                return;
                            }
                            requestFinished.consume((Object)stackTreeStructure);
                        });
                    }
                }
            });
            return true;
        }

        @Override
        public void eventDataReceiving(double progress) {
            if (this.myIsCancelled) {
                return;
            }
            if (this.myEventPreparingIndicator != null) {
                this.myEventPreparingIndicator.setFraction(progress);
            }
        }

        @Override
        public void eventDataReceived(StackEntryBase[] stackEntries) {
            if (this.myIsCancelled) {
                return;
            }
            this.myEntries = stackEntries;
            this.myEventPreparingLock.up();
        }

        static /* synthetic */ StackEntryBase[] access$1302(MyEventGettingRequest x0, StackEntryBase[] x1) {
            x0.myEntries = x1;
            return x1;
        }
    }
}

