/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.events.actions;

import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.events.EventNode;
import com.intellij.javascript.trace.execution.events.EventTree;
import com.intellij.javascript.trace.execution.events.actions.EventNodeAction;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyRequest;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyVirtualFile;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.OpenFileDescriptor;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import org.jetbrains.annotations.NotNull;

public class ShowEventDependencyGraphAction
extends EventNodeAction {
    @Override
    protected void doUpdate(@NotNull AnActionEvent e, @NotNull EventNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/ShowEventDependencyGraphAction", "doUpdate"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/ShowEventDependencyGraphAction", "doUpdate"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/ShowEventDependencyGraphAction", "doUpdate"));
        }
        TraceContext traceContext = tree.getTraceContext();
        if (traceContext == null) {
            e.getPresentation().setEnabledAndVisible(false);
            return;
        }
        TraceSession session = traceContext.getTraceSession();
        if (!session.isRunning()) {
            e.getPresentation().setEnabledAndVisible(false);
        }
    }

    @Override
    protected void doPerform(@NotNull AnActionEvent e, @NotNull EventNode context, @NotNull EventTree tree) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/javascript/trace/execution/events/actions/ShowEventDependencyGraphAction", "doPerform"));
        }
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/javascript/trace/execution/events/actions/ShowEventDependencyGraphAction", "doPerform"));
        }
        if (tree == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/javascript/trace/execution/events/actions/ShowEventDependencyGraphAction", "doPerform"));
        }
        TraceContext traceContext = tree.getTraceContext();
        if (traceContext == null) {
            return;
        }
        TraceSession session = traceContext.getTraceSession();
        String streamId = context.getEvent().getStreamId();
        long eventId = context.getEventId();
        session.getFileDependencyVirtualFile(new FileDependencyRequest(streamId, context.getName(), eventId), (Consumer<FileDependencyVirtualFile>)((Consumer)file -> {
            file.setTraceContext(traceContext);
            ApplicationManager.getApplication().invokeLater(() -> {
                OpenFileDescriptor openFileDescriptor = new OpenFileDescriptor(traceContext.getProject(), (VirtualFile)file);
                openFileDescriptor.navigate(true);
            });
        }));
    }
}

