/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.fileDependency;

import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.fileDependency.FunctionCombination;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class RuntimeDependencyEdge {
    @NotNull
    private final FileNode myFrom;
    @NotNull
    private final FileNode myTo;
    private int myFunctionCount;
    private List<FunctionCombination> myFunctionCombos;

    public RuntimeDependencyEdge(@NotNull FileNode from, @NotNull FileNode to) {
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/javascript/trace/execution/fileDependency/RuntimeDependencyEdge", "<init>"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/javascript/trace/execution/fileDependency/RuntimeDependencyEdge", "<init>"));
        }
        this.myFunctionCombos = new ArrayList<FunctionCombination>();
        this.myFrom = from;
        this.myTo = to;
    }

    public String getName() {
        return this.myFunctionCount + " function combo(s)";
    }

    public FileNode getSource() {
        return this.myFrom;
    }

    public FileNode getTarget() {
        return this.myTo;
    }

    public void addFunctionCombination(@NotNull FunctionCombination functionCombination) {
        if (functionCombination == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionCombination", "com/intellij/javascript/trace/execution/fileDependency/RuntimeDependencyEdge", "addFunctionCombination"));
        }
        this.myFunctionCombos.add(functionCombination);
        ++this.myFunctionCount;
    }

    public FunctionCombination[] getFunctionCombinations() {
        return this.myFunctionCombos.toArray(new FunctionCombination[this.myFunctionCombos.size()]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RuntimeDependencyEdge edge = (RuntimeDependencyEdge)o;
        if (!this.myFrom.getId().equals(edge.myFrom.getId())) {
            return false;
        }
        return this.myTo.getId().equals(edge.myTo.getId());
    }

    public int hashCode() {
        int result = this.myFrom.getId().hashCode();
        result = 31 * result + this.myTo.getId().hashCode();
        return result;
    }
}

