/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.trace.execution.session;

import com.google.common.base.Charsets;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.KillableColoredProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessTerminatedListener;
import com.intellij.javascript.trace.execution.TraceNodeConfiguration;
import com.intellij.javascript.trace.execution.TraceRunConfiguration;
import com.intellij.javascript.trace.execution.code.StaticCodeElement;
import com.intellij.javascript.trace.execution.code.StaticInReturn;
import com.intellij.javascript.trace.execution.common.ContextMetadata;
import com.intellij.javascript.trace.execution.common.EventDataReceivedHandler;
import com.intellij.javascript.trace.execution.common.EventDataReceivingHandler;
import com.intellij.javascript.trace.execution.common.EventMetadata;
import com.intellij.javascript.trace.execution.common.EventMetadataExtended;
import com.intellij.javascript.trace.execution.common.EventMetadataReceivedHandler;
import com.intellij.javascript.trace.execution.common.EventStreamChangeType;
import com.intellij.javascript.trace.execution.common.EventStreamChangedHandler;
import com.intellij.javascript.trace.execution.common.EventStreamCommand;
import com.intellij.javascript.trace.execution.common.FileLoadedHandler;
import com.intellij.javascript.trace.execution.common.MappedSourceFile;
import com.intellij.javascript.trace.execution.common.MappedTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.NewEventStreamHandler;
import com.intellij.javascript.trace.execution.common.OriginalTraceVirtualFile;
import com.intellij.javascript.trace.execution.common.RuntimeFunctionScope;
import com.intellij.javascript.trace.execution.common.RuntimeReturnStatement;
import com.intellij.javascript.trace.execution.common.RuntimeStatement;
import com.intellij.javascript.trace.execution.common.SourceFile;
import com.intellij.javascript.trace.execution.common.StackEntryBase;
import com.intellij.javascript.trace.execution.common.TraceContext;
import com.intellij.javascript.trace.execution.common.TraceLoadedHandler;
import com.intellij.javascript.trace.execution.common.TraceSavedHandler;
import com.intellij.javascript.trace.execution.common.TraceSession;
import com.intellij.javascript.trace.execution.common.TraceVirtualFile;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationRequest;
import com.intellij.javascript.trace.execution.evaluation.ExpressionEvaluationResult;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyGraph;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyRequest;
import com.intellij.javascript.trace.execution.fileDependency.FileDependencyVirtualFile;
import com.intellij.javascript.trace.execution.fileDependency.FileNode;
import com.intellij.javascript.trace.execution.search.TraceSearchRequest;
import com.intellij.javascript.trace.execution.search.TraceSearchResult;
import com.intellij.javascript.trace.execution.session.JsonSerialization;
import com.intellij.javascript.trace.execution.session.StaticCodeElementParser;
import com.intellij.javascript.trace.execution.session.TraceSessionCache;
import com.intellij.javascript.trace.settings.TraceSettings;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.impl.BulkVirtualFileListenerAdapter;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Url;
import com.intellij.util.Urls;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Predicate;
import com.jetbrains.javascript.debugger.FileUrlMapper;
import io.socket.IOAcknowledge;
import io.socket.IOCallback;
import io.socket.SocketIO;
import io.socket.SocketIOException;
import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.builtInWebServer.WebServerPathToFileManager;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TraceSessionImpl
implements TraceSession,
Disposable {
    private final ProcessHandler myProcessHandler;
    private final FileUrlMapper[] fileUrlMappers;
    private MyBackendConnection myBackendConnection;
    private TraceRunConfiguration myConfiguration;
    private Project myProject;
    private VirtualFile myConfigFile;
    private List<Consumer<Exception>> myErrorHandlers = new ArrayList<Consumer<Exception>>();
    private List<Consumer<VirtualFile>> myTraceFileChangedHandlers = new ArrayList<Consumer<VirtualFile>>();
    private List<TraceLoadedHandler> myTraceLoadedHandlers = new ArrayList<TraceLoadedHandler>();
    private TraceSessionCache myCache = new TraceSessionCache();
    private static final String SERVER_STARTED = "spy-js has started";
    private static final Logger LOG = Logger.getInstance(TraceSessionImpl.class);
    private List<Runnable> mySessionStoppedHandlers = new ArrayList<Runnable>();
    private TraceSettings myConfig;
    private boolean myIsLoaded;

    public TraceSessionImpl(TraceRunConfiguration configuration, Project project) throws ExecutionException {
        this.myConfiguration = configuration;
        this.myProject = project;
        this.myProcessHandler = this.createTraceServerProcess();
        this.myBackendConnection = new MyBackendConnection(configuration.getConfigJson());
        this.myConfigFile = this.myConfiguration.getConfigFile();
        this.myConfiguration.configurationStarted(this.myProcessHandler);
        this.myProcessHandler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                String text = event.getText();
                if (text != null && text.contains(TraceSessionImpl.SERVER_STARTED)) {
                    TraceSessionImpl.this.reconnect();
                }
            }

            public void processTerminated(ProcessEvent event) {
                TraceSessionImpl.this.closeConnection();
                TraceSessionImpl.this.myConfiguration.configurationStopped();
                ApplicationManager.getApplication().invokeLater(() -> {
                    for (Runnable handler : TraceSessionImpl.this.mySessionStoppedHandlers) {
                        handler.run();
                    }
                });
            }
        });
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this).subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkVirtualFileListenerAdapter((VirtualFileListener)new VirtualFileAdapter(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$2", "propertyChanged"));
                }
                this.handleAnyFileChange((VirtualFileEvent)event, false);
            }

            public void contentsChanged(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$2", "contentsChanged"));
                }
                this.handleAnyFileChange(event, true);
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$2", "fileDeleted"));
                }
                this.handleAnyFileChange(event, false);
            }

            public void fileMoved(@NotNull VirtualFileMoveEvent event) {
                if (event == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$2", "fileMoved"));
                }
                this.handleAnyFileChange((VirtualFileEvent)event, false);
            }

            private void handleAnyFileChange(VirtualFileEvent event, boolean contentsChanged) {
                if (!TraceSessionImpl.this.myBackendConnection.isOpen()) {
                    return;
                }
                if (TraceSessionImpl.this.myConfigFile != null && TraceSessionImpl.this.myConfigFile.equals(event.getFile())) {
                    TraceSessionImpl.this.myBackendConnection.updateConfigFile(event.getFile().isValid() ? event.getFile().getPath() : null, contentsChanged);
                } else {
                    String remoteUrl = TraceSessionImpl.this.myCache.getRemoteUrlByLocalUrl(event.getFile().getUrl());
                    if (remoteUrl == null) {
                        return;
                    }
                    TraceSessionImpl.this.myBackendConnection.clearFileCache(remoteUrl);
                }
            }
        }));
        FileUrlMapper[] extensions = (FileUrlMapper[])FileUrlMapper.EP_NAME.getExtensions();
        this.fileUrlMappers = extensions.length == 0 ? null : extensions;
    }

    @Override
    public void reconnect() {
        try {
            this.closeConnection();
            this.openConnection();
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public TraceVirtualFile[] getLoadedTracedSourceFiles(@NotNull String streamId) {
        if (streamId == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "streamId", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getLoadedTracedSourceFiles"));
        }
        return this.myCache.getTraceVirtualFilesStreamId(streamId);
    }

    @Override
    public ContextMetadata getContextMetadata(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getContextMetadata"));
        }
        return this.myCache.getContextMetadataById(id);
    }

    @Override
    public String getRemoteTracedFile(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getRemoteTracedFile"));
        }
        return this.myCache.getRemoteUrlByLocalUrl(file.getUrl());
    }

    private void openConnection() throws MalformedURLException {
        this.myBackendConnection.open();
    }

    private void closeConnection() {
        if (this.myBackendConnection != null) {
            this.myBackendConnection.close();
        }
    }

    private void disposeConnection() {
        if (this.myBackendConnection != null) {
            Disposer.dispose((Disposable)this.myBackendConnection);
        }
    }

    @NotNull
    private ProcessHandler createTraceServerProcess() throws ExecutionException {
        GeneralCommandLine commandLine = this.myConfiguration.createCommandLine();
        commandLine.withCharset(Charsets.UTF_8);
        KillableColoredProcessHandler processHandler = new KillableColoredProcessHandler(commandLine);
        ProcessTerminatedListener.attach((ProcessHandler)processHandler);
        processHandler.setShouldDestroyProcessRecursively(true);
        KillableColoredProcessHandler killableColoredProcessHandler = processHandler;
        if (killableColoredProcessHandler == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "createTraceServerProcess"));
        }
        return killableColoredProcessHandler;
    }

    @Override
    public ProcessHandler getProcessHandler() {
        return this.myProcessHandler;
    }

    @Override
    public void applySettings(@NotNull TraceSettings config) {
        if (config == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "config", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "applySettings"));
        }
        this.myConfig = config;
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> connection.applyConfig(this.myConfig)));
    }

    @Override
    public TraceSettings getSettings() {
        return this.myConfig;
    }

    @Override
    public void executeInBrowser(@NotNull EventStreamCommand command) {
        if (command == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "executeInBrowser"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (command == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "command", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$executeInBrowser$1"));
            }
            connection.executeInBrowser(command);
        }));
    }

    @Override
    public void evaluateExpression(@NotNull ExpressionEvaluationRequest request, @NotNull Consumer<ExpressionEvaluationResult> evaluationResultConsumer) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "evaluateExpression"));
        }
        if (evaluationResultConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationResultConsumer", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "evaluateExpression"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$evaluateExpression$2"));
            }
            if (evaluationResultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "evaluationResultConsumer", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$evaluateExpression$2"));
            }
            ((MyBackendConnection)connection).evaluateExpression(request, (Consumer<ExpressionEvaluationResult>)evaluationResultConsumer);
        }));
    }

    @Override
    public void searchFunction(@NotNull TraceSearchRequest request, @NotNull Consumer<TraceSearchResult> searchResultConsumer) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "searchFunction"));
        }
        if (searchResultConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchResultConsumer", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "searchFunction"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$searchFunction$3"));
            }
            if (searchResultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchResultConsumer", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$searchFunction$3"));
            }
            connection.searchFunction(request, searchResultConsumer);
        }));
    }

    @Override
    public void getFileDependencyVirtualFile(@NotNull FileDependencyRequest request, @NotNull Consumer<FileDependencyVirtualFile> fileDependencyGraphConsumer) {
        if (request == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getFileDependencyVirtualFile"));
        }
        if (fileDependencyGraphConsumer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDependencyGraphConsumer", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getFileDependencyVirtualFile"));
        }
        FileDependencyVirtualFile dependencyVirtualFile = this.myCache.getFileDependencyVirtualFile(request);
        if (dependencyVirtualFile != null && dependencyVirtualFile.isUpToDate()) {
            fileDependencyGraphConsumer.consume((Object)dependencyVirtualFile);
            return;
        }
        if (dependencyVirtualFile != null) {
            request.setFileToUpdate(dependencyVirtualFile);
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$getFileDependencyVirtualFile$4"));
            }
            if (fileDependencyGraphConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDependencyGraphConsumer", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$getFileDependencyVirtualFile$4"));
            }
            connection.getFileDependencyGraph(request, fileDependencyGraphConsumer);
        }));
    }

    @Override
    public void saveTrace(@NotNull TraceSavedHandler onTraceSaved) {
        if (onTraceSaved == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onTraceSaved", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "saveTrace"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (onTraceSaved == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onTraceSaved", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$saveTrace$5"));
            }
            connection.saveTrace(onTraceSaved);
        }));
    }

    @Override
    public void loadTrace(@NotNull String trace, final @NotNull TraceLoadedHandler onTraceLoaded) {
        if (trace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "loadTrace"));
        }
        if (onTraceLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onTraceLoaded", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "loadTrace"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (trace == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "trace", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$loadTrace$6"));
            }
            if (onTraceLoaded == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onTraceLoaded", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$loadTrace$6"));
            }
            connection.loadTrace(trace, new TraceLoadedHandler(){

                @Override
                public void traceLoaded(@NotNull String traceId) {
                    if (traceId == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceId", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$3", "traceLoaded"));
                    }
                    TraceSessionImpl.this.myIsLoaded = true;
                    TraceSessionImpl.this.myCache.clear();
                    onTraceLoaded.traceLoaded(traceId);
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (traceId == null) {
                            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "traceId", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$3", "lambda$traceLoaded$0"));
                        }
                        for (TraceLoadedHandler handler : TraceSessionImpl.this.myTraceLoadedHandlers) {
                            handler.traceLoaded(traceId);
                        }
                    });
                }
            });
        }));
    }

    @Override
    public boolean isLoaded() {
        return this.myIsLoaded;
    }

    @Override
    @Nullable
    public StaticCodeElement getCodeElementById(@NotNull String id) {
        if (id == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "id", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getCodeElementById"));
        }
        return this.myCache.getCodeElementById(id);
    }

    private void runOnConnection(Consumer<MyBackendConnection> delegate) {
        if (this.myBackendConnection != null) {
            try {
                delegate.consume((Object)this.myBackendConnection);
            }
            catch (Exception e) {
                this.handleConnectionError(e);
            }
        }
    }

    @Override
    public Runnable getEvent(@NotNull EventMetadataExtended event, @NotNull EventDataReceivingHandler progress, @NotNull EventDataReceivedHandler done) {
        if (event == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getEvent"));
        }
        if (progress == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getEvent"));
        }
        if (done == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getEvent"));
        }
        if (this.isRunning()) {
            try {
                String requestId = this.myBackendConnection.getEvent(event, progress, done);
                return () -> {
                    if (this.isRunning() && requestId != null) {
                        try {
                            this.myCache.putCancelledRequestId(requestId);
                            this.myBackendConnection.stopGettingEvent(requestId);
                        }
                        catch (Exception e) {
                            this.handleConnectionError(e);
                        }
                    }
                };
            }
            catch (Exception e) {
                this.handleConnectionError(e);
            }
        } else {
            done.eventDataReceived(new StackEntryBase[0]);
        }
        return () -> {};
    }

    @Override
    public void ensureFileDataLoaded(@NotNull String[] fileIds, @NotNull Runnable runWhenFileDataLoaded) {
        if (fileIds == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIds", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "ensureFileDataLoaded"));
        }
        if (runWhenFileDataLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runWhenFileDataLoaded", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "ensureFileDataLoaded"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (fileIds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIds", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$ensureFileDataLoaded$9"));
            }
            if (runWhenFileDataLoaded == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runWhenFileDataLoaded", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$ensureFileDataLoaded$9"));
            }
            connection.ensureFileDataLoaded(fileIds, runWhenFileDataLoaded);
        }));
    }

    @Override
    public void getTracedSourceFile(@NotNull RuntimeFunctionScope functionScope, @NotNull FileLoadedHandler done, boolean useMappedSourceIfAvailable) {
        if (functionScope == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "functionScope", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getTracedSourceFile"));
        }
        if (done == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "getTracedSourceFile"));
        }
        try {
            String fileId = functionScope.getFileId();
            final String streamId = functionScope.getEventMetadata().getStreamId();
            final OriginalTraceVirtualFile file = this.myCache.getTraceVirtualFileByIdAndStreamId(fileId, streamId);
            Object[] statementsToLoad = (RuntimeStatement[])ContainerUtil.findAllAsArray((Object[])functionScope.getStatements(), statement -> !statement.isLoaded());
            Integer[] indices = (Integer[])ContainerUtil.map((Object[])statementsToLoad, statement -> statement.getId(), (Object[])new Integer[0]);
            if (file != null && statementsToLoad.length == 0) {
                TraceSessionImpl.invokeFileLoaded(file, functionScope, done, useMappedSourceIfAvailable);
                return;
            }
            if (this.isRunning()) {
                this.myBackendConnection.getFragment(functionScope.getEventMetadata(), indices, file != null ? null : functionScope.getFileId(), new FragmentReceivedHandler((RuntimeStatement[])statementsToLoad, functionScope, done, useMappedSourceIfAvailable){
                    final /* synthetic */ RuntimeStatement[] val$statementsToLoad;
                    final /* synthetic */ RuntimeFunctionScope val$functionScope;
                    final /* synthetic */ FileLoadedHandler val$done;
                    final /* synthetic */ boolean val$useMappedSourceIfAvailable;
                    {
                        this.val$statementsToLoad = runtimeStatementArray;
                        this.val$functionScope = runtimeFunctionScope;
                        this.val$done = fileLoadedHandler;
                        this.val$useMappedSourceIfAvailable = bl;
                    }

                    @Override
                    public void fragmentReceived(SourceFile sourceFile, StackEntryBase[] fragment) {
                        try {
                            OriginalTraceVirtualFile virtualFile = file == null ? TraceSessionImpl.this.createTraceVirtualFile(TraceSessionImpl.this.myCache, sourceFile, streamId) : file;
                            for (int i = 0; i < fragment.length; ++i) {
                                RuntimeReturnStatement returnStatement;
                                RuntimeStatement statement = this.val$statementsToLoad[i];
                                StaticCodeElement element = fragment[i].getStaticCodeElement();
                                statement.update(element);
                                if (!(element instanceof StaticInReturn) || (returnStatement = this.val$functionScope.getReturnStatement()) == null) continue;
                                returnStatement.setInReturnStatement(statement);
                            }
                            if (file == null) {
                                TraceSessionImpl.this.myCache.putTraceVirtualFileIdAndStreamId(sourceFile.getFileId(), streamId, virtualFile);
                            }
                            TraceSessionImpl.invokeFileLoaded(virtualFile, this.val$functionScope, this.val$done, this.val$useMappedSourceIfAvailable);
                        }
                        catch (Exception e) {
                            TraceSessionImpl.this.handleConnectionError(e);
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            this.handleConnectionError(e);
        }
    }

    private OriginalTraceVirtualFile createTraceVirtualFile(TraceSessionCache traceSessionCache, SourceFile sourceFile, String streamId) {
        ArrayList<MappedTraceVirtualFile> mappedVirtualFiles = new ArrayList<MappedTraceVirtualFile>();
        for (MappedSourceFile mappedSourceFile : sourceFile.getMappedSourceFiles()) {
            mappedVirtualFiles.add(new MappedTraceVirtualFile(mappedSourceFile.getUrl(), mappedSourceFile.getSource(), this.findLocalFileByUrl(mappedSourceFile.getUrl()), streamId));
        }
        return new OriginalTraceVirtualFile(traceSessionCache.getRemoteUrlByFileId(sourceFile.getFileId()), sourceFile.getSource(), traceSessionCache.getLocalVirtualFileByRemoteUrl(traceSessionCache.getRemoteUrlByFileId(sourceFile.getFileId())), mappedVirtualFiles.toArray(new MappedTraceVirtualFile[mappedVirtualFiles.size()]), streamId);
    }

    private static void invokeFileLoaded(OriginalTraceVirtualFile file, RuntimeFunctionScope functionScope, FileLoadedHandler handler, boolean useMappedSourceIfAvailable) {
        ApplicationManager.getApplication().invokeLater(() -> handler.fileLoaded(file, functionScope, useMappedSourceIfAvailable));
    }

    @Override
    public void onNewEvent(@NotNull EventMetadataReceivedHandler done) {
        if (done == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "onNewEvent"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (done == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$onNewEvent$13"));
            }
            connection.onNewEvent(done);
        }));
    }

    @Override
    public void onNewContext(@NotNull NewEventStreamHandler onNewContext) {
        if (onNewContext == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onNewContext", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "onNewContext"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (onNewContext == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onNewContext", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$onNewContext$14"));
            }
            connection.onNewContext(onNewContext);
        }));
    }

    @Override
    public void onTraceFileChanged(@NotNull Consumer<VirtualFile> onTraceFileChanged) {
        if (onTraceFileChanged == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onTraceFileChanged", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "onTraceFileChanged"));
        }
        this.myTraceFileChangedHandlers.add(onTraceFileChanged);
    }

    @Override
    public void onContextChanged(@NotNull EventStreamChangedHandler onContextChanged) {
        if (onContextChanged == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onContextChanged", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "onContextChanged"));
        }
        this.runOnConnection((Consumer<MyBackendConnection>)((Consumer)connection -> {
            if (onContextChanged == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onContextChanged", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "lambda$onContextChanged$15"));
            }
            connection.onContextChanged(onContextChanged);
        }));
    }

    @Override
    public void onTraceLoaded(@NotNull TraceLoadedHandler onTraceLoaded) {
        if (onTraceLoaded == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onTraceLoaded", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "onTraceLoaded"));
        }
        this.myTraceLoadedHandlers.add(onTraceLoaded);
    }

    @Override
    public void onSessionStopped(@NotNull Runnable onSessionStopped) {
        if (onSessionStopped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onSessionStopped", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "onSessionStopped"));
        }
        this.mySessionStoppedHandlers.add(onSessionStopped);
    }

    @Override
    public void onError(@NotNull Consumer<Exception> onError) {
        if (onError == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onError", "com/intellij/javascript/trace/execution/session/TraceSessionImpl", "onError"));
        }
        this.myErrorHandlers.add(onError);
    }

    @Override
    public boolean isRunning() {
        return this.myBackendConnection != null && this.myBackendConnection.isOpen();
    }

    @Override
    public boolean isNodeJsSession() {
        return this.myConfiguration instanceof TraceNodeConfiguration;
    }

    public void dispose() {
        this.disposeConnection();
        this.myProcessHandler.putUserData(TraceContext.KEY, null);
        if (!this.myProcessHandler.isProcessTerminated()) {
            this.myProcessHandler.destroyProcess();
        }
    }

    private void fileCached(String url) {
        VirtualFile file = this.findLocalFileByUrl(url);
        if (file == null) {
            return;
        }
        this.myCache.putRemoteUrlLocalVirtualFile(file, url);
        for (Consumer<VirtualFile> handler : this.myTraceFileChangedHandlers) {
            handler.consume((Object)file);
        }
    }

    private VirtualFile findLocalFileByUrl(String url) {
        if (StringUtil.isEmpty((String)url)) {
            return null;
        }
        String protocol = VirtualFileManager.extractProtocol((String)url);
        if (StringUtil.isEmpty((String)protocol)) {
            return LocalFileSystem.getInstance().findFileByPath(url);
        }
        Url fileUrl = Urls.parse((String)url, (boolean)false);
        if (fileUrl == null) {
            return null;
        }
        if (this.fileUrlMappers != null) {
            for (FileUrlMapper mapper : this.fileUrlMappers) {
                VirtualFile file = mapper.getFile(fileUrl, this.myProject, null);
                if (file == null) continue;
                return file;
            }
        }
        return WebServerPathToFileManager.getInstance((Project)this.myProject).findVirtualFile(fileUrl.getPath());
    }

    private void handleConnectionError(Exception error) {
        LOG.warn((Throwable)error);
        ApplicationManager.getApplication().invokeLater(() -> {
            for (Consumer<Exception> handler : this.myErrorHandlers) {
                handler.consume((Object)error);
            }
        });
        if (error instanceof SocketIOException) {
            Disposer.dispose((Disposable)this);
        }
    }

    private static class MyEventReceiver {
        private List<Pair<Integer, StackEntryBase[]>> myReceivedStackEntries;
        private int mySize;
        private int myTotalExpectedStackEntries;
        private String myRequestId;
        private EventDataReceivingHandler myProgress;
        private EventDataReceivedHandler myDone;

        public MyEventReceiver(@NotNull EventDataReceivingHandler progress, @NotNull EventDataReceivedHandler done) {
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyEventReceiver", "<init>"));
            }
            if (done == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyEventReceiver", "<init>"));
            }
            this.myReceivedStackEntries = new ArrayList<Pair<Integer, StackEntryBase[]>>();
            this.myProgress = progress;
            this.myDone = done;
            this.myRequestId = Long.toHexString(Double.doubleToLongBits(Math.random()));
        }

        public boolean isExpectingEvent(String eventRequestId) {
            return this.myRequestId.equals(eventRequestId);
        }

        public void addEventChunk(int chunkId, @NotNull StackEntryBase[] chunk) {
            if (chunk == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "chunk", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyEventReceiver", "addEventChunk"));
            }
            this.mySize += chunk.length;
            this.myReceivedStackEntries.add((Pair<Integer, StackEntryBase[]>)new Pair((Object)chunkId, (Object)chunk));
            this.myProgress.eventDataReceiving((double)this.mySize / (double)this.myTotalExpectedStackEntries);
        }

        public String getRequestId() {
            return this.myRequestId;
        }

        public void finished() {
            this.myProgress.eventDataReceiving(1.0);
            this.myDone.eventDataReceived(this.getEvent());
            this.myReceivedStackEntries.clear();
            this.mySize = 0;
            this.myTotalExpectedStackEntries = 0;
        }

        private StackEntryBase[] getEvent() {
            Collections.sort(this.myReceivedStackEntries, (pair1, pair2) -> ((Integer)pair1.getFirst()).compareTo((Integer)pair2.getFirst()));
            List entries = ContainerUtil.concat(this.myReceivedStackEntries, (Function)new Function<Pair<Integer, StackEntryBase[]>, Collection<? extends StackEntryBase>>(){

                public Collection<StackEntryBase> fun(Pair<Integer, StackEntryBase[]> pair) {
                    return Arrays.asList((Object[])pair.getSecond());
                }
            });
            return entries.toArray(new StackEntryBase[entries.size()]);
        }

        public void setExpectedTotal(int expectedTotal) {
            this.myTotalExpectedStackEntries = expectedTotal;
        }
    }

    private class MyBackendConnection
    implements IOCallback,
    Disposable {
        private static final String SESSION_START = "session.start";
        private static final String SESSION_SAVE = "session.save";
        private static final String SESSION_LOAD = "session.load";
        private static final String CONFIG_FILE_CHANGE = "config.file.change";
        private static final String CONFIG_CHANGE = "config.change";
        private static final String BROWSER_EXECUTE = "browser.execute";
        private static final String FILE_CACHE_CLEAR = "file.cache.clear";
        private static final String FILE_DEPENDENCY_GET = "file.dependency.get";
        private static final String EVENT_GET = "event.get";
        private static final String EVENT_GET_CANCEL = "event.get.cancel";
        private static final String FRAGMENT_GET = "fragment.get";
        private static final String EXPRESSION_EVALUATE = "expression.evaluate";
        private static final String FUNCTION_SEARCH = "function.search";
        private static final String INSTRUMENTATION_MAP_GET = "source.instrumentationMap.get";
        private static final String EVENT_SESSION_NEW = "event.session.new";
        private static final String EVENT_SESSION_DISPOSE = "event.session.dispose";
        private static final String EVENT_CONTEXT_NEW = "event.context.new";
        private static final String EVENT_CONTEXT_EXPIRED = "event.context.expired";
        private static final String EVENT_CONTEXT_ACTIVE = "event.context.active";
        private static final String EVENT_CONTEXT_INTERRUPTION = "event.context.interruption";
        private static final String EVENT_FILE_CACHE = "event.file.cache";
        private static final String EVENT_EVENT_METADATA = "event.event.metadata";
        private static final String EVENT_EVENT_DATA = "event.event.data";
        private static final String EVENT_EVENT_DATA_END = "event.event.data.end";
        private SocketIO mySocket;
        private List<NewEventStreamHandler> myNewContextAddedHandlers = new ArrayList<NewEventStreamHandler>();
        private List<EventStreamChangedHandler> myContextChangedHandlers = new ArrayList<EventStreamChangedHandler>();
        private List<EventMetadataReceivedHandler> myExpectedEventMetadataReceivedHandlers = new ArrayList<EventMetadataReceivedHandler>();
        private List<Runnable> myStartDelegates = new ArrayList<Runnable>();
        private MyEventReceiver myEventReceiver;
        private JSONObject myConfig;

        private MyBackendConnection(JSONObject config) {
            this.myConfig = config;
        }

        public void open() throws MalformedURLException {
            try {
                this.mySocket = new SocketIO("http://127.0.0.1:" + TraceSessionImpl.this.myConfiguration.getProxyPort());
                this.mySocket.connect((IOCallback)this);
                java.util.logging.Logger.getLogger("io.socket").setLevel(Level.OFF);
                for (Runnable delegate : this.myStartDelegates) {
                    delegate.run();
                }
                this.myStartDelegates.clear();
            }
            catch (Exception e) {
                TraceSessionImpl.this.handleConnectionError(e);
            }
        }

        public void onDisconnect() {
        }

        public void onConnect() {
        }

        public void onMessage(String s, IOAcknowledge acknowledge) {
        }

        public void onMessage(JSONObject object, IOAcknowledge acknowledge) {
        }

        public void on(final String s, IOAcknowledge acknowledge, Object ... objects) {
            try {
                JSONObject incomingJson = this.getJsonObject(objects);
                if (s.equals(EVENT_SESSION_NEW)) {
                    this.mySocket.emit(SESSION_START, new IOAcknowledge(){

                        public void ack(Object ... objects) {
                            LOG.info("session started");
                        }
                    }, new Object[]{this.myConfig});
                } else if (s.equals(EVENT_SESSION_DISPOSE)) {
                    LOG.info("session disposed");
                } else if (s.equals(EVENT_CONTEXT_NEW)) {
                    if (!this.myNewContextAddedHandlers.isEmpty()) {
                        String id = incomingJson.getString("id");
                        String doc = incomingJson.optString("doc");
                        String agent = incomingJson.getString("agent");
                        String referrer = incomingJson.optString("referrer");
                        ApplicationManager.getApplication().invokeLater(() -> {
                            for (NewEventStreamHandler handler : this.myNewContextAddedHandlers) {
                                ContextMetadata context = new ContextMetadata(id, doc, agent, referrer);
                                handler.newEventStreamAdded(context);
                                TraceSessionImpl.this.myCache.putContextMetadata(context);
                            }
                        });
                    }
                } else if (s.equals(EVENT_CONTEXT_INTERRUPTION) || s.equals(EVENT_CONTEXT_EXPIRED) || s.equals(EVENT_CONTEXT_ACTIVE)) {
                    if (!this.myContextChangedHandlers.isEmpty()) {
                        final String id = incomingJson.getString("id");
                        ApplicationManager.getApplication().invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                for (EventStreamChangedHandler handler : MyBackendConnection.this.myContextChangedHandlers) {
                                    handler.eventStreamChanged(id, this.getChangeType(s));
                                }
                            }

                            private EventStreamChangeType getChangeType(String event) {
                                return event.equals(MyBackendConnection.EVENT_CONTEXT_INTERRUPTION) ? EventStreamChangeType.INTERRUPTED : (event.equals(MyBackendConnection.EVENT_CONTEXT_EXPIRED) ? EventStreamChangeType.EXPIRED : EventStreamChangeType.ACTIVATED);
                            }
                        });
                    }
                } else if (s.equals(EVENT_FILE_CACHE)) {
                    TraceSessionImpl.this.fileCached(incomingJson.getString("url"));
                } else if (s.equals(EVENT_EVENT_METADATA)) {
                    EventMetadataExtended eventMetadata = JsonSerialization.deserializeEventMetadataExtended(incomingJson, TraceSessionImpl.this.myCache);
                    FileDependencyVirtualFile appDependencyFile = TraceSessionImpl.this.myCache.getFileDependencyVirtualFile(new FileDependencyRequest(eventMetadata.getStreamId(), ""));
                    FileDependencyVirtualFile eventDependencyFile = TraceSessionImpl.this.myCache.getFileDependencyVirtualFile(new FileDependencyRequest(eventMetadata.getStreamId(), "", eventMetadata.getEventId()));
                    if (appDependencyFile != null) {
                        appDependencyFile.setExpired();
                    }
                    if (eventDependencyFile != null) {
                        eventDependencyFile.setExpired();
                    }
                    ApplicationManager.getApplication().invokeLater(() -> {
                        if (!this.myExpectedEventMetadataReceivedHandlers.isEmpty()) {
                            for (EventMetadataReceivedHandler handler : this.myExpectedEventMetadataReceivedHandlers) {
                                handler.eventMetadataReceived(eventMetadata);
                            }
                        }
                    });
                } else if (s.equals(EVENT_EVENT_DATA) || s.equals(EVENT_EVENT_DATA_END)) {
                    String correlationId = incomingJson.getString("correlationId");
                    if (s.equals(EVENT_EVENT_DATA) && this.isExpectingEvent(correlationId)) {
                        StackEntryBase[] receivedEntries = JsonSerialization.deserializeStackBaseEntries(incomingJson, TraceSessionImpl.this.myCache);
                        int chunkId = incomingJson.getInt("chunkId");
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (this.isExpectingEvent(correlationId)) {
                                this.myEventReceiver.addEventChunk(chunkId, receivedEntries);
                            }
                        });
                    } else if (s.equals(EVENT_EVENT_DATA_END) && this.isExpectingEvent(correlationId)) {
                        ApplicationManager.getApplication().invokeLater(() -> {
                            if (this.isExpectingEvent(correlationId)) {
                                this.myEventReceiver.finished();
                            }
                        });
                    }
                }
            }
            catch (Exception e) {
                TraceSessionImpl.this.handleConnectionError(e);
            }
        }

        private boolean isExpectingEvent(String correlationId) {
            return this.myEventReceiver != null && this.myEventReceiver.isExpectingEvent(correlationId);
        }

        public void onError(SocketIOException e) {
            TraceSessionImpl.this.handleConnectionError((Exception)e);
        }

        private JSONObject getJsonObject(Object ... objects) {
            if (objects.length > 0 && objects[0] instanceof JSONObject) {
                return (JSONObject)objects[0];
            }
            return new JSONObject();
        }

        public void close() {
            if (this.mySocket != null) {
                this.mySocket.disconnect();
            }
        }

        public void dispose() {
            this.close();
        }

        public String getEvent(@NotNull EventMetadataExtended eventMetadata, @NotNull EventDataReceivingHandler progress, @NotNull EventDataReceivedHandler done) throws JSONException {
            if (eventMetadata == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventMetadata", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "getEvent"));
            }
            if (progress == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "progress", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "getEvent"));
            }
            if (done == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "getEvent"));
            }
            this.myEventReceiver = new MyEventReceiver(progress, done);
            if (this.mySocket == null) {
                return null;
            }
            final String requestId = this.myEventReceiver.getRequestId();
            Runnable getEventData = () -> {
                if (eventMetadata == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventMetadata", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "lambda$getEvent$4"));
                }
                if (TraceSessionImpl.this.myCache.isRequestCancelled(requestId)) {
                    return;
                }
                try {
                    JSONObject json = JsonSerialization.serializeEventMetadata(eventMetadata);
                    json.put("compact", true);
                    json.put("correlationId", (Object)requestId);
                    this.mySocket.emit(EVENT_GET, new IOAcknowledge(){

                        public void ack(Object ... objects) {
                            if (TraceSessionImpl.this.myCache.isRequestCancelled(requestId)) {
                                return;
                            }
                            try {
                                MyBackendConnection.this.myEventReceiver.setExpectedTotal(Integer.parseInt(objects[0].toString()));
                            }
                            catch (Exception e) {
                                TraceSessionImpl.this.handleConnectionError(e);
                            }
                        }
                    }, new Object[]{json});
                }
                catch (Exception e) {
                    TraceSessionImpl.this.handleConnectionError(e);
                }
            };
            this.ensureFileDataLoaded(eventMetadata.getFileIds(), getEventData);
            return requestId;
        }

        public void ensureFileDataLoaded(@NotNull String[] fileIds, final @NotNull Runnable runWhenFileDataLoaded) {
            if (fileIds == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileIds", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "ensureFileDataLoaded"));
            }
            if (runWhenFileDataLoaded == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runWhenFileDataLoaded", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "ensureFileDataLoaded"));
            }
            final List<String> fileIdList = Arrays.asList(fileIds);
            JSONArray fileIdsToLoadMapFor = new JSONArray(ContainerUtil.subtract(fileIdList, Arrays.asList(TraceSessionImpl.this.myCache.getFileIdsWithLoadedInstrumentationMap())));
            if (fileIdsToLoadMapFor.length() > 0) {
                this.mySocket.emit(INSTRUMENTATION_MAP_GET, new IOAcknowledge(){

                    public void ack(Object ... objects) {
                        try {
                            final JSONObject incomingJson = MyBackendConnection.this.getJsonObject(objects);
                            incomingJson.remove("functionsInFile");
                            for (Object key : new Iterable(){

                                public Iterator iterator() {
                                    return incomingJson.keys();
                                }
                            }) {
                                TraceSessionImpl.this.myCache.putCodeElementId(key.toString(), StaticCodeElementParser.parseCodeElement(incomingJson.getString(key.toString()), TraceSessionImpl.this.myCache));
                            }
                            TraceSessionImpl.this.myCache.addFileIdsWithLoadedInstrumentationMap(fileIdList);
                            runWhenFileDataLoaded.run();
                        }
                        catch (Exception e) {
                            TraceSessionImpl.this.handleConnectionError(e);
                        }
                    }
                }, new Object[]{fileIdsToLoadMapFor});
            } else {
                runWhenFileDataLoaded.run();
            }
        }

        public void getFragment(@NotNull EventMetadata eventMetadata, @NotNull Integer[] ids, String fileId, final @NotNull FragmentReceivedHandler done) throws JSONException {
            if (eventMetadata == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "eventMetadata", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "getFragment"));
            }
            if (ids == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "getFragment"));
            }
            if (done == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "getFragment"));
            }
            if (this.mySocket == null) {
                return;
            }
            JSONObject json = JsonSerialization.serializeEventMetadata(eventMetadata);
            json.put("fileId", (Object)fileId);
            json.put("ids", (Object)new JSONArray((Object)ids));
            this.mySocket.emit(FRAGMENT_GET, new IOAcknowledge(){

                public void ack(Object ... objects) {
                    try {
                        JSONObject json = MyBackendConnection.this.getJsonObject(objects);
                        SourceFile file = JsonSerialization.deserializeSourceFile(json.optJSONObject("source"));
                        StackEntryBase[] entries = JsonSerialization.deserializeStackBaseEntries(json, TraceSessionImpl.this.myCache);
                        done.fragmentReceived(file, entries);
                    }
                    catch (Exception e) {
                        TraceSessionImpl.this.handleConnectionError(e);
                    }
                }
            }, new Object[]{json});
        }

        private void evaluateExpression(@NotNull ExpressionEvaluationRequest request, final Consumer<ExpressionEvaluationResult> expressionEvaluationResultConsumer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "evaluateExpression"));
            }
            if (this.mySocket == null) {
                return;
            }
            JSONObject json = JsonSerialization.serializeExpressionEvaluationRequest(request);
            this.mySocket.emit(EXPRESSION_EVALUATE, new IOAcknowledge(){

                public void ack(Object ... objects) {
                    expressionEvaluationResultConsumer.consume((Object)JsonSerialization.deserializeExpressionEvaluationResult(MyBackendConnection.this.getJsonObject(objects)));
                }
            }, new Object[]{json});
        }

        public void searchFunction(@NotNull TraceSearchRequest request, final @NotNull Consumer<TraceSearchResult> searchResultConsumer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "searchFunction"));
            }
            if (searchResultConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "searchResultConsumer", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "searchFunction"));
            }
            if (this.mySocket == null) {
                return;
            }
            JSONObject json = JsonSerialization.serializeFunctionSearchRequest(request);
            this.mySocket.emit(FUNCTION_SEARCH, new IOAcknowledge(){

                public void ack(Object ... objects) {
                    searchResultConsumer.consume((Object)JsonSerialization.deserializeFunctionSearchResult(MyBackendConnection.this.getJsonObject(objects)));
                }
            }, new Object[]{json});
        }

        public void getFileDependencyGraph(final @NotNull FileDependencyRequest request, final @NotNull Consumer<FileDependencyVirtualFile> fileDependencyGraphConsumer) {
            if (request == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "request", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "getFileDependencyGraph"));
            }
            if (fileDependencyGraphConsumer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileDependencyGraphConsumer", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "getFileDependencyGraph"));
            }
            if (this.mySocket == null) {
                return;
            }
            JSONObject json = JsonSerialization.serializeFileDependencyRequest(request);
            this.mySocket.emit(FILE_DEPENDENCY_GET, new IOAcknowledge(){

                public void ack(Object ... objects) {
                    FileDependencyGraph dependencyGraph = JsonSerialization.deserializeFileDependencyGraph(MyBackendConnection.this.getJsonObject(objects), TraceSessionImpl.this.myCache, request.getStreamId());
                    assert (dependencyGraph != null);
                    FileDependencyVirtualFile file = request.getFileToUpdate();
                    if (file != null) {
                        file.update(dependencyGraph);
                    } else {
                        file = new FileDependencyVirtualFile(dependencyGraph, request.getName());
                        TraceSessionImpl.this.myCache.putFileDependencyVirtualFile(request, file);
                        if (request.getEventId() != null) {
                            file.addNodeFilter(new Predicate<FileNode>(){

                                public boolean apply(@Nullable FileNode input) {
                                    return input != null && input.isUsedInEvent(request.getEventId());
                                }
                            });
                        }
                    }
                    fileDependencyGraphConsumer.consume((Object)file);
                }
            }, new Object[]{json});
        }

        public void onNewEvent(@NotNull EventMetadataReceivedHandler done) {
            if (done == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "done", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "onNewEvent"));
            }
            this.myExpectedEventMetadataReceivedHandlers.add(done);
        }

        public void onNewContext(NewEventStreamHandler onNewContext) {
            this.myNewContextAddedHandlers.add(onNewContext);
        }

        public void onContextChanged(@NotNull EventStreamChangedHandler onContextChanged) {
            if (onContextChanged == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "onContextChanged", "com/intellij/javascript/trace/execution/session/TraceSessionImpl$MyBackendConnection", "onContextChanged"));
            }
            this.myContextChangedHandlers.add(onContextChanged);
        }

        public void clearFileCache(String url) {
            this.mySocket.emit(FILE_CACHE_CLEAR, new Object[]{url});
        }

        public void stopGettingEvent(String requestId) {
            this.mySocket.emit(EVENT_GET_CANCEL, new Object[]{requestId});
        }

        public void updateConfigFile(String path, boolean reload) {
            JSONObject json = new JSONObject();
            try {
                json.put("path", (Object)path);
                json.put("reload", reload);
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
            this.mySocket.emit(CONFIG_FILE_CHANGE, new Object[]{json});
        }

        public boolean isOpen() {
            return this.mySocket != null && this.mySocket.isConnected();
        }

        public void applyConfig(TraceSettings config) {
            this.runWhenConnectionIsOpen(() -> this.mySocket.emit(CONFIG_CHANGE, new Object[]{JsonSerialization.serializeConfig(config)}));
        }

        public void executeInBrowser(EventStreamCommand command) {
            this.mySocket.emit(BROWSER_EXECUTE, new Object[]{JsonSerialization.serializeEventStreamCommand(command)});
        }

        public void saveTrace(final TraceSavedHandler saved) {
            this.mySocket.emit(SESSION_SAVE, new IOAcknowledge(){

                public void ack(Object ... objects) {
                    try {
                        JSONObject json = MyBackendConnection.this.getJsonObject(objects);
                        String file = json.optString("file");
                        if (!StringUtil.isEmpty((String)file)) {
                            saved.traceSaved(file);
                        }
                    }
                    catch (Exception e) {
                        TraceSessionImpl.this.handleConnectionError(e);
                    }
                }
            }, new Object[0]);
        }

        public void loadTrace(String trace, final TraceLoadedHandler onTraceLoaded) {
            this.mySocket.emit(SESSION_LOAD, new IOAcknowledge(){

                public void ack(Object ... objects) {
                    JSONObject json = MyBackendConnection.this.getJsonObject(objects);
                    String traceId = StringUtil.notNullize((String)json.optString("id"));
                    onTraceLoaded.traceLoaded(traceId);
                }
            }, new Object[]{trace});
        }

        private void runWhenConnectionIsOpen(Runnable delegate) {
            if (this.isOpen()) {
                delegate.run();
            } else {
                this.myStartDelegates.add(delegate);
            }
        }
    }

    private static interface FragmentReceivedHandler {
        public void fragmentReceived(SourceFile var1, StackEntryBase[] var2);
    }
}

