/*
 * Decompiled with CFR 0.152.
 */
package com.vladium.emma.ctl;

import com.vladium.emma.EMMAProperties;
import com.vladium.emma.EMMARuntimeException;
import com.vladium.emma.rt.rpc.Request;
import com.vladium.util.IProperties;
import com.vladium.util.Property;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public final class ControlRequest
extends Request {
    public static final String COMMAND_TEST_PING = "test.ping";
    public static final int ID_TEST_PING = 0;
    public static final String COMMAND_GET_COVERAGE = "coverage.get";
    public static final int ID_GET_COVERAGE = 1;
    public static final String COMMAND_DUMP_COVERAGE = "coverage.dump";
    public static final int ID_DUMP_COVERAGE = 2;
    public static final String COMMAND_RESET_COVERAGE = "coverage.reset";
    public static final int ID_RESET_COVERAGE = 3;
    static final ControlRequest[] EMPTY_CONTROL_REQUEST_ARRAY = new ControlRequest[0];
    private final ControlRequestDescriptor m_descriptor;
    private static final Map ID_MAP;

    public static ControlRequest create(String name, String[] args) {
        if (name == null) {
            throw new IllegalArgumentException("null input: name");
        }
        ControlRequestDescriptor descriptor = (ControlRequestDescriptor)ID_MAP.get(name);
        if (descriptor == null) {
            throw new EMMARuntimeException("unknown control command [" + name + "]");
        }
        if (args != null && args.length > descriptor.m_argCount) {
            throw new EMMARuntimeException("too many arguments for [" + name + "], usage: " + descriptor.usage());
        }
        String[] args2 = new String[descriptor.m_argCount];
        if (args != null) {
            System.arraycopy(args, 0, args2, 0, args.length);
        }
        return new ControlRequest(descriptor, args2);
    }

    public final String getName() {
        return this.m_descriptor.m_name;
    }

    public String toString() {
        StringBuffer s = new StringBuffer();
        s.append(this.getName());
        s.append(" (");
        String[] args = this.getArgs();
        int aLimit = args.length;
        for (int a = 0; a < aLimit; ++a) {
            String arg;
            if (a != 0) {
                s.append(',');
            }
            if ((arg = args[a]) == null) continue;
            s.append(arg);
        }
        s.append(')');
        return s.toString();
    }

    void populateDefaultArgs(IProperties properties) {
        if (properties != null) {
            this.m_descriptor.populateRequestArgs(this, properties);
        }
    }

    String[] getMutableArgs2() {
        return this.getMutableArgs();
    }

    private ControlRequest(ControlRequestDescriptor descriptor, String[] args) {
        super(descriptor.m_ID, args);
        this.m_descriptor = descriptor;
    }

    static {
        HashMap<String, ControlRequestDescriptor> map = new HashMap<String, ControlRequestDescriptor>();
        if (map.put(COMMAND_TEST_PING, new TESTPING(COMMAND_TEST_PING, 0, 1)) != null) {
            throw new Error("ID map error");
        }
        if (map.put(COMMAND_GET_COVERAGE, new GETCOVERAGE(COMMAND_GET_COVERAGE, 1, 3)) != null) {
            throw new Error("ID map error");
        }
        if (map.put(COMMAND_DUMP_COVERAGE, new DUMPCOVERAGE(COMMAND_DUMP_COVERAGE, 2, 3)) != null) {
            throw new Error("ID map error");
        }
        if (map.put(COMMAND_RESET_COVERAGE, new RESETCOVERAGE(COMMAND_RESET_COVERAGE, 3, 0)) != null) {
            throw new Error("ID map error");
        }
        ID_MAP = Collections.unmodifiableMap(map);
    }

    private static final class RESETCOVERAGE
    extends ControlRequestDescriptor {
        public void populateRequestArgs(ControlRequest request, IProperties properties) {
        }

        public String usage() {
            return this.m_name;
        }

        RESETCOVERAGE(String name, int ID, int argCount) {
            super(name, ID, argCount);
        }
    }

    private static final class DUMPCOVERAGE
    extends ControlRequestDescriptor {
        public void populateRequestArgs(ControlRequest request, IProperties properties) {
            String[] args = request.getMutableArgs2();
            args[2] = args[2] == null ? "true" : (Property.toBoolean(args[2]) ? "true" : "false");
        }

        public String usage() {
            return this.m_name + ", [<remote pathname>], [yes|no], [yes|no]";
        }

        DUMPCOVERAGE(String name, int ID, int argCount) {
            super(name, ID, argCount);
        }
    }

    private static final class GETCOVERAGE
    extends ControlRequestDescriptor {
        public void populateRequestArgs(ControlRequest request, IProperties properties) {
            String[] args = request.getMutableArgs2();
            if (args[0] == null) {
                args[0] = properties.getProperty("coverage.out.file", "coverage.ec");
            }
            if (args[1] == null) {
                args[1] = properties.getProperty("coverage.out.merge", EMMAProperties.DEFAULT_COVERAGE_DATA_OUT_MERGE.toString());
            } else {
                String string = args[1] = Property.toBoolean(args[1]) ? "true" : "false";
            }
            args[2] = args[2] == null ? "true" : (Property.toBoolean(args[2]) ? "true" : "false");
        }

        public String usage() {
            return this.m_name + ", [<local pathname>], [yes|no], [yes|no]";
        }

        GETCOVERAGE(String name, int ID, int argCount) {
            super(name, ID, argCount);
        }
    }

    private static final class TESTPING
    extends ControlRequestDescriptor {
        public void populateRequestArgs(ControlRequest request, IProperties properties) {
        }

        public String usage() {
            return this.m_name + ", <delay>";
        }

        TESTPING(String name, int ID, int argCount) {
            super(name, ID, argCount);
        }
    }

    private static abstract class ControlRequestDescriptor {
        final String m_name;
        final int m_ID;
        final int m_argCount;

        protected abstract void populateRequestArgs(ControlRequest var1, IProperties var2);

        protected abstract String usage();

        ControlRequestDescriptor(String name, int ID, int argCount) {
            if (name == null) {
                throw new IllegalArgumentException("null input: name");
            }
            this.m_name = name;
            this.m_ID = ID;
            this.m_argCount = argCount;
        }
    }
}

