/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javaee.oss.geronimo.admin;

import com.intellij.javaee.deployment.DeploymentModel;
import com.intellij.javaee.oss.agent.AgentProxyFactory;
import com.intellij.javaee.oss.geronimo.GeronimoUtil;
import com.intellij.javaee.oss.geronimo.admin.GeronimoAdminServerBase;
import com.intellij.javaee.oss.geronimo.model.GeronimoCommonRoot;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.Computable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Geronimo10AdminServerImpl
extends GeronimoAdminServerBase {
    private static final String SPECIFICS_MODULE_NAME = "idea-geronimo-srv10";
    private static final String SPECIFICS_JAR_PATH = "specifics/geronimo10-specifics.jar";

    public Geronimo10AdminServerImpl(AgentProxyFactory agentProxyFactory, List<File> libraries) throws Exception {
        super(agentProxyFactory, libraries, SPECIFICS_MODULE_NAME, SPECIFICS_JAR_PATH, "com.intellij.javaee.oss.geronimo.agent.Geronimo10Agent");
    }

    @Override
    @NotNull
    protected String getDeploymentModelName(final DeploymentModel deployment, File source) throws Exception {
        String result = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

            @Nullable
            public String compute() {
                GeronimoCommonRoot root = GeronimoUtil.getCommonRoot(deployment);
                return root != null ? root.getConfigId().getStringValue() : null;
            }
        });
        if (result == null) {
            result = Geronimo10AdminServerImpl.getDeploymentId(source);
        }
        String string = result;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/javaee/oss/geronimo/admin/Geronimo10AdminServerImpl", "getDeploymentModelName"));
        }
        return string;
    }

    private static String getDeploymentId(File file) {
        String name = file.getName();
        if (name.indexOf(46) > 0) {
            name = name.substring(0, name.lastIndexOf(46));
        }
        return name;
    }
}

