/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.osgi.project;

import aQute.lib.utf8properties.UTF8Properties;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.InvalidVirtualFileAccessException;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SoftHashMap;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.osgi.project.BundleManifest;
import org.osmorc.facet.OsmorcFacet;
import org.osmorc.facet.OsmorcFacetConfiguration;

public class BundleManifestCache {
    private final Project myProject;
    private final ProjectFileIndex myIndex;
    private final CachedValuesManager myManager;
    private final Map<Object, CachedValue<BundleManifest>> myCache;

    public static BundleManifestCache getInstance(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/osgi/project/BundleManifestCache", "getInstance"));
        }
        return (BundleManifestCache)ServiceManager.getService((Project)project, BundleManifestCache.class);
    }

    public BundleManifestCache(@NotNull Project project, @NotNull ProjectFileIndex index, @NotNull CachedValuesManager manager) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/jetbrains/osgi/project/BundleManifestCache", "<init>"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "org/jetbrains/osgi/project/BundleManifestCache", "<init>"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manager", "org/jetbrains/osgi/project/BundleManifestCache", "<init>"));
        }
        this.myProject = project;
        this.myIndex = index;
        this.myManager = manager;
        this.myCache = Collections.synchronizedMap(new SoftHashMap());
    }

    @Nullable
    public BundleManifest getManifest(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiClass", "org/jetbrains/osgi/project/BundleManifestCache", "getManifest"));
        }
        PsiFile classOwner = psiClass.getContainingFile();
        return classOwner != null ? this.getManifest((PsiFileSystemItem)classOwner) : null;
    }

    @Nullable
    public BundleManifest getManifest(@NotNull PsiFileSystemItem item) {
        if (item == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "org/jetbrains/osgi/project/BundleManifestCache", "getManifest"));
        }
        VirtualFile file = item.getVirtualFile();
        if (file != null) {
            List entries = this.myIndex.getOrderEntriesForFile(file);
            if (entries.size() == 1 && entries.get(0) instanceof JdkOrderEntry) {
                return new JdkBundleManifest();
            }
            Module module = this.myIndex.getModuleForFile(file);
            if (module != null) {
                return this.getManifest(module);
            }
            VirtualFile libRoot = this.myIndex.getClassRootForFile(file);
            if (libRoot != null) {
                return this.getManifest(libRoot);
            }
        }
        return null;
    }

    @Nullable
    public BundleManifest getManifest(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/jetbrains/osgi/project/BundleManifestCache", "getManifest"));
        }
        OsmorcFacet facet = OsmorcFacet.getInstance(module);
        if (facet == null) {
            return null;
        }
        CachedValue value = this.myCache.get((Object)facet);
        if (value == null) {
            value = this.myManager.createCachedValue(() -> {
                OsmorcFacetConfiguration configuration = (OsmorcFacetConfiguration)facet.getConfiguration();
                BundleManifest manifest = null;
                List dependencies = ContainerUtil.newSmartList((Object)configuration);
                switch (configuration.getManifestGenerationMode()) {
                    case Manually: {
                        PsiFile manifestFile = BundleManifestCache.findInModuleRoots(facet.getModule(), configuration.getManifestLocation());
                        if (manifestFile != null) {
                            manifest = BundleManifestCache.readManifest(manifestFile);
                            dependencies.add(manifestFile);
                            break;
                        }
                        dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
                        break;
                    }
                    case OsmorcControlled: {
                        HashMap map = ContainerUtil.newHashMap(configuration.getAdditionalPropertiesAsMap());
                        map.put("Bundle-SymbolicName", configuration.getBundleSymbolicName());
                        map.put("Bundle-Version", configuration.getBundleVersion());
                        map.put("Bundle-Activator", configuration.getBundleActivator());
                        manifest = new BundleManifest(map);
                        break;
                    }
                    case Bnd: {
                        PsiFile bndFile = BundleManifestCache.findInModuleRoots(facet.getModule(), configuration.getBndFileLocation());
                        if (bndFile != null) {
                            manifest = BundleManifestCache.readProperties(bndFile);
                            dependencies.add(bndFile);
                            break;
                        }
                        dependencies.add(PsiModificationTracker.MODIFICATION_COUNT);
                        break;
                    }
                }
                return CachedValueProvider.Result.create(manifest, (Collection)dependencies);
            }, false);
            this.myCache.put((Object)facet, (CachedValue<BundleManifest>)value);
        }
        return (BundleManifest)value.getValue();
    }

    @Nullable
    public BundleManifest getManifest(@NotNull VirtualFile libRoot) {
        if (libRoot == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libRoot", "org/jetbrains/osgi/project/BundleManifestCache", "getManifest"));
        }
        CachedValue value = this.myCache.get(libRoot);
        if (value == null) {
            value = this.myManager.createCachedValue(() -> {
                if (libRoot == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "libRoot", "org/jetbrains/osgi/project/BundleManifestCache", "lambda$getManifest$1"));
                }
                VirtualFile manifestFile = libRoot.findFileByRelativePath("META-INF/MANIFEST.MF");
                PsiFile psiFile = manifestFile != null ? PsiManager.getInstance((Project)this.myProject).findFile(manifestFile) : null;
                BundleManifest manifest = manifestFile != null ? BundleManifestCache.readManifest(psiFile) : null;
                return CachedValueProvider.Result.createSingleDependency((Object)manifest, (Object)libRoot);
            }, false);
            this.myCache.put(libRoot, (CachedValue<BundleManifest>)value);
        }
        return (BundleManifest)value.getValue();
    }

    private static PsiFile findInModuleRoots(Module module, String path) {
        for (VirtualFile root : ModuleRootManager.getInstance((Module)module).getContentRoots()) {
            VirtualFile file = root.findFileByRelativePath(path);
            if (file == null) continue;
            return PsiManager.getInstance((Project)module.getProject()).findFile(file);
        }
        return null;
    }

    private static BundleManifest readManifest(PsiFile manifestFile) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(manifestFile.getText().getBytes("UTF-8"));
            Attributes attributes = new Manifest(stream).getMainAttributes();
            HashMap map = ContainerUtil.newHashMap();
            for (Object key : attributes.keySet()) {
                String name = key.toString();
                map.put(name, attributes.getValue(name));
            }
            return new BundleManifest(map, manifestFile);
        }
        catch (IOException iOException) {
        }
        catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
            // empty catch block
        }
        return null;
    }

    private static BundleManifest readProperties(PsiFile propertiesFile) {
        try {
            VirtualFile file;
            UTF8Properties properties = new UTF8Properties();
            properties.load((Reader)new StringReader(propertiesFile.getText()));
            HashMap map = ContainerUtil.newHashMap();
            for (Object key : properties.keySet()) {
                String name = key.toString();
                map.put(name, properties.getProperty(name));
            }
            if (map.get("Bundle-SymbolicName") == null && (file = propertiesFile.getVirtualFile()) != null) {
                if (!"bnd.bnd".equals(file.getName())) {
                    map.put("Bundle-SymbolicName", FileUtil.getNameWithoutExtension((String)file.getName()));
                } else if (file.getParent() != null) {
                    map.put("Bundle-SymbolicName", file.getParent().getName());
                }
            }
            return new BundleManifest(map, propertiesFile);
        }
        catch (IOException iOException) {
        }
        catch (InvalidVirtualFileAccessException invalidVirtualFileAccessException) {
            // empty catch block
        }
        return null;
    }

    private static class JdkBundleManifest
    extends BundleManifest {
        public JdkBundleManifest() {
            super(Collections.emptyMap());
        }

        @Override
        public String getBundleSymbolicName() {
            return "";
        }

        @Override
        public String getExportedPackage(@NotNull String packageName) {
            if (packageName == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/jetbrains/osgi/project/BundleManifestCache$JdkBundleManifest", "getExportedPackage"));
            }
            return packageName;
        }
    }
}

