/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc;

import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerAdapter;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleComponent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.osmorc.facet.OsmorcFacetType;
import org.osmorc.impl.AdditionalJARContentsWatcherManager;

public class OsmorcModuleComponent
implements ModuleComponent {
    private final Module myModule;

    public OsmorcModuleComponent(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "org/osmorc/OsmorcModuleComponent", "<init>"));
        }
        this.myModule = module;
    }

    @NonNls
    @NotNull
    public String getComponentName() {
        if ("OsmorcModuleComponent" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/OsmorcModuleComponent", "getComponentName"));
        }
        return "OsmorcModuleComponent";
    }

    public void initComponent() {
        this.myModule.getMessageBus().connect((Disposable)this.myModule).subscribe(FacetManager.FACETS_TOPIC, (Object)new FacetManagerAdapter(){

            public void facetAdded(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/osmorc/OsmorcModuleComponent$1", "facetAdded"));
                }
                OsmorcModuleComponent.this.handleFacetChange(facet);
            }

            public void facetConfigurationChanged(@NotNull Facet facet) {
                if (facet == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facet", "org/osmorc/OsmorcModuleComponent$1", "facetConfigurationChanged"));
                }
                OsmorcModuleComponent.this.handleFacetChange(facet);
            }
        });
    }

    public void disposeComponent() {
    }

    public void projectOpened() {
    }

    public void projectClosed() {
        AdditionalJARContentsWatcherManager.getInstance(this.myModule).cleanup();
    }

    public void moduleAdded() {
    }

    private void handleFacetChange(Facet facet) {
        if (facet.getTypeId() == OsmorcFacetType.ID) {
            AdditionalJARContentsWatcherManager.getInstance(this.myModule).updateWatcherSetup();
        }
    }
}

