/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.run.ui;

import com.intellij.execution.ui.DefaultJreSelector;
import com.intellij.execution.ui.JrePathEditor;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SettingsEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerProjectExtension;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.RawCommandLineEditor;
import com.intellij.ui.SpeedSearchComparator;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBTabbedPane;
import com.intellij.ui.table.JBTable;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.IntStream;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSpinner;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.SpinnerNumberModel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.text.DefaultFormatterFactory;
import org.jetbrains.annotations.NotNull;
import org.osmorc.frameworkintegration.FrameworkInstanceDefinition;
import org.osmorc.frameworkintegration.FrameworkIntegrator;
import org.osmorc.frameworkintegration.FrameworkIntegratorRegistry;
import org.osmorc.i18n.OsmorcBundle;
import org.osmorc.run.OsgiRunConfiguration;
import org.osmorc.run.OsgiRunConfigurationChecker;
import org.osmorc.run.OsgiRunConfigurationCheckerProvider;
import org.osmorc.run.ui.BundleSelector;
import org.osmorc.run.ui.FrameworkRunPropertiesEditor;
import org.osmorc.run.ui.JSpinnerCellEditor;
import org.osmorc.run.ui.SelectedBundle;
import org.osmorc.settings.ApplicationSettings;
import org.osmorc.util.OsgiUiUtil;

public class OsgiRunConfigurationEditor
extends SettingsEditor<OsgiRunConfiguration> {
    private JTabbedPane root;
    private JComboBox myFrameworkInstances;
    private JSpinner myFrameworkStartLevel;
    private JSpinner myDefaultStartLevel;
    private JPanel myBundlesPanel;
    private JTable myBundlesTable;
    private RawCommandLineEditor myVmOptions;
    private RawCommandLineEditor myProgramParameters;
    private JRadioButton myOsmorcControlledDir;
    private JRadioButton myUserDefinedDir;
    private TextFieldWithBrowseButton myWorkingDirField;
    private JrePathEditor myJrePathEditor;
    private JCheckBox myClassPathAllBundles;
    private JPanel myAdditionalPropertiesPanel;
    private final Project myProject;
    private OsgiRunConfiguration myRunConfiguration;
    private FrameworkRunPropertiesEditor myCurrentRunPropertiesEditor;

    public OsgiRunConfigurationEditor(Project project) {
        this.myProject = project;
        this.$$$setupUI$$$();
        this.myJrePathEditor.setDefaultJreSelector(DefaultJreSelector.projectSdk((Project)project));
        this.myFrameworkStartLevel.setModel(new SpinnerNumberModel(0, 0, Integer.MAX_VALUE, 1));
        JSpinner.DefaultEditor editor = (JSpinner.DefaultEditor)this.myFrameworkStartLevel.getEditor();
        editor.getTextField().setFormatterFactory(new DefaultFormatterFactory(new JSpinnerCellEditor.MyNumberFormatter("Auto")));
        this.myDefaultStartLevel.setModel(new SpinnerNumberModel(1, 1, Integer.MAX_VALUE, 1));
        DefaultComboBoxModel<FrameworkInstanceDefinition> model = new DefaultComboBoxModel<FrameworkInstanceDefinition>();
        model.addElement(null);
        for (FrameworkInstanceDefinition instance : ApplicationSettings.getInstance().getActiveFrameworkInstanceDefinitions()) {
            model.addElement(instance);
        }
        this.myFrameworkInstances.setModel(model);
        this.myFrameworkInstances.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                OsgiRunConfigurationEditor.this.onFrameworkChange();
            }
        });
        this.myFrameworkInstances.setRenderer(new OsgiUiUtil.FrameworkInstanceRenderer("[project default]"));
        this.myBundlesTable.setModel(new RunConfigurationTableModel());
        this.myBundlesTable.setRowSelectionAllowed(true);
        this.myBundlesTable.setColumnSelectionAllowed(false);
        this.myBundlesTable.setDefaultEditor(Integer.class, new JSpinnerCellEditor());
        this.myBundlesTable.setDefaultRenderer(Integer.class, new JSpinnerCellEditor());
        this.myBundlesTable.setAutoCreateRowSorter(true);
        this.myBundlesPanel.add((Component)ToolbarDecorator.createDecorator((JTable)this.myBundlesTable).setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                OsgiRunConfigurationEditor.this.onAddClick();
            }
        }).setRemoveAction(new AnActionButtonRunnable(){

            public void run(AnActionButton button) {
                OsgiRunConfigurationEditor.this.onRemoveClick();
            }
        }).disableUpDownActions().createPanel(), "Center");
        this.myBundlesTable.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                int width = OsgiRunConfigurationEditor.this.myBundlesTable.getWidth();
                if (width > 200) {
                    OsgiRunConfigurationEditor.this.myBundlesTable.getColumnModel().getColumn(0).setPreferredWidth(width - 200);
                    OsgiRunConfigurationEditor.this.myBundlesTable.getColumnModel().getColumn(1).setPreferredWidth(80);
                    OsgiRunConfigurationEditor.this.myBundlesTable.getColumnModel().getColumn(2).setPreferredWidth(120);
                }
            }
        });
        new TableSpeedSearch(this.myBundlesTable).setComparator(new SpeedSearchComparator(false));
        this.myOsmorcControlledDir.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent e) {
                boolean isUserDefined = !OsgiRunConfigurationEditor.this.myOsmorcControlledDir.isSelected();
                OsgiRunConfigurationEditor.this.myWorkingDirField.setEnabled(isUserDefined);
            }
        });
        FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
        String title = OsmorcBundle.message("run.configuration.working.dir.title", new Object[0]);
        String description = OsmorcBundle.message("run.configuration.working.dir.description", new Object[0]);
        this.myWorkingDirField.addBrowseFolderListener(title, description, null, descriptor);
        this.myWorkingDirField.getTextField().setColumns(30);
        this.myVmOptions.getTextField().setPreferredSize(new Dimension(100, 20));
        this.myProgramParameters.getTextField().setPreferredSize(new Dimension(100, 20));
    }

    private void onFrameworkChange() {
        if (this.myFrameworkInstances.getSelectedItem() != null) {
            FrameworkInstanceDefinition instance = (FrameworkInstanceDefinition)((Object)this.myFrameworkInstances.getSelectedItem());
            FrameworkIntegrator integrator = FrameworkIntegratorRegistry.getInstance().findIntegratorByInstanceDefinition(instance);
            assert (integrator != null) : instance;
            this.myAdditionalPropertiesPanel.removeAll();
            this.myCurrentRunPropertiesEditor = integrator.createRunPropertiesEditor();
            if (this.myCurrentRunPropertiesEditor != null) {
                this.myAdditionalPropertiesPanel.removeAll();
                this.myAdditionalPropertiesPanel.add((Component)this.myCurrentRunPropertiesEditor.getUI(), "Center");
                if (this.myRunConfiguration != null) {
                    this.myCurrentRunPropertiesEditor.resetEditorFrom(this.myRunConfiguration);
                    OsgiRunConfigurationChecker checker = null;
                    if (integrator instanceof OsgiRunConfigurationCheckerProvider) {
                        checker = ((OsgiRunConfigurationCheckerProvider)((Object)integrator)).getOsgiRunConfigurationChecker();
                    }
                    this.myRunConfiguration.setAdditionalChecker(checker);
                }
            }
            RunConfigurationTableModel model = this.getTableModel();
            model.removeAllOfType(SelectedBundle.BundleType.FrameworkBundle);
        }
    }

    private RunConfigurationTableModel getTableModel() {
        return (RunConfigurationTableModel)this.myBundlesTable.getModel();
    }

    private void onAddClick() {
        FrameworkInstanceDefinition instance = (FrameworkInstanceDefinition)((Object)this.myFrameworkInstances.getSelectedItem());
        BundleSelector selector = new BundleSelector(this.myProject, instance, this.getBundlesToRun());
        if (selector.showAndGet()) {
            RunConfigurationTableModel model = this.getTableModel();
            for (SelectedBundle aModule : selector.getSelectedBundles()) {
                model.addBundle(aModule);
            }
        }
    }

    private void onRemoveClick() {
        int[] indices = IntStream.of(this.myBundlesTable.getSelectedRows()).map(this.myBundlesTable::convertRowIndexToModel).sorted().toArray();
        RunConfigurationTableModel model = this.getTableModel();
        for (int i = indices.length - 1; i >= 0; --i) {
            model.removeBundleAt(indices[i]);
        }
    }

    protected void resetEditorFrom(OsgiRunConfiguration osgiRunConfiguration) {
        VirtualFilePointer outputDirPointer;
        CompilerProjectExtension extension;
        this.myRunConfiguration = osgiRunConfiguration;
        this.myVmOptions.setText(osgiRunConfiguration.getVmParameters());
        this.myProgramParameters.setText(osgiRunConfiguration.getProgramParameters());
        this.myFrameworkInstances.setSelectedItem((Object)osgiRunConfiguration.getInstanceToUse());
        this.myClassPathAllBundles.setSelected(osgiRunConfiguration.isIncludeAllBundlesInClassPath());
        if (this.myCurrentRunPropertiesEditor != null) {
            this.myCurrentRunPropertiesEditor.resetEditorFrom(osgiRunConfiguration);
        }
        List<SelectedBundle> modules = osgiRunConfiguration.getBundlesToDeploy();
        RunConfigurationTableModel model = this.getTableModel();
        while (model.getRowCount() > 0) {
            model.removeBundleAt(0);
        }
        for (SelectedBundle module : modules) {
            model.addBundle(module);
        }
        this.myBundlesTable.getColumnModel().getColumn(1).setPreferredWidth(200);
        this.myFrameworkStartLevel.setValue(osgiRunConfiguration.getFrameworkStartLevel());
        this.myDefaultStartLevel.setValue(osgiRunConfiguration.getDefaultStartLevel());
        boolean useUserDefinedFields = !osgiRunConfiguration.isGenerateWorkingDir();
        this.myWorkingDirField.setText(osgiRunConfiguration.getWorkingDir());
        if (this.myWorkingDirField.getText().length() == 0 && (extension = CompilerProjectExtension.getInstance((Project)this.myProject)) != null && (outputDirPointer = extension.getCompilerOutputPointer()) != null) {
            this.myWorkingDirField.setText(VfsUtilCore.urlToPath((String)(outputDirPointer.getUrl() + "/run.osgi/")));
        }
        this.myWorkingDirField.setEnabled(useUserDefinedFields);
        this.myUserDefinedDir.setSelected(useUserDefinedFields);
        this.myOsmorcControlledDir.setSelected(!useUserDefinedFields);
        this.myJrePathEditor.setPathOrName(osgiRunConfiguration.getAlternativeJrePath(), osgiRunConfiguration.isUseAlternativeJre());
    }

    protected void applyEditorTo(OsgiRunConfiguration osgiRunConfiguration) throws ConfigurationException {
        osgiRunConfiguration.setBundlesToDeploy(this.getBundlesToRun());
        osgiRunConfiguration.setVmParameters(this.myVmOptions.getText());
        osgiRunConfiguration.setProgramParameters(this.myProgramParameters.getText());
        osgiRunConfiguration.setIncludeAllBundlesInClassPath(this.myClassPathAllBundles.isSelected());
        osgiRunConfiguration.setWorkingDir(this.myWorkingDirField.getText().replace('\\', '/'));
        osgiRunConfiguration.setUseAlternativeJre(this.myJrePathEditor.isAlternativeJreSelected());
        osgiRunConfiguration.setAlternativeJrePath(this.myJrePathEditor.getJrePathOrName());
        osgiRunConfiguration.setFrameworkStartLevel((Integer)this.myFrameworkStartLevel.getValue());
        osgiRunConfiguration.setDefaultStartLevel((Integer)this.myDefaultStartLevel.getValue());
        osgiRunConfiguration.setGenerateWorkingDir(this.myOsmorcControlledDir.isSelected());
        osgiRunConfiguration.setInstanceToUse((FrameworkInstanceDefinition)((Object)this.myFrameworkInstances.getSelectedItem()));
        if (this.myCurrentRunPropertiesEditor != null) {
            this.myCurrentRunPropertiesEditor.applyEditorTo(osgiRunConfiguration);
        }
    }

    private List<SelectedBundle> getBundlesToRun() {
        return this.getTableModel().getBundles();
    }

    @NotNull
    protected JComponent createEditor() {
        JTabbedPane jTabbedPane = this.root;
        if (jTabbedPane == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/run/ui/OsgiRunConfigurationEditor", "createEditor"));
        }
        return jTabbedPane;
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JPanel jPanel;
        JCheckBox jCheckBox;
        JrePathEditor jrePathEditor;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        JRadioButton jRadioButton;
        JRadioButton jRadioButton2;
        RawCommandLineEditor rawCommandLineEditor;
        RawCommandLineEditor rawCommandLineEditor2;
        JPanel jPanel2;
        JSpinner jSpinner;
        JSpinner jSpinner2;
        JComboBox jComboBox;
        JBTabbedPane jBTabbedPane = new JBTabbedPane();
        this.root = jBTabbedPane;
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.setMinimumSize(new Dimension(500, 200));
        jBTabbedPane.addTab("Framework & Bundles", null, jPanel3, null);
        JPanel jPanel4 = new JPanel();
        jPanel4.setLayout((LayoutManager)new GridLayoutManager(3, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel3.add((Component)jPanel4, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JLabel jLabel = new JLabel();
        jLabel.setText("OSGi framework:");
        jLabel.setDisplayedMnemonic('O');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel4.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFrameworkInstances = jComboBox = new JComboBox();
        jPanel4.add(jComboBox, new GridConstraints(0, 1, 1, 1, 8, 1, 3, 0, null, new Dimension(100, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Framework start level:");
        jPanel4.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myFrameworkStartLevel = jSpinner2 = new JSpinner();
        jPanel4.add((Component)jSpinner2, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Default start level:");
        jPanel4.add((Component)jLabel3, new GridConstraints(2, 0, 1, 1, 0, 1, 0, 0, null, null, null));
        this.myDefaultStartLevel = jSpinner = new JSpinner();
        jPanel4.add((Component)jSpinner, new GridConstraints(2, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel4.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myBundlesPanel = jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel3.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        JBTable jBTable = new JBTable();
        this.myBundlesTable = jBTable;
        jPanel2.add((Component)jBTable, "Center");
        JPanel jPanel5 = new JPanel();
        jPanel5.setLayout((LayoutManager)new GridLayoutManager(7, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jBTabbedPane.addTab("Parameters", null, jPanel5, null);
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("VM options:");
        jPanel5.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myVmOptions = rawCommandLineEditor2 = new RawCommandLineEditor();
        rawCommandLineEditor2.setDialogCaption("VM Parameters");
        jPanel5.add((Component)rawCommandLineEditor2, new GridConstraints(0, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Program parameters:");
        jPanel5.add((Component)jBLabel, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myProgramParameters = rawCommandLineEditor = new RawCommandLineEditor();
        rawCommandLineEditor.setDialogCaption("Program Parameters");
        jPanel5.add((Component)rawCommandLineEditor, new GridConstraints(1, 1, 1, 2, 0, 1, 7, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Runtime directory:");
        jPanel5.add((Component)jBLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myOsmorcControlledDir = jRadioButton2 = new JRadioButton();
        jRadioButton2.setText("Recreate each time ");
        jPanel5.add((Component)jRadioButton2, new GridConstraints(2, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myUserDefinedDir = jRadioButton = new JRadioButton();
        jRadioButton.setText("Use this directory:");
        jPanel5.add((Component)jRadioButton, new GridConstraints(3, 1, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myWorkingDirField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        jPanel5.add((Component)textFieldWithBrowseButton, new GridConstraints(3, 2, 1, 1, 0, 1, 6, 0, null, null, null));
        this.myJrePathEditor = jrePathEditor = new JrePathEditor();
        jPanel5.add((Component)jrePathEditor, new GridConstraints(4, 0, 1, 3, 0, 1, 7, 3, null, null, null));
        this.myClassPathAllBundles = jCheckBox = new JCheckBox();
        jCheckBox.setText("Include all bundles in class path");
        jPanel5.add((Component)jCheckBox, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel5.add((Component)spacer2, new GridConstraints(6, 1, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myAdditionalPropertiesPanel = jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout(0, 0));
        jBTabbedPane.addTab("Additional Framework Properties", null, jPanel, null);
        jLabel.setLabelFor(jComboBox);
        jLabel2.setLabelFor(jSpinner2);
        jLabel3.setLabelFor(jSpinner);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jRadioButton2);
        buttonGroup.add(jRadioButton);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.root;
    }

    private static class RunConfigurationTableModel
    extends AbstractTableModel {
        private final List<SelectedBundle> mySelectedBundles = new ArrayList<SelectedBundle>();

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return String.class;
                }
                case 1: {
                    return Integer.class;
                }
                case 2: {
                    return Boolean.class;
                }
            }
            return Object.class;
        }

        @Override
        public String getColumnName(int columnIndex) {
            switch (columnIndex) {
                case 0: {
                    return "Bundle name";
                }
                case 1: {
                    return "Start level";
                }
                case 2: {
                    return "Start after install";
                }
            }
            return "";
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.mySelectedBundles.size();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column != 0;
        }

        @Override
        public Object getValueAt(int row, int column) {
            SelectedBundle bundle = this.getBundleAt(row);
            switch (column) {
                case 0: {
                    return bundle.toString();
                }
                case 1: {
                    return bundle.getStartLevel();
                }
                case 2: {
                    return bundle.isStartAfterInstallation();
                }
            }
            throw new RuntimeException("Don't know column " + column);
        }

        @Override
        public void setValueAt(Object o, int row, int column) {
            SelectedBundle bundle = this.getBundleAt(row);
            switch (column) {
                case 1: {
                    bundle.setStartLevel((Integer)o);
                    break;
                }
                case 2: {
                    bundle.setStartAfterInstallation((Boolean)o);
                    break;
                }
                default: {
                    throw new RuntimeException("Cannot edit column " + column);
                }
            }
        }

        public SelectedBundle getBundleAt(int index) {
            return this.mySelectedBundles.get(index);
        }

        public List<SelectedBundle> getBundles() {
            return this.mySelectedBundles;
        }

        public void addBundle(SelectedBundle bundle) {
            this.mySelectedBundles.add(bundle);
            this.fireTableRowsInserted(this.mySelectedBundles.size() - 1, this.mySelectedBundles.size() - 1);
        }

        public void removeBundleAt(int index) {
            this.mySelectedBundles.remove(index);
            this.fireTableRowsDeleted(index, index);
        }

        public void removeAllOfType(SelectedBundle.BundleType type) {
            Iterator<SelectedBundle> selectedBundleIterator = this.mySelectedBundles.iterator();
            while (selectedBundleIterator.hasNext()) {
                SelectedBundle selectedBundle = selectedBundleIterator.next();
                if (selectedBundle.getBundleType() != type) continue;
                selectedBundleIterator.remove();
            }
            this.fireTableDataChanged();
        }
    }
}

