/*
 * Decompiled with CFR 0.152.
 */
package org.osmorc.util;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.ProjectScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.IncorrectOperationException;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.lang.manifest.ManifestFileTypeFactory;
import org.jetbrains.lang.manifest.psi.Header;
import org.jetbrains.lang.manifest.psi.HeaderValue;
import org.jetbrains.lang.manifest.psi.ManifestFile;
import org.jetbrains.lang.manifest.psi.Section;
import org.osgi.framework.BundleActivator;
import org.osmorc.facet.OsmorcFacet;

public class OsgiPsiUtil {
    private OsgiPsiUtil() {
    }

    public static boolean isActivator(@Nullable PsiElement element) {
        PsiClass activator;
        PsiClass psiClass;
        return element instanceof PsiClass && !(psiClass = (PsiClass)element).hasModifierProperty("abstract") && OsmorcFacet.getInstance((PsiElement)psiClass) != null && (activator = OsgiPsiUtil.getActivatorClass(psiClass.getProject())) != null && psiClass.isInheritor(activator, true);
    }

    @Nullable
    public static PsiClass getActivatorClass(@NotNull Project project) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/util/OsgiPsiUtil", "getActivatorClass"));
        }
        return (PsiClass)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "org/osmorc/util/OsgiPsiUtil", "lambda$getActivatorClass$0"));
            }
            GlobalSearchScope scope = ProjectScope.getLibrariesScope((Project)project);
            PsiClass aClass = JavaPsiFacade.getInstance((Project)project).findClass(BundleActivator.class.getName(), scope);
            return CachedValueProvider.Result.create((Object)aClass, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
    }

    @NotNull
    public static PsiDirectory[] resolvePackage(@NotNull PsiElement element, @NotNull String packageName) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "org/osmorc/util/OsgiPsiUtil", "resolvePackage"));
        }
        if (packageName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "packageName", "org/osmorc/util/OsgiPsiUtil", "resolvePackage"));
        }
        Project project = element.getProject();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        GlobalSearchScope scope = module != null ? module.getModuleWithDependenciesAndLibrariesScope(false) : ProjectScope.getAllScope((Project)project);
        PsiPackage aPackage = JavaPsiFacade.getInstance((Project)project).findPackage(packageName);
        PsiDirectory[] psiDirectoryArray = aPackage == null ? PsiDirectory.EMPTY_ARRAY : aPackage.getDirectories(scope);
        if (psiDirectoryArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/osmorc/util/OsgiPsiUtil", "resolvePackage"));
        }
        return psiDirectoryArray;
    }

    public static boolean isHeader(@Nullable PsiElement element, @NotNull String headerName) {
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "org/osmorc/util/OsgiPsiUtil", "isHeader"));
        }
        return element instanceof Header && headerName.equals(((Header)element).getName());
    }

    public static void setHeader(@NotNull ManifestFile manifestFile, @NotNull String headerName, @NotNull String headerValue) {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "org/osmorc/util/OsgiPsiUtil", "setHeader"));
        }
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "org/osmorc/util/OsgiPsiUtil", "setHeader"));
        }
        if (headerValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValue", "org/osmorc/util/OsgiPsiUtil", "setHeader"));
        }
        Header header = manifestFile.getHeader(headerName);
        Header newHeader = OsgiPsiUtil.createHeader(manifestFile.getProject(), headerName, headerValue);
        if (header != null) {
            header.replace((PsiElement)newHeader);
        } else {
            OsgiPsiUtil.addHeader(manifestFile, newHeader);
        }
    }

    public static void appendToHeader(@NotNull ManifestFile manifestFile, @NotNull String headerName, @NotNull String headerValue) {
        if (manifestFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "manifestFile", "org/osmorc/util/OsgiPsiUtil", "appendToHeader"));
        }
        if (headerName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerName", "org/osmorc/util/OsgiPsiUtil", "appendToHeader"));
        }
        if (headerValue == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "headerValue", "org/osmorc/util/OsgiPsiUtil", "appendToHeader"));
        }
        Header header = manifestFile.getHeader(headerName);
        if (header != null) {
            HeaderValue oldValue = header.getHeaderValue();
            if (oldValue != null) {
                String oldText = StringUtil.trimTrailing((String)header.getText().substring(oldValue.getStartOffsetInParent(), header.getTextLength()));
                if (!oldText.isEmpty()) {
                    oldText = oldText + ",\n ";
                }
                headerValue = oldText + headerValue;
            }
            header.replace((PsiElement)OsgiPsiUtil.createHeader(manifestFile.getProject(), headerName, headerValue));
        } else {
            OsgiPsiUtil.addHeader(manifestFile, OsgiPsiUtil.createHeader(manifestFile.getProject(), headerName, headerValue));
        }
    }

    private static Header createHeader(Project project, String headerName, String valueText) {
        String text = String.format("%s: %s\n", headerName, valueText);
        PsiFile file = PsiFileFactory.getInstance((Project)project).createFileFromText("DUMMY.MF", (FileType)ManifestFileTypeFactory.MANIFEST, (CharSequence)text);
        Header header = ((ManifestFile)file).getHeader(headerName);
        if (header == null) {
            throw new IncorrectOperationException("Bad header: '" + text + "'");
        }
        return header;
    }

    private static void addHeader(ManifestFile manifestFile, Header newHeader) {
        Section section = manifestFile.getMainSection();
        List headers = manifestFile.getHeaders();
        if (section == null) {
            manifestFile.add(newHeader.getParent());
        } else if (headers.isEmpty()) {
            section.addBefore((PsiElement)newHeader, section.getFirstChild());
        } else {
            section.addAfter((PsiElement)newHeader, (PsiElement)headers.get(headers.size() - 1));
        }
    }
}

