/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.velocity.inspections;

import com.intellij.lang.Language;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleFileIndex;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReferenceSet;
import com.intellij.psi.search.FilenameIndex;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.velocity.psi.PsiUtil;
import com.intellij.velocity.psi.VtlLanguage;
import com.intellij.velocity.psi.files.VelocityPropertiesProvider;
import com.intellij.velocity.psi.files.VtlFile;
import com.intellij.velocity.psi.reference.VtlFileReferenceSet;
import com.intellij.velocity.psi.reference.VtlReferenceExpression;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Util {
    @Nullable
    static VtlReferenceExpression findReferenceExpression(@NotNull Editor editor, @NotNull PsiFile file) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/velocity/inspections/Util", "findReferenceExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/velocity/inspections/Util", "findReferenceExpression"));
        }
        return Util.findReferenceExpression(editor, file, VtlReferenceExpression.class);
    }

    @Nullable
    static <T extends PsiReference> T findReferenceExpression(@NotNull Editor editor, @NotNull PsiFile file, @NotNull Class<T> refClass) {
        PsiReference reference;
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/intellij/velocity/inspections/Util", "findReferenceExpression"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/velocity/inspections/Util", "findReferenceExpression"));
        }
        if (refClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refClass", "com/intellij/velocity/inspections/Util", "findReferenceExpression"));
        }
        int offset = editor.getCaretModel().getOffset();
        CharSequence charSequence = editor.getDocument().getCharsSequence();
        if (charSequence.length() == offset || charSequence.length() > offset && !Character.isJavaIdentifierPart(charSequence.charAt(offset))) {
            --offset;
        }
        return (T)(refClass.isInstance(reference = file.findReferenceAt(offset)) ? reference : null);
    }

    @NotNull
    static <T> List<T> collectFilePaths(@NotNull PsiElement element, final @NotNull Function<PsiFile, T> converter) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/Util", "collectFilePaths"));
        }
        if (converter == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "converter", "com/intellij/velocity/inspections/Util", "collectFilePaths"));
        }
        SmartList allFiles = new SmartList();
        final PsiManager psiManager = element.getManager();
        ModuleFileIndex fileIndex = ModuleRootManager.getInstance((Module)ModuleUtil.findModuleForPsiElement((PsiElement)element)).getFileIndex();
        fileIndex.iterateContent(new ContentIterator((List)allFiles){
            final /* synthetic */ List val$allFiles;
            {
                this.val$allFiles = list;
            }

            public boolean processFile(VirtualFile fileOrDir) {
                PsiFile psiFile = psiManager.findFile(fileOrDir);
                if (psiFile != null) {
                    ContainerUtil.addIfNotNull((Object)converter.fun((Object)psiFile), (Collection)this.val$allFiles);
                }
                return true;
            }
        });
        SmartList smartList = allFiles;
        if (smartList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/Util", "collectFilePaths"));
        }
        return smartList;
    }

    static boolean canSetVelocityProperties(@Nullable PsiFile file) {
        if (file == null) {
            return false;
        }
        VtlFile vtlFile = (VtlFile)file.getViewProvider().getPsi((Language)VtlLanguage.INSTANCE);
        return vtlFile != null && vtlFile.getVelocityProperties() == null;
    }

    @Nullable
    static VtlFileReferenceSet findVtlFileReferenceSet(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/velocity/inspections/Util", "findVtlFileReferenceSet"));
        }
        for (PsiReference ref : element.getReferences()) {
            FileReferenceSet refSet;
            if (!(ref instanceof FileReference) || !((refSet = ((FileReference)ref).getFileReferenceSet()) instanceof VtlFileReferenceSet) || refSet.getLastReference() == null) continue;
            return (VtlFileReferenceSet)refSet;
        }
        return null;
    }

    @NotNull
    static PsiFile[] findReferencedFiles(final @Nullable Module module, @NotNull String nameFile) {
        if (nameFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "nameFile", "com/intellij/velocity/inspections/Util", "findReferencedFiles"));
        }
        if (module == null) {
            if (PsiFile.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/Util", "findReferencedFiles"));
            }
            return PsiFile.EMPTY_ARRAY;
        }
        PsiFile[] psiFileArray = FilenameIndex.getFilesByName((Project)module.getProject(), (String)nameFile, (GlobalSearchScope)new GlobalSearchScope(module.getProject()){
            private final VirtualFile[] myContentRoots;
            {
                super(arg0);
                this.myContentRoots = ModuleRootManager.getInstance((Module)module).getContentRoots();
            }

            public boolean contains(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/velocity/inspections/Util$2", "contains"));
                }
                for (VirtualFile contentRoot : this.myContentRoots) {
                    if (!VfsUtil.isAncestor((VirtualFile)contentRoot, (VirtualFile)file, (boolean)false)) continue;
                    return true;
                }
                return false;
            }

            public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
                if (file1 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file1", "com/intellij/velocity/inspections/Util$2", "compare"));
                }
                if (file2 == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file2", "com/intellij/velocity/inspections/Util$2", "compare"));
                }
                return 0;
            }

            public boolean isSearchInModuleContent(@NotNull Module aModule) {
                if (aModule == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aModule", "com/intellij/velocity/inspections/Util$2", "isSearchInModuleContent"));
                }
                return aModule == module;
            }

            public boolean isSearchInLibraries() {
                return false;
            }
        });
        if (psiFileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/velocity/inspections/Util", "findReferencedFiles"));
        }
        return psiFileArray;
    }

    static String computeFilePath(VelocityPropertiesProvider velocityProperties, String referencedFilePath, String pathString, PsiFile fileToInsertComment) {
        for (String path : velocityProperties.getResourceLoaderPathList()) {
            String propFilePath;
            String relativePath;
            String string = relativePath = ".".equals(path) ? pathString : path + "/" + pathString;
            if (!referencedFilePath.endsWith(relativePath)) continue;
            int len = referencedFilePath.length() - relativePath.length();
            String vtlRootPath = PsiUtil.getRelativePath(PsiUtil.getPath(fileToInsertComment), referencedFilePath.substring(0, len));
            if (vtlRootPath == null || (propFilePath = PsiUtil.getRelativePath(fileToInsertComment, velocityProperties.getPropertiesFile().getContainingFile())) == null) continue;
            return "\"" + propFilePath + "\" runtime_root=\"" + vtlRootPath + "\"";
        }
        return null;
    }
}

