/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.struts2.dom.struts.action;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiMethod;
import com.intellij.struts2.dom.struts.action.Action;
import com.intellij.struts2.dom.struts.action.CreateActionMethodQuickFix;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ActionMethodConverter
extends ResolvingConverter<PsiMethod> {
    @NotNull
    public Collection<? extends PsiMethod> getVariants(ConvertContext context) {
        Action action = ActionMethodConverter.getActionElement(context);
        List<PsiMethod> list = action.getActionMethods();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/action/ActionMethodConverter", "getVariants"));
        }
        return list;
    }

    public PsiMethod fromString(@Nullable @NonNls String value, ConvertContext context) {
        if (value == null) {
            return null;
        }
        Action action = ActionMethodConverter.getActionElement(context);
        return action.findActionMethod(value);
    }

    public String toString(@Nullable PsiMethod psiMethod, ConvertContext context) {
        return psiMethod != null ? psiMethod.getName() : null;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return "Cannot resolve action-method '" + s + "'";
    }

    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        Action action = ActionMethodConverter.getActionElement(context);
        String methodName = action.getMethod().getStringValue();
        PsiClass actionClass = action.searchActionClass();
        return new LocalQuickFix[]{new CreateActionMethodQuickFix(actionClass, methodName)};
    }

    @NotNull
    private static Action getActionElement(ConvertContext context) {
        DomElement domElement = context.getInvocationElement();
        Action action = (Action)domElement.getParentOfType(Action.class, false);
        assert (action != null) : "not triggered within <action> for " + domElement.getXmlElement();
        Action action2 = action;
        if (action2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/struts2/dom/struts/action/ActionMethodConverter", "getActionElement"));
        }
        return action2;
    }
}

