/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.cdi.view;

import com.intellij.cdi.CdiProjectComponent;
import com.intellij.cdi.beans.InjectionPointDescriptor;
import com.intellij.cdi.jam.CdiJamModel;
import com.intellij.cdi.toolWindow.tree.nodes.CdiViewSettings;
import com.intellij.cdi.utils.CdiCommonUtils;
import com.intellij.cdi.utils.CdiInjectionUtils;
import com.intellij.cdi.view.CdiBeansRecursivePanel;
import com.intellij.javaee.toolwindow.view.JavaeeViewFrameworkProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiParameter;
import com.intellij.ui.FinderRecursivePanel;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class CdiViewFrameworkProvider
extends JavaeeViewFrameworkProvider {
    public boolean isAvailable(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/view/CdiViewFrameworkProvider", "isAvailable"));
        }
        return CdiCommonUtils.isCdiInstalled(module) && (CdiInjectionUtils.getInjectionPoints(module).size() > 0 || CdiJamModel.getModel(module).getNamedBeans().size() > 0);
    }

    @NotNull
    public JComponent createModuleView(@NotNull FinderRecursivePanel parent, @NotNull Module module, @NotNull DefaultActionGroup actions) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/cdi/view/CdiViewFrameworkProvider", "createModuleView"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "module", "com/intellij/cdi/view/CdiViewFrameworkProvider", "createModuleView"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/cdi/view/CdiViewFrameworkProvider", "createModuleView"));
        }
        CdiBeansRecursivePanel cdiBeansRecursivePanel = new CdiBeansRecursivePanel(parent, module, actions);
        if (cdiBeansRecursivePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/view/CdiViewFrameworkProvider", "createModuleView"));
        }
        return cdiBeansRecursivePanel;
    }

    @NotNull
    public JComponent createProjectView(@NotNull FinderRecursivePanel parent, @NotNull Project project, @NotNull DefaultActionGroup actions) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/cdi/view/CdiViewFrameworkProvider", "createProjectView"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cdi/view/CdiViewFrameworkProvider", "createProjectView"));
        }
        if (actions == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "actions", "com/intellij/cdi/view/CdiViewFrameworkProvider", "createProjectView"));
        }
        CdiBeansRecursivePanel cdiBeansRecursivePanel = new CdiBeansRecursivePanel(parent, null, actions);
        if (cdiBeansRecursivePanel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/view/CdiViewFrameworkProvider", "createProjectView"));
        }
        return cdiBeansRecursivePanel;
    }

    @NotNull
    public static List<InjectionPointDescriptor> getFilteredEndpoints(@NotNull List<InjectionPointDescriptor> ips, @NotNull Project project) {
        if (ips == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ips", "com/intellij/cdi/view/CdiViewFrameworkProvider", "getFilteredEndpoints"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/cdi/view/CdiViewFrameworkProvider", "getFilteredEndpoints"));
        }
        CdiViewSettings viewSettings = CdiProjectComponent.getInstance(project).getState();
        if (viewSettings == null) {
            List<InjectionPointDescriptor> list = ips;
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/view/CdiViewFrameworkProvider", "getFilteredEndpoints"));
            }
            return list;
        }
        ArrayList<InjectionPointDescriptor> filtered = new ArrayList<InjectionPointDescriptor>();
        for (InjectionPointDescriptor ip : ips) {
            if ((!(ip.getOwner() instanceof PsiField) || !viewSettings.showBeans) && (!(ip.getOwner() instanceof PsiParameter) || !viewSettings.showProducers)) continue;
            filtered.add(ip);
        }
        ArrayList<InjectionPointDescriptor> arrayList = filtered;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/cdi/view/CdiViewFrameworkProvider", "getFilteredEndpoints"));
        }
        return arrayList;
    }
}

