/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment;

import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentPathChecker {
    private RunningState myRunningState = RunningState.READY;
    private Map<FileObjectHashCodedWrapper, FileObject> myProcessedPaths = null;

    public void initProcessing() {
        if (this.myRunningState != RunningState.READY) {
            throw new IllegalStateException("Cannot process paths twice with a single processor");
        }
        this.myRunningState = RunningState.STARTED;
        this.myProcessedPaths = ContainerUtil.newHashMap();
    }

    @Nullable
    public FileObject getAlreadyProcessedFileObject(FileObject source) {
        return this.myProcessedPaths.put(new FileObjectHashCodedWrapper(source), source);
    }

    private static final class FileObjectHashCodedWrapper {
        private static final int MAX_PATH_LENGTH = 239;
        @NotNull
        private final FileObject myFileObject;

        public FileObjectHashCodedWrapper(@NotNull FileObject fileObject) {
            if (fileObject == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fileObject", "com/jetbrains/plugins/webDeployment/DeploymentPathChecker$FileObjectHashCodedWrapper", "<init>"));
            }
            this.myFileObject = fileObject;
        }

        public boolean equals(Object other) {
            if (!(other instanceof FileObjectHashCodedWrapper)) {
                return false;
            }
            FileObject otherFileObject = ((FileObjectHashCodedWrapper)other).myFileObject;
            FileName myName = this.myFileObject.getName();
            FileName otherName = otherFileObject.getName();
            if (myName.toString().equals(otherName.toString())) {
                return true;
            }
            if (!myName.getBaseName().equals(otherName.getBaseName())) {
                return false;
            }
            if (!myName.isDescendent(otherName) && !otherName.isDescendent(myName)) {
                return false;
            }
            return FileObjectHashCodedWrapper.isSymlinkPath(otherFileObject, this.myFileObject);
        }

        public int hashCode() {
            return this.myFileObject.getName().getBaseName().hashCode();
        }

        private static boolean isSymlinkPath(@NotNull FileObject ancestor, @NotNull FileObject descendant) {
            if (ancestor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ancestor", "com/jetbrains/plugins/webDeployment/DeploymentPathChecker$FileObjectHashCodedWrapper", "isSymlinkPath"));
            }
            if (descendant == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descendant", "com/jetbrains/plugins/webDeployment/DeploymentPathChecker$FileObjectHashCodedWrapper", "isSymlinkPath"));
            }
            try {
                if (!descendant.isSymbolicLink()) {
                    return false;
                }
                return descendant.getLinkDestination().equals(ancestor);
            }
            catch (Exception exception) {
                return FileObjectHashCodedWrapper.isPseudoSymlinkPath(ancestor, descendant);
            }
        }

        private static boolean isPseudoSymlinkPath(FileObject ancestor, FileObject descendant) {
            FileName ancestorName = ancestor.getName();
            FileName descendantName = descendant.getName();
            try {
                String probablyIdPath = ancestorName.getRelativeName(descendantName);
                int idPathMultiplier = FileObjectHashCodedWrapper.calcAppendedPathMultiplier(ancestorName.getPath(), probablyIdPath);
                StringBuilder multipliedPath = new StringBuilder(probablyIdPath);
                for (int i = 1; i < idPathMultiplier; ++i) {
                    multipliedPath.append("/").append(probablyIdPath);
                }
                FileObject resolvedFile = ancestor.resolveFile(multipliedPath.toString());
                return resolvedFile.exists();
            }
            catch (FileSystemException e) {
                return false;
            }
        }

        private static int calcAppendedPathMultiplier(String basePath, String appendedPath) {
            int sep = "/".length();
            return Math.max(0, 239 - basePath.length() + sep) / (appendedPath.length() + sep);
        }
    }

    private static enum RunningState {
        READY,
        STARTED;

    }
}

