/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.actions.createproject;

import com.intellij.ide.util.treeView.NodeRenderer;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.ex.FileChooserDialogImpl;
import com.intellij.openapi.fileChooser.ex.FileNodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EventDispatcher;
import com.intellij.util.containers.MultiMap;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.actions.createproject.ActionTypeDescription;
import com.jetbrains.plugins.webDeployment.actions.createproject.FileChooserStep;
import com.jetbrains.plugins.webDeployment.actions.createproject.ServerTreeForm;
import com.jetbrains.plugins.webDeployment.ui.UiConstants;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.EventListener;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentFileChooserDialog
extends FileChooserDialogImpl {
    private final EventDispatcher<StateChangeListener> myEventDispatcher;
    private VirtualFile myProjectRoot;
    private final MultiMap<String, VirtualFile> myActionPaths;
    private final VirtualFile myToSelect;

    public DeploymentFileChooserDialog(@NotNull FileChooserDescriptor descriptor, @Nullable Project project, VirtualFile toSelect) {
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog", "<init>"));
        }
        super(descriptor, project);
        this.myEventDispatcher = EventDispatcher.create(StateChangeListener.class);
        this.myActionPaths = new MultiMap();
        this.myToSelect = toSelect;
    }

    public JComponent getTitlePane() {
        return this.createTitlePane();
    }

    public JComponent createCenterPanel() {
        JComponent panel = super.createCenterPanel();
        this.restoreSelection(this.myToSelect);
        return panel;
    }

    public VirtualFile getProjectRoot() {
        return this.myProjectRoot;
    }

    @Nullable
    protected JPanel createExtraToolbarPanel() {
        DefaultActionGroup actionGroup = new DefaultActionGroup();
        JTree tree = this.myFileSystemTree.getTree();
        SetRootFolderAction setRootFolderAction = new SetRootFolderAction();
        actionGroup.add((AnAction)setRootFolderAction);
        setRootFolderAction.registerCustomShortcutSet(setRootFolderAction.getShortcutSet(), tree, this.myDisposable);
        for (ActionTypeDescription.Local description : FileChooserStep.LOCAL_ACTION_TYPE_DESCRIPTIONS) {
            ParametrizedAction action = new ParametrizedAction(description);
            actionGroup.add((AnAction)action);
            action.registerCustomShortcutSet(action.getShortcutSet(), tree, this.myDisposable);
        }
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("unknown", (ActionGroup)actionGroup, true);
        JPanel toolbarPanel = new JPanel(new BorderLayout());
        toolbarPanel.add((Component)toolbar.getComponent(), "Center");
        return toolbarPanel;
    }

    protected JTree createTree() {
        super.createTree();
        NodeRenderer renderer = new NodeRenderer(){

            public void customizeCellRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                VirtualFile file;
                Object userObject;
                super.customizeCellRenderer(tree, value, selected, expanded, leaf, row, hasFocus);
                if (value instanceof DefaultMutableTreeNode && (userObject = ((DefaultMutableTreeNode)value).getUserObject()) instanceof FileNodeDescriptor && (file = ((FileNodeDescriptor)userObject).getElement().getFile()) != null) {
                    for (ActionTypeDescription.Local desc : FileChooserStep.LOCAL_ACTION_TYPE_DESCRIPTIONS) {
                        if (!DeploymentFileChooserDialog.this.isActionApplied(desc, new VirtualFile[]{file})) continue;
                        this.setIcon(desc.closedIcon);
                        return;
                    }
                }
            }
        };
        JTree tree = this.myFileSystemTree.getTree();
        tree.setCellRenderer((TreeCellRenderer)renderer);
        tree.setOpaque(false);
        return tree;
    }

    @NotNull
    protected Tree createInternalTree() {
        Tree tree = new Tree(){

            @Nullable
            public Color getFileColorFor(Object object) {
                if (object instanceof FileNodeDescriptor && DeploymentFileChooserDialog.this.isMapped(((FileNodeDescriptor)object).getElement().getFile())) {
                    return UiConstants.NodeAttributes.MAPPED_BACKGROUND;
                }
                return super.getFileColorFor(object);
            }

            public boolean isFileColorsEnabled() {
                return true;
            }
        };
        if (tree == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog", "createInternalTree"));
        }
        return tree;
    }

    protected void createDefaultActions() {
        DialogWrapper.DialogWrapperAction disabledAction = new DialogWrapper.DialogWrapperAction(""){

            public boolean isEnabled() {
                return false;
            }

            protected void doAction(ActionEvent e) {
            }
        };
        this.myOKAction = disabledAction;
        this.myCancelAction = disabledAction;
        this.myHelpAction = disabledAction;
    }

    private boolean isMapped(VirtualFile file) {
        if (!this.isUnderRoot(file)) {
            return false;
        }
        for (VirtualFile excluded : this.myActionPaths.get((Object)ActionTypeDescription.LOCAL_EXCLUDE_FOLDERS_ACTION_DESCRIPTION.key)) {
            if (!VfsUtilCore.isAncestor((VirtualFile)excluded, (VirtualFile)file, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    public MultiMap<String, VirtualFile> getActionPaths() {
        return this.myActionPaths;
    }

    public void addListener(StateChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private boolean isUnderRoot(VirtualFile ... files) {
        if (this.myProjectRoot == null) {
            return false;
        }
        for (VirtualFile file : files) {
            if (file != null && VfsUtilCore.isAncestor((VirtualFile)this.myProjectRoot, (VirtualFile)file, (boolean)false)) continue;
            return false;
        }
        return true;
    }

    private boolean isActionApplied(ActionTypeDescription.Local desc, VirtualFile ... paths) {
        if (desc.isRecursive) {
            for (VirtualFile path : paths) {
                boolean found = false;
                for (VirtualFile remotePath : this.myActionPaths.get((Object)desc.key)) {
                    if (!VfsUtilCore.isAncestor((VirtualFile)remotePath, (VirtualFile)path, (boolean)false)) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return false;
            }
        } else {
            for (VirtualFile path : paths) {
                if (this.myActionPaths.get((Object)desc.key).contains(path)) continue;
                return false;
            }
        }
        return true;
    }

    private class ParametrizedAction
    extends ToggleAction {
        private final ActionTypeDescription.Local myDescription;

        private ParametrizedAction(ActionTypeDescription.Local description) {
            super(description.title, description.description, description.closedIcon);
            this.myDescription = description;
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(description.keystroke, 512), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$ParametrizedAction", "update"));
            }
            super.update(e);
            boolean underRoot = DeploymentFileChooserDialog.this.isUnderRoot(DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles());
            e.getPresentation().setEnabled(underRoot);
        }

        public boolean isSelected(AnActionEvent e) {
            VirtualFile[] paths = DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles();
            if (!DeploymentFileChooserDialog.this.isUnderRoot(paths)) {
                return false;
            }
            return DeploymentFileChooserDialog.this.isActionApplied(this.myDescription, paths);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            VirtualFile[] selectedPaths = DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles();
            if (state) {
                Collection paths = DeploymentFileChooserDialog.this.myActionPaths.get((Object)this.myDescription.key);
                VirtualFile[] virtualFileArray = selectedPaths;
                int n = virtualFileArray.length;
                for (int i = 0; i < n; ++i) {
                    VirtualFile path = virtualFileArray[i];
                    if (paths.contains(path)) continue;
                    DeploymentFileChooserDialog.this.myActionPaths.putValue((Object)this.myDescription.key, (Object)path);
                }
            } else {
                for (VirtualFile path : selectedPaths) {
                    DeploymentFileChooserDialog.this.myActionPaths.remove((Object)this.myDescription.key, (Object)path);
                }
            }
            for (VirtualFile path : selectedPaths) {
                DeploymentFileChooserDialog.this.myFileSystemTree.getTreeBuilder().queueUpdateFrom((Object)path, false, false);
            }
        }

        public boolean displayTextInToolbar() {
            return true;
        }
    }

    private class SetRootFolderAction
    extends ToggleAction {
        private SetRootFolderAction() {
            super(WDBundle.message("project.root.action.text", new Object[0]), WDBundle.message("project.root.action.description", new Object[0]), ServerTreeForm.PROJECT_ICON);
            this.setShortcutSet((ShortcutSet)new CustomShortcutSet(new Shortcut[]{new KeyboardShortcut(KeyStroke.getKeyStroke(74, 512), null)}));
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/jetbrains/plugins/webDeployment/actions/createproject/DeploymentFileChooserDialog$SetRootFolderAction", "update"));
            }
            super.update(e);
            e.getPresentation().setEnabled(DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles().length == 1);
        }

        public boolean isSelected(AnActionEvent e) {
            VirtualFile[] path = DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles();
            if (path.length != 1) {
                return false;
            }
            return path[0].equals(DeploymentFileChooserDialog.this.myProjectRoot);
        }

        public void setSelected(AnActionEvent e, boolean state) {
            VirtualFile[] path = DeploymentFileChooserDialog.this.myFileSystemTree.getSelectedFiles();
            if (path.length != 1) {
                return;
            }
            VirtualFile oldRoot = DeploymentFileChooserDialog.this.myProjectRoot;
            if (state) {
                DeploymentFileChooserDialog.this.myProjectRoot = path[0];
            } else {
                DeploymentFileChooserDialog.this.myProjectRoot = null;
            }
            if (oldRoot != null) {
                DeploymentFileChooserDialog.this.myFileSystemTree.getTreeBuilder().queueUpdateFrom((Object)oldRoot, false);
            }
            if (DeploymentFileChooserDialog.this.myProjectRoot != null) {
                DeploymentFileChooserDialog.this.myFileSystemTree.getTreeBuilder().queueUpdateFrom((Object)DeploymentFileChooserDialog.this.myProjectRoot, false);
            }
            ((StateChangeListener)DeploymentFileChooserDialog.this.myEventDispatcher.getMulticaster()).stateChanged();
        }

        public boolean displayTextInToolbar() {
            return true;
        }
    }

    public static interface StateChangeListener
    extends EventListener {
        public void stateChanged();
    }
}

