/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.DocumentAdapter;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.AccessType;
import com.jetbrains.plugins.webDeployment.config.AdvancedOptionsConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.EventListener;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.apache.commons.vfs2.provider.ftp.JBFtpKeepAliveCommand;
import org.jetbrains.annotations.Nullable;

public class AdvancedOptionsForm {
    private JCheckBox myShowHiddenFilesCheckBox;
    private JPanel myContentPane;
    private JCheckBox myPassiveModeCheckBox;
    private JCheckBox myMaxConnectionsCheckBox;
    private JTextField myMaxConnectionsTextField;
    private JLabel myMessageLabel;
    private JComboBox myTimestampsCombo;
    private JLabel myTimestampsLabel;
    private JCheckBox myCompatibilityModeCheckBox;
    private JLabel myDataProtectionLevelLabel;
    private JComboBox myDataProtectionLevelComboBox;
    private JTextField myControlEncodingTextField;
    private JBCheckBox myMuteSftpMessagesCheckBox;
    private JBCheckBox myForceListCommandCheckBox;
    private JCheckBox myKeepAliveCheckbox;
    private JTextField myKeepAliveTimeoutField;
    private JLabel myKeepAliveMeasureLabel;
    private JComboBox myKeepAliveFtpCommandComboBox;
    private JLabel myKeepAliveFtpCommandLabel;
    private final AdvancedOptionsConfig myConfig;
    private final EventDispatcher<ChangeListener> myEventDispatcher;

    public AdvancedOptionsForm(AdvancedOptionsConfig config, AccessType accessType) {
        this.$$$setupUI$$$();
        this.myEventDispatcher = EventDispatcher.create(ChangeListener.class);
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        ArrayList<String> timestampsComboValues = new ArrayList<String>();
        for (AdvancedOptionsConfig.AccurateTimestamps v : AdvancedOptionsConfig.AccurateTimestamps.values()) {
            timestampsComboValues.add(WDBundle.message("accurate.timestamps.option." + (Object)((Object)v), new Object[0]));
        }
        this.myTimestampsCombo.setModel(new DefaultComboBoxModel<Object>(timestampsComboValues.toArray()));
        this.myDataProtectionLevelComboBox.setModel(new EnumComboBoxModel(AdvancedOptionsConfig.DataChannelProtectionLevel.class));
        this.myDataProtectionLevelComboBox.setRenderer(new ListCellRendererWrapper<AdvancedOptionsConfig.DataChannelProtectionLevel>(){

            public void customize(JList list, AdvancedOptionsConfig.DataChannelProtectionLevel value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getPresentableValue());
            }
        });
        this.myKeepAliveFtpCommandComboBox.setModel(new EnumComboBoxModel(JBFtpKeepAliveCommand.class));
        this.myKeepAliveFtpCommandComboBox.setRenderer(new ListCellRendererWrapper<JBFtpKeepAliveCommand>(){

            public void customize(JList list, JBFtpKeepAliveCommand value, int index, boolean selected, boolean hasFocus) {
                this.setText(value.getCommand());
            }
        });
        this.myConfig = config;
        this.reset();
        this.myShowHiddenFilesCheckBox.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myPassiveModeCheckBox.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myTimestampsLabel.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myTimestampsCombo.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        this.myCompatibilityModeCheckBox.setVisible(accessType == AccessType.FTP);
        this.myDataProtectionLevelLabel.setVisible(accessType == AccessType.FTPS);
        this.myDataProtectionLevelComboBox.setVisible(accessType == AccessType.FTPS);
        this.myMuteSftpMessagesCheckBox.setVisible(accessType == AccessType.SFTP);
        this.myForceListCommandCheckBox.setVisible(accessType == AccessType.FTP || accessType == AccessType.FTPS);
        boolean showKeepAliveFtpCommand = accessType == AccessType.FTP || accessType == AccessType.FTPS;
        this.myKeepAliveFtpCommandLabel.setVisible(showKeepAliveFtpCommand);
        this.myKeepAliveFtpCommandComboBox.setVisible(showKeepAliveFtpCommand);
    }

    private void reset() {
        this.myShowHiddenFilesCheckBox.setSelected(this.myConfig.isShowHiddenFiles());
        this.myPassiveModeCheckBox.setSelected(this.myConfig.isPassiveMode());
        this.myTimestampsCombo.setSelectedIndex(this.myConfig.getAccurateTimestamps().ordinal());
        if (this.myConfig.getMaxConnections() != Integer.MAX_VALUE) {
            this.myMaxConnectionsCheckBox.setSelected(true);
            this.myMaxConnectionsTextField.setText(String.valueOf(this.myConfig.getMaxConnections()));
            this.myMaxConnectionsTextField.setEnabled(true);
        } else {
            this.myMaxConnectionsCheckBox.setSelected(false);
            this.myMaxConnectionsTextField.setText("");
            this.myMaxConnectionsTextField.setEnabled(false);
        }
        this.myMaxConnectionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedOptionsForm.this.myMaxConnectionsCheckBox.isSelected()) {
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setEnabled(true);
                    IdeFocusManager.findInstanceByComponent((Component)AdvancedOptionsForm.this.myContentPane).requestFocus((Component)AdvancedOptionsForm.this.myMaxConnectionsTextField, false);
                } else {
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setText("");
                    AdvancedOptionsForm.this.myMaxConnectionsTextField.setEnabled(false);
                }
                ((ChangeListener)AdvancedOptionsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myMaxConnectionsTextField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((ChangeListener)AdvancedOptionsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            }
        });
        this.myCompatibilityModeCheckBox.setSelected(this.myConfig.isCompatibilityMode());
        this.myDataProtectionLevelComboBox.setSelectedIndex(this.myConfig.getDataChannelProtectionLevel().ordinal());
        this.myControlEncodingTextField.setText(this.myConfig.getControlEncoding());
        this.myMuteSftpMessagesCheckBox.setSelected(this.myConfig.isMuteSftpMessages());
        this.myForceListCommandCheckBox.setSelected(this.myConfig.isForceListCommand());
        int keepAliveTimeout = this.myConfig.getKeepAliveTimeout();
        boolean keepAliveEnabled = keepAliveTimeout > 0;
        this.myKeepAliveCheckbox.setSelected(keepAliveEnabled);
        this.myKeepAliveTimeoutField.setEnabled(keepAliveEnabled);
        this.myKeepAliveTimeoutField.setText(keepAliveEnabled ? String.valueOf(keepAliveTimeout / 1000) : "");
        this.myKeepAliveCheckbox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (AdvancedOptionsForm.this.myKeepAliveCheckbox.isSelected()) {
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setEnabled(true);
                    int timeout = AdvancedOptionsForm.this.myConfig.getKeepAliveTimeout() > 0 ? AdvancedOptionsForm.this.myConfig.getKeepAliveTimeout() : 300000;
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setText(String.valueOf(timeout / 1000));
                    IdeFocusManager.findInstanceByComponent((Component)AdvancedOptionsForm.this.myContentPane).requestFocus((Component)AdvancedOptionsForm.this.myKeepAliveTimeoutField, false);
                } else {
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setText("");
                    AdvancedOptionsForm.this.myKeepAliveTimeoutField.setEnabled(false);
                }
                ((ChangeListener)AdvancedOptionsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent(this));
            }
        });
        this.myKeepAliveTimeoutField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            protected void textChanged(DocumentEvent e) {
                ((ChangeListener)AdvancedOptionsForm.this.myEventDispatcher.getMulticaster()).stateChanged(new ChangeEvent((Object)this));
            }
        });
        this.myKeepAliveFtpCommandComboBox.setSelectedItem(this.myConfig.getKeepAliveFtpCommand());
    }

    public JComponent getContentPane() {
        return this.myContentPane;
    }

    public void apply() {
        this.myConfig.setShowHiddenFiles(this.myShowHiddenFilesCheckBox.isSelected());
        this.myConfig.setPassiveMode(this.myPassiveModeCheckBox.isSelected());
        this.myConfig.setAccurateTimestamps(AdvancedOptionsConfig.AccurateTimestamps.values()[this.myTimestampsCombo.getSelectedIndex()]);
        String s = this.myMaxConnectionsTextField.getText();
        this.myConfig.setMaxConnections(StringUtil.isEmpty((String)s) ? Integer.MAX_VALUE : Integer.parseInt(s));
        this.myConfig.setCompatibilityMode(this.myCompatibilityModeCheckBox.isSelected());
        this.myConfig.setDataChannelProtectionLevel((AdvancedOptionsConfig.DataChannelProtectionLevel)((Object)this.myDataProtectionLevelComboBox.getSelectedItem()));
        this.myConfig.setControlEncoding(this.myControlEncodingTextField.getText());
        this.myConfig.setMuteSftpMessages(this.myMuteSftpMessagesCheckBox.isSelected());
        this.myConfig.setForceListCommand(this.myForceListCommandCheckBox.isSelected());
        String timeout = this.myKeepAliveTimeoutField.getText();
        this.myConfig.setKeepAliveTimeout(this.myKeepAliveCheckbox.isSelected() ? Integer.parseInt(timeout) * 1000 : 0);
        this.myConfig.setKeepAliveFtpCommand((JBFtpKeepAliveCommand)this.myKeepAliveFtpCommandComboBox.getSelectedItem());
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myPassiveModeCheckBox.isVisible() ? this.myPassiveModeCheckBox : this.myMaxConnectionsCheckBox;
    }

    public void setMessage(String warning) {
        if (warning != null) {
            this.myMessageLabel.setText(warning);
            this.myMessageLabel.setVisible(true);
        } else {
            this.myMessageLabel.setVisible(false);
        }
    }

    @Nullable
    public String getErrorMessage() {
        String text;
        if (this.myMaxConnectionsCheckBox.isSelected()) {
            text = this.myMaxConnectionsTextField.getText();
            if (StringUtil.isEmpty((String)text)) {
                return WDBundle.message("empty.max.connections", new Object[0]);
            }
            try {
                if (Integer.parseInt(text) < 0) {
                    return WDBundle.message("invalid.max.connections", new Object[0]);
                }
            }
            catch (NumberFormatException e) {
                return WDBundle.message("invalid.max.connections", new Object[0]);
            }
        }
        if (this.myKeepAliveCheckbox.isSelected()) {
            text = this.myKeepAliveTimeoutField.getText();
            if (StringUtil.isEmpty((String)text)) {
                return WDBundle.message("empty.keep.alive.timeout", new Object[0]);
            }
            try {
                if (Integer.parseInt(text) < 1) {
                    return WDBundle.message("invalid.keep.alive.timeout", new Object[0]);
                }
            }
            catch (NumberFormatException e) {
                return WDBundle.message("invalid.keep.alive.timeout", new Object[0]);
            }
        }
        return null;
    }

    public void addListener(ChangeListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JLabel jLabel;
        JComboBox jComboBox;
        JLabel jLabel2;
        JTextField jTextField;
        JCheckBox jCheckBox;
        JBCheckBox jBCheckBox;
        JBCheckBox jBCheckBox2;
        JTextField jTextField2;
        JComboBox jComboBox2;
        JLabel jLabel3;
        JCheckBox jCheckBox2;
        JTextField jTextField3;
        JCheckBox jCheckBox3;
        JLabel jLabel4;
        JComboBox jComboBox3;
        JLabel jLabel5;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JPanel jPanel;
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(13, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(12, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.myShowHiddenFilesCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox5.setText("Show and process hidden files");
        jCheckBox5.setMnemonic('S');
        jCheckBox5.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox5, new GridConstraints(1, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myPassiveModeCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox4.setText("Passive mode");
        jCheckBox4.setMnemonic('P');
        jCheckBox4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox4, new GridConstraints(0, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myMessageLabel = jLabel5 = new JLabel();
        jLabel5.setText("Label");
        jPanel.add((Component)jLabel5, new GridConstraints(11, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myTimestampsCombo = jComboBox3 = new JComboBox();
        jPanel.add(jComboBox3, new GridConstraints(3, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myTimestampsLabel = jLabel4 = new JLabel();
        jLabel4.setText("Retrieve accurate files timestamps:");
        jLabel4.setDisplayedMnemonic('R');
        jLabel4.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel4, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMaxConnectionsCheckBox = jCheckBox3 = new JCheckBox();
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox3.setText("Limit concurrent connections:");
        jCheckBox3.setMnemonic('L');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox3, new GridConstraints(4, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myMaxConnectionsTextField = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(100, -1), null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(4, 2, 1, 1, 0, 1, 6, 1, null, null, null));
        this.myCompatibilityModeCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox2.setText("Compatibility mode");
        jCheckBox2.setMnemonic('C');
        jCheckBox2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jCheckBox2, new GridConstraints(2, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        this.myDataProtectionLevelLabel = jLabel3 = new JLabel();
        jLabel3.setText("Protect data channel:");
        jLabel3.setDisplayedMnemonic('D');
        jLabel3.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel3, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myDataProtectionLevelComboBox = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(5, 1, 1, 1, 8, 0, 2, 0, null, new Dimension(100, -1), null));
        this.myControlEncodingTextField = jTextField2 = new JTextField();
        jPanel.add((Component)jTextField2, new GridConstraints(6, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(100, -1), null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Control encoding:");
        jLabel6.setDisplayedMnemonic('E');
        jLabel6.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel6, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myMuteSftpMessagesCheckBox = jBCheckBox2 = new JBCheckBox();
        jBCheckBox2.setText("Ignore info messages");
        jBCheckBox2.setMnemonic('G');
        jBCheckBox2.setDisplayedMnemonicIndex(1);
        jPanel.add((Component)jBCheckBox2, new GridConstraints(7, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myForceListCommandCheckBox = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Always use LIST command");
        jBCheckBox.setMnemonic('U');
        jBCheckBox.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jBCheckBox, new GridConstraints(8, 0, 1, 2, 0, 1, 0, 0, null, null, null));
        this.myKeepAliveCheckbox = jCheckBox = new JCheckBox();
        jCheckBox.setMargin(new Insets(2, 0, 2, 3));
        jCheckBox.setText("Send keep alive messages each:");
        jCheckBox.setMnemonic('K');
        jCheckBox.setDisplayedMnemonicIndex(5);
        jPanel.add((Component)jCheckBox, new GridConstraints(9, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout(0, 0));
        jPanel.add((Component)jPanel2, new GridConstraints(9, 1, 1, 1, 0, 3, 3, 3, null, null, null));
        this.myKeepAliveTimeoutField = jTextField = new JTextField();
        jTextField.setMargin(new Insets(0, 0, 0, 0));
        jPanel2.add((Component)jTextField, "Center");
        this.myKeepAliveMeasureLabel = jLabel2 = new JLabel();
        jLabel2.setText(" s");
        jPanel2.add((Component)jLabel2, "East");
        this.myKeepAliveFtpCommandComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(10, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.myKeepAliveFtpCommandLabel = jLabel = new JLabel();
        jLabel.setText("Use keep alive command:");
        jLabel.setDisplayedMnemonic('A');
        jLabel.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jLabel, new GridConstraints(10, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        jLabel4.setLabelFor(jComboBox3);
        jLabel3.setLabelFor(jComboBox2);
        jLabel6.setLabelFor(jTextField2);
        jLabel2.setLabelFor(jTextField);
        jLabel.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }
}

