/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.plugins.webDeployment.ui;

import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.EnumComboBoxModel;
import com.intellij.ui.HideableTitledPanel;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ui.UIUtil;
import com.jetbrains.plugins.webDeployment.WDBundle;
import com.jetbrains.plugins.webDeployment.config.DeploymentPathMapping;
import com.jetbrains.plugins.webDeployment.config.PublishConfig;
import com.jetbrains.plugins.webDeployment.config.WebServerConfig;
import com.jetbrains.plugins.webDeployment.config.WebServersConfigManager;
import com.jetbrains.plugins.webDeployment.ui.PermissionsDialog;
import com.jetbrains.plugins.webDeployment.ui.SftpAdvancedOptionsPanel;
import com.jetbrains.plugins.webDeployment.ui.Util;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.ResourceBundle;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.ListCellRenderer;

public class PublishOptionsConfigForm {
    private JPanel myContentPane;
    private JCheckBox myStopOnFirstError;
    private JCheckBox myOverwriteCheckBox;
    private JCheckBox myPreserveTimestamps;
    private JCheckBox myDeleteMissingItems;
    private JCheckBox myCreateEmptyDirectories;
    private JCheckBox myPromptOnLocalOverwrite;
    private JTextField myExcludeTextField;
    private JCheckBox myOverwriteFilesPermissionsCheckBox;
    private JCheckBox myOverwriteFoldersPermissionsCheckBox;
    private TextFieldWithBrowseButton myFilesPermissionsField;
    private TextFieldWithBrowseButton myFoldersPermissionsField;
    private JComboBox myAutoUploadComboBox;
    private ComboBox myTraceLevelCombo;
    private JLabel myTraceLevelLabel;
    private JCheckBox myAutoUploadExternalChangesCheckBox;
    private JCheckBox myNotifyRemoteChangesCheckBox;
    private JComboBox myPromptOnRemoteOverwriteCombo;
    private JLabel myMessageLabel;
    private JBLabel myAutoUploadMessageLabel;
    private HideableTitledPanel mySftpAdvancedPanel;
    private String myAutoUploadMessageLabelText;
    private int myFilePermissions;
    private int myFolderPermissions;
    private PublishConfig.PromptOnRemoteOverwrite myPromptOnRemoteOverwriteOriginal;
    private SftpAdvancedOptionsPanel mySftpAdvancedOptionsPanel;
    private boolean myShowMessage;

    public PublishOptionsConfigForm() {
        this.$$$setupUI$$$();
        this.myOverwriteFilesPermissionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishOptionsConfigForm.this.myFilePermissions = PublishOptionsConfigForm.this.myOverwriteFilesPermissionsCheckBox.isSelected() ? 420 : -1;
                PublishOptionsConfigForm.this.updateFilesPermissionsControls();
            }
        });
        this.myFilesPermissionsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionsDialog.Single d = new PermissionsDialog.Single(PublishOptionsConfigForm.this.myContentPane, WDBundle.message("change.default.file.permissions.dialog.title", new Object[0]), PublishOptionsConfigForm.this.myFilePermissions);
                if (d.showAndGet()) {
                    PublishOptionsConfigForm.this.myFilePermissions = d.getPermissions();
                    PublishOptionsConfigForm.this.updateFilesPermissionsControls();
                }
            }
        });
        this.myOverwriteFoldersPermissionsCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishOptionsConfigForm.this.myFolderPermissions = PublishOptionsConfigForm.this.myOverwriteFoldersPermissionsCheckBox.isSelected() ? 493 : -1;
                PublishOptionsConfigForm.this.updateFoldersPermissionsControls();
            }
        });
        this.myFoldersPermissionsField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PermissionsDialog.Single d = new PermissionsDialog.Single(PublishOptionsConfigForm.this.myContentPane, WDBundle.message("change.default.folder.permissions.dialog.title", new Object[0]), PublishOptionsConfigForm.this.myFolderPermissions);
                if (d.showAndGet()) {
                    PublishOptionsConfigForm.this.myFolderPermissions = d.getPermissions();
                    PublishOptionsConfigForm.this.updateFoldersPermissionsControls();
                }
            }
        });
        this.myTraceLevelCombo.setModel((ComboBoxModel)new EnumComboBoxModel(PublishConfig.TraceLevel.class));
        this.myTraceLevelCombo.setRenderer((ListCellRenderer)new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof PublishConfig.TraceLevel) {
                    this.setText(WDBundle.message("trace.level." + ((PublishConfig.TraceLevel)((Object)value)).name(), new Object[0]));
                }
            }
        });
        this.myTraceLevelLabel.setLabelFor((Component)this.myTraceLevelCombo);
        this.myAutoUploadComboBox.setModel(new EnumComboBoxModel(PublishConfig.AutoUploadState.class));
        this.myAutoUploadComboBox.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                if (value instanceof PublishConfig.AutoUploadState) {
                    this.setText(((PublishConfig.AutoUploadState)((Object)value)).getPresentableName());
                }
            }
        });
        this.myAutoUploadComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishOptionsConfigForm.this.updateUploadExternalChangesCombo();
                PublishOptionsConfigForm.this.myAutoUploadMessageLabel.setVisible(PublishOptionsConfigForm.this.myAutoUploadComboBox.getSelectedItem() != PublishConfig.AutoUploadState.NEVER && PublishOptionsConfigForm.this.myAutoUploadMessageLabelText != null);
            }
        });
        this.myPromptOnRemoteOverwriteCombo.setModel(new EnumComboBoxModel(PublishConfig.PromptOnRemoteOverwrite.class));
        this.myPromptOnRemoteOverwriteCombo.setRenderer(new ListCellRendererWrapper(){

            public void customize(JList list, Object value, int index, boolean selected, boolean hasFocus) {
                this.setText(WDBundle.message("propmt.on.remote.overwrite." + value, new Object[0]));
            }
        });
        this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myAutoUploadMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
        this.myPromptOnRemoteOverwriteCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PublishOptionsConfigForm.this.updateMessage();
            }
        });
    }

    public void setShowMessage(boolean showMessage) {
        this.myShowMessage = showMessage;
    }

    private void updateMessage() {
        if (this.myPromptOnRemoteOverwriteCombo.getSelectedItem() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
            this.myNotifyRemoteChangesCheckBox.setSelected(false);
            this.myNotifyRemoteChangesCheckBox.setEnabled(false);
        } else {
            this.myNotifyRemoteChangesCheckBox.setEnabled(true);
        }
        if (!this.myShowMessage) {
            this.myMessageLabel.setVisible(false);
            return;
        }
        if (this.myPromptOnRemoteOverwriteOriginal == PublishConfig.PromptOnRemoteOverwrite.NONE && this.myPromptOnRemoteOverwriteCombo.getSelectedItem() != PublishConfig.PromptOnRemoteOverwrite.NONE) {
            this.myMessageLabel.setIcon(UIUtil.getBalloonInformationIcon());
            this.myMessageLabel.setText(WDBundle.message("merge.on.upload.option.on", new Object[0]));
            this.myMessageLabel.setVisible(true);
        } else if (this.myPromptOnRemoteOverwriteOriginal != PublishConfig.PromptOnRemoteOverwrite.NONE && this.myPromptOnRemoteOverwriteCombo.getSelectedItem() == PublishConfig.PromptOnRemoteOverwrite.NONE) {
            this.myMessageLabel.setIcon(UIUtil.getBalloonWarningIcon());
            this.myMessageLabel.setText(WDBundle.message("merge.on.upload.option.off", new Object[0]));
            this.myMessageLabel.setVisible(true);
        } else {
            this.myMessageLabel.setVisible(false);
        }
    }

    private void updateUploadExternalChangesCombo() {
        if (this.myAutoUploadComboBox.getSelectedItem() != PublishConfig.AutoUploadState.NEVER) {
            this.myAutoUploadExternalChangesCheckBox.setEnabled(true);
        } else {
            this.myAutoUploadExternalChangesCheckBox.setEnabled(false);
            this.myAutoUploadExternalChangesCheckBox.setSelected(false);
        }
    }

    private void updateFilesPermissionsControls() {
        this.myFilesPermissionsField.setEnabled(this.myOverwriteFilesPermissionsCheckBox.isSelected());
        this.myFilesPermissionsField.setText(this.myFilePermissions == -1 ? WDBundle.message("permissions.none", new Object[0]) : PublishOptionsConfigForm.toString(this.myFilePermissions));
    }

    private void updateFoldersPermissionsControls() {
        this.myFoldersPermissionsField.setEnabled(this.myOverwriteFoldersPermissionsCheckBox.isSelected());
        this.myFoldersPermissionsField.setText(this.myFolderPermissions == -1 ? WDBundle.message("permissions.none", new Object[0]) : PublishOptionsConfigForm.toString(this.myFolderPermissions));
    }

    public boolean isModified(PublishConfig config) {
        if (config.isStopOnFirstError() != this.myStopOnFirstError.isSelected()) {
            return true;
        }
        if (config.isOverwriteAll() != this.myOverwriteCheckBox.isSelected()) {
            return true;
        }
        if (config.isPreserveTimestamps() != this.myPreserveTimestamps.isSelected()) {
            return true;
        }
        if (config.isDeleteMissingItems() != this.myDeleteMissingItems.isSelected()) {
            return true;
        }
        if (config.isCreateEmptyDirectories() != this.myCreateEmptyDirectories.isSelected()) {
            return true;
        }
        if (config.getTraceLevel() != this.myTraceLevelCombo.getSelectedItem()) {
            return true;
        }
        if (config.isPromptOnLocalOverwrite() != this.myPromptOnLocalOverwrite.isSelected()) {
            return true;
        }
        if (!Comparing.strEqual((String)config.getExcludeMask(), (String)this.myExcludeTextField.getText())) {
            return true;
        }
        if (config.getFilePermissions() != this.myFilePermissions) {
            return true;
        }
        if (config.getFolderPermissions() != this.myFolderPermissions) {
            return true;
        }
        if (config.getAutoUploadState() != this.myAutoUploadComboBox.getSelectedItem()) {
            return true;
        }
        if (config.isAutoUploadExternalChanges() != this.myAutoUploadExternalChangesCheckBox.isSelected()) {
            return true;
        }
        if (config.getPromptOnRemoteOverwrite() != this.myPromptOnRemoteOverwriteCombo.getSelectedItem()) {
            return true;
        }
        if (this.myNotifyRemoteChangesCheckBox.isSelected() != config.isNotifyRemoteChanges()) {
            return true;
        }
        return this.mySftpAdvancedOptionsPanel.isModified(WebServersConfigManager.getInstance(null));
    }

    public void applyTo(PublishConfig config) {
        config.setStopOnFirstError(this.myStopOnFirstError.isSelected());
        config.setOverwriteAll(this.myOverwriteCheckBox.isSelected());
        config.setPreserveTimestamps(this.myPreserveTimestamps.isSelected());
        config.setDeleteMissingItems(this.myDeleteMissingItems.isSelected());
        config.setCreateEmptyDirectories(this.myCreateEmptyDirectories.isSelected());
        Object value = this.myTraceLevelCombo.getSelectedItem();
        config.setTraceLevel(value instanceof PublishConfig.TraceLevel ? (PublishConfig.TraceLevel)((Object)value) : PublishConfig.DEFAULT_TRACE_LEVEL);
        config.setPromptOnLocalOverwrite(this.myPromptOnLocalOverwrite.isSelected());
        config.setExcludeMask(this.myExcludeTextField.getText());
        config.setFilePermissions(this.myFilePermissions);
        config.setFolderPermissions(this.myFolderPermissions);
        Object autoUploadState = this.myAutoUploadComboBox.getSelectedItem();
        config.setAutoUploadState(autoUploadState instanceof PublishConfig.AutoUploadState ? (PublishConfig.AutoUploadState)((Object)autoUploadState) : PublishConfig.AutoUploadState.NEVER);
        config.setAutoUploadExternalChanges(this.myAutoUploadExternalChangesCheckBox.isSelected());
        config.setPromptOnRemoteOverwrite((PublishConfig.PromptOnRemoteOverwrite)((Object)this.myPromptOnRemoteOverwriteCombo.getSelectedItem()));
        this.myPromptOnRemoteOverwriteOriginal = (PublishConfig.PromptOnRemoteOverwrite)((Object)this.myPromptOnRemoteOverwriteCombo.getSelectedItem());
        config.setNotifyRemoteChanges(this.myPromptOnRemoteOverwriteCombo.getSelectedItem() != PublishConfig.PromptOnRemoteOverwrite.NONE && this.myNotifyRemoteChangesCheckBox.isSelected());
        this.mySftpAdvancedOptionsPanel.applyTo(WebServersConfigManager.getInstance(null));
        this.updateMessage();
    }

    public void resetFrom(PublishConfig config) {
        this.myStopOnFirstError.setSelected(config.isStopOnFirstError());
        this.myOverwriteCheckBox.setSelected(config.isOverwriteAll());
        this.myPreserveTimestamps.setSelected(config.isPreserveTimestamps());
        this.myDeleteMissingItems.setSelected(config.isDeleteMissingItems());
        this.myCreateEmptyDirectories.setSelected(config.isCreateEmptyDirectories());
        this.myTraceLevelCombo.setSelectedItem((Object)config.getTraceLevel());
        this.myPromptOnLocalOverwrite.setSelected(config.isPromptOnLocalOverwrite());
        this.myExcludeTextField.setText(config.getExcludeMask());
        this.myOverwriteFilesPermissionsCheckBox.setSelected(config.getFilePermissions() != -1);
        this.myOverwriteFoldersPermissionsCheckBox.setSelected(config.getFolderPermissions() != -1);
        this.myFilePermissions = config.getFilePermissions();
        this.myFolderPermissions = config.getFolderPermissions();
        this.updateFilesPermissionsControls();
        this.updateFoldersPermissionsControls();
        this.myAutoUploadComboBox.setSelectedItem((Object)config.getAutoUploadState());
        this.updateUploadExternalChangesCombo();
        WebServerConfig server = config.findDefaultServer();
        this.myAutoUploadMessageLabelText = null;
        if (server == null) {
            if (this.myShowMessage) {
                this.myAutoUploadMessageLabelText = WDBundle.message("default.server.is.not.configured", new Object[0]);
            }
        } else if (!server.needsTransfer()) {
            this.myAutoUploadMessageLabelText = WDBundle.message("default.server.0.does.n.t.need.automatic.upload", server.getName());
        } else {
            String validationMessage = server.getFileTransferConfig().validateFast();
            if (validationMessage != null) {
                this.myAutoUploadMessageLabelText = WDBundle.message("automatic.upload.will.not.work.because.default.server.0.is.invalid.1", server.getName(), StringUtil.decapitalize((String)validationMessage));
            } else {
                List<DeploymentPathMapping> mappings = config.getPathMappings(server.getId());
                boolean validMappingFound = false;
                if (mappings != null && !mappings.isEmpty()) {
                    boolean isProtocolBased = server.getFileTransferConfig().getAccessType().isProtocolBased();
                    for (DeploymentPathMapping mapping : mappings) {
                        if (!mapping.isLocalPathValid() || !mapping.isDeployPathValid(isProtocolBased)) continue;
                        validMappingFound = true;
                        break;
                    }
                }
                if (!validMappingFound) {
                    this.myAutoUploadMessageLabelText = WDBundle.message("automatic.upload.will.not.work.because.default.server.0.has.no.valid.mappings", server.getName());
                }
            }
        }
        this.myAutoUploadMessageLabel.setText(this.myAutoUploadMessageLabelText);
        this.myAutoUploadMessageLabel.setVisible(config.getAutoUploadState() != PublishConfig.AutoUploadState.NEVER && this.myAutoUploadMessageLabelText != null);
        this.myAutoUploadExternalChangesCheckBox.setSelected(config.isAutoUploadExternalChanges());
        this.myNotifyRemoteChangesCheckBox.setSelected(config.getPromptOnRemoteOverwrite() != PublishConfig.PromptOnRemoteOverwrite.NONE && config.isNotifyRemoteChanges());
        this.myPromptOnRemoteOverwriteCombo.setSelectedItem((Object)config.getPromptOnRemoteOverwrite());
        this.myPromptOnRemoteOverwriteOriginal = config.getPromptOnRemoteOverwrite();
        this.mySftpAdvancedOptionsPanel.resetFrom(WebServersConfigManager.getInstance(null));
        this.updateMessage();
    }

    private static String toString(int permissions) {
        return MessageFormat.format("{0} ({1})", Util.getPermissionsAsString(permissions), Util.toOctalString(permissions));
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myExcludeTextField;
    }

    private void createUIComponents() {
        this.mySftpAdvancedOptionsPanel = new SftpAdvancedOptionsPanel();
        this.mySftpAdvancedPanel = new HideableTitledPanel(WDBundle.message("configurable.panel.title.sftp.advanced.options", new Object[0]), (JComponent)this.mySftpAdvancedOptionsPanel.getMainPanel(), false);
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JTextField jTextField;
        JBLabel jBLabel;
        JCheckBox jCheckBox;
        JLabel jLabel;
        JComboBox jComboBox2;
        JCheckBox jCheckBox2;
        ComboBox comboBox;
        JCheckBox jCheckBox3;
        JLabel jLabel2;
        TextFieldWithBrowseButton textFieldWithBrowseButton;
        TextFieldWithBrowseButton textFieldWithBrowseButton2;
        JCheckBox jCheckBox4;
        JCheckBox jCheckBox5;
        JCheckBox jCheckBox6;
        JCheckBox jCheckBox7;
        JCheckBox jCheckBox8;
        JCheckBox jCheckBox9;
        JCheckBox jCheckBox10;
        JPanel jPanel;
        this.createUIComponents();
        this.myContentPane = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(19, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myOverwriteCheckBox = jCheckBox10 = new JCheckBox();
        jCheckBox10.setText("Overwrite up-to-date files");
        jCheckBox10.setMnemonic('W');
        jCheckBox10.setDisplayedMnemonicIndex(4);
        jCheckBox10.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox10, new GridConstraints(4, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myPreserveTimestamps = jCheckBox9 = new JCheckBox();
        jCheckBox9.setText("Preserve files timestamps");
        jCheckBox9.setMnemonic('P');
        jCheckBox9.setDisplayedMnemonicIndex(0);
        jCheckBox9.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox9, new GridConstraints(5, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myDeleteMissingItems = jCheckBox8 = new JCheckBox();
        jCheckBox8.setText("Delete target items when source ones do not exist (when transferring from Project view or Remote Host view)");
        jCheckBox8.setMnemonic('D');
        jCheckBox8.setDisplayedMnemonicIndex(0);
        jCheckBox8.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox8, new GridConstraints(6, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myCreateEmptyDirectories = jCheckBox7 = new JCheckBox();
        jCheckBox7.setText("Create empty directories");
        jCheckBox7.setMnemonic('C');
        jCheckBox7.setDisplayedMnemonicIndex(0);
        jCheckBox7.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox7, new GridConstraints(7, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myPromptOnLocalOverwrite = jCheckBox6 = new JCheckBox();
        jCheckBox6.setText("Prompt when overwriting or deleting local items");
        jCheckBox6.setMnemonic('R');
        jCheckBox6.setDisplayedMnemonicIndex(1);
        jCheckBox6.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox6, new GridConstraints(8, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myOverwriteFilesPermissionsCheckBox = jCheckBox5 = new JCheckBox();
        jCheckBox5.setText("Override default permissions on files:");
        jCheckBox5.setMnemonic('V');
        jCheckBox5.setDisplayedMnemonicIndex(1);
        jCheckBox5.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox5, new GridConstraints(11, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myOverwriteFoldersPermissionsCheckBox = jCheckBox4 = new JCheckBox();
        jCheckBox4.setText("Override default permissions on folders:");
        jCheckBox4.setMnemonic('I');
        jCheckBox4.setDisplayedMnemonicIndex(5);
        jCheckBox4.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox4, new GridConstraints(12, 0, 1, 2, 8, 0, 3, 0, null, null, null));
        this.myFilesPermissionsField = textFieldWithBrowseButton2 = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton2.setEditable(false);
        jPanel.add((Component)textFieldWithBrowseButton2, new GridConstraints(11, 2, 1, 1, 8, 0, 2, 0, null, new Dimension(180, -1), null));
        this.myFoldersPermissionsField = textFieldWithBrowseButton = new TextFieldWithBrowseButton();
        textFieldWithBrowseButton.setEditable(false);
        jPanel.add((Component)textFieldWithBrowseButton, new GridConstraints(12, 2, 1, 1, 8, 0, 6, 0, null, new Dimension(180, -1), null));
        this.myTraceLevelLabel = jLabel2 = new JLabel();
        jLabel2.setText("Operations logging:");
        jLabel2.setDisplayedMnemonic('O');
        jLabel2.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel2, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myStopOnFirstError = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Stop operation on the first error");
        jCheckBox3.setMnemonic('S');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jCheckBox3.setMargin(new Insets(2, 0, 2, 3));
        jPanel.add((Component)jCheckBox3, new GridConstraints(3, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        this.myTraceLevelCombo = comboBox = new ComboBox();
        jPanel.add((Component)comboBox, new GridConstraints(2, 1, 1, 1, 8, 0, 3, 3, null, new Dimension(100, 22), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(16, 2, 1, 1, 0, 2, 5, 6, null, null, null));
        this.myAutoUploadExternalChangesCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Upload external changes");
        jCheckBox2.setMnemonic('X');
        jCheckBox2.setDisplayedMnemonicIndex(8);
        ((Component)jCheckBox2).setVisible(true);
        jCheckBox2.setMargin(new Insets(2, 15, 2, 3));
        jPanel.add((Component)jCheckBox2, new GridConstraints(10, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Warn when uploading over newer file:");
        jLabel3.setDisplayedMnemonic('N');
        jLabel3.setDisplayedMnemonicIndex(25);
        jPanel.add((Component)jLabel3, new GridConstraints(13, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        this.myPromptOnRemoteOverwriteCombo = jComboBox2 = new JComboBox();
        jPanel.add(jComboBox2, new GridConstraints(13, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        this.myMessageLabel = jLabel = new JLabel();
        jLabel.setText("Label");
        jPanel.add((Component)jLabel, new GridConstraints(17, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        this.myNotifyRemoteChangesCheckBox = jCheckBox = new JCheckBox();
        jCheckBox.setText("Notify about remote changes");
        jCheckBox.setMnemonic('H');
        jCheckBox.setDisplayedMnemonicIndex(21);
        jPanel.add((Component)jCheckBox, new GridConstraints(14, 0, 1, 3, 8, 0, 3, 0, null, null, null, 1));
        this.myAutoUploadMessageLabel = jBLabel = new JBLabel();
        jBLabel.setText("Label");
        jPanel.add((Component)jBLabel, new GridConstraints(18, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("<html><u>E</u>xclude items by name:</html>");
        jLabel4.setDisplayedMnemonic('E');
        jLabel4.setDisplayedMnemonicIndex(9);
        jPanel.add((Component)jLabel4, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(2, 1, new Insets(0, 0, 8, 0), -1, 0, false, false));
        jPanel.add((Component)jPanel2, new GridConstraints(0, 1, 2, 2, 0, 3, 3, 3, null, null, null, 0, true));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setComponentStyle(UIUtil.ComponentStyle.SMALL);
        jBLabel2.setText("<html>use <b>;</b> as delimiter, <b>*</b> and <b>?</b> as wildcards</html>");
        jBLabel2.setFontColor(UIUtil.FontColor.BRIGHTER);
        jPanel2.add((Component)jBLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null, 1));
        this.myExcludeTextField = jTextField = new JTextField();
        jPanel2.add((Component)jTextField, new GridConstraints(0, 0, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.myAutoUploadComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(9, 2, 1, 1, 8, 0, 2, 0, null, null, null));
        JLabel jLabel5 = new JLabel();
        this.$$$loadLabelText$$$(jLabel5, ResourceBundle.getBundle("messages/WDBundle").getString("upload.changed.files.option.description"));
        jPanel.add((Component)jLabel5, new GridConstraints(9, 0, 1, 2, 8, 0, 0, 0, null, null, null));
        HideableTitledPanel hideableTitledPanel = this.mySftpAdvancedPanel;
        jPanel.add((Component)hideableTitledPanel, new GridConstraints(15, 0, 1, 3, 0, 1, 7, 3, null, null, null));
        jLabel3.setLabelFor(jComboBox2);
        jLabel4.setLabelFor(jTextField);
        jLabel5.setLabelFor(jComboBox);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myContentPane;
    }

    private /* synthetic */ void $$$loadLabelText$$$(JLabel jLabel, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        jLabel.setText(stringBuffer.toString());
        if (bl) {
            jLabel.setDisplayedMnemonic(c);
            jLabel.setDisplayedMnemonicIndex(n);
        }
    }
}

