/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.xsltDebugger;

import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import java.io.Serializable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.SwingUtilities;
import org.intellij.plugins.xsltDebugger.VMPausedException;
import org.intellij.plugins.xsltDebugger.rt.engine.Watchable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class EDTGuard
implements InvocationHandler {
    private static final long MAX_TIMEOUT = 10000L;
    private final Map<Object, Object> myInstanceCache = ContainerUtil.newIdentityTroveMap();
    private final Object myTarget;
    private final Pair<LinkedBlockingQueue<Call>, LinkedBlockingQueue<Call.Result>> myQueue;
    private final AtomicBoolean myPausedRef;

    private EDTGuard(Object target, Pair<LinkedBlockingQueue<Call>, LinkedBlockingQueue<Call.Result>> queue, AtomicBoolean ref) {
        this.myTarget = target;
        this.myQueue = queue;
        this.myPausedRef = ref;
    }

    @Override
    @Nullable
    public Object invoke(Object proxy, @NotNull Method method, Object[] args) throws Throwable {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/intellij/plugins/xsltDebugger/EDTGuard", "invoke"));
        }
        if (SwingUtilities.isEventDispatchThread()) {
            return this.invokeAsync(method, args);
        }
        return this.invoke(method, args);
    }

    @Nullable
    private Object invokeAsync(Method method, Object[] args) throws Throwable {
        Call.Result result;
        Call call = new Call(method, args);
        if (!((LinkedBlockingQueue)this.myQueue.first).offer(call)) {
            throw new VMPausedException();
        }
        long start = System.currentTimeMillis();
        do {
            result = (Call.Result)((LinkedBlockingQueue)this.myQueue.second).poll(200L, TimeUnit.MILLISECONDS);
            if (!this.myPausedRef.get() && (result != null || System.currentTimeMillis() - start <= 10000L)) continue;
            throw new VMPausedException();
        } while (result == null || !result.isFromCall(call));
        return result.getValue();
    }

    @Nullable
    private Object invoke(@NotNull Method method, Object[] args) throws Throwable {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "method", "org/intellij/plugins/xsltDebugger/EDTGuard", "invoke"));
        }
        try {
            return this.convert(method.invoke(this.myTarget, args));
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof Error) {
                throw (Error)t;
            }
            throw t;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Object convert(@Nullable Object o) {
        if (o != null && !(o instanceof Serializable)) {
            Map<Object, Object> map = this.myInstanceCache;
            synchronized (map) {
                Object instance = this.myInstanceCache.get(o);
                if (instance == null) {
                    ClassLoader loader = o.getClass().getClassLoader();
                    Class<?>[] interfaces = o.getClass().getInterfaces();
                    EDTGuard guard = new EDTGuard(o, this.myQueue, this.myPausedRef);
                    instance = Proxy.newProxyInstance(loader, interfaces, (InvocationHandler)guard);
                    this.myInstanceCache.put(o, instance);
                }
                return instance;
            }
        }
        if (o instanceof List) {
            List list = (List)o;
            for (int i = 0; i < list.size(); ++i) {
                Object e = list.remove(i);
                list.add(i, this.convert(e));
            }
        } else if (o instanceof Set) {
            Set set = (Set)o;
            ArrayList<Object> s2 = new ArrayList<Object>();
            Iterator iterator = set.iterator();
            while (iterator.hasNext()) {
                Object o2;
                Object o1 = iterator.next();
                if (o1 == (o2 = this.convert(o1))) continue;
                iterator.remove();
                s2.add(o2);
            }
            set.addAll(s2);
        }
        return o;
    }

    @NotNull
    public static <T, O extends Watchable> T create(final @NotNull O target, ProcessHandler process) {
        if (target == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "target", "org/intellij/plugins/xsltDebugger/EDTGuard", "create"));
        }
        final Pair queue = Pair.create(new LinkedBlockingQueue(10), new LinkedBlockingQueue());
        final Thread thread = new Thread("Async Invocation Thread for " + process){

            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Call call = (Call)((LinkedBlockingQueue)queue.first).take();
                        if (call == null) continue;
                        ((LinkedBlockingQueue)queue.second).offer(call.invoke());
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        };
        thread.start();
        final AtomicBoolean ref = new AtomicBoolean();
        final Disposable d = new Disposable(){
            boolean disposed;

            public void dispose() {
                if (!this.disposed) {
                    this.disposed = true;
                    ref.set(true);
                    thread.interrupt();
                }
            }
        };
        process.addProcessListener((ProcessListener)new ProcessAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processTerminated(ProcessEvent event) {
                Disposable disposable = d;
                synchronized (disposable) {
                    Disposer.dispose((Disposable)d);
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void processWillTerminate(ProcessEvent event, boolean willBeDestroyed) {
                if (!willBeDestroyed) {
                    Disposable disposable = d;
                    synchronized (disposable) {
                        Disposer.dispose((Disposable)d);
                    }
                }
            }
        });
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.SHARED_THREAD, d);
        final Alarm alarm2 = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)alarm);
        final Runnable watchdog = () -> ref.set(true);
        Runnable ping = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Disposable disposable = d;
                synchronized (disposable) {
                    if (alarm.isDisposed()) {
                        return;
                    }
                    alarm2.addRequest(watchdog, 200);
                    try {
                        ref.set(!target.ping());
                    }
                    catch (Exception e) {
                        ref.set(true);
                    }
                    finally {
                        alarm2.cancelRequest(watchdog);
                        alarm.addRequest((Runnable)this, 500);
                    }
                }
            }
        };
        alarm.addRequest(ping, 500);
        EDTGuard guard = new EDTGuard(target, (Pair<LinkedBlockingQueue<Call>, LinkedBlockingQueue<Call.Result>>)queue, ref);
        ClassLoader classLoader = target.getClass().getClassLoader();
        Class<?>[] interfaces = target.getClass().getInterfaces();
        Object object = Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)guard);
        if (object == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/EDTGuard", "create"));
        }
        return (T)object;
    }

    class Call {
        private final Method myMethod;
        private final Object[] myArguments;

        public Call(Method method, Object[] arguments) {
            this.myMethod = method;
            this.myArguments = arguments;
        }

        @NotNull
        public Result invoke() {
            Result result;
            block3: {
                try {
                    result = new Result(EDTGuard.this.invoke(this.myMethod, this.myArguments));
                    if (result != null) break block3;
                }
                catch (Throwable e) {
                    Result result2 = new Result(e);
                    if (result2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/EDTGuard$Call", "invoke"));
                    }
                    return result2;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "org/intellij/plugins/xsltDebugger/EDTGuard$Call", "invoke"));
            }
            return result;
        }

        class Result {
            private final Object myObject;
            private final Throwable myThrowable;

            public Result(Object o) {
                this.myObject = o;
                this.myThrowable = null;
            }

            public Result(Throwable o) {
                this.myObject = null;
                this.myThrowable = o;
            }

            public boolean isFromCall(Call call) {
                return call == Call.this;
            }

            @Nullable
            public Object getValue() throws Throwable {
                if (this.myThrowable != null) {
                    throw this.myThrowable;
                }
                return this.myObject;
            }
        }
    }
}

