/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.autoconfig;

import com.intellij.database.access.DatabaseCredentials;
import com.intellij.database.autoconfig.DataSourceDetector;
import com.intellij.database.autoconfig.DataSourceRegistry;
import com.intellij.database.dataSource.DataSource;
import com.intellij.database.dataSource.DataSourceManagerEx;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.download.DownloadableFileService;
import com.intellij.util.download.DownloadableFileSetDescription;
import com.intellij.util.download.DownloadableFileSetVersions;
import java.net.URL;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class DataSourceConfigUtil {
    private DataSourceConfigUtil() {
    }

    @NotNull
    public static DownloadableFileSetVersions<DownloadableFileSetDescription> getDriverVersionsFetcher() {
        DownloadableFileSetVersions downloadableFileSetVersions = DownloadableFileService.getInstance().createFileSetVersions("jdbc-drivers", new URL[]{DataSourceConfigUtil.class.getResource("/resources/jdbc-drivers.xml")});
        if (downloadableFileSetVersions == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/autoconfig/DataSourceConfigUtil", "getDriverVersionsFetcher"));
        }
        return downloadableFileSetVersions;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void configureDetectedDataSources(@NotNull Project project, @NotNull DataSourceRegistry registry, boolean silentCreate) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/autoconfig/DataSourceConfigUtil", "configureDetectedDataSources"));
        }
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "com/intellij/database/autoconfig/DataSourceConfigUtil", "configureDetectedDataSources"));
        }
        DataSourceManagerEx dataSourceManager = DataSourceManagerEx.getInstanceEx(project);
        AccessToken writeLock = ApplicationManager.getApplication().acquireWriteActionLock(DataSourceConfigUtil.class);
        try {
            for (LocalDataSource dataSource : registry.getDataSources()) {
                LocalDataSource updated;
                DataSource existing = dataSourceManager.getDataSourceByName(dataSource.getName());
                if (existing instanceof LocalDataSource) {
                    updated = (LocalDataSource)existing;
                    DataSourceConfigUtil.copy(project, dataSource, updated, false);
                    continue;
                }
                if (!silentCreate) continue;
                updated = dataSource;
                DataSourceConfigUtil.copy(project, dataSource, updated, true);
                dataSourceManager.addDataSource(dataSource);
            }
        }
        finally {
            writeLock.finish();
        }
        DataSourceConfigUtil.runRegistryCallbacks(project, registry);
    }

    public static void runRegistryCallbacks(@NotNull Project project, @NotNull DataSourceRegistry registry) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/autoconfig/DataSourceConfigUtil", "runRegistryCallbacks"));
        }
        if (registry == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registry", "com/intellij/database/autoconfig/DataSourceConfigUtil", "runRegistryCallbacks"));
        }
        LinkedHashSet toUpdate = ContainerUtil.newLinkedHashSet();
        DataSourceManagerEx dataSourceManager = DataSourceManagerEx.getInstanceEx(project);
        for (LocalDataSource dataSource : registry.getDataSources()) {
            DataSourceDetector.Callback callback = registry.getCallback(dataSource);
            DataSource existing = dataSourceManager.getDataSourceByName(dataSource.getName());
            if (Comparing.equal((Object)existing, (Object)((Object)dataSource))) {
                if (callback != null) {
                    callback.onCreated((DatabaseSystem)dataSource);
                }
                toUpdate.add(dataSource);
                continue;
            }
            if (!(existing instanceof LocalDataSource)) continue;
            if (callback != null) {
                callback.onUpdated((DatabaseSystem)existing);
            }
            toUpdate.add((LocalDataSource)existing);
        }
        DataSourceConfigUtil.refreshTablesInBackground(project, toUpdate);
    }

    private static void copy(@NotNull Project project, @NotNull LocalDataSource from, @NotNull LocalDataSource to, boolean justCreated) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/autoconfig/DataSourceConfigUtil", "copy"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/autoconfig/DataSourceConfigUtil", "copy"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/autoconfig/DataSourceConfigUtil", "copy"));
        }
        to.setUrl(from.getUrl());
        to.setClasspathElements(ContainerUtil.newArrayList(from.getClasspathElements()));
        if (to.getDatabaseDriver() == null || !to.getOwnClasspath().isEmpty()) {
            to.ensureDriverConfigured();
        }
        if (justCreated && StringUtil.isNotEmpty((String)from.getUsername()) && StringUtil.isNotEmpty((String)from.getPassword())) {
            DatabaseCredentials.getInstance().setCredentials(project, (DatabaseSystem)to, from.getUsername(), from.getPassword());
        }
    }

    public static void refreshTablesInBackground(Project project, Collection<? extends LocalDataSource> dataSources) {
        for (LocalDataSource localDataSource : dataSources) {
            DataSourceUiUtil.performAutoSyncTask(project, localDataSource);
        }
    }
}

