/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.url.ui;

import com.intellij.database.dataSource.url.DataInterchange;
import com.intellij.database.dataSource.url.TypesRegistry;
import com.intellij.database.dataSource.url.template.PatternBuilder;
import com.intellij.database.dataSource.url.ui.ParamEditorBase;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ListCellRendererWrapper;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ComboBoxParamEditor
extends ParamEditorBase<ComboBox> {
    private static Pattern CONFIG_PATTERN = Pattern.compile("(?:^|,)((?:[^=,]|\\\\=)+)=((?:[^=,]|\\\\=)+)");
    private String myText;

    @Nullable
    private static List<Pair<String, String>> parseConfiguration(@Nullable String configuration) {
        if (StringUtil.isEmpty((String)configuration)) {
            return null;
        }
        ArrayList res = ContainerUtil.newArrayList();
        Matcher matcher = CONFIG_PATTERN.matcher(configuration);
        int start = 0;
        while (matcher.find(start)) {
            if (matcher.start() != start) {
                return null;
            }
            start = matcher.end();
            res.add(Pair.create((Object)matcher.group(1), (Object)matcher.group(2)));
        }
        if (configuration.length() != start) {
            return null;
        }
        return res;
    }

    @Nullable
    public static Pattern getPattern(@Nullable String configuration) {
        List<Pair<String, String>> parsed = ComboBoxParamEditor.parseConfiguration(configuration);
        if (parsed == null) {
            return null;
        }
        PatternBuilder builder = PatternBuilder.build("");
        boolean first = true;
        for (Pair<String, String> pair : parsed) {
            if (!first) {
                builder.append("|");
            }
            first = false;
            builder.append(Pattern.quote((String)pair.second));
        }
        return builder.compile();
    }

    @NotNull
    private static Object[] getItems(@Nullable String configuration) {
        List<Object> parsed = ComboBoxParamEditor.parseConfiguration(configuration);
        if (parsed == null) {
            parsed = Collections.emptyList();
        }
        Object[] objectArray = ArrayUtil.toObjectArray(parsed);
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/ComboBoxParamEditor", "getItems"));
        }
        return objectArray;
    }

    public ComboBoxParamEditor(@NotNull DataInterchange interchange, @Nullable String caption, @Nullable String configuration) {
        if (interchange == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "interchange", "com/intellij/database/dataSource/url/ui/ComboBoxParamEditor", "<init>"));
        }
        super(new ComboBox(ComboBoxParamEditor.getItems(configuration)), interchange, TypesRegistry.ParamEditor.FieldSize.MEDIUM, caption, new AnAction[0]);
        this.myText = "";
        ((ComboBox)this.getEditorComponent()).setRenderer((ListCellRenderer)new ListCellRendererWrapper<Pair<String, String>>(){

            public void customize(JList list, Pair<String, String> value, int index, boolean selected, boolean hasFocus) {
                if (value != null) {
                    this.setText((String)value.first);
                }
            }
        });
        ((ComboBox)this.getEditorComponent()).setEditable(false);
        ((ComboBox)this.getEditorComponent()).addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getItem() != null) {
                    ComboBoxParamEditor.this.myText = StringUtil.notNullize((String)((Pair)e.getItem()).second.toString());
                }
                ComboBoxParamEditor.this.fireChanged();
            }
        });
    }

    @Override
    @NotNull
    public String getText() {
        String string = this.myText;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dataSource/url/ui/ComboBoxParamEditor", "getText"));
        }
        return string;
    }

    @Override
    public void setText(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "text", "com/intellij/database/dataSource/url/ui/ComboBoxParamEditor", "setText"));
        }
        this.myText = text;
        int res = -1;
        int count = ((ComboBox)this.getEditorComponent()).getItemCount();
        for (int i = 0; i < count; ++i) {
            Object item = ((ComboBox)this.getEditorComponent()).getItemAt(i);
            Pair pair = (Pair)ObjectUtils.tryCast((Object)item, Pair.class);
            if (pair == null || !text.equals(pair.second)) continue;
            res = i;
            break;
        }
        ((ComboBox)this.getEditorComponent()).setSelectedIndex(res);
    }

    @Override
    public TypesRegistry.ParamEditor.FieldSize getFieldSize() {
        return TypesRegistry.ParamEditor.FieldSize.SMALL;
    }

    @Override
    public void setActive(boolean active) {
        ((ComboBox)this.getEditorComponent()).setBackground(ComboBoxParamEditor.getBackground(active));
    }
}

