/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dataSource.validation;

import com.intellij.database.dataSource.validation.DataSourceProblem;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DatabaseConfigValidator {
    public static final ExtensionPointName<DatabaseConfigValidator> EP_NAME = ExtensionPointName.create((String)"com.intellij.database.configValidator");

    public abstract void findProblems(@NotNull Object var1, @NotNull Consumer<DataSourceProblem> var2, @Nullable Function.Mono<?> var3);

    public static Set<DataSourceProblem> getProblems(@NotNull Object dataSource, @Nullable Function.Mono<?> actualizer) {
        DatabaseConfigValidator[] extensions;
        if (dataSource == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/validation/DatabaseConfigValidator", "getProblems"));
        }
        HashSet result = ContainerUtil.newHashSet();
        Consumer consumer = problem -> result.add(problem);
        for (DatabaseConfigValidator extension : extensions = (DatabaseConfigValidator[])Extensions.getExtensions(EP_NAME)) {
            extension.findProblems(dataSource, (Consumer<DataSourceProblem>)consumer, actualizer);
        }
        return result;
    }

    public static abstract class Typed<E>
    extends DatabaseConfigValidator {
        private final Class<E> myClass;
        private Function.Mono myActualizer;

        public Typed(Class<E> clazz) {
            this.myClass = clazz;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void findProblems(@NotNull Object dataSource, @NotNull Consumer<DataSourceProblem> problems, @Nullable Function.Mono<?> actualizer) {
            if (dataSource == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSource", "com/intellij/database/dataSource/validation/DatabaseConfigValidator$Typed", "findProblems"));
            }
            if (problems == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "problems", "com/intellij/database/dataSource/validation/DatabaseConfigValidator$Typed", "findProblems"));
            }
            Object dataSourceTyped = ObjectUtils.tryCast((Object)dataSource, this.myClass);
            if (dataSourceTyped != null) {
                try {
                    this.myActualizer = actualizer;
                    this.findProblemsTyped(dataSourceTyped, problems);
                }
                finally {
                    this.myActualizer = null;
                }
            }
        }

        public abstract void findProblemsTyped(@NotNull E var1, @NotNull Consumer<DataSourceProblem> var2);

        @Contract(value="!null->!null;null->null")
        protected <T> T actualize(@Nullable T x) {
            return (T)(this.myActualizer == null ? x : ObjectUtils.chooseNotNull((Object)this.myActualizer.fun(x), x));
        }
    }
}

