/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.datagrid;

import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DataType;
import com.intellij.database.model.DataTypeFactory;
import com.intellij.openapi.util.text.StringUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface DataConsumer {
    public void setColumns(@NotNull DataRequest.Context var1, int var2, Column[] var3, int var4);

    public void addRows(@NotNull DataRequest.Context var1, List<Row> var2);

    public void afterLastRowAdded(@NotNull DataRequest.Context var1, int var2);

    public static class Composite
    extends Adapter {
        private final List<DataConsumer> delegates;

        public Composite(List<DataConsumer> delegates) {
            this.delegates = delegates;
        }

        public Composite(DataConsumer ... delegates) {
            this.delegates = Arrays.asList(delegates);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column[] infos, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Composite", "setColumns"));
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.setColumns(context, resultSetIndex, infos, firstRowNum);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Composite", "addRows"));
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.addRows(context, rows);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Composite", "afterLastRowAdded"));
            }
            for (DataConsumer delegate : this.delegates) {
                delegate.afterLastRowAdded(context, total);
            }
        }
    }

    public static abstract class Wrapper
    implements DataConsumer {
        public final DataConsumer delegate;

        public Wrapper(DataConsumer dataConsumer) {
            this.delegate = dataConsumer;
        }

        public boolean accepts(DataRequest.Owner owner) {
            return true;
        }

        public boolean accepts(@NotNull DataRequest.Context context) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Wrapper", "accepts"));
            }
            return this.accepts(context.request.owner);
        }

        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column[] infos, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Wrapper", "setColumns"));
            }
            if (this.accepts(context)) {
                this.delegate.setColumns(context, resultSetIndex, infos, firstRowNum);
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Wrapper", "addRows"));
            }
            if (this.accepts(context)) {
                this.delegate.addRows(context, rows);
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Wrapper", "afterLastRowAdded"));
            }
            if (this.accepts(context)) {
                this.delegate.afterLastRowAdded(context, total);
            }
        }
    }

    public static abstract class Adapter
    implements DataConsumer {
        @Override
        public void setColumns(@NotNull DataRequest.Context context, int resultSetIndex, Column[] infos, int firstRowNum) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Adapter", "setColumns"));
            }
        }

        @Override
        public void addRows(@NotNull DataRequest.Context context, List<Row> rows) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Adapter", "addRows"));
            }
        }

        @Override
        public void afterLastRowAdded(@NotNull DataRequest.Context context, int total) {
            if (context == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/datagrid/DataConsumer$Adapter", "afterLastRowAdded"));
            }
        }
    }

    public static class Column {
        public final int columnNum;
        public final int type;
        public final String name;
        public final String typeName;
        public final String clazz;
        public final int precision;
        public final int scale;
        public final String catalog;
        public final String schema;
        public final String table;

        public Column(int columnNum, String name, int type, String typeName, String clazz) {
            this(columnNum, name, type, typeName, clazz, -1, -1, null, null, null);
        }

        public Column(int columnNum, String name, int type, String typeName, String clazz, int precision, int scale, @Nullable String catalog, @Nullable String schema, @Nullable String table) {
            this.columnNum = columnNum;
            this.name = name;
            this.type = type;
            this.typeName = typeName;
            this.clazz = clazz;
            this.precision = precision;
            this.scale = scale;
            this.catalog = catalog;
            this.schema = schema;
            this.table = table;
        }

        @Nullable
        public Object getValue(@NotNull Row row) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DataConsumer$Column", "getValue"));
            }
            return row.values[this.columnNum];
        }

        public void setValue(@NotNull Row row, Object o) {
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/datagrid/DataConsumer$Column", "setValue"));
            }
            row.values[this.columnNum] = o;
        }

        @NotNull
        public DataType asDataType() {
            String type = StringUtil.isEmpty((String)this.typeName) ? "unknown" : this.typeName;
            DataType dataType = DataTypeFactory.of(this.schema, type, this.precision, this.scale, null, null, false, false);
            if (dataType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/datagrid/DataConsumer$Column", "asDataType"));
            }
            return dataType;
        }

        public String toString() {
            return "Column" + this.columnNum + "{name='" + this.name + '\'' + ", type=" + this.type + ", typeName='" + this.typeName + '\'' + ", clazz='" + this.clazz + '\'' + ", table='" + this.catalog + '\'' + ".'" + this.schema + '\'' + ".'" + this.table + '\'' + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Column column = (Column)o;
            if (this.columnNum != column.columnNum) {
                return false;
            }
            if (this.precision != column.precision) {
                return false;
            }
            if (this.scale != column.scale) {
                return false;
            }
            if (this.type != column.type) {
                return false;
            }
            if (this.catalog != null ? !this.catalog.equals(column.catalog) : column.catalog != null) {
                return false;
            }
            if (this.clazz != null ? !this.clazz.equals(column.clazz) : column.clazz != null) {
                return false;
            }
            if (this.name != null ? !this.name.equals(column.name) : column.name != null) {
                return false;
            }
            if (this.schema != null ? !this.schema.equals(column.schema) : column.schema != null) {
                return false;
            }
            if (this.table != null ? !this.table.equals(column.table) : column.table != null) {
                return false;
            }
            return !(this.typeName != null ? !this.typeName.equals(column.typeName) : column.typeName != null);
        }

        public int hashCode() {
            int result = this.columnNum;
            result = 31 * result + this.type;
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.typeName != null ? this.typeName.hashCode() : 0);
            result = 31 * result + (this.clazz != null ? this.clazz.hashCode() : 0);
            result = 31 * result + this.precision;
            result = 31 * result + this.scale;
            result = 31 * result + (this.catalog != null ? this.catalog.hashCode() : 0);
            result = 31 * result + (this.schema != null ? this.schema.hashCode() : 0);
            result = 31 * result + (this.table != null ? this.table.hashCode() : 0);
            return result;
        }
    }

    public static class Row {
        public final int rowNum;
        public final Object[] values;

        public Row(int rowNum, Object[] values) {
            this.rowNum = rowNum;
            this.values = values;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Row row = (Row)o;
            if (this.rowNum != row.rowNum) {
                return false;
            }
            return Arrays.equals(this.values, row.values);
        }

        public int hashCode() {
            int result = this.rowNum;
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }
    }
}

