/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.dialects;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.DatabaseMessages;
import com.intellij.database.dialects.AbstractDatabaseDialect;
import com.intellij.database.dialects.DatabaseDialect;
import com.intellij.database.dialects.DialectUtils;
import com.intellij.database.dialects.KeywordHelper;
import com.intellij.database.dialects.TypeHelper;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTypedObject;
import com.intellij.database.model.MultiRef;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.database.vfs.ObjectPath;
import com.intellij.database.vfs.SearchPath;
import com.intellij.database.view.editors.DatabaseEditorCapabilities;
import com.intellij.dbm.h2.H2Model;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class H2Dialect
extends AbstractDatabaseDialect
implements DatabaseDialect {
    public static final H2Dialect INSTANCE = new H2Dialect();

    protected H2Dialect() {
        super(H2Model.META_MODEL, new TypeHelper.H2TypeHelper(), new KeywordHelper.H2Keywords(), H2Model.CASING);
    }

    @Override
    public boolean supportsColumnCommentsInTableDefinition() {
        return false;
    }

    @NotNull
    public DatabaseFamilyId getFamilyId() {
        DatabaseFamilyId databaseFamilyId = DatabaseFamilyId.H2;
        if (databaseFamilyId == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "getFamilyId"));
        }
        return databaseFamilyId;
    }

    @NotNull
    public Icon getIcon() {
        Icon icon = AllIcons.Providers.H2;
        if (icon == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "getIcon"));
        }
        return icon;
    }

    @NotNull
    public String getDisplayName() {
        if ("H2" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "getDisplayName"));
        }
        return "H2";
    }

    public boolean supportsProduct(@Nullable String databaseProductName, @NotNull String databaseProductVersion) {
        if (databaseProductVersion == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "databaseProductVersion", "com/intellij/database/dialects/H2Dialect", "supportsProduct"));
        }
        if (databaseProductName == null) {
            return false;
        }
        return databaseProductName.trim().startsWith("H2");
    }

    public boolean supportsColumnComment() {
        return true;
    }

    @Override
    public boolean supportsTableComment() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropTable(@NotNull DdlBuilder builder, @NotNull DasTable table, boolean cascadeConstraints, boolean isMaterializedView, @NotNull DasModel model) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlDropTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/H2Dialect", "sqlDropTable"));
        }
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/database/dialects/H2Dialect", "sqlDropTable"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getTableDropSQL(builder, table, true, cascadeConstraints, false, "CASCADE", false);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlDropTable"));
        }
        return ddlBuilder;
    }

    @Override
    @Nullable
    public SearchPath tryToLoadSearchPath(@NotNull Connection connection) throws SQLException {
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/dialects/H2Dialect", "tryToLoadSearchPath"));
        }
        String s = DbImplUtil.concatStringResults(connection, this, "select schema()", 1, DbImplUtil.ConcatenationProps.NO_CONCAT);
        return SearchPath.of(new ObjectPath(ObjectKind.SCHEMA, Arrays.asList("", s)));
    }

    @Override
    public String sqlSetSearchPath(@NotNull SearchPath path) {
        if (path == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/dialects/H2Dialect", "sqlSetSearchPath"));
        }
        ObjectPath current = path.getCurrent();
        if (current.kind != ObjectKind.SCHEMA) {
            return null;
        }
        return String.format("set schema %s", this.quoteIdentifier(current.getName(), false, false));
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddPrimaryKey(@NotNull DdlBuilder builder, @NotNull DasTableKey pk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAddPrimaryKey"));
        }
        if (pk == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "pk", "com/intellij/database/dialects/H2Dialect", "sqlAddPrimaryKey"));
        }
        for (DasTypedObject column : pk.getColumnsRef().resolveObjects()) {
            if (column.isNotNull()) continue;
            DialectUtils.getColumnNullableAlterSQL(builder, column, false, "ALTER COLUMN", true);
            builder.newStatement();
        }
        builder.keywords("ALTER", "TABLE").space();
        DasTable table = pk.getTable();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("ADD").space();
        String pkName = pk.getName();
        if (StringUtil.isNotEmpty((String)pkName) && !"PRIMARY".equalsIgnoreCase(pkName)) {
            builder.keyword("CONSTRAINT").space().constraintRef((DasObject)pk).space();
        }
        builder.keywords("PRIMARY", "KEY").space();
        DialectUtils.columnList(builder, (MultiRef<? extends DasTypedObject>)pk.getColumnsRef());
        builder.newStatement();
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAddPrimaryKey"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnComment(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnComment"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnComment"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getColumnCommentAlterSQL(builder, column, this.isCommentDroppedByNull());
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnComment"));
        }
        return ddlBuilder;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnTypeNullabilityDefault(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnTypeNullabilityDefault"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnTypeNullabilityDefault"));
        }
        DialectUtils.getColumnTypeAlterSQL(builder, "ALTER COLUMN", "", false, column);
        DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        DialectUtils.addNullabilityClause(builder, column, false);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnTypeNullabilityDefault"));
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnNull() {
        return true;
    }

    public boolean supportsRenameColumn() {
        return true;
    }

    @NotNull
    public DdlBuilder sqlAlterColumnName(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull String toName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnName"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnName"));
        }
        if (toName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "toName", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnName"));
        }
        String alterClause = "ALTER COLUMN";
        String renameToClause = "RENAME TO";
        DdlBuilder ddlBuilder = DialectUtils.getColumnNameAlterSQL(builder, from, toName, alterClause, renameToClause);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnName"));
        }
        return ddlBuilder;
    }

    public boolean supportsAlterColumnType() {
        return true;
    }

    public boolean supportsAlterColumnDefault() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterColumnDefinition(@NotNull DdlBuilder builder, @NotNull DasColumn from, @NotNull DasColumn to, boolean forceOutput) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnDefinition"));
        }
        if (from == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "from", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnDefinition"));
        }
        if (to == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "to", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnDefinition"));
        }
        int before = builder.getStatements().size();
        if (!H2Dialect.isSameName(from, to)) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        if (!(this.isSameType(from, to) && H2Dialect.isSameNullability(from, to) && H2Dialect.isSameDefault(from, to))) {
            this.sqlAlterColumnTypeNullabilityDefault(builder, to).newStatement();
        }
        if (!H2Dialect.isSameComment(from, to)) {
            this.sqlAlterColumnComment(builder, to).newStatement();
        }
        if (!H2Dialect.isSameAutoInc(from, to)) {
            this.sqlAddColumnAutoIncrement(builder, to).newStatement();
        }
        if (builder.getStatements().size() == before && forceOutput) {
            this.sqlAlterColumnName(builder, from, to.getName()).newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAlterColumnDefinition"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column) throws UnsupportedOperationException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlDropColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/H2Dialect", "sqlDropColumn"));
        }
        DasTable table = column.getTable();
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table).space();
        builder.keyword("DROP").space();
        builder.columnRef((DasObject)column);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlDropColumn"));
        }
        return ddlBuilder;
    }

    public String[] getIndexAccessMethodsTypes() {
        return new String[]{"DEFAULT", "HASH"};
    }

    public String[] getIndexStorageOptions() {
        return null;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumnAutoIncrement(@NotNull DdlBuilder builder, @NotNull DasColumn column) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAddColumnAutoIncrement"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/H2Dialect", "sqlAddColumnAutoIncrement"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)column.getTable());
        builder.space().keywords("ALTER", "COLUMN").space();
        builder.columnRef((DasObject)column).space();
        builder.keyword("IDENTITY");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAddColumnAutoIncrement"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, @NotNull Set<DasColumn.Attribute> attrs) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAddColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/H2Dialect", "sqlAddColumn"));
        }
        if (attrs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "attrs", "com/intellij/database/dialects/H2Dialect", "sqlAddColumn"));
        }
        DialectUtils.getAddColumnSQL(builder, column, true, true, true);
        if (DasUtil.isAutoVal((DasColumn)column)) {
            builder.space().keyword("AUTO_INCREMENT");
        }
        builder.newStatement();
        if (StringUtil.isNotEmpty((String)column.getComment())) {
            this.sqlAlterColumnComment(builder, column);
            builder.newStatement();
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAddColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddForeignKey(@NotNull DdlBuilder builder, @NotNull DasForeignKey keyInfo, boolean matchFull, boolean autoFKIndex) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAddForeignKey"));
        }
        if (keyInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "keyInfo", "com/intellij/database/dialects/H2Dialect", "sqlAddForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getAddForeignKeyConstraintSQL(builder, keyInfo, false, autoFKIndex, this);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAddForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineForeignKey(@NotNull DdlBuilder builder, DasForeignKey info, boolean matchFull) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlDefineForeignKey"));
        }
        DdlBuilder ddlBuilder = DialectUtils.foreignKeyTail(builder, info, DasForeignKey.Deferrability.NOT_DEFERRABLE, false, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlDefineForeignKey"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDefineColumn(@NotNull DdlBuilder builder, @NotNull DasColumn column, boolean singlePk) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlDefineColumn"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/dialects/H2Dialect", "sqlDefineColumn"));
        }
        builder.columnRef((DasObject)column);
        builder.space();
        builder.type((DasTypedObject)column);
        if (DasUtil.isAutoVal((DasColumn)column)) {
            builder.space().keyword("AUTO_INCREMENT");
        }
        if (singlePk) {
            builder.space().keywords("PRIMARY", "KEY");
        } else {
            DialectUtils.addDefaultClauseIfNeeded(builder, column, "DEFAULT");
        }
        if (column.isNotNull()) {
            builder.space().keywords("NOT", "NULL");
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlDefineColumn"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAddUniqueConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName, @NotNull List<DasColumn> columns) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAddUniqueConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/H2Dialect", "sqlAddUniqueConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/H2Dialect", "sqlAddUniqueConstraint"));
        }
        if (columns == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "columns", "com/intellij/database/dialects/H2Dialect", "sqlAddUniqueConstraint"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table);
        builder.space().keywords("ADD", "CONSTRAINT").space();
        builder.constraintRef(constraint, constraintName).space();
        builder.keyword("UNIQUE").space();
        builder.symbol("(");
        DialectUtils.appendColumnList(builder, columns);
        builder.symbol(")");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAddUniqueConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlAlterSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String restart, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlAlterSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/H2Dialect", "sqlAlterSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/H2Dialect", "sqlAlterSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/H2Dialect", "sqlAlterSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/H2Dialect", "sqlAlterSequence"));
        }
        if (restart == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "restart", "com/intellij/database/dialects/H2Dialect", "sqlAlterSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/H2Dialect", "sqlAlterSequence"));
        }
        DdlBuilder ddlBuilder = DialectUtils.alterSequenceSQL(builder, sequence, increment, restart);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlAlterSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateIndex(@NotNull DdlBuilder builder, @NotNull DasIndex index, @NotNull String accessMethod, @NotNull String tablespace, @NotNull String constraints) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlCreateIndex"));
        }
        if (index == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "index", "com/intellij/database/dialects/H2Dialect", "sqlCreateIndex"));
        }
        if (accessMethod == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "accessMethod", "com/intellij/database/dialects/H2Dialect", "sqlCreateIndex"));
        }
        if (tablespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tablespace", "com/intellij/database/dialects/H2Dialect", "sqlCreateIndex"));
        }
        if (constraints == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraints", "com/intellij/database/dialects/H2Dialect", "sqlCreateIndex"));
        }
        DdlBuilder ddlBuilder = DialectUtils.createIndex(builder, index, accessMethod);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlCreateIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, @NotNull String increment, @NotNull String minimum, @NotNull String maximum, @NotNull String start, @NotNull String cache, boolean cycle) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlCreateSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/H2Dialect", "sqlCreateSequence"));
        }
        if (increment == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "increment", "com/intellij/database/dialects/H2Dialect", "sqlCreateSequence"));
        }
        if (minimum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "minimum", "com/intellij/database/dialects/H2Dialect", "sqlCreateSequence"));
        }
        if (maximum == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "maximum", "com/intellij/database/dialects/H2Dialect", "sqlCreateSequence"));
        }
        if (start == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "start", "com/intellij/database/dialects/H2Dialect", "sqlCreateSequence"));
        }
        if (cache == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "cache", "com/intellij/database/dialects/H2Dialect", "sqlCreateSequence"));
        }
        builder.keywords("CREATE", "SEQUENCE").space();
        builder.qualifiedRef((DasObject)sequence);
        if (StringUtil.isNotEmpty((String)start)) {
            builder.space().keywords("START", "WITH").space().literal(start);
        }
        if (StringUtil.isNotEmpty((String)increment)) {
            builder.space().keywords("INCREMENT", "BY").space().literal(increment);
        }
        if (StringUtil.isNotEmpty((String)cache)) {
            builder.space().keyword("CACHE").space().literal(cache);
        }
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlCreateSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlCreateView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String definition, @NotNull String checkOption) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlCreateView"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/H2Dialect", "sqlCreateView"));
        }
        if (definition == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "definition", "com/intellij/database/dialects/H2Dialect", "sqlCreateView"));
        }
        if (checkOption == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "checkOption", "com/intellij/database/dialects/H2Dialect", "sqlCreateView"));
        }
        DdlBuilder ddlBuilder = DialectUtils.getCreateViewWithCheckOptionSQL(builder, view, definition, "");
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlCreateView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropConstraint(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasObject constraint, @NotNull String constraintName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlDropConstraint"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/H2Dialect", "sqlDropConstraint"));
        }
        if (constraintName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "constraintName", "com/intellij/database/dialects/H2Dialect", "sqlDropConstraint"));
        }
        DdlBuilder.Marker m = builder.mark();
        DialectUtils.getDropConstraintSQL(builder, table, constraint, constraintName);
        m.replace(DialectUtils.stripQuotesFromIdentifier(this, constraintName, m.extract()));
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlDropConstraint"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropIndex(@NotNull DdlBuilder builder, @NotNull DasTable table, @Nullable DasIndex index, @NotNull String indexName, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlDropIndex"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/H2Dialect", "sqlDropIndex"));
        }
        if (indexName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indexName", "com/intellij/database/dialects/H2Dialect", "sqlDropIndex"));
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)table);
        builder.keywords("DROP", "INDEX").space().identifier(schema, DasUtil.getName((DasObject)schema)).literal(".").identifier((DasObject)index, indexName);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlDropIndex"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropSequence(@NotNull DdlBuilder builder, @NotNull DasTable sequence, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlDropSequence"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/H2Dialect", "sqlDropSequence"));
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "SEQUENCE").space().qualifiedRef((DasObject)sequence);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlDropSequence"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlDropView(@NotNull DdlBuilder builder, @NotNull DasTable view, boolean cascade) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlDropView"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/H2Dialect", "sqlDropView"));
        }
        DdlBuilder ddlBuilder = builder.keywords("DROP", "VIEW").space().qualifiedRef((DasObject)view);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlDropView"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameTable(@NotNull DdlBuilder builder, @NotNull DasTable table, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlRenameTable"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/dialects/H2Dialect", "sqlRenameTable"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/H2Dialect", "sqlRenameTable"));
        }
        builder.keywords("ALTER", "TABLE").space();
        builder.qualifiedRef((DasObject)table).space();
        builder.keywords("RENAME", "TO").space();
        builder.newName(newName, (DasObject)table);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlRenameTable"));
        }
        return ddlBuilder;
    }

    @Override
    @NotNull
    public DdlBuilder sqlRenameView(@NotNull DdlBuilder builder, @NotNull DasTable view, @NotNull String newName) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlRenameView"));
        }
        if (view == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "view", "com/intellij/database/dialects/H2Dialect", "sqlRenameView"));
        }
        if (newName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newName", "com/intellij/database/dialects/H2Dialect", "sqlRenameView"));
        }
        throw new UnsupportedOperationException(DatabaseMessages.message((String)"ddl.error.rename.view", (Object[])new Object[]{this.getDisplayName()}));
    }

    @Override
    @NotNull
    public DdlBuilder sqlSequenceInformation(@NotNull DdlBuilder builder, @NotNull DasTable sequence) {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlSequenceInformation"));
        }
        if (sequence == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sequence", "com/intellij/database/dialects/H2Dialect", "sqlSequenceInformation"));
        }
        builder.keyword("SELECT").space();
        builder.ref(null, "CURRENT_VALUE").symbol(",").space();
        builder.literal("'NONE'").symbol(",").space();
        builder.literal("'NONE'").symbol(",").space();
        builder.ref(null, "CACHE").symbol(",").space();
        builder.ref(null, "INCREMENT").symbol(",").space();
        builder.literal("0").space();
        builder.keyword("FROM").space().ref(null, "INFORMATION_SCHEMA.SEQUENCES").space();
        builder.keyword("WHERE").space().ref(null, "SEQUENCE_SCHEMA").space().symbol("=").space().literal("'" + DasUtil.getSchema((DasObject)sequence) + "'").space().keyword("AND").space().ref(null, "SEQUENCE_NAME").space().symbol("=").space().literal("'" + sequence.getName() + "'").space().keyword("AND").space().ref(null, "SEQUENCE_CATALOG").space().symbol("=").space().literal("'" + DasUtil.getCatalog((DasObject)sequence) + "'");
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlSequenceInformation"));
        }
        return ddlBuilder;
    }

    public boolean supportsAccessMethods() {
        return true;
    }

    public boolean supportsAddForeignKey() {
        return true;
    }

    public boolean supportsAddUniqueConstraint() {
        return true;
    }

    public boolean supportsAlterSequence() {
        return true;
    }

    @Override
    public boolean supportsAutoIncrement() {
        return true;
    }

    public boolean supportsCheckOptionsForViews() {
        return false;
    }

    public boolean supportsCreateIndex() {
        return true;
    }

    public boolean supportsCreateSequence() {
        return true;
    }

    @Override
    public boolean supportsCreateTable() {
        return true;
    }

    public boolean supportsCreateView() {
        return true;
    }

    public boolean supportsDropConstraint() {
        return true;
    }

    public boolean supportsDropIndex() {
        return true;
    }

    public boolean supportsDropSequence() {
        return true;
    }

    public boolean supportsDropView() {
        return true;
    }

    public boolean supportsEmptyTables() {
        return true;
    }

    public boolean supportsIndexes() {
        return true;
    }

    @Override
    public boolean supportsInsertInto() {
        return true;
    }

    @Override
    public boolean supportsRenameRoutine() {
        return false;
    }

    public boolean supportsMultipleRowInserts() {
        return true;
    }

    public boolean supportsRenameTable() {
        return true;
    }

    public boolean supportsRenameView() {
        return false;
    }

    public boolean supportsSequence() {
        return true;
    }

    public boolean supportsSequenceInformation() {
        return true;
    }

    public boolean supportsTablespace() {
        return false;
    }

    public boolean supportsAddColumn() {
        return true;
    }

    public boolean supportsViewDefinition() {
        return true;
    }

    public boolean supportsCommonTableExpression() {
        return false;
    }

    @Override
    public Pair<String, DbImplUtil.ConcatenationProps> sqlViewDefinition(@NotNull DasObject element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/H2Dialect", "sqlViewDefinition"));
        }
        String templateStr = "select view_definition from information_schema.views where table_schema = ''{0}'' and UPPER(table_name) = UPPER(''{1}'') ";
        return Pair.create((Object)MessageFormat.format(templateStr, DasUtil.getSchema((DasObject)element), element.getName()), (Object)DbImplUtil.ConcatenationProps.NO_CONCAT);
    }

    public boolean supportsProcedureDefinition() {
        return false;
    }

    @Override
    @NotNull
    public Pair<String, DbImplUtil.ConcatenationProps> sqlProcedureDefinition(@NotNull DasRoutine element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/dialects/H2Dialect", "sqlProcedureDefinition"));
        }
        throw new UnsupportedOperationException("Not supported");
    }

    @Override
    @NotNull
    protected DatabaseEditorCapabilities.ForeignKeyEditorCaps getForeignKeyEditorCaps(boolean existing) {
        boolean fkRecreateable = this.supportsAddForeignKey() && this.supportsDropForeignKey();
        DatabaseEditorCapabilities.ForeignKeyEditorCaps foreignKeyEditorCaps = new DatabaseEditorCapabilities.ForeignKeyEditorCaps(DatabaseEditorCapabilities.Capability.available(!existing || fkRecreateable), DatabaseEditorCapabilities.Capability.UNAVAILABLE, DatabaseEditorCapabilities.ValuesCapability.unsupported(DasForeignKey.Deferrability.class), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()), DatabaseEditorCapabilities.ValuesCapability.supported(!existing || fkRecreateable, DasForeignKey.RuleAction.values()));
        if (foreignKeyEditorCaps == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "getForeignKeyEditorCaps"));
        }
        return foreignKeyEditorCaps;
    }

    @Override
    public boolean isValidPlainIdentifier(@NotNull String identifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/H2Dialect", "isValidPlainIdentifier"));
        }
        char c0 = identifier.charAt(0);
        if (c0 != '_' && !Character.isLetter(c0)) {
            return false;
        }
        int len = identifier.length();
        for (int i = 1; i < len; ++i) {
            char c = identifier.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '$') continue;
            return false;
        }
        return super.isValidPlainIdentifier(identifier);
    }

    @Override
    @NotNull
    public DdlBuilder qualifiedIdentifier(DdlBuilder builder, @NotNull String identifier, @Nullable DasObject object, @NotNull DasObject qualifier) {
        if (identifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "identifier", "com/intellij/database/dialects/H2Dialect", "qualifiedIdentifier"));
        }
        if (qualifier == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "qualifier", "com/intellij/database/dialects/H2Dialect", "qualifiedIdentifier"));
        }
        DasObject schema = DasUtil.getSchemaObject((DasObject)qualifier);
        DdlBuilder ddlBuilder = builder.qualifiedRef(object, identifier, schema, DasUtil.getName((DasObject)schema), null, null, null, null);
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "qualifiedIdentifier"));
        }
        return ddlBuilder;
    }

    public boolean supportsCorrelatedSubQuery() {
        return true;
    }

    @Override
    @NotNull
    public DdlBuilder sqlExplainPlan(@NotNull DdlBuilder builder, @NotNull String statement, boolean analyze) throws UnsupportedOperationException, IllegalArgumentException {
        if (builder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "builder", "com/intellij/database/dialects/H2Dialect", "sqlExplainPlan"));
        }
        if (statement == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "statement", "com/intellij/database/dialects/H2Dialect", "sqlExplainPlan"));
        }
        builder.keyword("explain").space();
        if (analyze) {
            builder.keyword("analyze").space();
        }
        builder.plain(statement);
        DdlBuilder ddlBuilder = builder;
        if (ddlBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/dialects/H2Dialect", "sqlExplainPlan"));
        }
        return ddlBuilder;
    }
}

