/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.google.common.base.Function;
import com.google.common.collect.Iterables;
import com.intellij.database.access.ConnectionProvider;
import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.dataSource.LocalDataSource;
import com.intellij.database.dialects.DatabaseDialectEx;
import com.intellij.database.dialects.GenericDialect;
import com.intellij.database.model.CasingProvider;
import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasColumn;
import com.intellij.database.model.DasConstraint;
import com.intellij.database.model.DasForeignKey;
import com.intellij.database.model.DasIndex;
import com.intellij.database.model.DasModel;
import com.intellij.database.model.DasNamespace;
import com.intellij.database.model.DasObject;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.DasSchemaChild;
import com.intellij.database.model.DasSynonym;
import com.intellij.database.model.DasTable;
import com.intellij.database.model.DasTableChild;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.model.DasUserDefinedType;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.model.PsiObject;
import com.intellij.database.model.RawConnectionConfig;
import com.intellij.database.psi.DbColumnImpl;
import com.intellij.database.psi.DbCustomTypeImpl;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.psi.DbElement;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbForeignKeyImpl;
import com.intellij.database.psi.DbIndexImpl;
import com.intellij.database.psi.DbNamespaceImpl;
import com.intellij.database.psi.DbPackageImpl;
import com.intellij.database.psi.DbPsiManager;
import com.intellij.database.psi.DbPsiManagerSpi;
import com.intellij.database.psi.DbRoutineImpl;
import com.intellij.database.psi.DbSchemaChildImpl;
import com.intellij.database.psi.DbSynonymImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTableImpl;
import com.intellij.database.psi.DbTableKeyImpl;
import com.intellij.database.psi.DbTableTypeImpl;
import com.intellij.database.psi.DbTriggerImpl;
import com.intellij.database.util.Casing;
import com.intellij.database.util.CharOut;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.DbImplUtil;
import com.intellij.database.util.QNameUtil;
import com.intellij.database.vfs.DatabaseElementVirtualFileImpl;
import com.intellij.dbm.common.DbmModel;
import com.intellij.lang.Language;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ClearableLazyValue;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.RenameableFakePsiElement;
import com.intellij.sql.database.SqlDataSource;
import com.intellij.sql.psi.SqlDefinition;
import com.intellij.sql.psi.SqlFile;
import com.intellij.sql.psi.SqlLanguage;
import com.intellij.sql.psi.SqlNameElement;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.containers.TreeTraversal;
import gnu.trove.TLongHashSet;
import gnu.trove.TLongObjectHashMap;
import gnu.trove.TLongObjectProcedure;
import gnu.trove.TObjectHashingStrategy;
import gnu.trove.TObjectLongHashMap;
import gnu.trove.TObjectLongProcedure;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.regex.Pattern;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbDataSourceImpl
extends DbElementImpl<DatabaseSystem, DbElement>
implements DbDataSource {
    protected static final Pattern DOC_PATTERN = Pattern.compile("(?m)(^[^:]+:)");
    protected static final Pattern NEW_LINE = Pattern.compile("\n");
    @NotNull
    private final Project myProject;
    @NotNull
    private final DbPsiManagerSpi myManager;
    @NotNull
    private final ClearableLazyValue<DatabaseDialectEx> myDialect;
    private final ReadWriteLock myStateLock;
    private final AtomicLong myIdCounter;
    private final TObjectLongHashMap<String> string2Id;
    private final TObjectLongHashMap<DasObject> model2Id;
    private final TLongObjectHashMap<DbElement> id2Psi;
    private volatile State myState;
    private boolean myStateRecursionGuard;

    public DbDataSourceImpl(@NotNull Project project, @NotNull DatabaseSystem dataSourceInfo, @NotNull DbPsiManagerSpi managerSpi) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/database/psi/DbDataSourceImpl", "<init>"));
        }
        if (dataSourceInfo == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "dataSourceInfo", "com/intellij/database/psi/DbDataSourceImpl", "<init>"));
        }
        if (managerSpi == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "managerSpi", "com/intellij/database/psi/DbDataSourceImpl", "<init>"));
        }
        super(null, dataSourceInfo);
        this.myDialect = new ClearableLazyValue<DatabaseDialectEx>(){

            @NotNull
            protected DatabaseDialectEx compute() {
                DatabaseDialectEx databaseDialectEx = DbDataSourceImpl.this.calcDialect();
                if (databaseDialectEx == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$1", "compute"));
                }
                return databaseDialectEx;
            }
        };
        this.myStateLock = new ReentrantReadWriteLock();
        this.myIdCounter = new AtomicLong();
        this.string2Id = new TObjectLongHashMap(4, 0.98f);
        this.model2Id = new TObjectLongHashMap(4, 0.98f, TObjectHashingStrategy.IDENTITY);
        this.id2Psi = new TLongObjectHashMap(4, 0.98f);
        this.myProject = project;
        this.myManager = managerSpi;
    }

    @Override
    public boolean isValid() {
        if (this.getProject().isDisposed()) {
            return false;
        }
        return this.myManager.isDataSourceElementValid(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        State state = this.myState;
        if (state == null) {
            return;
        }
        this.myStateLock.writeLock().lock();
        try {
            this.myState = null;
            for (DbNamespaceImpl ns : DbDataSourceImpl.findChildrenImpl(this, DbNamespaceImpl.class, state)) {
                ns.getDelegates().clear();
            }
        }
        finally {
            this.myStateLock.writeLock().unlock();
        }
    }

    @NotNull
    public DbPsiManager getDbManager() {
        DbPsiManagerSpi dbPsiManagerSpi = this.myManager;
        if (dbPsiManagerSpi == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getDbManager"));
        }
        return dbPsiManagerSpi;
    }

    @Override
    @NotNull
    public DbDataSourceImpl getDataSource() {
        DbDataSourceImpl dbDataSourceImpl = this;
        if (dbDataSourceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getDataSource"));
        }
        return dbDataSourceImpl;
    }

    @Override
    @Nullable
    public String getComment() {
        return ((DatabaseSystem)this.myDelegate).getComment();
    }

    @Override
    @NotNull
    public String getTypeName() {
        if ("data source" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getTypeName"));
        }
        return "data source";
    }

    @Override
    @NotNull
    public Language getLanguage() {
        SqlLanguage sqlLanguage = SqlLanguage.INSTANCE;
        if (sqlLanguage == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getLanguage"));
        }
        return sqlLanguage;
    }

    @Override
    @NotNull
    public String getName() {
        String string = ((DatabaseSystem)this.myDelegate).getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getName"));
        }
        return string;
    }

    @Override
    public PsiElement setName(@NonNls @NotNull String name) throws IncorrectOperationException {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/psi/DbDataSourceImpl", "setName"));
        }
        this.myManager.setDataSourceName(this, name);
        return this;
    }

    public String getUniqueId() {
        return ((DatabaseSystem)this.myDelegate).getUniqueId();
    }

    public String getDatabaseProductName() {
        return ((DatabaseSystem)this.myDelegate).getDatabaseProductName();
    }

    public String getDatabaseProductVersion() {
        return ((DatabaseSystem)this.myDelegate).getDatabaseProductVersion();
    }

    @Override
    @NotNull
    public ObjectKind getKind() {
        ObjectKind objectKind = ObjectKind.NONE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getKind"));
        }
        return objectKind;
    }

    @Override
    @Nullable
    public Icon getIcon(boolean open) {
        return this.myDelegate instanceof Iconable ? ((Iconable)this.myDelegate).getIcon(0) : super.getIcon(open);
    }

    public PsiFile getContainingFile() {
        return null;
    }

    @Override
    @NotNull
    public Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getProject"));
        }
        return project;
    }

    @Nullable
    public RawConnectionConfig getConnectionConfig() {
        return ((DatabaseSystem)this.myDelegate).getConnectionConfig();
    }

    @NotNull
    public DatabaseDialectEx getDatabaseDialect() {
        this.checkValid();
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)this.myDialect.getValue();
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getDatabaseDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    private DatabaseDialectEx calcDialect() {
        DatabaseDialectEx databaseDialectEx = (DatabaseDialectEx)ObjectUtils.notNull((Object)this.myManager.getDatabaseDialect(this), (Object)GenericDialect.INSTANCE);
        if (databaseDialectEx == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "calcDialect"));
        }
        return databaseDialectEx;
    }

    @NotNull
    public DasModel getModel() {
        DasModel delegateModel;
        this.checkValid();
        DatabaseSystem delegate = (DatabaseSystem)this.getDelegate();
        DasModel dasModel = delegateModel = delegate == null ? DasUtil.emptyModel() : delegate.getModel();
        if (delegateModel == DasUtil.emptyModel()) {
            DasModel dasModel2 = delegateModel;
            if (dasModel2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getModel"));
            }
            return dasModel2;
        }
        State state = this.getStateSafe();
        if (state == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getModel"));
        }
        return state;
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        StringBuilder sb = super.getDocumentation();
        DatabaseDialectEx dialect = this.getDatabaseDialect();
        sb.append("<b>Dialect:</b> ").append(dialect.getDisplayName()).append("<br>");
        if (this.myDelegate instanceof LocalDataSource) {
            if (!StringUtil.isEmpty((String)this.getDatabaseProductName())) {
                sb.append("<br>").append("<!-- async-doc-cut -->");
                sb.append(DbDataSourceImpl.boldAndNewLine(DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)((Object)this.myDelegate)))).append("<br>");
            }
        } else {
            DasObject first = (DasObject)((DatabaseSystem)this.myDelegate).getModel().getModelRoots().first();
            sb.append("<br>");
            Casing modes = ((DatabaseSystem)this.myDelegate).getModel().getCasing(ObjectKind.TABLE, first);
            sb.append(MessageFormat.format("<b>Case sensitivity:</b> {0} (quoted: {1})", modes.plain, modes.quoted));
        }
        if (DbImplUtil.canConnectTo(this)) {
            this.scheduleAsyncDocumentationUpdate(sb);
        }
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getDocumentation"));
        }
        return stringBuilder;
    }

    private static String boldAndNewLine(@NotNull String str) {
        if (str == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "str", "com/intellij/database/psi/DbDataSourceImpl", "boldAndNewLine"));
        }
        return NEW_LINE.matcher(DOC_PATTERN.matcher(str).replaceAll("<b>$1</b>")).replaceAll("<br>\n");
    }

    @Override
    protected void loadSlowDocumentationInner(CharOut charOut, ConnectionProvider provider) throws Exception {
        ((LocalDataSource)((Object)this.myDelegate)).refreshDatabaseInfo(provider.getConnection().getMetaData());
        charOut.append(DbDataSourceImpl.boldAndNewLine(DataSourceUiUtil.formatDataSourceInfoString((LocalDataSource)((Object)this.myDelegate))));
    }

    @NotNull
    private State getStateSafe() {
        this.myStateLock.readLock().lock();
        State state = this.getStateWithStateReadLockAcquired();
        State state2 = state;
        if (state2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getStateSafe"));
        }
        return state2;
        finally {
            this.myStateLock.readLock().unlock();
        }
    }

    /*
     * Exception decompiling
     */
    private State getStateWithStateReadLockAcquired() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void compact() {
        this.string2Id.compact();
        this.model2Id.compact();
        this.id2Psi.compact();
    }

    <S extends DasObject> com.intellij.util.Function<S, S> mapper() {
        return s -> this.mapElement(s);
    }

    @Nullable
    <S extends DasObject> DbElement mapElement(@Nullable S s) {
        return s == null ? null : this.findDbElement(s);
    }

    private void populateState(@NotNull State state, DasModel model) {
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/psi/DbDataSourceImpl", "populateState"));
        }
        JBTreeTraverser traverser = model.traverser();
        traverser = (JBTreeTraverser)traverser.expandAndFilter(o -> !(o instanceof DasNamespace) || ((DasNamespace)o).isVisible());
        final TLongHashSet ids = new TLongHashSet();
        for (DasObject o2 : traverser.traverse()) {
            if (o2 instanceof DasArgument) continue;
            long id = this.model2Id.get((Object)o2);
            if (id == 0L) {
                id = this.myIdCounter.incrementAndGet();
                this.model2Id.put((Object)o2, id);
            }
            ids.add(id);
        }
        boolean isWellFormed = model instanceof DbmModel;
        TreeTraversal.TracingIt it = (TreeTraversal.TracingIt)traverser.tracingBfsTraversal().typedIterator();
        while (it.advance()) {
            DbElementImpl element;
            DasObject o3 = (DasObject)it.current();
            if (o3 instanceof DasArgument) continue;
            ObjectKind kind = o3.getKind();
            long id = isWellFormed ? this.model2Id.get((Object)o3) : this.getLegacyObjectId(model, o3, ids, state);
            DbElement existing = (DbElement)this.id2Psi.get(id);
            if (existing != null) {
                state.addElement(existing);
                if (!(existing instanceof DbNamespaceImpl)) continue;
                ((DbNamespaceImpl)existing).addDelegate(o3);
                continue;
            }
            long parentId = isWellFormed ? this.model2Id.get(it.parent()) : this.getLegacyParentId(o3, ids, state);
            DbElement parent = (DbElement)this.id2Psi.get(parentId);
            String name = DbDataSourceImpl.getActualName(model, o3);
            if (kind == ObjectKind.DATABASE || kind == ObjectKind.SCHEMA) {
                element = new DbNamespaceImpl(parent == null ? this : parent, name, kind, o3);
                Object delegate = element.getDelegate();
                if (delegate instanceof String) {
                    id = this.replaceObjectWithKey(o3, ids, id, (String)delegate);
                }
                ((DbNamespaceImpl)element).addDelegate(o3);
            } else {
                element = o3 instanceof DasUserDefinedType ? (o3.getKind() == ObjectKind.TABLE_TYPE ? new DbTableTypeImpl(parent, (DasUserDefinedType)o3) : new DbCustomTypeImpl(parent, (DasUserDefinedType)o3)) : (o3 instanceof DasTable ? new DbTableImpl(parent, (DasTable)o3) : (kind == ObjectKind.COLUMN && o3 instanceof DasColumn ? new DbColumnImpl((DbTable)parent, (DasColumn)o3) : (kind == ObjectKind.KEY && o3 instanceof DasTableKey ? new DbTableKeyImpl((DbTable)parent, (DasTableKey)o3) : (kind == ObjectKind.FOREIGN_KEY && o3 instanceof DasForeignKey ? new DbForeignKeyImpl((DbTable)parent, (DasForeignKey)o3) : (kind == ObjectKind.INDEX && o3 instanceof DasIndex ? new DbIndexImpl((DbTable)parent, (DasIndex)o3) : (kind == ObjectKind.PACKAGE ? new DbPackageImpl(parent, name, o3) : (o3 instanceof DasRoutine ? new DbRoutineImpl(parent, (DasRoutine)o3) : (kind == ObjectKind.TRIGGER && o3 instanceof DasTrigger ? new DbTriggerImpl((DbTable)parent, (DasTrigger)o3) : (o3 instanceof DasSynonym ? new DbSynonymImpl(parent, (DasSynonym)o3) : (o3 instanceof DasSchemaChild ? new DbSchemaChildImpl(parent, (DasSchemaChild)o3) : new DbElementImpl<DasObject, DbElement>(parent, o3)))))))))));
            }
            this.id2Psi.put(id, (Object)element);
            state.addElement(element);
        }
        this.id2Psi.retainEntries((TLongObjectProcedure)new TLongObjectProcedure<DbElement>(){

            public boolean execute(long a, DbElement b) {
                return ids.contains(a);
            }
        });
        this.model2Id.retainEntries((TObjectLongProcedure)new TObjectLongProcedure<DasObject>(){

            public boolean execute(DasObject a, long b) {
                return ids.contains(b);
            }
        });
        if (this.id2Psi.size() != state.classified.values().size()) {
            throw new ProcessCanceledException();
        }
        this.compact();
    }

    @NotNull
    private static String getActualName(DasModel model, DasObject o) {
        if (o == null) {
            String string = DasUtil.NO_NAME;
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getActualName"));
            }
            return string;
        }
        if (o instanceof SqlDefinition && !(o instanceof RenameableFakePsiElement)) {
            SqlNameElement e = ((SqlDefinition)o).getNameElement();
            String string = model.getCasing(o.getKind(), o).choose(e != null && e.isPlainIdentifier()).apply(o.getName());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getActualName"));
            }
            return string;
        }
        String string = o.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getActualName"));
        }
        return string;
    }

    private long getLegacyObjectId(DasModel model, DasObject o, TLongHashSet ids, State state) {
        ObjectKind kind = o.getKind();
        long id = this.model2Id.get((Object)o);
        if (kind == ObjectKind.SCHEMA || kind == ObjectKind.DATABASE) {
            String cat;
            String key;
            boolean isRootKind;
            String oName = DbDataSourceImpl.getActualName(model, o);
            DasObject parent = o.getDbParent();
            boolean isDatabase = kind == ObjectKind.DATABASE;
            boolean hasNoDatabaseParent = isDatabase || parent == null || StringUtil.isEmpty((String)parent.getName()) || parent.getKind() != ObjectKind.DATABASE;
            boolean bl = isRootKind = this.getDatabaseDialect().getMetaModel().getRootKinds().contains((Object)kind) && hasNoDatabaseParent;
            if (isRootKind) {
                cat = key = DbDataSourceImpl.getLegacyKey(isDatabase ? oName : null, oName, isDatabase);
            } else {
                String pName = DbDataSourceImpl.getActualName(model, parent);
                cat = DbDataSourceImpl.getLegacyKey(pName, null, true);
                key = DbDataSourceImpl.getLegacyKey(pName, oName, false);
            }
            id = this.replaceObjectWithKey(o, ids, id, key);
            if (kind == ObjectKind.SCHEMA && !isRootKind) {
                DbElement element;
                long catId = this.string2Id.get((Object)cat);
                if (catId == 0L) {
                    catId = this.myIdCounter.incrementAndGet();
                    this.string2Id.put((Object)cat, catId);
                }
                if ((element = (DbElement)this.id2Psi.get(catId)) == null) {
                    String pName = DbDataSourceImpl.getActualName(model, parent);
                    element = new DbNamespaceImpl(this, pName, ObjectKind.DATABASE, cat);
                    this.id2Psi.put(catId, (Object)element);
                }
                if (ids.add(catId)) {
                    state.addElement(element);
                }
            }
        }
        return id;
    }

    private long replaceObjectWithKey(DasObject o, TLongHashSet ids, long id, String key) {
        long stringId = this.string2Id.get((Object)key);
        if (stringId == 0L) {
            this.string2Id.put((Object)key, id);
        } else if (id != stringId) {
            this.model2Id.put((Object)o, stringId);
            ids.remove(id);
            ids.add(stringId);
            id = stringId;
        }
        return id;
    }

    private long getLegacyParentId(@NotNull DasObject o, @NotNull TLongHashSet ids, @NotNull State state) {
        String packageKey;
        boolean packagedRoutine;
        if (o == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "o", "com/intellij/database/psi/DbDataSourceImpl", "getLegacyParentId"));
        }
        if (ids == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "ids", "com/intellij/database/psi/DbDataSourceImpl", "getLegacyParentId"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "state", "com/intellij/database/psi/DbDataSourceImpl", "getLegacyParentId"));
        }
        boolean bl = packagedRoutine = o instanceof DasRoutine && !(o instanceof PsiElement) && !StringUtil.isEmpty((String)((DasRoutine)o).getPackage());
        if (!packagedRoutine) {
            long feelLucky;
            DasObject parent = o.getDbParent();
            long l = feelLucky = parent == null ? 0L : this.model2Id.get((Object)parent);
            if (feelLucky != 0L) {
                return feelLucky;
            }
        }
        String schemaKey = DbDataSourceImpl.getLegacyKey(DasUtil.getCatalog((DasObject)o), DasUtil.getSchema((DasObject)o), false);
        if (packagedRoutine) {
            DbElement element;
            String packageName = ((DasRoutine)o).getPackage();
            packageKey = schemaKey + ";" + DbDataSourceImpl.encode(ObjectKind.PACKAGE, packageName);
            long stringId = this.string2Id.get((Object)packageKey);
            if (stringId == 0L) {
                stringId = this.myIdCounter.incrementAndGet();
                this.string2Id.put((Object)packageKey, stringId);
            }
            if ((element = (DbElement)this.id2Psi.get(stringId)) == null) {
                element = new DbPackageImpl((DbElement)this.id2Psi.get(this.string2Id.get((Object)schemaKey)), packageName, packageKey);
                this.id2Psi.put(stringId, (Object)element);
            }
            if (ids.add(stringId)) {
                state.addElement(element);
            }
        } else {
            packageKey = null;
        }
        long parentId = o.getKind() == ObjectKind.SCHEMA ? this.string2Id.get((Object)DbDataSourceImpl.getLegacyKey(DasUtil.getCatalog((DasObject)o), null, true)) : (o instanceof DasRoutine ? this.string2Id.get((Object)(packageKey != null ? packageKey : schemaKey)) : (o instanceof DasSchemaChild ? this.string2Id.get((Object)schemaKey) : (o instanceof DasTableChild ? this.model2Id.get((Object)((DasTableChild)o).getTable()) : -1L)));
        return parentId;
    }

    @NotNull
    private static String getLegacyKey(String catalog, String schema, boolean ignoreSchema) {
        String string = DbDataSourceImpl.encode(ObjectKind.DATABASE, catalog) + (ignoreSchema ? "" : ";" + DbDataSourceImpl.encode(ObjectKind.SCHEMA, schema));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getLegacyKey"));
        }
        return string;
    }

    @NotNull
    static String getNamespaceKey(String name, ObjectKind kind, DbElement parent) {
        String string = StringUtil.join((Iterable)DasUtil.dasParents((DasObject)parent).transform(object -> DbDataSourceImpl.encode(object.getKind(), object.getName())).append((Object)DbDataSourceImpl.encode(kind, name)), (String)";");
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "getNamespaceKey"));
        }
        return string;
    }

    private static String encode(ObjectKind kind, String name) {
        return StringUtil.toLowerCase((char)kind.name().charAt(0)) + ":" + StringUtil.notNullize((String)name);
    }

    @Override
    public void navigate(boolean requestFocus) {
        super.navigate(requestFocus);
    }

    @Nullable
    public DbElement findElement(@NotNull String encodedName, @NotNull ObjectKind type) {
        if (encodedName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "encodedName", "com/intellij/database/psi/DbDataSourceImpl", "findElement"));
        }
        if (type == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "type", "com/intellij/database/psi/DbDataSourceImpl", "findElement"));
        }
        this.checkValid();
        return (DbElement)this.getStateSafe().elementMap.get((Object)Pair.create((Object)type, (Object)encodedName));
    }

    public <S> JBIterable<S> findChildren(@NotNull DbElement element, @NotNull Class<? extends S> aClass) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DbDataSourceImpl", "findChildren"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/psi/DbDataSourceImpl", "findChildren"));
        }
        this.checkValid();
        State state = this.getStateSafe();
        return DbDataSourceImpl.findChildrenImpl(element, aClass, state);
    }

    @NotNull
    private static <S> JBIterable<S> findChildrenImpl(final @NotNull DbElement element, final @NotNull Class<? extends S> aClass, final State state) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DbDataSourceImpl", "findChildrenImpl"));
        }
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "aClass", "com/intellij/database/psi/DbDataSourceImpl", "findChildrenImpl"));
        }
        JBIterable jBIterable = JBIterable.from((Iterable)Iterables.concat((Iterable)Iterables.transform((Iterable)state.childrenKeys.get((Object)element), (Function)new Function<Class<?>, Iterable<S>>(){

            public Iterable<S> apply(Class<?> clazz) {
                if (clazz == aClass || aClass.isAssignableFrom(clazz)) {
                    return state.children.get((Object)Pair.create((Object)element, clazz));
                }
                return ContainerUtil.emptyIterable();
            }
        })));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl", "findChildrenImpl"));
        }
        return jBIterable;
    }

    public boolean isValidImpl(DbElement element) {
        PsiElement delegatePsi;
        if (!this.isValid()) {
            return false;
        }
        Object delegate = element.getDelegate();
        PsiElement psiElement = delegatePsi = delegate instanceof PsiElement ? (PsiElement)delegate : null;
        if (delegatePsi != null && !((PsiElement)delegate).isValid()) {
            return false;
        }
        if (delegate == null) {
            return false;
        }
        return this.findDbElement(delegate) == element;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private DbElement findDbElement(@NotNull Object delegate) {
        if (delegate == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/database/psi/DbDataSourceImpl", "findDbElement"));
        }
        this.myStateLock.readLock().lock();
        try {
            this.getStateWithStateReadLockAcquired();
            long id = delegate instanceof DasObject ? this.model2Id.get((Object)((DasObject)delegate)) : this.string2Id.get((Object)((String)delegate));
            DbElement dbElement = (DbElement)this.id2Psi.get(id);
            return dbElement;
        }
        finally {
            this.myStateLock.readLock().unlock();
        }
    }

    private class State
    implements DasModel {
        final long modCount;
        final MultiMap<ObjectKind, DbElement> classified = MultiMap.createOrderedSet();
        final MultiMap<Pair<DbElement, Class<?>>, DbElement> children = MultiMap.createOrderedSet();
        final MultiMap<DbElement, Class<?>> childrenKeys = MultiMap.createOrderedSet();
        final ConcurrentFactoryMap<Pair<ObjectKind, String>, DbElement> elementMap = new ConcurrentFactoryMap<Pair<ObjectKind, String>, DbElement>(){

            @Nullable
            protected DbElement create(Pair<ObjectKind, String> key) {
                return (DbElement)QNameUtil.findByQName(State.this, (String)key.second, DatabaseElementVirtualFileImpl.NAMER).filter(DasUtil.byKind((ObjectKind)((ObjectKind)key.first))).first();
            }
        };

        public State(long count) {
            this.modCount = count;
        }

        void addElement(@NotNull DbElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/database/psi/DbDataSourceImpl$State", "addElement"));
            }
            Pair key = Pair.create((Object)element.getDbParent(), element.getClass());
            this.children.putValue((Object)key, (Object)element);
            this.childrenKeys.putValue(key.first, key.second);
            this.classified.putValue((Object)element.getKind(), (Object)element);
        }

        @NotNull
        public JBIterable<DbElement> getModelRoots() {
            JBIterable jBIterable = DbDataSourceImpl.findChildrenImpl(DbDataSourceImpl.this, DbElement.class, this);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$State", "getModelRoots"));
            }
            return jBIterable;
        }

        @Nullable
        public DasNamespace getCurrentRootNamespace() {
            DasNamespace database = ((DatabaseSystem)DbDataSourceImpl.this.myDelegate).getModel().getCurrentRootNamespace();
            return database == null ? null : (DasNamespace)DbDataSourceImpl.this.findDbElement(database);
        }

        @NotNull
        public Casing getCasing(@NotNull ObjectKind kind, @Nullable DasObject context) {
            SqlFile file;
            DasObject delegate;
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/database/psi/DbDataSourceImpl$State", "getCasing"));
            }
            Object object = delegate = context instanceof DbElement ? ((DbElement)context).getDelegate() : context;
            if (!(delegate instanceof DasObject) && delegate != null) {
                Casing casing = DbDataSourceImpl.this.getDatabaseDialect().getCasing(kind, context);
                if (casing == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$State", "getCasing"));
                }
                return casing;
            }
            PsiObject psiObject = (PsiObject)ObjectUtils.tryCast((Object)delegate, PsiObject.class);
            SqlFile sqlFile = file = psiObject == null ? null : (SqlFile)ObjectUtils.tryCast((Object)psiObject.getContainingFile(), SqlFile.class);
            if (file != null && !(DbDataSourceImpl.this.myDelegate instanceof SqlDataSource)) {
                ArrayList objects = ContainerUtil.newArrayList((Iterable)DasUtil.dasParents((DasObject)psiObject));
                Collections.reverse(objects);
                DasObject deepest = this.findDeepest(objects, (CasingProvider)((DatabaseSystem)DbDataSourceImpl.this.myDelegate).getModel());
                if (deepest != null) {
                    Casing casing = ((DatabaseSystem)DbDataSourceImpl.this.myDelegate).getModel().getCasing(kind, deepest);
                    if (casing == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$State", "getCasing"));
                    }
                    return casing;
                }
            }
            Casing casing = ((DatabaseSystem)DbDataSourceImpl.this.myDelegate).getModel().getCasing(kind, delegate);
            if (casing == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$State", "getCasing"));
            }
            return casing;
        }

        @Nullable
        private DasObject findDeepest(@NotNull List<DasObject> path, @NotNull CasingProvider provider) {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "path", "com/intellij/database/psi/DbDataSourceImpl$State", "findDeepest"));
            }
            if (provider == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/psi/DbDataSourceImpl$State", "findDeepest"));
            }
            JBIterable current = JBIterable.empty();
            JBIterable next = this.getModelRoots().filter(DasObject.class);
            for (DasObject item : path) {
                JBIterable newCur = next.filter(object -> {
                    if (provider == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "provider", "com/intellij/database/psi/DbDataSourceImpl$State", "lambda$findDeepest$0"));
                    }
                    return object.getKind() == item.getKind() && DasUtil.nameEqual((DasObject)object, (String)item.getName(), (CasingProvider)provider);
                });
                if ((next = newCur.flatten(DasUtil.ALL_CHILDREN)).isEmpty()) {
                    return (DasObject)ObjectUtils.chooseNotNull((Object)newCur.first(), (Object)current.first());
                }
                current = newCur;
            }
            return (DasObject)current.first();
        }

        @NotNull
        public JBTreeTraverser<DasObject> traverser() {
            com.intellij.util.Function<DasObject, Iterable<? extends DasObject>> structure = this.TREE_STRUCTURE();
            JBTreeTraverser jBTreeTraverser = (JBTreeTraverser)new JBTreeTraverser(structure).withRoots(this.getModelRoots());
            if (jBTreeTraverser == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$State", "traverser"));
            }
            return jBTreeTraverser;
        }

        @NotNull
        public JBIterable<? extends DasConstraint> getExportedKeys(DasTable table) {
            DasTable t = table instanceof DbTable ? (DasTable)((DbTable)table).getDelegate() : table;
            JBIterable jBIterable = ((DatabaseSystem)DbDataSourceImpl.this.myDelegate).getModel().getExportedKeys(t).transform(DbDataSourceImpl.this.mapper()).filter(DasConstraint.class);
            if (jBIterable == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$State", "getExportedKeys"));
            }
            return jBIterable;
        }

        @NotNull
        private com.intellij.util.Function<DasObject, Iterable<? extends DasObject>> TREE_STRUCTURE() {
            com.intellij.util.Function function = node -> {
                if (node instanceof DbElement) {
                    return DbDataSourceImpl.findChildrenImpl((DbElement)node, DbElement.class, this);
                }
                return Collections.emptyList();
            };
            if (function == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbDataSourceImpl$State", "TREE_STRUCTURE"));
            }
            return function;
        }
    }
}

