/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.psi;

import com.intellij.database.definition.DatabaseDefinitionGenerator;
import com.intellij.database.model.DasTrigger;
import com.intellij.database.psi.DbElementImpl;
import com.intellij.database.psi.DbTable;
import com.intellij.database.psi.DbTrigger;
import com.intellij.database.util.DbSqlUtil;
import com.intellij.database.util.DdlBuilder;
import com.intellij.lang.Language;
import com.intellij.openapi.editor.DefaultLanguageHighlighterColors;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.dialects.SqlLanguageDialect;
import com.intellij.sql.psi.SqlPsiFacade;
import org.jetbrains.annotations.NotNull;

public class DbTriggerImpl
extends DbElementImpl<DasTrigger, DbTable>
implements DbTrigger {
    public DbTriggerImpl(DbTable parent, DasTrigger trigger) {
        super(parent, trigger);
    }

    @Override
    @NotNull
    public StringBuilder getDocumentation() {
        StringBuilder sb = super.getDocumentation();
        DdlBuilder.Colored colored = this.createDocBuilder(sb);
        String remarks = this.getComment();
        if (StringUtil.isNotEmpty((String)remarks)) {
            colored.plain("<br>").plain("-- " + remarks, DefaultLanguageHighlighterColors.LINE_COMMENT);
        }
        sb.append("<br><code><pre>");
        colored.plain(this.getColoredDefinition());
        sb.append("</pre></code><br>");
        StringBuilder stringBuilder = sb;
        if (stringBuilder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbTriggerImpl", "getDocumentation"));
        }
        return stringBuilder;
    }

    @NotNull
    public String getColoredDefinition() {
        SqlLanguageDialect dialect = DbSqlUtil.getSqlDialect(this);
        Project project = this.getProject();
        CharSequence formatted = SqlPsiFacade.getInstance((Project)project).format(project, dialect, (CharSequence)DatabaseDefinitionGenerator.INSTANCE.defineTrigger((DasTrigger)this.getDelegate()));
        String string = DbSqlUtil.sql2Html(project, (Language)dialect, formatted);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbTriggerImpl", "getColoredDefinition"));
        }
        return string;
    }

    public String getTableName() {
        return this.getTable().getName();
    }

    @NotNull
    public DbTable getTable() {
        DbTable dbTable = (DbTable)this.myParent;
        if (dbTable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/psi/DbTriggerImpl", "getTable"));
        }
        return dbTable;
    }
}

