/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.reference.SoftReference;
import com.intellij.ui.CellRendererPanel;
import com.intellij.ui.ExpandedItemRendererComponentWrapper;
import com.intellij.ui.Graphics2DDelegate;
import com.intellij.ui.Gray;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SingleAlarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUMap;
import com.intellij.util.containers.hash.EqualityPolicy;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.Activatable;
import com.intellij.util.ui.update.UiNotifyConnector;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.HierarchyBoundsAdapter;
import java.awt.event.HierarchyEvent;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.Random;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.UIResource;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TableCellImageCache {
    private CacheImpl myImageCache;
    private Map<TableCellRenderer, CellRendererWrapper> myCellRendererWrappers;
    private final JTable myTable;
    private int myCacheLevel;
    private boolean myWrappedGraphics;

    public TableCellImageCache(@NotNull JTable table, @NotNull Disposable disposable) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/database/run/ui/grid/TableCellImageCache", "<init>"));
        }
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/run/ui/grid/TableCellImageCache", "<init>"));
        }
        this.myImageCache = new CacheImpl();
        this.myCellRendererWrappers = TableCellImageCache.newCellRendererWrappersMap();
        this.myTable = table;
        table.addHierarchyBoundsListener(new HierarchyBoundsAdapter(){

            @Override
            public void ancestorResized(HierarchyEvent e) {
                TableCellImageCache.this.updateCacheSize();
            }
        });
        new UiNotifyConnector((Component)table, (Activatable)new Activatable.Adapter(){

            public void hideNotify() {
                TableCellImageCache.this.myImageCache = new CacheImpl();
                TableCellImageCache.this.myCellRendererWrappers = TableCellImageCache.newCellRendererWrappersMap();
            }
        });
        this.installFastScrollingCaching(disposable);
    }

    private void installFastScrollingCaching(@NotNull Disposable disposable) {
        SingleAlarm scrollingAlarm;
        if (disposable == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "disposable", "com/intellij/database/run/ui/grid/TableCellImageCache", "installFastScrollingCaching"));
        }
        SingleAlarm[] alarmRef = new SingleAlarm[]{null};
        alarmRef[0] = scrollingAlarm = new SingleAlarm(() -> {
            if (this.myCacheLevel == 0) {
                this.myTable.repaint();
            } else {
                this.myCacheLevel -= 25;
                alarmRef[0].cancelAndRequest();
            }
        }, 100);
        Disposer.register((Disposable)disposable, (Disposable)scrollingAlarm);
        int[] xySum = new int[]{0};
        final ChangeListener scrollListener = e -> {
            Point p = this.myTable.getLocation();
            int curSum = p.x + p.y;
            int delta = xySum[0] == 0 ? 0 : Math.abs(curSum - xySum[0]);
            xySum[0] = curSum;
            if (delta <= this.myTable.getRowHeight() * 4) {
                return;
            }
            scrollingAlarm.cancelAndRequest();
            this.myCacheLevel = 100;
        };
        new UiNotifyConnector.Once((Component)this.myTable, (Activatable)new Activatable.Adapter(){

            public void showNotify() {
                JScrollPane scrollPane = (JScrollPane)ObjectUtils.notNull((Object)UIUtil.getParentOfType(JScrollPane.class, (Component)TableCellImageCache.this.myTable));
                scrollPane.getHorizontalScrollBar().getModel().addChangeListener(scrollListener);
                scrollPane.getVerticalScrollBar().getModel().addChangeListener(scrollListener);
            }
        });
    }

    public TableCellRenderer wrapCellRenderer(@NotNull TableCellRenderer renderer, @Nullable CellStateGetter cellStateGetter) {
        if (renderer == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/run/ui/grid/TableCellImageCache", "wrapCellRenderer"));
        }
        CellRendererWrapper wrapper = this.myCellRendererWrappers.get(renderer);
        if (wrapper == null) {
            wrapper = new CellRendererWrapper(renderer, cellStateGetter);
            this.myCellRendererWrappers.put(renderer, wrapper);
        }
        return wrapper;
    }

    public void reset() {
        this.myCellRendererWrappers.clear();
        this.myImageCache.clear();
    }

    private void updateCacheSize() {
        TableColumnModel columnModel = this.myTable.getColumnModel();
        int columnCount = columnModel == null ? 0 : columnModel.getColumnCount();
        int rowCount = this.myTable.getRowCount();
        Rectangle visibleRect = this.myTable.getVisibleRect();
        if (columnCount == 0 || rowCount == 0 || visibleRect.isEmpty()) {
            return;
        }
        int minColumnWidth = Integer.MAX_VALUE;
        for (int i = 0; i < columnCount; ++i) {
            TableColumn column = columnModel.getColumn(i);
            minColumnWidth = Math.min(minColumnWidth, column.getMinWidth());
        }
        int rowHeight = this.myTable.getRowHeight();
        int rowsMax = rowHeight == 0 ? rowCount : Math.min(rowCount, (int)Math.ceil((float)visibleRect.height / (float)rowHeight));
        int colsMax = minColumnWidth == 0 ? columnCount : Math.min(columnCount, (int)Math.ceil((float)visibleRect.width / (float)minColumnWidth));
        this.myImageCache.adjustCacheSize(rowsMax * colsMax);
    }

    @NotNull
    private static Map<TableCellRenderer, CellRendererWrapper> newCellRendererWrappersMap() {
        THashMap tHashMap = ContainerUtil.newTroveMap((TObjectHashingStrategy)ContainerUtil.identityStrategy());
        if (tHashMap == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/TableCellImageCache", "newCellRendererWrappersMap"));
        }
        return tHashMap;
    }

    private static int getContrastForColor(Color color) {
        int yiqValue = (color.getRed() * 299 + color.getGreen() * 587 + color.getBlue() * 114) / 1000;
        return yiqValue * 150 / 255 + 100;
    }

    private static void updateLcdContrast(Graphics2D g2d, Color color) {
        if (SystemInfo.isJetbrainsJvm) {
            g2d.setRenderingHint(RenderingHints.KEY_TEXT_LCD_CONTRAST, TableCellImageCache.getContrastForColor(color));
        }
    }

    private static final class CacheImpl {
        private MySLRUCache myCache = new MySLRUCache(0);

        private CacheImpl() {
        }

        @Nullable
        public BufferedImage get(@NotNull CellStateInfo key) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/run/ui/grid/TableCellImageCache$CacheImpl", "get"));
            }
            SoftReference imageRef = (SoftReference)this.myCache.get(key);
            if (imageRef == null) {
                return null;
            }
            BufferedImage image = (BufferedImage)imageRef.get();
            if (image == null) {
                this.myCache.remove(key);
            }
            return image;
        }

        public void put(@NotNull CellStateInfo key, @NotNull BufferedImage value) {
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/database/run/ui/grid/TableCellImageCache$CacheImpl", "put"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/TableCellImageCache$CacheImpl", "put"));
            }
            this.myCache.put(key, new SoftReference((Object)value));
        }

        public void clear() {
            this.myCache.clear();
        }

        public void adjustCacheSize(int newMaxSize) {
            int oldCacheSize = this.myCache.getMaximumSize();
            if (oldCacheSize >= newMaxSize && oldCacheSize / 2 < newMaxSize) {
                return;
            }
            MySLRUCache newCache = new MySLRUCache(newMaxSize);
            for (Map.Entry entry : this.myCache.entrySet()) {
                newCache.put(entry.getKey(), entry.getValue());
            }
            this.myCache = newCache;
        }

        private static class MySLRUCache
        extends SLRUMap<CellStateInfo, SoftReference<BufferedImage>> {
            private final int mySize;

            public MySLRUCache(int size) {
                super(size, size, EqualityPolicy.CANONICAL);
                this.mySize = size;
            }

            public int getMaximumSize() {
                return this.mySize;
            }
        }
    }

    private static final class CellStateInfo {
        private final TableCellRenderer myRenderer;
        private final Object myValue;
        private final boolean myIsSelected;
        private final boolean myHasFocus;
        private final int myWidth;
        private final int myHeight;
        private final boolean myIsRetina;
        private final Object myUserState;

        public CellStateInfo(@NotNull TableCellRenderer renderer, @Nullable Object value, boolean isSelected, boolean hasFocus, int width, int height, boolean isRetina, @Nullable Object userState) {
            if (renderer == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "renderer", "com/intellij/database/run/ui/grid/TableCellImageCache$CellStateInfo", "<init>"));
            }
            this.myRenderer = renderer;
            this.myValue = value;
            this.myIsSelected = isSelected;
            this.myHasFocus = hasFocus;
            this.myWidth = width;
            this.myHeight = height;
            this.myIsRetina = isRetina;
            this.myUserState = userState;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CellStateInfo info = (CellStateInfo)o;
            if (this.myIsSelected != info.myIsSelected) {
                return false;
            }
            if (this.myHasFocus != info.myHasFocus) {
                return false;
            }
            if (this.myWidth != info.myWidth) {
                return false;
            }
            if (this.myHeight != info.myHeight) {
                return false;
            }
            if (this.myRenderer != info.myRenderer) {
                return false;
            }
            if (!CellStateInfo.equalObjectsAndHashCodes(this.myValue, info.myValue)) {
                return false;
            }
            if (this.myIsRetina != info.myIsRetina) {
                return false;
            }
            return CellStateInfo.equalObjectsAndHashCodes(this.myUserState, info.myUserState);
        }

        public int hashCode() {
            int result = System.identityHashCode(this.myRenderer);
            result = 31 * result + (this.myValue != null ? this.myValue.hashCode() : 0);
            result = 31 * result + (this.myIsSelected ? 1 : 0);
            result = 31 * result + (this.myHasFocus ? 1 : 0);
            result = 31 * result + this.myWidth;
            result = 31 * result + this.myHeight;
            result = 31 * result + (this.myIsRetina ? 1 : 0);
            result = 31 * result + (this.myUserState != null ? this.myUserState.hashCode() : 0);
            return result;
        }

        private static boolean equalObjectsAndHashCodes(@Nullable Object o1, @Nullable Object o2) {
            return o1 == null && o2 == null || o1 != null && o2 != null && o1.equals(o2) && o1.hashCode() == o2.hashCode();
        }
    }

    private class CellRendererWrapper
    extends CellRendererPanel
    implements TableCellRenderer {
        private final TableCellRenderer myWrappee;
        private final CellStateGetter myCellStateGetter;
        private Object myValue;
        private int myRow;
        private int myColumn;
        private boolean myIsSelected;
        private boolean myHasFocus;
        private JTable myTable;
        private Random myRandom = new Random();

        private CellRendererWrapper(TableCellRenderer wrappee, CellStateGetter cellStateGetter) {
            this.myWrappee = wrappee;
            this.myCellStateGetter = cellStateGetter;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.myValue = value;
            this.myIsSelected = isSelected;
            this.myHasFocus = hasFocus;
            this.myTable = table;
            this.myRow = row;
            this.myColumn = column;
            Component originalComponent = this.myWrappee.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (!this.hasWrappeeComponent()) {
                this.add(originalComponent);
            } else if (originalComponent != this.getWrappeeComponent()) {
                this.removeAll();
                this.add(originalComponent);
            }
            return this;
        }

        protected void paintChildren(Graphics g) {
            boolean tooLargeToCache;
            boolean wrappedGraphics = g instanceof Graphics2DDelegate;
            JComponent originalComponent = this.getWrappeeComponent();
            originalComponent.validate();
            boolean forceNoCaching = wrappedGraphics && (TableCellImageCache.this.myCacheLevel == 0 || TableCellImageCache.this.myCacheLevel < 100 && this.myRandom.nextInt(100) > TableCellImageCache.this.myCacheLevel);
            Rectangle tableVisibleRect = this.myTable.getVisibleRect();
            int width = this.getWidth();
            int height = this.getHeight();
            boolean paintingExpansionHint = this.getParent() instanceof ExpandedItemRendererComponentWrapper;
            boolean bl = tooLargeToCache = tableVisibleRect.width <= width || tableVisibleRect.height <= height;
            if (paintingExpansionHint || tooLargeToCache || forceNoCaching) {
                super.paintChildren(g);
                return;
            }
            if (TableCellImageCache.this.myWrappedGraphics != wrappedGraphics) {
                TableCellImageCache.this.myImageCache.clear();
            }
            TableCellImageCache.this.myWrappedGraphics = wrappedGraphics;
            Graphics2D g2d = (Graphics2D)g;
            boolean isMacRetina = UIUtil.isRetina((Graphics2D)g2d);
            Object userCellState = this.myCellStateGetter.getState(this.myTable, (Component)((Object)this), this.myRow, this.myColumn);
            CellStateInfo cacheKey = new CellStateInfo(this, this.myValue, this.myIsSelected, this.myHasFocus, width, height, isMacRetina, userCellState);
            BufferedImage image = TableCellImageCache.this.myImageCache.get(cacheKey);
            if (image == null) {
                image = UIUtil.createImageForGraphics((Graphics2D)g2d, (int)width, (int)height, (int)(wrappedGraphics ? 2 : 1));
                this.paintComponentOn(originalComponent, image);
                TableCellImageCache.this.myImageCache.put(cacheKey, image);
            }
            UIUtil.drawImage((Graphics)g, (BufferedImage)image, null, (int)0, (int)0);
        }

        public Border getBorder() {
            return this.hasWrappeeComponent() ? this.getWrappeeBorder() : super.getBorder();
        }

        public void setBorder(Border border) {
            if (this.hasWrappeeComponent() && !(border instanceof UIResource)) {
                this.getWrappeeComponent().setBorder(border);
                return;
            }
            super.setBorder(border);
        }

        public void setBackground(Color bg) {
            if (this.hasWrappeeComponent()) {
                this.getWrappeeComponent().setBackground(bg);
            }
            super.setBackground(bg);
        }

        private Border getWrappeeBorder() {
            Border border = this.getWrappeeComponent().getBorder();
            return border instanceof UIResource ? super.getBorder() : border;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void paintComponentOn(@NotNull JComponent c, @NotNull BufferedImage image) {
            if (c == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "c", "com/intellij/database/run/ui/grid/TableCellImageCache$CellRendererWrapper", "paintComponentOn"));
            }
            if (image == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "image", "com/intellij/database/run/ui/grid/TableCellImageCache$CellRendererWrapper", "paintComponentOn"));
            }
            boolean hasAlpha = image.getColorModel().hasAlpha();
            boolean wasDoubleBuffered = c.isDoubleBuffered();
            c.setDoubleBuffered(false);
            c.setOpaque(true);
            c.setBackground(this.myIsSelected || !hasAlpha ? c.getBackground() : Gray.TRANSPARENT);
            if (c instanceof CellRendererPanel) {
                ((CellRendererPanel)c).setSelected(this.myIsSelected || !hasAlpha);
            }
            Graphics2D g = image.createGraphics();
            try {
                TableCellImageCache.updateLcdContrast(g, c.getForeground());
                c.paint(g);
            }
            finally {
                g.dispose();
            }
            if (wasDoubleBuffered) {
                c.setDoubleBuffered(true);
            }
        }

        private JComponent getWrappeeComponent() {
            return (JComponent)this.getComponent(0);
        }

        private boolean hasWrappeeComponent() {
            return this.getComponentCount() > 0;
        }
    }

    public static interface CellStateGetter {
        public Object getState(JTable var1, Component var2, int var3, int var4);
    }
}

