/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.datagrid.DataConsumer;
import com.intellij.database.datagrid.DataGrid;
import com.intellij.database.datagrid.DataGridUtil;
import com.intellij.database.datagrid.ModelIndex;
import com.intellij.database.extractors.ExtractorsUtil;
import com.intellij.database.remote.jdbc.LobInfo;
import com.intellij.database.run.ReservedCellValue;
import com.intellij.database.run.actions.LoadFileAction;
import com.intellij.database.run.ui.grid.editors.GridCellEditor;
import com.intellij.database.run.ui.grid.editors.GridCellEditorFactory;
import com.intellij.database.run.ui.grid.editors.GridTextCellEditorBase;
import com.intellij.database.settings.DatabaseSettings;
import com.intellij.database.util.DbImplUtil;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationType;
import com.intellij.notification.Notifications;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.io.IOException;
import java.util.EventObject;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class DefaultTextEditorFactory
implements GridCellEditorFactory {
    DefaultTextEditorFactory() {
    }

    @Override
    public int getSuitability(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory", "getSuitability"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory", "getSuitability"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory", "getSuitability"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel().getColumn(column));
        int suitability = 0;
        if (DataGridUtil.getDatabaseDialect(grid).getFamilyId().isPostgres()) {
            suitability = DefaultTextEditorFactory.getPostgresSuitability(c);
        }
        if (suitability == 0) {
            suitability = DefaultTextEditorFactory.getCommonSuitability(c);
        }
        return suitability;
    }

    @Override
    @NotNull
    public GridCellEditor createEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, EventObject initiator) {
        if (grid == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory", "createEditor"));
        }
        if (row == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory", "createEditor"));
        }
        if (column == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory", "createEditor"));
        }
        DataConsumer.Column c = (DataConsumer.Column)ObjectUtils.assertNotNull((Object)grid.getDataModel().getColumn(column));
        if (DefaultTextEditorFactory.getPostgresSuitability(c) > 0) {
            GridTextCellEditor gridTextCellEditor = new GridTextCellEditor(grid, row, column, initiator){

                @Override
                protected boolean isValueEditable() {
                    return super.isValueEditable() || this.myValue instanceof Object[];
                }
            };
            if (gridTextCellEditor == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory", "createEditor"));
            }
            return gridTextCellEditor;
        }
        GridTextCellEditor gridTextCellEditor = new GridTextCellEditor(grid, row, column, initiator);
        if (gridTextCellEditor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory", "createEditor"));
        }
        return gridTextCellEditor;
    }

    private static int getCommonSuitability(DataConsumer.Column c) {
        switch (ExtractorsUtil.guessJdbcType(c)) {
            case -16: 
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 239: 
            case 2005: 
            case 2009: 
            case 2011: {
                return 1;
            }
        }
        return 0;
    }

    private static int getPostgresSuitability(DataConsumer.Column c) {
        switch (c.type) {
            case 0: 
            case 1111: {
                if (!ContainerUtil.list((Object[])new String[]{"inet", "cidr", "macaddr", "interval", "json", "jsonb", "money", "citext"}).contains(c.typeName)) break;
                return 1;
            }
            case 2002: 
            case 2003: {
                return 1;
            }
        }
        return 0;
    }

    private static class GridTextCellEditor
    extends GridTextCellEditorBase
    implements LoadFileAction.LoadFileActionHandler {
        private GridTextCellEditor(@NotNull DataGrid grid, @NotNull ModelIndex<DataConsumer.Row> row, @NotNull ModelIndex<DataConsumer.Column> column, EventObject initiator) {
            if (grid == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grid", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor", "<init>"));
            }
            if (row == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "row", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor", "<init>"));
            }
            if (column == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "column", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor", "<init>"));
            }
            super(grid, row, column, initiator);
        }

        @Nullable
        public Object getData(@NonNls String dataId) {
            if (LoadFileAction.LOAD_FILE_ACTION_HANDLER_KEY.is(dataId)) {
                return this;
            }
            return null;
        }

        @Override
        @NotNull
        protected String getInitialText() {
            if (this.myValue instanceof ReservedCellValue) {
                if ("" == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor", "getInitialText"));
                }
                return "";
            }
            if (this.isValueEditable() && this.myValue instanceof LobInfo) {
                String string = this.myValue instanceof LobInfo.ClobInfo ? ((LobInfo.ClobInfo)this.myValue).data : "";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor", "getInitialText"));
                }
                return string;
            }
            String string = StringUtil.notNullize((String)super.getInitialText());
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor", "getInitialText"));
            }
            return string;
        }

        @Override
        protected boolean isValueEditable() {
            return this.myValue == null || this.myValue instanceof String || this.myValue instanceof ReservedCellValue || this.myValue instanceof LobInfo && !((LobInfo)this.myValue).isTruncated() && (this.myValue instanceof LobInfo.ClobInfo || ((LobInfo)this.myValue).length == 0L);
        }

        @Override
        public void fileChosen(@NotNull VirtualFile file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor", "fileChosen"));
            }
            this.myValue = GridTextCellEditor.loadValueFromFile(file);
            if (this.myValue == null || this.myValue instanceof LobInfo.FileClobInfo) {
                this.myGrid.stopEditing();
            } else {
                this.myTextField.setText(this.getInitialText());
            }
        }

        @Nullable
        private static Object loadValueFromFile(@NotNull VirtualFile virtualFile) {
            if (virtualFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "virtualFile", "com/intellij/database/run/ui/grid/editors/DefaultTextEditorFactory$GridTextCellEditor", "loadValueFromFile"));
            }
            if (virtualFile.getLength() > (long)DatabaseSettings.getSettings().getMaxLobLength()) {
                return DbImplUtil.clobFromFile(virtualFile);
            }
            try {
                return StringUtil.convertLineSeparators((String)VfsUtilCore.loadText((VirtualFile)virtualFile));
            }
            catch (IOException e) {
                String trace = ExceptionUtil.getUserStackTrace((Throwable)e, (Logger)DataGridUtil.LOG).replace("\n", "<br>\n");
                String title = "Cannot read file: " + virtualFile.getName();
                Notifications.Bus.notify((Notification)new Notification("Update Table", title, trace, NotificationType.ERROR));
                return null;
            }
        }
    }
}

