/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.run.ui.grid.editors;

import com.intellij.database.run.ui.grid.editors.DataGridFormattersUtil;
import com.intellij.database.run.ui.grid.editors.DateAndTimeFormatterDelegate;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.temporal.ChronoField;
import org.jetbrains.annotations.NotNull;

public class TimestampDelegate
extends DateAndTimeFormatterDelegate<Timestamp, LocalDateTime> {
    public TimestampDelegate() {
        super(LocalDateTime::from, temporal -> LocalDate.from(temporal).atTime(0, 0, 0));
    }

    @Override
    LocalDateTime toTemporalAccessor(@NotNull Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/TimestampDelegate", "toTemporalAccessor"));
        }
        if (!(value instanceof Timestamp)) {
            throw new IllegalArgumentException("Value must be of type Timestamp");
        }
        Timestamp timestamp = (Timestamp)value;
        return timestamp.toLocalDateTime().with(ChronoField.ERA, DataGridFormattersUtil.getEra(timestamp, ZoneId.systemDefault()));
    }

    @Override
    Timestamp create(@NotNull LocalDateTime value, @NotNull String stringRepresentation) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "value", "com/intellij/database/run/ui/grid/editors/TimestampDelegate", "create"));
        }
        if (stringRepresentation == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stringRepresentation", "com/intellij/database/run/ui/grid/editors/TimestampDelegate", "create"));
        }
        return Timestamp.valueOf(value);
    }
}

