/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.settings;

import com.intellij.database.csv.CsvFormat;
import com.intellij.database.csv.CsvRecordFormat;
import com.intellij.database.csv.PersistentCsvFormat;
import com.intellij.database.util.TokenPatternCache;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.components.ExportableComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.messages.Topic;
import com.intellij.util.xmlb.XmlSerializerUtil;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.OptionTag;
import com.intellij.util.xmlb.annotations.Property;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.Transient;
import java.io.File;
import java.util.HashMap;
import java.util.List;
import org.intellij.lang.annotations.RegExp;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="DatabaseSettings", storages={@Storage(value="databaseSettings.xml")})
public class DatabaseSettings
implements PersistentStateComponent<DatabaseSettings>,
ExportableComponent {
    private static final int CURRENT_VERSION = 1;
    static final String STATE_NAME = "databaseSettings";
    public static final int EXECUTE_INSIDE_SHOW_CHOOSER = 1;
    public static final int EXECUTE_INSIDE_SMALLEST = 2;
    public static final int EXECUTE_INSIDE_LARGEST = 3;
    public static final int EXECUTE_INSIDE_BATCH = 4;
    public static final int EXECUTE_INSIDE_WHOLE_SCRIPT = 5;
    public static final int EXECUTE_OUTSIDE_NOTHING = 1;
    public static final int EXECUTE_OUTSIDE_WHOLE_SCRIPT = 2;
    public static final int EXECUTE_OUTSIDE_SCRIPT_TAIL = 3;
    public static final int EXECUTE_SELECTION_EXACTLY_ONE = 1;
    public static final int EXECUTE_SELECTION_EXACTLY_SCRIPT = 2;
    public static final int EXECUTE_SELECTION_SMART_EXPAND = 3;
    public static final CsvFormat TSV_FORMAT = DatabaseSettings.xsvFormat("Tab-separated (TSV)", "\t");
    public static final CsvFormat CSV_FORMAT = DatabaseSettings.xsvFormat("Comma-separated (CSV)", ",");
    public static final List<CsvFormat> DEFAULT_CSV_FORMATS = ContainerUtil.immutableList((Object[])new CsvFormat[]{TSV_FORMAT, CSV_FORMAT});
    private static final List<ParameterPattern> DEFAULT_PATTERNS = ContainerUtil.immutableList((Object[])new ParameterPattern[]{new ParameterPattern("\\?(\\d+)"), new ParameterPattern(":(\\w+)", "*,-PostgreSQL"), new ParameterPattern("%\\w+", "JAVA,Python"), new ParameterPattern("\\$\\{([^\\{\\}]*)\\}"), new ParameterPattern("\\$\\(([^\\)]+)\\)"), new ParameterPattern("\\$(\\w+)\\$", "*,-PostgreSQL"), new ParameterPattern("#(\\w+)#", "XML"), new ParameterPattern("(?<=\\W|\\A)\\$(\\d+|[a-zA-Z_](?:\\w|\\.)*)\\$?(?=\\W|\\z)", "*,-SQL,Oracle,OracleSqlPlus,PostgreSQL,PostgresPLSQL"), new ParameterPattern("(?<=\\W|\\A)#(\\d+|[a-zA-Z_](?:\\w|\\.)*)#?(?=\\W|\\z)", "*,-SQL,Oracle,OracleSqlPlus,PostgreSQL,PostgresPLSQL"), new ParameterPattern("%\\((\\w+)\\)s", "Python")});
    public static final List<ParameterPattern> HARDCODED_PATTERNS = ContainerUtil.immutableList((Object[])new ParameterPattern[]{new ParameterPattern("\\$\\{([^\\{\\}]*)\\}"), new ParameterPattern("#\\{([^\\{\\}]*)\\}")});
    public static final Topic<Listener> TOPIC = Topic.create((String)"Database settings", Listener.class);
    @Attribute(value="version")
    public int version = 1;
    @OptionTag(value="page-size")
    public int pageSize = 500;
    @OptionTag(value="reuse-result-tab")
    public boolean reuseResultTab = true;
    @OptionTag(value="always-review-parameters")
    public boolean alwaysReviewParameters = true;
    @OptionTag(value="execute-inside-option")
    public int executeInsideOption = 1;
    @OptionTag(value="execute-outside-option")
    public int executeOutsideOption = 1;
    @OptionTag(value="execute-selection-option")
    public int executeSelectionOption = 2;
    @OptionTag(value="load-slow-documentation")
    public boolean loadSlowDocumentation = true;
    @OptionTag(value="preview-rows")
    public int previewRows = 10;
    @OptionTag(value="filters-history-size")
    public int filtersHistorySize = 10;
    @OptionTag(value="prefetch-size")
    public int prefetchSize = 100;
    @OptionTag(value="lob-length")
    public int lobLength = 204800;
    @OptionTag(value="error-in-editor")
    public boolean showErrorInEditor = true;
    @OptionTag(value="ddl-editor-confirm-loss")
    public boolean ddlConfirmLoss = true;
    @Property(surroundWithTag=false)
    public UserPatterns userPatterns = new UserPatterns();
    @Tag(value="csv-formats")
    @AbstractCollection(surroundWithTag=false, elementTag="format", elementTypes={PersistentCsvFormat.class})
    public List<PersistentCsvFormat> csvFormats = ContainerUtil.newArrayList();
    @Transient
    public final TokenPatternCache patternCache = new TokenPatternCache(this);

    private static CsvFormat xsvFormat(@NotNull String name, @NotNull String valueSeparator) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/database/settings/DatabaseSettings", "xsvFormat"));
        }
        if (valueSeparator == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "valueSeparator", "com/intellij/database/settings/DatabaseSettings", "xsvFormat"));
        }
        ImmutableList quotes = ContainerUtil.immutableList((Object[])new CsvRecordFormat.Quotes[]{new CsvRecordFormat.Quotes("\"", "\"", "\"\"", "\"\""), new CsvRecordFormat.Quotes("'", "'", "''", "''")});
        CsvRecordFormat.QuotationPolicy quotationPolicy = CsvRecordFormat.QuotationPolicy.AS_NEEDED;
        CsvRecordFormat dataFormat = new CsvRecordFormat("", "", "", (List<CsvRecordFormat.Quotes>)quotes, quotationPolicy, valueSeparator, "\n", false);
        return new CsvFormat(name, dataFormat, null, false);
    }

    public static DatabaseSettings getSettings() {
        return (DatabaseSettings)ServiceManager.getService(DatabaseSettings.class);
    }

    public static void fireSettingsChanged() {
        DatabaseSettings.fireSettingsChanged(DatabaseSettings.getSettings());
    }

    public static void fireSettingsChanged(@NotNull DatabaseSettings settings) {
        if (settings == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "settings", "com/intellij/database/settings/DatabaseSettings", "fireSettingsChanged"));
        }
        settings.patternCache.clear();
        ((Listener)ApplicationManager.getApplication().getMessageBus().syncPublisher(TOPIC)).settingsChanged();
    }

    public DatabaseSettings() {
        this.ensureDefaultsSet();
    }

    public void initTestDefaults() {
        this.getUserPatterns().inScripts = true;
        this.getUserPatterns().inLiterals = true;
        this.getUserPatterns().patterns = ContainerUtil.newArrayList();
        for (ParameterPattern pattern : DEFAULT_PATTERNS) {
            this.userPatterns.patterns.add(pattern.clone());
        }
        this.patternCache.clear();
    }

    @Nullable
    public DatabaseSettings getState() {
        return this;
    }

    public void loadState(DatabaseSettings state) {
        XmlSerializerUtil.copyBean((Object)state, (Object)this);
        this.ensureDefaultsSet();
        DatabaseSettings.fireSettingsChanged(this);
    }

    @NotNull
    public File[] getExportFiles() {
        File[] fileArray = new File[]{PathManager.getOptionsFile((String)STATE_NAME)};
        if (fileArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/settings/DatabaseSettings", "getExportFiles"));
        }
        return fileArray;
    }

    @NotNull
    public String getPresentableName() {
        if ("Database: settings" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/settings/DatabaseSettings", "getPresentableName"));
        }
        return "Database: settings";
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public boolean isReuseResultTab() {
        return this.reuseResultTab;
    }

    public void setReuseResultTab(boolean reuseResultTab) {
        this.reuseResultTab = reuseResultTab;
    }

    public int getPreviewRows() {
        return this.previewRows;
    }

    public void setPreviewRows(int rows) {
        this.previewRows = rows;
    }

    public int getFiltersHistorySize() {
        return this.filtersHistorySize;
    }

    public void setFiltersHistorySize(int filtersHistorySize) {
        this.filtersHistorySize = filtersHistorySize;
    }

    public int getPrefetchSize() {
        return this.prefetchSize;
    }

    public void setPrefetchSize(int prefetchSize) {
        this.prefetchSize = prefetchSize;
    }

    public int getMaxLobLength() {
        return this.lobLength;
    }

    public void setMaxLobLength(int lobLength) {
        this.lobLength = lobLength;
    }

    public boolean isShowErrorInEditor() {
        return this.showErrorInEditor;
    }

    public void setShowErrorInEditor(boolean show) {
        this.showErrorInEditor = show;
    }

    public UserPatterns getUserPatterns() {
        return this.userPatterns;
    }

    @NotNull
    public List<CsvFormat> getCsvFormats() {
        List<CsvFormat> formats = DatabaseSettings.getImmutableFormats(this.csvFormats);
        List<CsvFormat> list = formats.isEmpty() ? DEFAULT_CSV_FORMATS : formats;
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/settings/DatabaseSettings", "getCsvFormats"));
        }
        return list;
    }

    public void setCsvFormats(@NotNull List<CsvFormat> formats) {
        if (formats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "formats", "com/intellij/database/settings/DatabaseSettings", "setCsvFormats"));
        }
        this.csvFormats = ContainerUtil.map(formats, PersistentCsvFormat::new);
    }

    private void ensureDefaultsSet() {
        Application application = ApplicationManager.getApplication();
        if (application == null || application.isUnitTestMode()) {
            return;
        }
        if (this.userPatterns.patterns.isEmpty()) {
            this.userPatterns.patterns = ContainerUtil.newArrayList();
            for (ParameterPattern pattern : DEFAULT_PATTERNS) {
                this.userPatterns.patterns.add(pattern.clone());
            }
        } else {
            DatabaseSettings.migrateStandardPatterns(this.userPatterns.patterns, this.version);
        }
        if (DatabaseSettings.getImmutableFormats(this.csvFormats).isEmpty()) {
            this.setCsvFormats(DEFAULT_CSV_FORMATS);
        }
    }

    @NotNull
    private static List<CsvFormat> getImmutableFormats(@NotNull List<PersistentCsvFormat> persistentFormats) {
        if (persistentFormats == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "persistentFormats", "com/intellij/database/settings/DatabaseSettings", "getImmutableFormats"));
        }
        List list = ContainerUtil.mapNotNull(persistentFormats, format -> format == null ? null : format.immutable());
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/settings/DatabaseSettings", "getImmutableFormats"));
        }
        return list;
    }

    private static void migrateStandardPatterns(List<ParameterPattern> patterns, int version) {
        HashMap map = ContainerUtil.newHashMap();
        HashMap replacement = ContainerUtil.newHashMap();
        for (ParameterPattern parameterPattern : DEFAULT_PATTERNS) {
            map.put(parameterPattern.pattern, parameterPattern);
            replacement.put(parameterPattern.pattern.replaceAll("[\\(\\)]", ""), parameterPattern.pattern);
        }
        for (ParameterPattern parameterPattern : patterns) {
            ParameterPattern def;
            String s = (String)replacement.get(parameterPattern.pattern);
            if (s != null) {
                parameterPattern.pattern = s;
            }
            if ((def = (ParameterPattern)map.get(parameterPattern.pattern)) == null || StringUtil.isEmpty((String)def.scope) || !StringUtil.isEmpty((String)parameterPattern.scope)) continue;
            parameterPattern.scope = def.scope;
            parameterPattern.inScripts = def.inScripts;
            parameterPattern.inLiterals = def.inLiterals;
        }
        HashMap existing = ContainerUtil.newHashMap();
        for (ParameterPattern pattern : patterns) {
            existing.put(pattern.pattern, pattern);
            if (map.containsKey(pattern.pattern)) continue;
            pattern.predefined = false;
        }
        boolean bl = version == 1;
        for (ParameterPattern pattern : DEFAULT_PATTERNS) {
            ParameterPattern ex = (ParameterPattern)existing.get(pattern.pattern);
            if (ex != null) {
                ex.predefined = true;
                continue;
            }
            ParameterPattern copy = pattern.clone();
            if (bl) {
                copy.inScripts = false;
                copy.inLiterals = false;
            }
            patterns.add(copy);
        }
    }

    @Tag(value="xsv-extractor")
    public static class XsvState
    extends StdState {
        @OptionTag(value="opening-quote")
        public String openingQuote = "\"";
        @OptionTag(value="closing-quote")
        public String closingQuote = "\"";
        @OptionTag(value="line-separator")
        public String lineSeparator = "\\n";
        @OptionTag(value="value-separator")
        public String valueSeparator = ",";
        @OptionTag(value="line-prefix")
        public String linePrefix = "";
        @OptionTag(value="line-suffix")
        public String lineSuffix = "";
        @OptionTag(value="always-quote")
        public boolean alwaysQuote = false;

        public XsvState() {
            this.type = "xsv";
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            XsvState state = (XsvState)o;
            if (this.alwaysQuote != state.alwaysQuote) {
                return false;
            }
            if (!this.closingQuote.equals(state.closingQuote)) {
                return false;
            }
            if (!this.linePrefix.equals(state.linePrefix)) {
                return false;
            }
            if (!this.lineSeparator.equals(state.lineSeparator)) {
                return false;
            }
            if (!this.lineSuffix.equals(state.lineSuffix)) {
                return false;
            }
            if (!this.openingQuote.equals(state.openingQuote)) {
                return false;
            }
            return this.valueSeparator.equals(state.valueSeparator);
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + this.openingQuote.hashCode();
            result = 31 * result + this.closingQuote.hashCode();
            result = 31 * result + this.lineSeparator.hashCode();
            result = 31 * result + this.valueSeparator.hashCode();
            result = 31 * result + this.linePrefix.hashCode();
            result = 31 * result + this.lineSuffix.hashCode();
            result = 31 * result + (this.alwaysQuote ? 1 : 0);
            return result;
        }
    }

    @Tag(value="std-extractor")
    public static class StdState
    extends BaseState {
        @OptionTag(value="row-numbers")
        public boolean rowNumber;
        @OptionTag(value="column-names")
        public boolean columnNames;

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            StdState state = (StdState)o;
            if (this.columnNames != state.columnNames) {
                return false;
            }
            return this.rowNumber == state.rowNumber;
        }

        @Override
        public int hashCode() {
            int result = super.hashCode();
            result = 31 * result + (this.rowNumber ? 1 : 0);
            result = 31 * result + (this.columnNames ? 1 : 0);
            return result;
        }
    }

    @Tag(value="extractor")
    public static class BaseState
    implements Cloneable {
        @Attribute(value="type")
        public String type = "";
        @Attribute(value="name")
        public String name = "";

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BaseState state = (BaseState)o;
            if (!this.name.equals(state.name)) {
                return false;
            }
            return this.type.equals(state.type);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + this.type.hashCode();
            return result;
        }

        public BaseState clone() {
            try {
                return (BaseState)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    @Tag(value="parameter-pattern")
    public static class ParameterPattern
    implements Cloneable {
        @Attribute(value="value")
        public String pattern = "";
        @Attribute(value="in-scripts")
        public boolean inScripts = true;
        @Attribute(value="in-literals")
        public boolean inLiterals = true;
        @Attribute(value="scope")
        public String scope = "";
        @Attribute(value="predefined")
        public boolean predefined = false;

        public ParameterPattern() {
        }

        public ParameterPattern(@RegExp String pattern) {
            this.pattern = pattern;
        }

        public ParameterPattern(@RegExp String pattern, String scope) {
            this.pattern = pattern;
            this.scope = scope;
            this.predefined = true;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ParameterPattern pattern1 = (ParameterPattern)o;
            if (this.inScripts != pattern1.inScripts) {
                return false;
            }
            if (this.inLiterals != pattern1.inLiterals) {
                return false;
            }
            if (this.pattern != null ? !this.pattern.equals(pattern1.pattern) : pattern1.pattern != null) {
                return false;
            }
            return !(this.scope != null ? !this.scope.equals(pattern1.scope) : pattern1.scope != null);
        }

        public int hashCode() {
            int result = this.pattern != null ? this.pattern.hashCode() : 0;
            result = 31 * result + (this.inScripts ? 1 : 0);
            result = 31 * result + (this.inLiterals ? 1 : 0);
            result = 31 * result + (this.scope != null ? this.scope.hashCode() : 0);
            return result;
        }

        public ParameterPattern clone() {
            try {
                return (ParameterPattern)super.clone();
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }

    @Tag(value="text-mode")
    public static class UserPatterns {
        @Attribute(value="in-scripts")
        public boolean inScripts;
        @Attribute(value="in-literals")
        public boolean inLiterals;
        @Tag(value="parameter-patterns")
        @AbstractCollection(surroundWithTag=false)
        public List<ParameterPattern> patterns = ContainerUtil.newArrayList();

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            UserPatterns mode = (UserPatterns)o;
            if (this.inLiterals != mode.inLiterals) {
                return false;
            }
            if (this.inScripts != mode.inScripts) {
                return false;
            }
            return this.patterns.equals(mode.patterns);
        }

        public int hashCode() {
            int result = this.patterns.hashCode();
            result = 31 * result + (this.inLiterals ? 1 : 0);
            result = 31 * result + (this.inScripts ? 1 : 0);
            return result;
        }
    }

    public static interface Listener {
        public void settingsChanged();
    }
}

