/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.mssql.ssrp;

import com.intellij.database.dataSource.DataSourceUiUtil;
import com.intellij.database.vendors.mssql.ssrp.SsrpConstants;
import com.intellij.database.vendors.mssql.ssrp.SsrpInfo;
import com.intellij.database.vendors.mssql.ssrp.SsrpNet;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.Function;
import com.intellij.util.SofterReference;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.WeakList;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import gnu.trove.THashSet;
import gnu.trove.TObjectHashingStrategy;
import java.util.Collection;
import java.util.EventListener;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SsrpInfoCache {
    private static final SsrpInfoCache INSTANCE = new SsrpInfoCache();
    public static final Function<Ref<String>, String> DEREF = ref -> (String)ref.get();
    public static final Condition<String> HOST_FILTER = s -> !StringUtil.isEmptyOrSpaces((String)s);
    private final EventDispatcher<Listener> myDispatcher = EventDispatcher.create(Listener.class);
    private SofterReference<SsrpInfo> myInfo;
    private WeakList<Ref<String>> myHosts = new WeakList();
    private boolean myQueued;
    private final Task.Backgroundable myUpdateTask = new MyBaseTask("Discovering Reachable SQL Server Instances"){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache$1", "run"));
            }
            try {
                Set<SsrpNet.Response> responses = SsrpNet.queryNetworkInstances(1434, 5000);
                SsrpInfo info = new SsrpInfo();
                for (SsrpNet.Response resp : responses) {
                    info.merge(resp);
                }
                THashSet hosts = ContainerUtil.newTroveSet((TObjectHashingStrategy)CaseInsensitiveStringHashingStrategy.INSTANCE);
                JBIterable.from((Iterable)SsrpInfoCache.this.myHosts.toStrongList()).transform(DEREF).filter(HOST_FILTER).addAllTo((Collection)hosts);
                responses = SsrpNet.queryNetworkInstances((Set<String>)hosts, 1434, 5000);
                for (SsrpNet.Response resp : responses) {
                    info.merge(resp);
                }
                SsrpInfoCache ssrpInfoCache = INSTANCE;
                synchronized (ssrpInfoCache) {
                    INSTANCE.myInfo = new SofterReference((Object)info);
                }
                ((Listener)SsrpInfoCache.this.myDispatcher.getMulticaster()).consume(null);
            }
            catch (SsrpConstants.SsrpException e) {
                ((Listener)SsrpInfoCache.this.myDispatcher.getMulticaster()).consume(e);
            }
        }
    };

    private SsrpInfoCache() {
    }

    public static void addListener(@NotNull Listener listener, @NotNull Disposable parent) {
        if (listener == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "listener", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache", "addListener"));
        }
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache", "addListener"));
        }
        SsrpInfoCache.INSTANCE.myDispatcher.addListener((EventListener)listener, parent);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static SsrpInfo get() {
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        synchronized (ssrpInfoCache) {
            return SsrpInfoCache.INSTANCE.myInfo == null ? null : (SsrpInfo)SsrpInfoCache.INSTANCE.myInfo.get();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @NotNull
    public static Ref<String> addHost() {
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        // MONITORENTER : ssrpInfoCache
        Ref result = Ref.create();
        SsrpInfoCache.INSTANCE.myHosts.add((Object)result);
        Ref ref = result;
        // MONITOREXIT : ssrpInfoCache
        if (ref != null) return ref;
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache", "addHost"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateHost(boolean async, @NotNull String host) {
        if (host == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache", "updateHost"));
        }
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        synchronized (ssrpInfoCache) {
            if (SsrpInfoCache.INSTANCE.myQueued) {
                return;
            }
            SsrpInfoCache.INSTANCE.myQueued = true;
        }
        MyHostUpdater updater = new MyHostUpdater(host);
        if (async) {
            DataSourceUiUtil.runAsyncWithCorrectModality(updater);
        } else {
            DataSourceUiUtil.runSynchronously((Task)updater);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(boolean async) {
        SsrpInfoCache ssrpInfoCache = INSTANCE;
        synchronized (ssrpInfoCache) {
            if (SsrpInfoCache.INSTANCE.myQueued) {
                return;
            }
            SsrpInfoCache.INSTANCE.myQueued = true;
        }
        if (async) {
            DataSourceUiUtil.runAsyncWithCorrectModality(SsrpInfoCache.INSTANCE.myUpdateTask);
        } else {
            DataSourceUiUtil.runSynchronously((Task)SsrpInfoCache.INSTANCE.myUpdateTask);
        }
    }

    public static interface Listener
    extends EventListener,
    Consumer<SsrpConstants.SsrpException> {
    }

    private static abstract class MyBaseTask
    extends Task.Backgroundable {
        public MyBaseTask(@NotNull String title) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache$MyBaseTask", "<init>"));
            }
            super(null, title, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onCancel() {
            SsrpInfoCache ssrpInfoCache = INSTANCE;
            synchronized (ssrpInfoCache) {
                INSTANCE.myQueued = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onSuccess() {
            SsrpInfoCache ssrpInfoCache = INSTANCE;
            synchronized (ssrpInfoCache) {
                INSTANCE.myQueued = false;
            }
        }
    }

    private static class MyHostUpdater
    extends MyBaseTask {
        private final String myHost;

        public MyHostUpdater(@NotNull String host) {
            if (host == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "host", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache$MyHostUpdater", "<init>"));
            }
            super("Discovering Instances on " + host);
            this.myHost = host;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(@NotNull ProgressIndicator indicator) {
            if (indicator == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/database/vendors/mssql/ssrp/SsrpInfoCache$MyHostUpdater", "run"));
            }
            try {
                SsrpNet.Response resp = SsrpNet.queryInstances(this.myHost, 1434, 5000);
                SsrpInfo info = new SsrpInfo(SsrpInfoCache.get(), SsrpInfo.extractServers(resp.response));
                info.merge(resp);
                SsrpInfoCache ssrpInfoCache = INSTANCE;
                synchronized (ssrpInfoCache) {
                    INSTANCE.myInfo = new SofterReference((Object)info);
                }
                ((Listener)INSTANCE.myDispatcher.getMulticaster()).consume(null);
            }
            catch (SsrpConstants.SsrpException e) {
                ((Listener)INSTANCE.myDispatcher.getMulticaster()).consume(e);
            }
        }
    }
}

