/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.vendors.oracle;

import com.intellij.database.DatabaseFamilyId;
import com.intellij.database.console.JdbcConsole;
import com.intellij.database.console.JdbcEngine;
import com.intellij.database.datagrid.DataRequest;
import com.intellij.database.model.DatabaseSystem;
import com.intellij.openapi.actionSystem.AnActionEvent;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class OracleConsoleUtils {
    OracleConsoleUtils() {
    }

    @Nullable
    static JdbcConsole getOracleConsole(AnActionEvent e) {
        JdbcConsole console = JdbcConsole.getConsole(e);
        if (console == null) {
            return null;
        }
        DatabaseFamilyId familyId = DatabaseFamilyId.forDataSource((DatabaseSystem)((DatabaseSystem)console.getTarget()));
        return familyId.isOracle() ? console : null;
    }

    @Nullable
    static Connection getConnection(DataRequest.Context context) {
        if (context.producer instanceof JdbcEngine) {
            return ((JdbcEngine)context.producer).getCurrentConnection();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    static List<String> queryForStrings(@NotNull Connection connection, @NotNull String query, String ... params) throws SQLException {
        ArrayList<String> result;
        if (connection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "connection", "com/intellij/database/vendors/oracle/OracleConsoleUtils", "queryForStrings"));
        }
        if (query == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/database/vendors/oracle/OracleConsoleUtils", "queryForStrings"));
        }
        try (PreparedStatement stmt = connection.prepareStatement(query, 1003, 1007);){
            int n = params.length;
            for (int i = 0; i < n; ++i) {
                stmt.setString(i + 1, params[i]);
            }
            try (ResultSet rset = stmt.executeQuery();){
                result = new ArrayList<String>();
                while (rset.next()) {
                    result.add(rset.getString(1));
                }
            }
        }
        ArrayList<String> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/vendors/oracle/OracleConsoleUtils", "queryForStrings"));
        }
        return arrayList;
    }
}

