/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.database.view.generators;

import com.intellij.database.DatabasePluginId;
import com.intellij.database.extensions.ExtensionScriptsUtil;
import com.intellij.database.psi.DbElement;
import com.intellij.database.view.DatabaseView;
import com.intellij.database.view.generators.Clipboard;
import com.intellij.database.view.generators.DatabaseViewExtensionScriptsBindings;
import com.intellij.database.view.generators.Files;
import com.intellij.database.view.generators.Logger;
import com.intellij.ide.extensionResources.ExtensionsRootType;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileSaverDescriptor;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.util.Consumer;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.TextTransferable;
import com.intellij.util.ui.UIUtil;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.ide.script.IdeScriptEngine;

public class DatabaseViewExtensionScripts {
    private static final String SCRIPT_DIR = "schema";

    private DatabaseViewExtensionScripts() {
    }

    @NotNull
    public static List<VirtualFile> getScriptFiles() {
        List list;
        try {
            VirtualFile scriptDir = DatabaseViewExtensionScripts.getScriptsDirectoryImpl(false);
            Object[] scriptDirChildren = scriptDir != null ? scriptDir.getChildren() : VirtualFile.EMPTY_ARRAY;
            list = ContainerUtil.filter((Object[])scriptDirChildren, (Condition)ExtensionsRootType.regularFileFilter());
        }
        catch (IOException iOException) {
            List list2 = ContainerUtil.emptyList();
            if (list2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "getScriptFiles"));
            }
            return list2;
        }
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "getScriptFiles"));
        }
        return list;
    }

    @Nullable
    public static VirtualFile getScriptsDirectory() {
        try {
            return DatabaseViewExtensionScripts.getScriptsDirectoryImpl(true);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    @Nullable
    private static VirtualFile getScriptsDirectoryImpl(boolean createIfMissing) throws IOException {
        return ExtensionsRootType.getInstance().findResourceDirectory(DatabasePluginId.get(), SCRIPT_DIR, createIfMissing);
    }

    public static boolean areAvailableIn(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "areAvailableIn"));
        }
        boolean inDatabaseView = DatabaseView.DATABASE_VIEW_KEY.getData(context) != null;
        return inDatabaseView && !DatabaseViewExtensionScripts.getSelection(context).isEmpty();
    }

    public static void runScript(@NotNull DataContext context, @NotNull VirtualFile scriptFile) {
        JBIterable selection;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "runScript"));
        }
        if (scriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFile", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "runScript"));
        }
        Project project = (Project)CommonDataKeys.PROJECT.getData(context);
        IdeScriptEngine engine = DatabaseViewExtensionScripts.prepareEngine(project, scriptFile, (JBIterable<DbElement>)(selection = JBIterable.from(DatabaseViewExtensionScripts.getSelection(context))));
        if (engine == null) {
            return;
        }
        ExtensionScriptsUtil.prepareScript(scriptFile);
        ExtensionScriptsUtil.doAsynchronously(project, () -> {
            if (scriptFile == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFile", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "lambda$runScript$0"));
            }
            Application application = ApplicationManager.getApplication();
            AccessToken token = application.acquireReadActionLock();
            try {
                if (project != null && project.isDisposed() || DatabaseViewExtensionScripts.hasInvalidElements((Iterable<? extends PsiElement>)selection)) {
                    return;
                }
                try {
                    String script = ExtensionScriptsUtil.loadScript(project, scriptFile);
                    ExtensionScriptsUtil.evalScript(project, engine, script);
                }
                catch (Exception ignore) {
                    System.out.println(ignore);
                }
            }
            finally {
                token.finish();
            }
        });
    }

    @Nullable
    private static IdeScriptEngine prepareEngine(@Nullable Project project, @NotNull VirtualFile scriptFile, @NotNull JBIterable<DbElement> selection) {
        if (scriptFile == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "scriptFile", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "prepareEngine"));
        }
        if (selection == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "selection", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "prepareEngine"));
        }
        IdeScriptEngine engine = ExtensionScriptsUtil.getEngineFor(project, scriptFile);
        if (engine != null) {
            ExtensionScriptsUtil.setBindings(engine).bind(DatabaseViewExtensionScriptsBindings.PROJECT, project).bind(DatabaseViewExtensionScriptsBindings.SELECTION, selection).bind(DatabaseViewExtensionScriptsBindings.CLIPBOARD, new ClipboardImpl()).bind(DatabaseViewExtensionScriptsBindings.LOG, new LoggerImpl(engine)).bind(DatabaseViewExtensionScriptsBindings.FILES, new FilesImpl(project));
        }
        return engine;
    }

    @NotNull
    private static Set<DbElement> getSelection(@NotNull DataContext context) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "context", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "getSelection"));
        }
        Set<DbElement> set = DatabaseView.getSelectedElements(context, DbElement.class);
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "getSelection"));
        }
        return set;
    }

    private static boolean hasInvalidElements(@NotNull Iterable<? extends PsiElement> elements) {
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "elements", "com/intellij/database/view/generators/DatabaseViewExtensionScripts", "hasInvalidElements"));
        }
        return ContainerUtil.find(elements, (Condition)new Condition<PsiElement>(){

            public boolean value(PsiElement element) {
                return !element.isValid();
            }
        }) != null;
    }

    private static class FilesImpl
    implements Files {
        private final Project myProject;

        private FilesImpl(@Nullable Project project) {
            this.myProject = project;
        }

        public void chooseFileAndSave(@NotNull String title, @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "chooseFileAndSave"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "chooseFileAndSave"));
            }
            if (saveAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "chooseFileAndSave"));
            }
            FileSaverDescriptor descriptor = new FileSaverDescriptor(title, description, new String[0]);
            this.chooseFileAndSaveImpl((FileChooserDescriptor)descriptor, saveAction);
        }

        public void chooseDirectoryAndSave(@NotNull String title, @NotNull String description, @NotNull Consumer<File> saveAction) {
            if (title == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "title", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "chooseDirectoryAndSave"));
            }
            if (description == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "description", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "chooseDirectoryAndSave"));
            }
            if (saveAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "chooseDirectoryAndSave"));
            }
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor().withTitle(title).withDescription(description);
            this.chooseFileAndSaveImpl(descriptor, saveAction);
        }

        public void refresh(@NotNull File file) {
            if (file == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "file", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "refresh"));
            }
            VirtualFile virtualFile = VfsUtil.findFileByIoFile((File)file, (boolean)true);
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)false, (boolean)true, (VirtualFile[])new VirtualFile[]{virtualFile});
        }

        private void chooseFileAndSaveImpl(@NotNull FileChooserDescriptor descriptor, @NotNull Consumer<File> saveAction) {
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "chooseFileAndSaveImpl"));
            }
            if (saveAction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "chooseFileAndSaveImpl"));
            }
            UIUtil.invokeLaterIfNeeded(() -> {
                if (saveAction == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "lambda$chooseFileAndSaveImpl$2"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "descriptor", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "lambda$chooseFileAndSaveImpl$2"));
                }
                Consumer selectedFilesConsumer = files -> {
                    if (saveAction == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "lambda$null$1"));
                    }
                    VirtualFile file = (VirtualFile)ContainerUtil.getFirstItem((List)files);
                    if (file != null) {
                        ExtensionScriptsUtil.doAsynchronously(this.myProject, () -> {
                            if (saveAction == null) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "saveAction", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$FilesImpl", "lambda$null$0"));
                            }
                            saveAction.consume((Object)VfsUtilCore.virtualToIoFile((VirtualFile)file));
                        });
                    }
                };
                FileChooserFactory.getInstance().createPathChooser(descriptor, this.myProject, null).choose(null, selectedFilesConsumer);
            });
        }
    }

    private static class LoggerImpl
    implements Logger {
        private final IdeScriptEngine myEngine;

        private LoggerImpl(@NotNull IdeScriptEngine engine) {
            if (engine == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "engine", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$LoggerImpl", "<init>"));
            }
            this.myEngine = engine;
        }

        public void print(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$LoggerImpl", "print"));
            }
            try {
                this.myEngine.getStdOut().append(message);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        public void error(@NotNull String message) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$LoggerImpl", "error"));
            }
            this.error(message, null);
        }

        public void error(@NotNull String message, @Nullable Throwable th) {
            if (message == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "message", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$LoggerImpl", "error"));
            }
            try {
                Writer err = this.myEngine.getStdErr();
                err.append(message).append("\n");
                if (th != null) {
                    err.append(ExceptionUtil.getThrowableText((Throwable)th));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class ClipboardImpl
    implements Clipboard {
        private ClipboardImpl() {
        }

        @NotNull
        public String get() {
            String string;
            try {
                Transferable contents = CopyPasteManager.getInstance().getContents();
                string = contents != null ? (String)contents.getTransferData(DataFlavor.stringFlavor) : "";
            }
            catch (UnsupportedFlavorException unsupportedFlavorException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$ClipboardImpl", "get"));
            }
            return string;
            if ("" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/database/view/generators/DatabaseViewExtensionScripts$ClipboardImpl", "get"));
            }
            return "";
        }

        public void set(@Nullable String text) {
            CopyPasteManager.getInstance().setContents((Transferable)new TextTransferable(StringUtil.notNullize((String)text)));
        }
    }
}

