/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableList;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.Case;
import com.intellij.dbm.common.DBIntrospector;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionMode;
import com.intellij.dbm.common.IntrospectionOptions;
import com.intellij.dbm.common.IntrospectionUtil;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.sql.CommonPreprocessor;
import com.intellij.sql.Evaluator;
import com.intellij.util.ArrayUtil;
import gnu.trove.TIntHashSet;
import java.sql.Timestamp;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableMap;
import java.util.TreeMap;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;
import org.jetbrains.dekaf.core.InTransactionNoResult;
import org.jetbrains.dekaf.sql.SqlQuery;
import org.jetbrains.dekaf.util.StringOperator;
import org.jetbrains.dekaf.util.Version;

public abstract class BaseIntrospector<S extends DbmSchema, M extends DbmModel<?>>
implements DBIntrospector {
    protected static final Timestamp AGES_AGO = new Timestamp(139460400000L);
    @NotNull
    protected final DBFacade myFacade;
    protected final boolean myConsiderSystemSchemasReinstrospection;
    protected M myModel;
    @NotNull
    protected IntrospectionOptions myOptions;
    @NotNull
    protected ProgressIndicator myProgressIndicator;
    @NotNull
    protected final Map<String, Object> myQueryParameters;
    @NotNull
    protected Version myServerVersion;
    protected Version myDriverVersion;
    protected boolean myInitialized;

    protected BaseIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/common/BaseIntrospector", "<init>"));
        }
        this.myProgressIndicator = DumbProgressIndicator.INSTANCE;
        this.myQueryParameters = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
        this.myServerVersion = Version.ZERO;
        this.myDriverVersion = Version.ZERO;
        this.myInitialized = false;
        this.myFacade = facade;
        this.myOptions = IntrospectionOptions.DEFAULT_OPTIONS;
        this.myConsiderSystemSchemasReinstrospection = BaseIntrospector.stringToBoolean(System.getProperty("dbe.always.reintrospect.system.schemas"));
    }

    @Override
    public void init(@Nullable DbmModel model) {
        this.checkNotInitialized();
        this.myModel = this.modelCanBeAccepted(model) ? model : this.createNewModel();
        ConnectionInfo connectionInfo = this.myFacade.getConnectionInfo();
        this.myServerVersion = connectionInfo.serverVersion;
        this.myDriverVersion = connectionInfo.driverVersion;
        this.initInternalState();
        this.myInitialized = true;
    }

    protected abstract boolean modelCanBeAccepted(@Nullable DbmModel var1);

    protected void initInternalState() {
    }

    protected void checkNotInitialized() {
        if (this.myInitialized) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
    }

    @NotNull
    protected abstract M createNewModel();

    @NotNull
    public M getModel() {
        M m = this.myModel;
        assert (m != null) : "The introspector is not initialized yet: model is not created";
        M m2 = m;
        if (m2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/BaseIntrospector", "getModel"));
        }
        return m2;
    }

    protected boolean isPossibleToIntrospectSchemaIncrementally(@NotNull S schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/BaseIntrospector", "isPossibleToIntrospectSchemaIncrementally"));
        }
        return ((DbmSchema)schema).getIntrospectionTimestamp() != null;
    }

    @Override
    public void setOptions(@NotNull IntrospectionOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/dbm/common/BaseIntrospector", "setOptions"));
        }
        this.myOptions = options;
    }

    @Override
    public void setProgressIndicator(@Nullable ProgressIndicator progressIndicator) {
        this.myProgressIndicator = progressIndicator != null ? progressIndicator : DumbProgressIndicator.INSTANCE;
    }

    @Override
    public void introspectAuto(DbmNamespace ... namespaces) {
        if (!this.myInitialized) {
            throw new IllegalStateException("Introspector is not initialized yet.");
        }
        assert (this.myModel != null);
        this.myFacade.inTransaction(tran -> this.introspectAuto(tran, namespaces));
    }

    protected abstract void introspectAuto(@NotNull DBTransaction var1, DbmNamespace[] var2);

    @Override
    public void introspectNamespaces() {
        if (!this.myInitialized) {
            throw new IllegalStateException("Introspector is not initialized yet.");
        }
        assert (this.myModel != null);
        this.myFacade.inTransaction(this::introspectNamespaces);
    }

    protected abstract void introspectNamespaces(@NotNull DBTransaction var1);

    @Override
    public void introspectSessionState() {
        if (!this.myInitialized) {
            throw new IllegalStateException("Introspector is not initialized yet.");
        }
        assert (this.myModel != null);
        this.myFacade.inTransaction(this::introspectSessionState);
    }

    protected void introspectSessionState(@NotNull DBTransaction tran) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector", "introspectSessionState"));
        }
    }

    @Override
    public void introspectFragment(@NotNull DbmNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/dbm/common/BaseIntrospector", "introspectFragment"));
        }
        if (objectKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectKind", "com/intellij/dbm/common/BaseIntrospector", "introspectFragment"));
        }
        if (objectNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectNames", "com/intellij/dbm/common/BaseIntrospector", "introspectFragment"));
        }
    }

    protected void withModel(SimpleModelWorker<M> worker) {
        ((DbmModel)this.myModel).startModifications();
        try {
            worker.working(this.myModel);
        }
        finally {
            ((DbmModel)this.myModel).finishModifications();
        }
    }

    protected void postIntrospectionProcess() {
        this.withModel(this::postIntrospectionProcess);
    }

    protected void postIntrospectionProcess(M model) {
        for (DbmSchema schema : ((DbmModel)model).getAllSchemas()) {
            IntrospectionUtil.derefAll(schema);
        }
    }

    protected void updateStatus(@NotNull String status, @NotNull String details) {
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "status", "com/intellij/dbm/common/BaseIntrospector", "updateStatus"));
        }
        if (details == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "details", "com/intellij/dbm/common/BaseIntrospector", "updateStatus"));
        }
        this.myProgressIndicator.checkCanceled();
        this.myProgressIndicator.setText(status);
        this.myProgressIndicator.setText2(StringUtil.capitalize((String)Case.LOWER.apply(details)));
    }

    @Contract(value="null->false", pure=true)
    private static boolean stringToBoolean(@Nullable String str) {
        if (str == null) {
            return false;
        }
        String s = str.toLowerCase(Locale.ROOT);
        return s.equals("true") || s.equals("yes") || s.equals("1") || s.equals("+");
    }

    protected static void dropUnexistentObjects(Family<? extends DbmObject> family, TIntHashSet existentObjectIds) {
        if (family.isEmpty()) {
            return;
        }
        ImmutableList<? extends DbmObject> objects = family.asList();
        for (int i = objects.size() - 1; i >= 0; --i) {
            DbmObject object = (DbmObject)objects.get(i);
            int id = (int)object.getObjectId();
            if (existentObjectIds.contains(id)) continue;
            object.drop();
        }
    }

    protected abstract class SchemaRetriever
    implements Evaluator {
        @Nullable
        protected final DBTransaction myTransaction;
        protected final S schema;
        protected IntrospectionMode myMode;
        @Deprecated
        protected boolean incremental;
        protected boolean myWithSources;
        @NotNull
        protected ObjectKind myFragmentKind;
        @NotNull
        protected String[] myFragmentNames;
        @NotNull
        protected final Timestamp fromTimestamp;
        protected Timestamp introspectionBeginTimestamp;
        protected final Map<String, Object> myQueryParameters;
        protected final CommonPreprocessor myPreprocessor;
        final /* synthetic */ BaseIntrospector this$0;

        @Deprecated
        public SchemaRetriever(S schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "<init>"));
            }
            this(this$0, null, (DbmSchema)schema);
        }

        public SchemaRetriever(@NotNull DBTransaction transaction, S schema) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "<init>"));
            }
            this(this$0, transaction, (DbmSchema)schema, ((DbmObject)schema).hasChildren() && this$0.isPossibleToIntrospectSchemaIncrementally(schema) ? IntrospectionMode.INCREMENT : IntrospectionMode.FULL);
        }

        public SchemaRetriever(@NotNull DBTransaction transaction, @NotNull S schema, IntrospectionMode mode) {
            if (schema == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "<init>"));
            }
            if (mode == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "mode", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "<init>"));
            }
            this.this$0 = this$0;
            this.myWithSources = false;
            this.myFragmentKind = ObjectKind.NONE;
            this.myFragmentNames = ArrayUtil.EMPTY_STRING_ARRAY;
            this.myQueryParameters = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            this.myPreprocessor = new CommonPreprocessor(true, this);
            this.myTransaction = transaction;
            this.schema = schema;
            this.myMode = mode;
            this.incremental = mode.increment;
            this.myWithSources = false;
            Date lastIntrospectionTimestamp = ((DbmSchema)schema).getIntrospectionTimestamp();
            this.fromTimestamp = mode.increment && lastIntrospectionTimestamp != null ? new Timestamp(lastIntrospectionTimestamp.getTime()) : AGES_AGO;
            this.myQueryParameters.putAll(this$0.myQueryParameters);
            this.setQueryParameter("SCHEMA_NAME", ((DbmObject)schema).getNameOrNull());
            this.setQueryParameter("SCHEMA_ID", ((DbmObject)schema).getObjectId() != 0L ? Long.valueOf(((DbmObject)schema).getObjectId()) : null);
            this.setQueryParameter(this.myMode.code, Boolean.TRUE);
            this.setQueryParameter("SINCE", this.fromTimestamp);
        }

        protected void setQueryParameter(String name, Object value) {
            if (value != null) {
                this.myQueryParameters.put(name, value);
            } else {
                this.myQueryParameters.remove(name);
            }
        }

        @Override
        @Nullable
        public Object evaluate(@NotNull String expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "evaluate"));
            }
            return this.myQueryParameters.get(expression);
        }

        public void process() {
            this.processPreliminaryPhase();
            this.processMainPhase();
        }

        protected <R> R performQuery(@NotNull DBTransaction tran, @NotNull SqlQuery<R> query) {
            if (tran == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "performQuery"));
            }
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "performQuery"));
            }
            SqlQuery preprocessedQuery = query.rewrite((StringOperator)this.myPreprocessor);
            return (R)tran.query(preprocessedQuery).withParams(this.myPreprocessor.getBindableParameters()).run();
        }

        public void processPreliminaryPhase() {
            if (((DbmObject)this.schema).isDropped() || this.myMode.fragment) {
                return;
            }
            this.work(new InTransactionNoResult(){

                public void run(@NotNull DBTransaction tran) {
                    if (tran == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever$1", "run"));
                    }
                    SchemaRetriever.this.analyzeBriefInfo(tran);
                }
            });
            if (this.myMode.increment) {
                this.work(this::analyzeCurrentContent);
            } else {
                this.work(this::clearSchema);
                this.work(this::retrieveMajorNames);
            }
        }

        public void processMainPhase() {
            if (((DbmObject)this.schema).isDropped()) {
                return;
            }
            this.work(new InTransactionNoResult(){

                public void run(@NotNull DBTransaction tran) {
                    if (tran == null) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever$2", "run"));
                    }
                    SchemaRetriever.this.retrieveMainContent(tran);
                }
            });
        }

        protected void work(@NotNull Runnable runnable) {
            if (runnable == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "runnable", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "work"));
            }
            ((DbmSchema)this.schema).model.startModifications();
            try {
                runnable.run();
            }
            finally {
                ((DbmSchema)this.schema).model.finishModifications();
            }
        }

        protected void work(@NotNull InTransactionNoResult block) {
            if (block == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "block", "com/intellij/dbm/common/BaseIntrospector$SchemaRetriever", "work"));
            }
            ((DbmSchema)this.schema).model.startModifications();
            try {
                if (this.myTransaction != null) {
                    block.run(this.myTransaction);
                } else {
                    this.this$0.myFacade.inTransaction(block);
                }
            }
            finally {
                ((DbmSchema)this.schema).model.finishModifications();
            }
        }

        protected abstract void analyzeBriefInfo(@NotNull DBTransaction var1);

        protected abstract void analyzeCurrentContent(@NotNull DBTransaction var1);

        protected abstract void retrieveMajorNames(@NotNull DBTransaction var1);

        protected abstract void retrieveMainContent(@NotNull DBTransaction var1);

        protected void clearSchema() {
            for (Family family : ((DbmObject)this.schema).families()) {
                family.clear();
            }
        }
    }

    protected static abstract class DatabaseRetriever
    extends AbstractRetriever {
        final /* synthetic */ BaseIntrospector this$0;

        protected DatabaseRetriever(@NotNull DBTransaction transaction, M model) {
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/dbm/common/BaseIntrospector$DatabaseRetriever", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/BaseIntrospector$DatabaseRetriever", "<init>"));
            }
            this.this$0 = this$0;
            super((BaseIntrospector)this$0, transaction, model);
        }
    }

    protected static abstract class AbstractRetriever
    implements Evaluator {
        @NotNull
        private final DBTransaction myTransaction;
        @NotNull
        private final M myModel;
        @NotNull
        protected final NavigableMap<String, Object> myQueryParameters;
        @NotNull
        protected final CommonPreprocessor myPreprocessor;
        final /* synthetic */ BaseIntrospector this$0;

        public AbstractRetriever(@NotNull DBTransaction transaction, M model) {
            if (transaction == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "transaction", "com/intellij/dbm/common/BaseIntrospector$AbstractRetriever", "<init>"));
            }
            if (model == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/BaseIntrospector$AbstractRetriever", "<init>"));
            }
            this.this$0 = this$0;
            this.myTransaction = transaction;
            this.myModel = model;
            this.myQueryParameters = new TreeMap<String, Object>(String.CASE_INSENSITIVE_ORDER);
            this.myQueryParameters.putAll(this$0.myQueryParameters);
            this.myPreprocessor = new CommonPreprocessor(true, this);
        }

        protected abstract void process();

        protected void setQueryParameter(String name, Object value) {
            if (value != null) {
                this.myQueryParameters.put(name, value);
            } else {
                this.myQueryParameters.remove(name);
            }
        }

        @Override
        @Nullable
        public Object evaluate(@NotNull String expression) {
            if (expression == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/dbm/common/BaseIntrospector$AbstractRetriever", "evaluate"));
            }
            return this.myQueryParameters.get(expression);
        }

        protected <R> R performQuery(@NotNull SqlQuery<R> query) {
            if (query == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "query", "com/intellij/dbm/common/BaseIntrospector$AbstractRetriever", "performQuery"));
            }
            SqlQuery preprocessedQuery = query.rewrite((StringOperator)this.myPreprocessor);
            return (R)this.myTransaction.query(preprocessedQuery).withParams(this.myPreprocessor.getBindableParameters()).run();
        }

        protected void withModel(SimpleModelWorker<M> worker) {
            ((DbmModel)this.myModel).startModifications();
            try {
                worker.working(this.myModel);
            }
            finally {
                ((DbmModel)this.myModel).finishModifications();
            }
        }

        protected void reportRetrieving(@NotNull String what) {
            if (what == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "what", "com/intellij/dbm/common/BaseIntrospector$AbstractRetriever", "reportRetrieving"));
            }
            this.this$0.updateStatus("Introspecting database", what);
        }
    }

    protected static interface SimpleModelWorker<M extends DbmModel> {
        public void working(M var1);
    }
}

