/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.PropertyHolder;
import com.intellij.openapi.util.text.StringUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DbmElement {
    @NotNull
    protected final DbmModel<?> model;
    private static final ImmutableSet<String> EMPTY_STRING_SET = ImmutableSet.of();

    protected DbmElement(@NotNull DbmModel<?> model) {
        if (model == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "model", "com/intellij/dbm/common/DbmElement", "<init>"));
        }
        this.model = model;
    }

    @NotNull
    public abstract String identity();

    @NotNull
    public abstract String identity(boolean var1);

    @NotNull
    public String description(boolean includeSurrogates) {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmElement", "description"));
        }
        return "";
    }

    @NotNull
    public final DbmModel<?> getModel() {
        DbmModel<?> dbmModel = this.model;
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmElement", "getModel"));
        }
        return dbmModel;
    }

    abstract void modifying();

    public ImmutableMap<String, Object> getState(boolean surrogates) {
        ImmutableMap.Builder stateBuilder = ImmutableMap.builder();
        this.collectState((ImmutableMap.Builder<String, Object>)stateBuilder, surrogates);
        return stateBuilder.build();
    }

    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmElement", "collectState"));
        }
    }

    protected void putState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, @NotNull String fieldName, boolean value) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmElement", "putState"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/dbm/common/DbmElement", "putState"));
        }
        if (value) {
            stateBuilder.put((Object)fieldName, (Object)Boolean.TRUE);
        }
    }

    protected void putState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, @NotNull String fieldName, @Nullable Number value) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmElement", "putState"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/dbm/common/DbmElement", "putState"));
        }
        if (value != null && value.longValue() != 0L) {
            stateBuilder.put((Object)fieldName, (Object)value);
        }
    }

    protected void putState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, @NotNull String fieldName, @Nullable String value) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmElement", "putState"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/dbm/common/DbmElement", "putState"));
        }
        if (value == null) {
            return;
        }
        String theValue = value.trim();
        if (theValue.length() == 0) {
            return;
        }
        stateBuilder.put((Object)fieldName, (Object)theValue);
    }

    protected void putState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, @NotNull String fieldName, @Nullable Collection<String> value) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmElement", "putState"));
        }
        if (fieldName == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "fieldName", "com/intellij/dbm/common/DbmElement", "putState"));
        }
        if (value == null || value.isEmpty()) {
            return;
        }
        StringBuilder b = new StringBuilder();
        for (String item : value) {
            if (b.length() > 0) {
                b.append(',');
            }
            b.append(item.trim());
        }
        if (b.length() == 0) {
            return;
        }
        stateBuilder.put((Object)fieldName, (Object)b.toString());
    }

    static String nns(@Nullable String str1, @Nullable String str2) {
        return str1 != null && str2 != null ? str1 + str2 : "";
    }

    static String nns(boolean additionalCondition, @Nullable String str1, @Nullable String str2) {
        return additionalCondition && str1 != null && str2 != null ? str1 + str2 : "";
    }

    public final class NameSet
    implements PropertyHolder,
    Iterable<String> {
        private final AtomicReference<ImmutableSet<String>> myNames = new AtomicReference<ImmutableSet>(DbmElement.access$000());

        @NotNull
        public Set<String> get() {
            Set set = (Set)this.myNames.get();
            if (set == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmElement$NameSet", "get"));
            }
            return set;
        }

        public void set(@Nullable Collection<String> names) {
            if (names == null || names.isEmpty()) {
                this.clearState();
                return;
            }
            DbmElement.this.modifying();
            this.myNames.set((ImmutableSet<String>)ImmutableSet.copyOf(names));
        }

        public void add(@NotNull String name) {
            ImmutableSet neo;
            ImmutableSet<String> old;
            boolean ok;
            if (name == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/dbm/common/DbmElement$NameSet", "add"));
            }
            DbmElement.this.modifying();
            do {
                if (!(old = this.myNames.get()).contains((Object)name)) continue;
                return;
            } while (!(ok = this.myNames.compareAndSet(old, (ImmutableSet<String>)(neo = ImmutableSet.builder().addAll(old).add((Object)name).build()))));
        }

        @Override
        public void clearState() {
            if (this.myNames.get().isEmpty()) {
                return;
            }
            DbmElement.this.modifying();
            this.myNames.set((ImmutableSet<String>)EMPTY_STRING_SET);
        }

        @Override
        public String exportState() {
            ImmutableSet<String> names = this.myNames.get();
            if (names.isEmpty()) {
                return null;
            }
            return StringUtil.join(names, (String)", ");
        }

        @Override
        public void importState(@Nullable String text) {
            if (text == null) {
                this.clearState();
                return;
            }
            List strings = StringUtil.splitHonorQuotes((String)text, (char)',');
            ArrayList<String> names = new ArrayList<String>();
            for (String s : strings) {
                String s1;
                if (s == null || (s1 = s.trim()).isEmpty() || names.contains(s1)) continue;
                names.add(s1);
            }
            this.set(names);
        }

        public String toString() {
            return this.exportState();
        }

        @Override
        public Iterator<String> iterator() {
            return this.myNames.get().iterator();
        }
    }
}

