/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.database.model.DasArgument;
import com.intellij.database.model.DasInnerRoutine;
import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmArgument;
import com.intellij.dbm.common.DbmComplex;
import com.intellij.dbm.common.DbmComplexElement;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.NaturalPositioned;
import com.intellij.dbm.common.StateProperty;
import com.intellij.util.Numbers;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmInnerRoutine
extends DbmComplexElement
implements DbmRoutine,
NaturalPositioned,
DasInnerRoutine {
    @NotNull
    final Family<DbmArgument> myArguments;
    @StateProperty
    public DasRoutine.Kind myRoutineKind;
    @StateProperty
    public boolean myDeterministic;
    private short myPosition;

    public DbmInnerRoutine(@NotNull DbmComplex parent, @Nullable String name) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/intellij/dbm/common/DbmInnerRoutine", "<init>"));
        }
        super(parent, name);
        this.myRoutineKind = DasRoutine.Kind.NONE;
        this.myArguments = Family.of(this, ObjectKind.ARGUMENT);
        this.assignFamilies(this.myArguments);
    }

    @NotNull
    public Family<DbmArgument> arguments() {
        Family<DbmArgument> family = this.myArguments;
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmInnerRoutine", "arguments"));
        }
        return family;
    }

    @Override
    @NotNull
    public ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.ROUTINE;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmInnerRoutine", "kind"));
        }
        return objectKind;
    }

    @Override
    @NotNull
    public DbmSchema schema() {
        DbmSchema dbmSchema = this.parent().schema();
        if (dbmSchema == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmInnerRoutine", "schema"));
        }
        return dbmSchema;
    }

    @Override
    public short getPosition() {
        return this.myPosition;
    }

    @Override
    public void setPosition(short position) {
        if (this.myPosition == position) {
            return;
        }
        this.modifying();
        this.myPosition = position;
    }

    @Override
    @NotNull
    protected String calculateDisplayOrder() {
        String string = Numbers.toFixLengthNumber(this.getPosition(), 3);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmInnerRoutine", "calculateDisplayOrder"));
        }
        return string;
    }

    @Override
    @NotNull
    public DasRoutine.Kind getRoutineKind() {
        DasRoutine.Kind kind = this.myRoutineKind;
        if (kind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmInnerRoutine", "getRoutineKind"));
        }
        return kind;
    }

    @Override
    public void setRoutineKind(@NotNull DasRoutine.Kind routineKind) {
        if (routineKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "routineKind", "com/intellij/dbm/common/DbmInnerRoutine", "setRoutineKind"));
        }
        if (this.myRoutineKind == routineKind) {
            return;
        }
        this.modifying();
        this.myRoutineKind = routineKind;
    }

    @Override
    @Nullable
    public DbmArgument getReturnArgument() {
        for (DbmArgument argument : this.myArguments) {
            DasArgument.Direction direction = argument.getDirection();
            if (direction != DasArgument.Direction.RETURN && direction != DasArgument.Direction.RESULT) continue;
            return argument;
        }
        return null;
    }

    @Override
    @NotNull
    public DbmArgument getOrCreateReturnArgument() {
        DbmArgument r = this.getReturnArgument();
        if (r == null) {
            r = this.myArguments.create(null);
            r.setDirection(DasArgument.Direction.RETURN);
            this.myArguments.move(r, 0);
        } else {
            r.resetSyncPending();
        }
        this.setRoutineKind(DasRoutine.Kind.FUNCTION);
        DbmArgument dbmArgument = r;
        if (dbmArgument == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmInnerRoutine", "getOrCreateReturnArgument"));
        }
        return dbmArgument;
    }

    @Override
    public boolean isDeterministic() {
        return this.myDeterministic;
    }

    @Override
    public void setDeterministic(boolean deterministic) {
        if (this.myDeterministic == deterministic) {
            return;
        }
        this.modifying();
        this.myDeterministic = deterministic;
    }

    @Nullable
    public String getPackage() {
        return this.parent().getName();
    }

    @NotNull
    public Iterable<? extends DasArgument> getArguments() {
        Family<DbmArgument> family = this.arguments();
        if (family == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmInnerRoutine", "getArguments"));
        }
        return family;
    }
}

