/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.google.common.collect.ImmutableMap;
import com.intellij.database.model.DasTableKey;
import com.intellij.database.model.ObjectKind;
import com.intellij.dbm.common.DbmConstraint;
import com.intellij.dbm.common.DbmIndex;
import com.intellij.dbm.common.DbmLikeColumn;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.DomOrderedObjectsRef;
import com.intellij.dbm.common.ObjectRef;
import com.intellij.dbm.common.StateProperty;
import com.intellij.openapi.util.text.StringUtil;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DbmKey
extends DbmConstraint
implements DasTableKey {
    @StateProperty
    public final ObjectRef<DbmKey, DbmIndex> myUnderlyingIndex;
    @StateProperty
    public boolean myPrimary;

    public DbmKey(@NotNull DbmLikeTable table, @Nullable String name) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmKey", "<init>"));
        }
        super(table, name);
        this.myUnderlyingIndex = new ObjectRef<DbmKey, DbmIndex>(this, table.indices());
    }

    @Override
    protected DomObjectsRef<DbmLikeColumn> createColumnsRef(@NotNull DbmLikeTable table) {
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/common/DbmKey", "createColumnsRef"));
        }
        return new DomOrderedObjectsRef<DbmLikeColumn>(this, table.columnResolver);
    }

    @Override
    @NotNull
    public final ObjectKind kind() {
        ObjectKind objectKind = ObjectKind.KEY;
        if (objectKind == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmKey", "kind"));
        }
        return objectKind;
    }

    @Override
    protected char getConstraintKindOrderPrefix() {
        return this.myPrimary ? (char)'1' : '2';
    }

    @Override
    @NotNull
    public String identity() {
        if (this.myPrimary) {
            if ("primary_key" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmKey", "identity"));
            }
            return "primary_key";
        }
        String string = "key(" + this.myColumns.toString() + ")";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmKey", "identity"));
        }
        return string;
    }

    @Override
    @NotNull
    public String description(boolean includeSurrogates) {
        StringBuilder b = new StringBuilder(80);
        b.append(this.myPrimary ? "PK " : "AK ");
        List<String> columnNames = this.myColumns.namesOrdered();
        int size = columnNames.size();
        for (int i = 0; i < size; ++i) {
            String columnName = columnNames.get(i);
            b.append(i == 0 ? "(" : ", ");
            b.append(columnName);
        }
        b.append(')');
        DbmIndex underlyingIndex = this.getUnderlyingIndex();
        if (underlyingIndex != null) {
            b.append(" (underlying index ").append(underlyingIndex.identity(includeSurrogates)).append(')');
        }
        String string = b.toString();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmKey", "description"));
        }
        return string;
    }

    @Nullable
    public DbmIndex getUnderlyingIndex() {
        return this.myUnderlyingIndex.resolveObject();
    }

    public void setUnderlyingIndex(@Nullable DbmIndex underlyingIndex) {
        if (underlyingIndex != null) {
            if (!this.table.indices().contains(underlyingIndex)) {
                throw new IllegalArgumentException("Alien index");
            }
            this.myUnderlyingIndex.set(underlyingIndex);
        } else {
            this.myUnderlyingIndex.clearState();
        }
    }

    public boolean isClustering() {
        DbmIndex index = this.myUnderlyingIndex.resolveObject();
        if (index != null) {
            return index.isClustering();
        }
        return false;
    }

    public boolean isPrimary() {
        return this.myPrimary;
    }

    public void setPrimary(boolean primary) {
        this.myPrimary = primary;
    }

    public boolean isIndexCustomized() {
        return false;
    }

    @NotNull
    public List<String> listColumnNames() {
        List<String> list = this.myColumns.namesOrdered();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/common/DbmKey", "listColumnNames"));
        }
        return list;
    }

    public boolean isExactlyByColumns(String ... columnNames) {
        int n = columnNames.length;
        if (n == 0) {
            return false;
        }
        List<String> names = this.myColumns.namesOrdered();
        if (names.size() != n) {
            return false;
        }
        for (int i = 0; i < n; ++i) {
            if (StringUtil.equals((CharSequence)names.get(i), (CharSequence)columnNames[i])) continue;
            return false;
        }
        return true;
    }

    @Override
    protected void collectState(@NotNull ImmutableMap.Builder<String, Object> stateBuilder, boolean surrogates) {
        if (stateBuilder == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "stateBuilder", "com/intellij/dbm/common/DbmKey", "collectState"));
        }
        super.collectState(stateBuilder, surrogates);
        DbmIndex index = this.myUnderlyingIndex.resolveObject();
        if (index != null) {
            this.putState(stateBuilder, "index", index.identity());
        }
        this.putState(stateBuilder, "primary", this.myPrimary);
    }

    @Override
    public String toString() {
        return super.toString() + (this.myPrimary ? ": [PK] " : ": [AK] ") + this.myColumns.toString();
    }
}

