/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.DbmNamedObject;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DomObjectsRef;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.Resolver;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class DomEnsembleObjectsRef<T extends DbmNamedObject>
extends DomObjectsRef<T> {
    public DomEnsembleObjectsRef(@NotNull DbmObject owner, @NotNull Resolver<? extends T> resolver) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/dbm/common/DomEnsembleObjectsRef", "<init>"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "resolver", "com/intellij/dbm/common/DomEnsembleObjectsRef", "<init>"));
        }
        super(owner, resolver);
    }

    @Override
    public Set<String> names() {
        if (this.isEmpty()) {
            return Collections.emptySet();
        }
        TreeSet<String> names = new TreeSet<String>();
        this.retrieveNamesAsIs(names);
        return names;
    }

    @Override
    public List<String> namesOrdered() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<String> names = new ArrayList<String>(this.size());
        if (this.myResolver instanceof Family) {
            Collection refNames = this.names();
            Family family = (Family)this.myResolver;
            for (DbmObject object : family) {
                String name = object.getNameOrNull();
                if (name == null || !refNames.contains(name)) continue;
                names.add(name);
            }
        } else {
            this.retrieveNamesAsIs(names);
        }
        return names;
    }

    @Override
    public List<T> resolveObjects() {
        if (this.isEmpty()) {
            return Collections.emptyList();
        }
        this.resolveAll();
        ArrayList<DbmObject> objects = new ArrayList<DbmObject>(this.size());
        if (this.myResolver instanceof Family) {
            ArrayList refObjects = new ArrayList(this.size());
            this.retrieveResolvedObjectsAsIs(refObjects);
            Family family = (Family)this.myResolver;
            for (DbmObject object : family) {
                if (!refObjects.contains(object)) continue;
                objects.add(object);
            }
        } else {
            this.retrieveResolvedObjectsAsIs(objects);
        }
        return objects;
    }

    @Override
    @Nullable
    public String firstName() {
        switch (this.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return super.firstName();
            }
        }
        throw new IllegalStateException("The domestic ensemble includes several names and we don't know which of them is first.");
    }
}

