/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.common;

import com.intellij.dbm.common.BaseIntrospector;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.DbmSingleDatabaseModel;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBTransaction;

public abstract class SingleDatabaseIntrospector<S extends DbmSchema, M extends DbmSingleDatabaseModel<S>>
extends BaseIntrospector<S, M> {
    public SingleDatabaseIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/common/SingleDatabaseIntrospector", "<init>"));
        }
        super(facade);
    }

    @Override
    protected void introspectAuto(@NotNull DBTransaction tran, DbmNamespace[] namespaces) {
        if (tran == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tran", "com/intellij/dbm/common/SingleDatabaseIntrospector", "introspectAuto"));
        }
        ArrayList<DbmSchema> schemas = new ArrayList<DbmSchema>();
        if (namespaces == null || namespaces.length == 0) {
            this.introspectNamespaces(tran);
            this.introspectSessionState(tran);
            for (DbmSchema schema : ((DbmSingleDatabaseModel)this.myModel).schemas()) {
                if (!schema.isVisible()) continue;
                schemas.add(schema);
            }
        } else {
            for (DbmNamespace namespace : namespaces) {
                assert (namespace.getModel() == this.myModel);
                assert (namespace instanceof DbmSchema);
                DbmSchema schema = (DbmSchema)namespace;
                schemas.add(schema);
            }
        }
        if (!schemas.isEmpty()) {
            this.introspectAuto(tran, schemas);
        }
        this.postIntrospectionProcess();
    }

    protected abstract void introspectAuto(@NotNull DBTransaction var1, @NotNull List<S> var2);
}

