/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic;

import com.intellij.database.model.DasRoutine;
import com.intellij.database.model.ObjectKind;
import com.intellij.database.util.DasUtil;
import com.intellij.database.util.ErrorHandler;
import com.intellij.database.util.JdbcUtil;
import com.intellij.dbm.common.DBIntrospectionError;
import com.intellij.dbm.common.DBIntrospector;
import com.intellij.dbm.common.DbmDatabase;
import com.intellij.dbm.common.DbmLikeTable;
import com.intellij.dbm.common.DbmModel;
import com.intellij.dbm.common.DbmNamespace;
import com.intellij.dbm.common.DbmObject;
import com.intellij.dbm.common.DbmRoutine;
import com.intellij.dbm.common.DbmSchema;
import com.intellij.dbm.common.Family;
import com.intellij.dbm.common.IntrospectionOptions;
import com.intellij.dbm.factories.RdbmsDefinition;
import com.intellij.dbm.factories.RdbmsRegistry;
import com.intellij.dbm.factories.RdbmsServiceFactory;
import com.intellij.dbm.generic.GenericIntrospectorHelper;
import com.intellij.dbm.generic.legacy.TableType;
import com.intellij.dbm.generic.meta.ClosableIt;
import com.intellij.dbm.generic.meta.DatabaseMetaDataWrapper;
import com.intellij.dbm.generic.meta.MetaDataUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.progress.DumbProgressIndicator;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.Conditions;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.containers.JBTreeTraverser;
import com.intellij.util.containers.MultiMap;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.dekaf.core.ConnectionInfo;
import org.jetbrains.dekaf.core.DBFacade;
import org.jetbrains.dekaf.core.DBSession;

public class GenericIntrospector
implements DBIntrospector {
    private final DBFacade myFacade;
    private ProgressIndicator myIndicator;
    private final ErrorHandler myErrorHandler;
    private String[] myTableTypes;
    private Set<ObjectKind> myTableKinds;
    private GenericIntrospectorHelper myHelper;
    private ConnectionInfo myInfo;

    public GenericIntrospector(@NotNull DBFacade facade) {
        if (facade == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "facade", "com/intellij/dbm/generic/GenericIntrospector", "<init>"));
        }
        this.myIndicator = DumbProgressIndicator.INSTANCE;
        this.myErrorHandler = new ErrorHandler();
        this.myFacade = facade;
    }

    @Override
    public void init(@Nullable DbmModel model) {
        if (this.myHelper != null) {
            throw new IllegalStateException(this.getClass().getSimpleName() + " already initialized");
        }
        RdbmsDefinition def = RdbmsRegistry.instance().getDefinitionByRdbms(this.myFacade.rdbms());
        if (model == null || !def.modelClass.isAssignableFrom(model.getClass())) {
            model = RdbmsServiceFactory.instance().createModel(def.rdbms);
        }
        this.myHelper = new GenericIntrospectorHelper(model, def.rdbms);
        this.myInfo = this.myFacade.getConnectionInfo();
    }

    @Override
    public void setOptions(@NotNull IntrospectionOptions options) {
        if (options == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "options", "com/intellij/dbm/generic/GenericIntrospector", "setOptions"));
        }
    }

    @Override
    @NotNull
    public DbmModel getModel() {
        DbmModel<?> dbmModel = this.myHelper.getModel();
        if (dbmModel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospector", "getModel"));
        }
        return dbmModel;
    }

    @Override
    public void setProgressIndicator(@Nullable ProgressIndicator indicator) {
        this.myIndicator = indicator != null ? indicator : DumbProgressIndicator.INSTANCE;
    }

    @Override
    public void introspectAuto(DbmNamespace ... namespaces) {
        this.getModel().startModifications();
        try {
            this.myFacade.inSession(s -> {
                DatabaseMetaDataWrapper meta = this.createMeta(s);
                if (namespaces == null || namespaces.length == 0) {
                    this.introspectNamespaces(meta);
                }
                this.introspectSchemas(meta, (JBIterable<DbmSchema>)this.schemas(namespaces).filter(DbmNamespace::isVisible));
            });
        }
        finally {
            this.getModel().finishModifications();
        }
    }

    @Override
    public void introspectNamespaces() {
        this.getModel().startModifications();
        try {
            this.myFacade.inSession(s -> this.introspectNamespaces(this.createMeta(s)));
        }
        finally {
            this.getModel().finishModifications();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void introspectSchemas(@NotNull DatabaseMetaDataWrapper meta, @NotNull JBIterable<DbmSchema> schemas) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectSchemas"));
        }
        if (schemas == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schemas", "com/intellij/dbm/generic/GenericIntrospector", "introspectSchemas"));
        }
        try {
            this.myTableTypes = meta.getAllTableTypes();
        }
        catch (SQLException e) {
            this.myErrorHandler.addError("Failed to retrieve table types", (Throwable)e);
            this.myTableTypes = ArrayUtil.EMPTY_STRING_ARRAY;
        }
        this.myTableKinds = JBIterable.of((Object[])this.myTableTypes).transform(x -> TableType.findByName(x).getKind()).toSet();
        MultiMap byCatalog = MultiMap.create();
        for (DbmSchema schema : schemas) {
            byCatalog.putValue((Object)this.myHelper.getCatalog(schema), (Object)schema);
        }
        String catalog = null;
        try {
            catalog = meta.getConnection().getCatalog();
            this.introspectSchemasByCatalogs(meta, (MultiMap<DbmNamespace, DbmSchema>)byCatalog);
        }
        catch (SQLException e) {
            this.myErrorHandler.addError("Failed to get current catalog", (Throwable)e);
        }
        finally {
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), (String)catalog);
        }
    }

    private void introspectSchemasByCatalogs(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<DbmNamespace, DbmSchema> byCatalog) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectSchemasByCatalogs"));
        }
        if (byCatalog == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "byCatalog", "com/intellij/dbm/generic/GenericIntrospector", "introspectSchemasByCatalogs"));
        }
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "lambda$introspectSchemasByCatalogs$3"));
            }
            this.introspectTablesInSchema(meta, (DbmSchema)s);
            this.introspectRoutinesInSchema(meta, (DbmSchema)s);
        });
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "lambda$introspectSchemasByCatalogs$5"));
            }
            this.introspectColumnsInSchema(meta, (DbmSchema)s);
            s.tables().forEach(t -> {
                if (meta == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "lambda$null$4"));
                }
                this.introspectTableKeys(meta, (DbmLikeTable)t);
            });
            this.introspectPrototypesInSchema(meta, (DbmSchema)s);
        });
        GenericIntrospector.forEachSchemaInCatalog(meta, byCatalog, s -> {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "lambda$introspectSchemasByCatalogs$8"));
            }
            s.tables().forEach(t -> {
                if (meta == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "lambda$null$6"));
                }
                this.introspectTableForeignKeys(meta, (DbmLikeTable)t);
            });
            s.tables().forEach(t -> {
                if (meta == null) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "lambda$null$7"));
                }
                this.introspectTableIndices(meta, (DbmLikeTable)t);
            });
        });
    }

    private static void forEachCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<DbmNamespace, DbmSchema> grouped, @NotNull Consumer<Iterable<DbmSchema>> process) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "forEachCatalog"));
        }
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/dbm/generic/GenericIntrospector", "forEachCatalog"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/dbm/generic/GenericIntrospector", "forEachCatalog"));
        }
        for (Map.Entry entry : grouped.entrySet()) {
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), entry.getKey() == null ? null : ((DbmNamespace)entry.getKey()).getName());
            process.accept((Iterable<DbmSchema>)entry.getValue());
        }
    }

    private static void forEachSchemaInCatalog(@NotNull DatabaseMetaDataWrapper meta, @NotNull MultiMap<DbmNamespace, DbmSchema> grouped, @NotNull Consumer<DbmSchema> process) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "forEachSchemaInCatalog"));
        }
        if (grouped == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "grouped", "com/intellij/dbm/generic/GenericIntrospector", "forEachSchemaInCatalog"));
        }
        if (process == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/dbm/generic/GenericIntrospector", "forEachSchemaInCatalog"));
        }
        GenericIntrospector.forEachCatalog(meta, grouped, ss -> {
            if (process == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "process", "com/intellij/dbm/generic/GenericIntrospector", "lambda$forEachSchemaInCatalog$9"));
            }
            ss.forEach(process);
        });
    }

    private void introspectTablesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull DbmSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectTablesInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospector", "introspectTablesInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table list in " + MetaDataUtil.qName(schema));
        JBIterable<Family<? extends DbmObject>> families = this.getTableFamilies(schema);
        families.forEach(Family::markChildrenAsSyncPending);
        try (ClosableIt<? extends DatabaseMetaDataWrapper.Table> tableIt = meta.tables(this.myHelper.asSchema(schema), null, this.myTableTypes);){
            for (DatabaseMetaDataWrapper.Table table : JBIterable.once(tableIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createTable(schema, table);
            }
        }
        catch (SQLException e) {
            this.myErrorHandler.addError("Failed to retrieve tables in " + MetaDataUtil.qName(schema), (Throwable)e);
        }
        families.forEach(GenericIntrospector::cleanupFamily);
    }

    @NotNull
    private JBIterable<Family<? extends DbmObject>> getTableFamilies(@NotNull DbmSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospector", "getTableFamilies"));
        }
        JBIterable jBIterable = JBIterable.from(schema.families()).filter(x -> this.myTableKinds.contains(x.getChildKind()));
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospector", "getTableFamilies"));
        }
        return jBIterable;
    }

    private void introspectTableKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull DbmLikeTable table) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectTableKeys"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospector", "introspectTableKeys"));
        }
        if (table.getKind() != ObjectKind.TABLE) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Keys in " + MetaDataUtil.qName(table));
        table.keys().markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableKey, DatabaseMetaDataWrapper.TableKeyColumn> keyIt = meta.tableKeys(this.myHelper.asTable(table));){
            this.myHelper.createKeys(table, keyIt);
        }
        catch (Exception ex) {
            this.myErrorHandler.addError(MetaDataUtil.qName(table), (Throwable)ex);
        }
        GenericIntrospector.cleanupFamily(table.keys());
    }

    private void introspectTableForeignKeys(@NotNull DatabaseMetaDataWrapper meta, @NotNull DbmLikeTable table) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectTableForeignKeys"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospector", "introspectTableForeignKeys"));
        }
        if (table.getKind() != ObjectKind.TABLE) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Foreign keys in " + MetaDataUtil.qName(table));
        table.foreignKeys().markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableFKey, DatabaseMetaDataWrapper.TableFKeyColumn> fkColumnIt = meta.tableFKeyColumns(this.myHelper.asTable(table));){
            this.myHelper.createForeignKeys(table, fkColumnIt);
        }
        catch (Exception ex) {
            this.myErrorHandler.addError(MetaDataUtil.qName(table), (Throwable)ex);
        }
        GenericIntrospector.cleanupFamily(table.foreignKeys());
    }

    private void introspectTableIndices(@NotNull DatabaseMetaDataWrapper meta, @NotNull DbmLikeTable table) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectTableIndices"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/GenericIntrospector", "introspectTableIndices"));
        }
        if (table.getKind() != ObjectKind.TABLE) {
            return;
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Indices in " + MetaDataUtil.qName(table));
        table.indices().markChildrenAsSyncPending();
        try (ClosableIt.GroupingIt<DatabaseMetaDataWrapper.TableIndex, DatabaseMetaDataWrapper.TableIndexColumn> indexColumnIt = meta.tableIndexColumns(this.myHelper.asTable(table));){
            this.myHelper.createIndices(table, indexColumnIt);
        }
        catch (Exception ex) {
            this.myErrorHandler.addError(MetaDataUtil.qName(table), (Throwable)ex);
        }
        GenericIntrospector.cleanupFamily(table.indices());
    }

    private void introspectColumnsInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull DbmSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectColumnsInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospector", "introspectColumnsInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Table columns in " + MetaDataUtil.qName(schema));
        JBIterable tables = this.getTableFamilies(schema).flatten(Family::asList).filter(DbmLikeTable.class);
        HashMap name2Table = ContainerUtil.newHashMap();
        for (Object table : tables) {
            ((DbmLikeTable)table).columns().markChildrenAsSyncPending();
            name2Table.put(((DbmObject)table).getName(), table);
        }
        try {
            Object table;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn> columnIt = meta.tableColumns(this.myHelper.asSchema(schema), null, name2Table.keySet());
            table = null;
            try {
                for (DatabaseMetaDataWrapper.Table table2 : JBIterable.once(columnIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createColumns((DbmLikeTable)name2Table.get(table2.name), (Iterator<DatabaseMetaDataWrapper.TableColumn>)columnIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                table = throwable;
                throw throwable;
            }
            finally {
                if (columnIt != null) {
                    if (table != null) {
                        try {
                            columnIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)table).addSuppressed(throwable);
                        }
                    } else {
                        columnIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorHandler.addError(MetaDataUtil.qName(schema), (Throwable)e);
        }
        for (Object table : tables) {
            GenericIntrospector.cleanupFamily(((DbmLikeTable)table).columns());
        }
    }

    private void introspectPrototypesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull DbmSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectPrototypesInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospector", "introspectPrototypesInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Prototypes in " + MetaDataUtil.qName(schema));
        JBIterable<Family<?>> routineFamilies = this.getRoutineFamilies(schema);
        JBIterable routines = routineFamilies.flatten(Family::asList).filter(DbmRoutine.class);
        GenericIntrospectorHelper.RoutineMap map = this.myHelper.createRoutineMap();
        for (Object routine : routines) {
            routine.arguments().markChildrenAsSyncPending();
            map.put((DbmRoutine)routine);
        }
        try {
            Object routine;
            ClosableIt.GroupingIt<DatabaseMetaDataWrapper.Routine, DatabaseMetaDataWrapper.RoutineArgument> argumentIt = meta.routineArguments(this.myHelper.asSchema(schema), null, (Function<DatabaseMetaDataWrapper.Routine, DasRoutine.Kind>)((Function)map::guessType));
            routine = null;
            try {
                for (DatabaseMetaDataWrapper.Routine routine2 : JBIterable.once(argumentIt)) {
                    this.myIndicator.checkCanceled();
                    this.myHelper.createArguments(map.get(routine2), (Iterator<DatabaseMetaDataWrapper.RoutineArgument>)argumentIt.groupIt());
                }
            }
            catch (Throwable throwable) {
                routine = throwable;
                throw throwable;
            }
            finally {
                if (argumentIt != null) {
                    if (routine != null) {
                        try {
                            argumentIt.close();
                        }
                        catch (Throwable throwable) {
                            ((Throwable)routine).addSuppressed(throwable);
                        }
                    } else {
                        argumentIt.close();
                    }
                }
            }
        }
        catch (SQLException e) {
            this.myErrorHandler.addError(MetaDataUtil.qName(schema), (Throwable)e);
        }
        for (Object routine : routines) {
            GenericIntrospector.cleanupFamily(routine.arguments());
        }
        routineFamilies.forEach(Family::reorder);
    }

    private void introspectRoutinesInSchema(@NotNull DatabaseMetaDataWrapper meta, @NotNull DbmSchema schema) {
        if (meta == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectRoutinesInSchema"));
        }
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospector", "introspectRoutinesInSchema"));
        }
        this.myIndicator.checkCanceled();
        this.myIndicator.setText("Routine list in " + MetaDataUtil.qName(schema));
        JBIterable<Family<?>> routineFamilies = this.getRoutineFamilies(schema);
        routineFamilies.forEach(Family::markChildrenAsSyncPending);
        try (ClosableIt<DatabaseMetaDataWrapper.Routine> routineIt = meta.routines(this.myHelper.asSchema(schema), null, null);){
            for (DatabaseMetaDataWrapper.Routine routine : JBIterable.once(routineIt)) {
                this.myIndicator.checkCanceled();
                this.myHelper.createRoutine(schema, routine);
            }
        }
        catch (SQLException e) {
            this.myErrorHandler.addError("Failed to retrieve routines in " + MetaDataUtil.qName(schema), (Throwable)e);
        }
        routineFamilies.forEach(GenericIntrospector::cleanupFamily);
    }

    private void introspectNamespaces(@NotNull DatabaseMetaDataWrapper meta) {
        block17: {
            if (meta == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "meta", "com/intellij/dbm/generic/GenericIntrospector", "introspectNamespaces"));
            }
            try (ClosableIt<DatabaseMetaDataWrapper.Schema> schemaIt = meta.schemas(true);){
                Family root = this.getModel().getRootNamespaces();
                if (root.getChildKind() == ObjectKind.SCHEMA) {
                    this.fillSchemas((Iterator<DatabaseMetaDataWrapper.Schema>)((Object)schemaIt));
                    break block17;
                }
                if (root.getChildKind() == ObjectKind.DATABASE) {
                    this.fillDatabases((Iterator<DatabaseMetaDataWrapper.Schema>)((Object)schemaIt));
                    break block17;
                }
                throw new GenericIntrospectionException("Model does not contain database/schema namespace", null);
            }
            catch (SQLException e) {
                throw new GenericIntrospectionException("Failed to retrieve namespaces", e);
            }
        }
    }

    private void fillDatabases(Iterator<DatabaseMetaDataWrapper.Schema> schemaIt) {
        Family root = this.getModel().getRootNamespaces();
        root.markChildrenAsSyncPending();
        for (Family family : this.childFamilies(root, ObjectKind.SCHEMA)) {
            family.markChildrenAsSyncPending();
        }
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(schemaIt)) {
            this.myHelper.createSchema(schema);
        }
        DbmDatabase curDb = (DbmDatabase)JBIterable.from(root).filter(DbmDatabase.class).filter(this::isCurrent).first();
        if (curDb == null && root.size() == 1) {
            curDb = (DbmDatabase)root.get(0);
        }
        if (curDb != null) {
            curDb.setVisible(true);
            this.getModel().setCurrentRootNamespace(curDb);
            DbmSchema curSc = (DbmSchema)JBIterable.from(curDb.schemas()).filter(this::isCurrent).first();
            if (curSc != null) {
                curSc.setVisible(true);
                curDb.setCurrentSchema(curSc);
            } else if (ApplicationManager.getApplication().isUnitTestMode() && curDb.schemas().stream().noneMatch(DbmNamespace::isVisible)) {
                curDb.schemas().forEach(sc -> sc.setVisible(true));
            }
        }
        GenericIntrospector.cleanupFamily(root);
        this.childFamilies(root, ObjectKind.SCHEMA).forEach(GenericIntrospector::cleanupFamily);
    }

    private void fillSchemas(Iterator<DatabaseMetaDataWrapper.Schema> schemaIt) {
        Family root = this.getModel().getRootNamespaces();
        root.markChildrenAsSyncPending();
        for (DatabaseMetaDataWrapper.Schema schema : JBIterable.once(schemaIt)) {
            this.myHelper.createSchema(schema);
        }
        JBIterable schemas = JBIterable.from(root).filter(DbmSchema.class);
        DbmSchema curSc = (DbmSchema)schemas.filter(this::isCurrent).first();
        if (curSc != null) {
            curSc.setVisible(true);
            this.getModel().setCurrentRootNamespace(curSc);
        } else if (ApplicationManager.getApplication().isUnitTestMode() && schemas.filter(DbmNamespace::isVisible).isEmpty()) {
            schemas.forEach(sc -> sc.setVisible(true));
        }
        GenericIntrospector.cleanupFamily(root);
    }

    private boolean isCurrent(@Nullable DbmDatabase db) {
        if (db == null || this.myInfo == null) {
            return false;
        }
        return db.isName(this.myInfo.databaseName);
    }

    private boolean isCurrent(@Nullable DbmSchema sc) {
        if (sc == null || this.myInfo == null) {
            return false;
        }
        return this.myHelper.isSchemaDbMode() ? sc.isName(this.myInfo.databaseName) : sc.isName(this.myInfo.schemaName) || sc.isName(this.myInfo.userName);
    }

    @NotNull
    private DatabaseMetaDataWrapper createMeta(DBSession session) {
        DatabaseMetaDataWrapper databaseMetaDataWrapper;
        Connection connection = (Connection)session.getSpecificService(Connection.class, "jdbc-connection");
        if (connection == null) {
            throw new GenericIntrospectionException("Failed to get connection", null);
        }
        try {
            databaseMetaDataWrapper = DatabaseMetaDataWrapper.create(connection, connection.getMetaData(), this.myErrorHandler, this.myHelper.getFamilyId());
        }
        catch (SQLException e) {
            throw new GenericIntrospectionException("Failed to retrieve meta data", e);
        }
        if (databaseMetaDataWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospector", "createMeta"));
        }
        return databaseMetaDataWrapper;
    }

    @NotNull
    public JBIterable<DbmSchema> schemas(DbmNamespace ... roots) {
        JBTreeTraverser traverser = this.getModel().traverser();
        if (roots != null && roots.length != 0) {
            traverser = (JBTreeTraverser)traverser.withRoots((Iterable)JBIterable.of((Object[])roots));
        }
        JBIterable jBIterable = ((JBTreeTraverser)((JBTreeTraverser)traverser.expand(DasUtil.byKind((ObjectKind)ObjectKind.DATABASE))).filter(DasUtil.byKind((ObjectKind)ObjectKind.SCHEMA))).filter(DbmSchema.class);
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospector", "schemas"));
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<Family<?>> getRoutineFamilies(@NotNull DbmSchema schema) {
        if (schema == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "schema", "com/intellij/dbm/generic/GenericIntrospector", "getRoutineFamilies"));
        }
        JBIterable routineFamilies = JBIterable.of(schema.routines());
        Family<?> packages = schema.findFamilyByChildKind(ObjectKind.PACKAGE);
        if (packages != null) {
            JBIterable pkg = JBIterable.of(packages);
            routineFamilies = routineFamilies.append((Iterable)pkg).append((Iterable)pkg.flatten(Family::asList).transform(f -> f.findFamilyByChildKind(ObjectKind.ROUTINE)).filter(Conditions.notNull()));
        }
        JBIterable jBIterable = routineFamilies;
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospector", "getRoutineFamilies"));
        }
        return jBIterable;
    }

    @NotNull
    public JBIterable<Family<?>> childFamilies(@NotNull Family<?> family, @NotNull ObjectKind kind) {
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "family", "com/intellij/dbm/generic/GenericIntrospector", "childFamilies"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/generic/GenericIntrospector", "childFamilies"));
        }
        JBIterable jBIterable = JBIterable.from(family.asList()).transform(o -> {
            if (kind == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "kind", "com/intellij/dbm/generic/GenericIntrospector", "lambda$childFamilies$14"));
            }
            return o.findFamilyByChildKind(kind);
        }).filter(Conditions.notNull());
        if (jBIterable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/GenericIntrospector", "childFamilies"));
        }
        return jBIterable;
    }

    private static void cleanupFamily(Family f) {
        f.removeSyncPendingChildren();
        f.reorder();
    }

    @Override
    public void introspectSessionState() {
    }

    @Override
    public void introspectFragment(@NotNull DbmNamespace namespace, boolean withSources, @NotNull ObjectKind objectKind, String ... objectNames) {
        if (namespace == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "namespace", "com/intellij/dbm/generic/GenericIntrospector", "introspectFragment"));
        }
        if (objectKind == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectKind", "com/intellij/dbm/generic/GenericIntrospector", "introspectFragment"));
        }
        if (objectNames == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "objectNames", "com/intellij/dbm/generic/GenericIntrospector", "introspectFragment"));
        }
    }

    private static class GenericIntrospectionException
    extends DBIntrospectionError {
        public GenericIntrospectionException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

