/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic.meta;

import com.intellij.database.util.DbUtil;
import com.intellij.database.util.JdbcUtil;
import com.intellij.dbm.generic.meta.ClosableIt;
import com.intellij.dbm.generic.meta.DatabaseMetaDataWrapper;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.text.StringUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jetbrains.dekaf.core.BaseSession;
import org.jetbrains.dekaf.core.Layouts;
import org.jetbrains.dekaf.core.RowLayout;
import org.jetbrains.dekaf.intermediate.DBExceptionRecognizer;
import org.jetbrains.dekaf.intermediate.IntegralIntermediateSession;
import org.jetbrains.dekaf.jdbc.JdbcIntermediateSession;
import org.jetbrains.dekaf.jdbc.OracleExceptionRecognizer;
import org.jetbrains.dekaf.sql.SqlQuery;

public class SchemaLoader {
    private static final Logger LOG = Logger.getInstance(SchemaLoader.class);

    public static ClosableIt<String> catalogs(DatabaseMetaDataWrapper meta) throws SQLException {
        try {
            if (meta.getFamilyId().isMicrosoft()) {
                return SchemaLoader.mssqlCatalogs(meta);
            }
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
        }
        return SchemaLoader.jdbcCatalogs(meta);
    }

    private static ClosableIt<String> mssqlCatalogs(DatabaseMetaDataWrapper meta) throws SQLException {
        try (ClosableIt.AutoCloseableGuard<Statement> statement = new ClosableIt.AutoCloseableGuard<Statement>(meta.getConnection().createStatement());){
            ClosableIt.ResultSetDelegateIt<String> res = new ClosableIt.ResultSetDelegateIt<String>(statement.get().executeQuery("select name from master.sys.databases where has_dbaccess(name) = 1"), meta.getErrorHandler(), (AutoCloseable)statement.get()){

                @Override
                protected String calcValue() throws SQLException {
                    return this.myRs.getString("name", 1);
                }
            };
            statement.release();
            ClosableIt.ResultSetDelegateIt<String> resultSetDelegateIt = res;
            return resultSetDelegateIt;
        }
    }

    private static ClosableIt<String> jdbcCatalogs(DatabaseMetaDataWrapper meta) throws SQLException {
        return new ClosableIt.ResultSetDelegateIt<String>(meta.getMetaData().getCatalogs(), meta.getErrorHandler(), null){

            @Override
            protected String calcValue() throws SQLException {
                return this.myRs.getString("TABLE_CAT", 1);
            }
        };
    }

    public static ClosableIt<DatabaseMetaDataWrapper.Schema> schemas(Set<String> catalogs, String current, DatabaseMetaDataWrapper meta) {
        ClosableIt<DatabaseMetaDataWrapper.Schema> specific = null;
        if (meta.getFamilyId().isMicrosoft()) {
            specific = SchemaLoader.mssqlSchemas(catalogs.iterator(), meta);
        } else if (meta.getFamilyId().isOracle()) {
            specific = SchemaLoader.oracleSchemas(meta);
        }
        if (specific != null) {
            return ClosableIt.lazyAppendIfEmpty(specific, () -> SchemaLoader.jdbcSchemas(catalogs, current, meta));
        }
        return SchemaLoader.jdbcSchemas(catalogs, current, meta);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> oracleSchemas(DatabaseMetaDataWrapper meta) {
        try (JdbcIntermediateSession intermediateSession = new JdbcIntermediateSession(null, (DBExceptionRecognizer)OracleExceptionRecognizer.INSTANCE, meta.getConnection(), false){};){
            BaseSession session = new BaseSession((IntegralIntermediateSession)intermediateSession){};
            SqlQuery query = new SqlQuery("select username                                                       \nfrom sys.all_users U                                                  \nwhere exists (select 1 from sys.all_objects where owner = U.username) \n   or username = user                                                 \n   or username = sys_context('userenv','current_schema')              \n", Layouts.listOf((RowLayout)Layouts.oneOf(String.class)));
            List names = (List)session.query(query).run();
            names.add("PUBLIC");
            names.sort(StringUtil::naturalCompare);
            ClosableIt.DelegateIt<String, DatabaseMetaDataWrapper.Schema> delegateIt = new ClosableIt.DelegateIt<String, DatabaseMetaDataWrapper.Schema>(names.iterator()){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue(String schema) {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)schema), "*");
                }
            };
            return delegateIt;
        }
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> mssqlSchemas(Iterator<String> catalogs, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.mssqlSchemasInCatalog(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.mssqlSchemas(catalogs, meta));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> mssqlSchemasInCatalog(final String catalog, DatabaseMetaDataWrapper meta) {
        try (ClosableIt.AutoCloseableGuard<Statement> statement = new ClosableIt.AutoCloseableGuard<Statement>(meta.getConnection().createStatement());){
            ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema> res = new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(statement.get().executeQuery("select name from [" + catalog + "].sys.schemas"), meta.getErrorHandler(), (AutoCloseable)statement.get()){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)this.myRs.getString("name", 1)), catalog);
                }
            };
            statement.release();
            ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema> resultSetDelegateIt = res;
            return resultSetDelegateIt;
        }
        catch (SQLException e) {
            LOG.debug((Throwable)e);
            return ClosableIt.empty();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas(Set<String> catalogs, String current, DatabaseMetaDataWrapper meta) {
        Throwable throwable;
        try {
            throwable = null;
            try (ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>> it222 = new ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>>(SchemaLoader.jdbcSchemas1(catalogs.iterator(), meta));){
                if (it222.get().hasNext()) {
                    ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it222.release();
                    return closableIt;
                }
            }
            catch (Throwable throwable4) {
                throwable = throwable4;
                throw throwable4;
            }
        }
        catch (UnsupportedOperationException it222) {
        }
        catch (AbstractMethodError it222) {
            // empty catch block
        }
        throwable = null;
        try (ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>> it = new ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>>(SchemaLoader.jdbcSchemas2(catalogs.iterator(), current, meta));){
            JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), (String)current);
            if (it.get().hasNext()) {
                ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it.release();
                return closableIt;
            }
        }
        catch (Throwable throwable7) {
            throwable = throwable7;
            throw throwable7;
        }
        it = new ClosableIt.AutoCloseableGuard<ClosableIt<DatabaseMetaDataWrapper.Schema>>(SchemaLoader.jdbcSchemas3(catalogs, current, meta));
        throwable = null;
        try {
            if (it.get().hasNext()) {
                ClosableIt<DatabaseMetaDataWrapper.Schema> closableIt = it.release();
                return closableIt;
            }
        }
        catch (Throwable throwable9) {
            throwable = throwable9;
            throw throwable9;
        }
        finally {
            if (it != null) {
                if (throwable != null) {
                    try {
                        it.close();
                    }
                    catch (Throwable throwable10) {
                        throwable.addSuppressed(throwable10);
                    }
                } else {
                    it.close();
                }
            }
        }
        Set<String> cats = catalogs;
        if (!catalogs.isEmpty()) return new ClosableIt.DelegateIt<String, DatabaseMetaDataWrapper.Schema>(cats.iterator()){

            @Override
            protected DatabaseMetaDataWrapper.Schema calcValue(String catalog) {
                return new DatabaseMetaDataWrapper.Schema("", catalog);
            }
        };
        cats = Collections.singleton(null);
        return new /* invalid duplicate definition of identical inner class */;
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas3(final Set<String> catalogs, final String current, DatabaseMetaDataWrapper meta) {
        try {
            return new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(meta.getMetaData().getSchemas(), meta.getErrorHandler(), null){
                private Iterator<String> myCats;
                private DatabaseMetaDataWrapper.Schema myCur;
                {
                    super(rs, handler, hook);
                    this.myCats = null;
                    this.myCur = null;
                }

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    String schema = this.myRs.getString("TABLE_SCHEM", 1);
                    String catalog = this.myRs.getString("TABLE_CATALOG", 2);
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)schema), catalog == null ? null : DbUtil.intern((String)catalog));
                }

                @Override
                protected DatabaseMetaDataWrapper.Schema nextImpl() {
                    if (this.myCats != null && this.myCats.hasNext() && this.myCur != null) {
                        return new DatabaseMetaDataWrapper.Schema(this.myCur.schema, this.myCats.next());
                    }
                    DatabaseMetaDataWrapper.Schema schema = (DatabaseMetaDataWrapper.Schema)super.nextImpl();
                    if (schema == null) {
                        return null;
                    }
                    if (schema.database == null && !catalogs.isEmpty()) {
                        this.myCur = schema;
                        this.myCats = catalogs.iterator();
                        return (DatabaseMetaDataWrapper.Schema)this.skip();
                    }
                    if (schema.database == null) {
                        schema.database = current;
                    }
                    return schema;
                }
            };
        }
        catch (SQLException e) {
            meta.getErrorHandler().addError(null, (Throwable)e);
            return ClosableIt.empty();
        }
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas2(Iterator<String> catalogs, String current, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext() || current == null) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.jdbcSchemasInCatalog2(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.jdbcSchemas2(catalogs, current, meta));
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemasInCatalog2(final String catalog, DatabaseMetaDataWrapper meta) {
        String dbName = catalog;
        if (meta.getFamilyId().isTransactSql()) {
            String q = meta.getQuote();
            dbName = q + dbName + q;
        }
        if (JdbcUtil.setCatalogSafe((Connection)meta.getConnection(), (String)dbName)) {
            try {
                return new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(meta.getMetaData().getSchemas(), meta.getErrorHandler(), null){

                    @Override
                    protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                        String schema = this.myRs.getString("TABLE_SCHEM", 1);
                        String cat = this.myRs.getString("TABLE_CATALOG", 2);
                        if (cat != null && !catalog.equals(cat)) {
                            return (DatabaseMetaDataWrapper.Schema)this.skip();
                        }
                        return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)schema), catalog);
                    }
                };
            }
            catch (Exception ex) {
                meta.getErrorHandler().addError(null, (Throwable)ex);
            }
        }
        return ClosableIt.empty();
    }

    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemas1(Iterator<String> catalogs, DatabaseMetaDataWrapper meta) {
        if (!catalogs.hasNext()) {
            return ClosableIt.empty();
        }
        return ClosableIt.lazyAppend(SchemaLoader.jdbcSchemasInCatalog1(DbUtil.intern((String)catalogs.next()), meta), () -> SchemaLoader.jdbcSchemas1(catalogs, meta));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static ClosableIt<DatabaseMetaDataWrapper.Schema> jdbcSchemasInCatalog1(final String catalog, DatabaseMetaDataWrapper meta) {
        ResultSet rs = SchemaLoader.getSchemas(catalog, meta);
        if (rs == null) return ClosableIt.empty();
        try (ClosableIt.AutoCloseableGuard<ResultSet> g = new ClosableIt.AutoCloseableGuard<ResultSet>(rs);){
            ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema> res = new ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema>(rs, meta.getErrorHandler(), null){

                @Override
                protected DatabaseMetaDataWrapper.Schema calcValue() throws SQLException {
                    return new DatabaseMetaDataWrapper.Schema(DbUtil.intern((String)this.myRs.getString("TABLE_SCHEM", 1)), catalog);
                }
            };
            g.release();
            ClosableIt.ResultSetDelegateIt<DatabaseMetaDataWrapper.Schema> resultSetDelegateIt = res;
            return resultSetDelegateIt;
        }
        catch (SQLException e) {
            LOG.warn((Throwable)e);
        }
        return ClosableIt.empty();
    }

    private static ResultSet getSchemas(String catalog, DatabaseMetaDataWrapper meta) {
        try {
            return meta.getMetaData().getSchemas(catalog, "%");
        }
        catch (SQLException ex) {
            try {
                String q = meta.getQuote();
                return meta.getMetaData().getSchemas(q + catalog + q, "%");
            }
            catch (SQLException ex2) {
                return null;
            }
        }
    }
}

