/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.dbm.generic.meta;

import com.intellij.database.util.ErrorHandler;
import com.intellij.dbm.generic.meta.ClosableIt;
import com.intellij.dbm.generic.meta.DatabaseMetaDataWrapper;
import com.intellij.dbm.generic.meta.MetaDataUtil;
import com.intellij.openapi.util.Comparing;
import java.sql.ResultSet;
import java.sql.SQLException;
import org.jetbrains.annotations.NotNull;

public class TableVersionColumnIt
extends ClosableIt.ResultSetClosableIt<DatabaseMetaDataWrapper.TableColumn> {
    private final DatabaseMetaDataWrapper.Table myTable;

    public TableVersionColumnIt(@NotNull ResultSet rs, @NotNull ErrorHandler handler, @NotNull DatabaseMetaDataWrapper.Table table) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "rs", "com/intellij/dbm/generic/meta/TableVersionColumnIt", "<init>"));
        }
        if (handler == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "handler", "com/intellij/dbm/generic/meta/TableVersionColumnIt", "<init>"));
        }
        if (table == null) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "table", "com/intellij/dbm/generic/meta/TableVersionColumnIt", "<init>"));
        }
        super(rs, handler);
        this.myTable = table;
    }

    @Override
    @NotNull
    protected DatabaseMetaDataWrapper.TableColumn createStorage() {
        DatabaseMetaDataWrapper.TableColumn tableColumn = new DatabaseMetaDataWrapper.TableColumn(this.myTable);
        if (tableColumn == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/TableVersionColumnIt", "createStorage"));
        }
        return tableColumn;
    }

    @Override
    protected DatabaseMetaDataWrapper.TableColumn calcValue() throws SQLException {
        DatabaseMetaDataWrapper.TableColumn res = (DatabaseMetaDataWrapper.TableColumn)this.getStorageToFill();
        try {
            short type = this.myRs.getShort("PSEUDO_COLUMN", 8);
            if (type == 2) {
                return (DatabaseMetaDataWrapper.TableColumn)this.skip();
            }
            res.name = this.myRs.getString("COLUMN_NAME", 2);
        }
        catch (SQLException e) {
            this.onError(res, e);
            return (DatabaseMetaDataWrapper.TableColumn)this.skip();
        }
        return res;
    }

    @Override
    public void onError(DatabaseMetaDataWrapper.TableColumn cur, SQLException e) {
        String title = cur == null ? null : MetaDataUtil.qName(cur.table.schema.database, cur.table.schema.schema, cur.table.name);
        this.myErrorHandler.addError(title, (Throwable)e);
    }

    public static class Grouping
    extends ClosableIt.GroupingItImpl<DatabaseMetaDataWrapper.Table, DatabaseMetaDataWrapper.TableColumn, DatabaseMetaDataWrapper.TableColumn> {
        protected Grouping(@NotNull ClosableIt<DatabaseMetaDataWrapper.TableColumn> delegate) {
            if (delegate == null) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "delegate", "com/intellij/dbm/generic/meta/TableVersionColumnIt$Grouping", "<init>"));
            }
            super(delegate);
        }

        @Override
        @NotNull
        protected ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> createGroupIt(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            final String tableName = ((DatabaseMetaDataWrapper.TableColumn)it.current()).table.name;
            ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn> groupIt = new ClosableIt.GroupingItImpl.GroupIt<DatabaseMetaDataWrapper.TableColumn>(it){

                @Override
                protected boolean isInGroup(DatabaseMetaDataWrapper.TableColumn item) {
                    return Comparing.equal((String)tableName, (String)item.table.name);
                }
            };
            if (groupIt == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/dbm/generic/meta/TableVersionColumnIt$Grouping", "createGroupIt"));
            }
            return groupIt;
        }

        @Override
        protected DatabaseMetaDataWrapper.Table getItem(ClosableIt<DatabaseMetaDataWrapper.TableColumn> it) {
            return ((DatabaseMetaDataWrapper.TableColumn)it.current()).table;
        }
    }
}

